/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.automata.entities;

import edu.ksu.cis.automata.interfaces.IAutomata;
import edu.ksu.cis.automata.interfaces.IState;
import edu.ksu.cis.automata.interfaces.ISymbol;
import edu.ksu.cis.automata.interfaces.ITransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class Automata
implements IAutomata {
    private Collection finalStateCollection = new ArrayList();
    private IState initialState;
    private IState currentState;

    public void setInitialState(IState initialState) {
        this.initialState = initialState;
        this.currentState = initialState;
    }

    public boolean performTransition(ITransition transition) {
        boolean result = false;
        if (this.currentState != null) {
            Set transSet = this.currentState.getExitingTransitions();
            for (ITransition trans : transSet) {
                if (!trans.equals(transition)) continue;
                this.currentState = trans.getDstnState();
                result = true;
                break;
            }
        }
        return result;
    }

    public Set canPerformTransition(ISymbol sym) {
        HashSet<ITransition> resultSet = new HashSet<ITransition>();
        if (this.currentState != null) {
            Set transSet = this.currentState.getExitingTransitions();
            for (ITransition trans : transSet) {
                if (!trans.getSymbol().match(sym)) continue;
                resultSet.add(trans);
            }
        }
        return resultSet;
    }

    public boolean isInFinalState() {
        boolean result = false;
        if (this.currentState != null) {
            result = this.currentState.isFinalState();
        }
        return result;
    }

    public IState getInitialState() {
        return this.initialState;
    }

    public Collection getFinalStates() {
        return this.finalStateCollection;
    }

    public Object clone() {
        Object retValue = null;
        try {
            retValue = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return retValue;
    }

    public void collectFinalStates() {
        HashSet<IState> reachSet = new HashSet<IState>();
        LinkedList<IState> _workList = new LinkedList<IState>();
        _workList.add(this.initialState);
        while (_workList.size() > 0) {
            IState state = (IState)_workList.remove(0);
            if (reachSet.contains(state)) continue;
            reachSet.add(state);
            if (state.isFinalState()) {
                this.finalStateCollection.add(state);
            }
            Set transSet = state.getExitingTransitions();
            for (ITransition it : transSet) {
                _workList.add(it.getDstnState());
            }
        }
    }
}

