/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.StaticBinder;
import org.slf4j.impl.SystemPropBinder;
import org.slf4j.impl.Util;

public final class LoggerFactory {
    static ILoggerFactory loggerFactory = new SystemPropBinder().getLoggerFactory();

    private LoggerFactory() {
    }

    public static Logger getLogger(String string) {
        return loggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return loggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        return loggerFactory;
    }

    static {
        if (loggerFactory != null) {
            System.out.println("However, SLF4J will use [" + loggerFactory.getClass().getName() + "] adapter factory from system properties.");
        } else {
            try {
                loggerFactory = StaticBinder.SINGLETON.getLoggerFactory();
            }
            catch (Exception exception) {
                Util.reportFailure("Could not instantiate instance of class [" + StaticBinder.SINGLETON.getLoggerFactoryClassStr() + "]", exception);
            }
        }
    }
}

