/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.processing;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IClassHierarchy;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.impl.ClassHierarchy;
import edu.ksu.cis.indus.tools.slicer.processing.ISlicePostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.tagkit.Host;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableSlicePostProcessor
implements ISlicePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutableSlicePostProcessor.class);
    protected SliceCollector collector;
    private BasicBlockGraphMgr bbgMgr;
    private final Collection<SootMethod> processedMethodCache = new HashSet<SootMethod>();
    private final IWorkBag<SootMethod> methodWorkBag = new HistoryAwareFIFOWorkBag(this.processedMethodCache);
    private NonTerminationSensitiveEntryControlDA cd = new NonTerminationSensitiveEntryControlDA();
    private boolean stmtCollected;

    @Empty
    public ExecutableSlicePostProcessor() {
    }

    @Override
    public final void process(Collection<SootMethod> taggedMethods, BasicBlockGraphMgr basicBlockMgr, SliceCollector theCollector) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Post Processing");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Slice before processing: " + theCollector.toString());
        }
        this.collector = theCollector;
        this.bbgMgr = basicBlockMgr;
        this.cd.setBasicBlockGraphManager(basicBlockMgr);
        this.methodWorkBag.addAllWorkNoDuplicates(taggedMethods);
        while (this.methodWorkBag.hasWork()) {
            SootMethod _method = (SootMethod)this.methodWorkBag.getWork();
            this.processMethod(_method);
            if (_method.isConcrete()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Post Processing method " + _method);
                }
                this.stmtCollected = false;
                this.processStmts(_method);
                if (!this.stmtCollected) continue;
                this.pickReturnPoints(_method);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Could not process method " + _method.getSignature());
        }
        this.fixupAbstractMethodsInClassHierarchy();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Post Processing");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Slice after processing: " + theCollector.toString());
        }
    }

    public final void reset() {
        this.methodWorkBag.clear();
        this.processedMethodCache.clear();
    }

    protected IClassHierarchy getClassHierarchyContainingClasses(Collection<SootClass> classes) {
        return ClassHierarchy.createClassHierarchyFrom(classes);
    }

    private void fixupAbstractMethodsInClassHierarchy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Fixing Class Hierarchy - " + this.getClass() + " " + this.collector.getClassesInSlice());
        }
        IClassHierarchy _ch = this.getClassHierarchyContainingClasses(this.collector.getClassesInSlice());
        List _topologicallyOrderedClasses = _ch.getClassesInTopologicalOrder(true);
        HashMap<SootClass, Collection<SootMethod>> _class2abstractMethods = new HashMap<SootClass, Collection<SootMethod>>();
        this.collector.includeInSlice(_ch.getClasses());
        this.collector.includeInSlice(_ch.getInterfaces());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Topological Sort: " + _topologicallyOrderedClasses);
        }
        for (SootClass _currClass : _topologicallyOrderedClasses) {
            Collection<SootMethod> _abstractMethodsAtCurrClass = this.gatherCollectedAbstractMethodsInSuperClasses(_class2abstractMethods, _currClass);
            List _methods = _currClass.getMethods();
            Collection _collectedMethods = this.collector.getCollected(_methods);
            Collection _unCollectedMethods = SetUtils.difference((Collection)_methods, _collectedMethods);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fixing up " + _currClass);
            }
            Util.removeMethodsWithSameSignature(_abstractMethodsAtCurrClass, _collectedMethods);
            Util.retainMethodsWithSameSignature((Collection)_unCollectedMethods, _abstractMethodsAtCurrClass);
            Util.removeMethodsWithSameSignature(_abstractMethodsAtCurrClass, (Collection)_unCollectedMethods);
            this.collector.includeInSlice(_unCollectedMethods);
            if (_currClass.isInterface()) {
                _abstractMethodsAtCurrClass.addAll(_collectedMethods);
            } else if (_currClass.isAbstract()) {
                for (SootMethod _sm : _collectedMethods) {
                    if (!_sm.isAbstract()) continue;
                    _abstractMethodsAtCurrClass.add(_sm);
                }
            }
            if (_abstractMethodsAtCurrClass.isEmpty()) continue;
            _class2abstractMethods.put(_currClass, new ArrayList<SootMethod>(_abstractMethodsAtCurrClass));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Class -> abstract Method mapping:\n" + _class2abstractMethods);
            LOGGER.debug("END: Fixing Class Hierarchy");
        }
    }

    private Collection<SootMethod> gatherCollectedAbstractMethodsInSuperClasses(Map<SootClass, Collection<SootMethod>> class2abstractMethods, SootClass clazz) {
        Collection<SootMethod> _abstractMethods;
        SootClass _superClass;
        HashSet<SootMethod> _methods = new HashSet<SootMethod>();
        for (SootClass _interface : clazz.getInterfaces()) {
            Collection<SootMethod> _abstractMethods2;
            if (!this.collector.hasBeenCollected((Host)_interface) || (_abstractMethods2 = class2abstractMethods.get(_interface)) == null) continue;
            _methods.addAll(_abstractMethods2);
        }
        if (clazz.hasSuperclass() && this.collector.hasBeenCollected((Host)(_superClass = clazz.getSuperclass())) && (_abstractMethods = class2abstractMethods.get(_superClass)) != null) {
            _methods.addAll(_abstractMethods);
        }
        return _methods;
    }

    private void pickARandomReturnPoint(Collection<BasicBlockGraph.BasicBlock> returnPoints) {
        Stmt _exitStmt = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("pickARandomReturnPoint(returnPoints = " + returnPoints + ")");
        }
        for (BasicBlockGraph.BasicBlock _bb : returnPoints) {
            Stmt _stmt = _bb.getTrailerStmt();
            if (_stmt instanceof ReturnStmt || _stmt instanceof ReturnVoidStmt) {
                _exitStmt = _stmt;
                break;
            }
            if (_stmt instanceof ThrowStmt) {
                _exitStmt = _stmt;
                continue;
            }
            if (_exitStmt != null) continue;
            _exitStmt = _stmt;
        }
        this.processAndIncludeExitStmt(_exitStmt);
    }

    private void pickReturnPoints(SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Picking return points in " + method);
        }
        String _tagName = this.collector.getTagName();
        BasicBlockGraph _bbg = this.bbgMgr.getBasicBlockGraph(method);
        HashSet<BasicBlockGraph.BasicBlock> _tails = new HashSet<BasicBlockGraph.BasicBlock>();
        _tails.addAll(_bbg.getTails());
        this.cd.analyze((Collection)Collections.singleton(method));
        if (_tails.size() == 1) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_tails.iterator().next();
            this.processAndIncludeExitStmt(_bb.getTrailerStmt());
        } else {
            boolean _tailWasNotPicked = true;
            for (BasicBlockGraph.BasicBlock _bb : _tails) {
                Stmt _stmt = _bb.getTrailerStmt();
                Collection _dependees = this.cd.getDependees(_stmt, method);
                if (this.collector.hasBeenCollected((Host)_stmt) || !_dependees.isEmpty() && Util.getHostsWithTag((Collection)_dependees, (String)_tagName).isEmpty()) continue;
                this.processAndIncludeExitStmt(_stmt);
                _tailWasNotPicked = false;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Picked " + _stmt + " in " + method);
            }
            if (_tailWasNotPicked) {
                this.pickARandomReturnPoint(_tails);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Picking return points in " + method);
        }
    }

    private void processAndIncludeExitStmt(Stmt exitStmt) {
        if (exitStmt instanceof ThrowStmt) {
            this.processThrowStmt((ThrowStmt)exitStmt);
        }
        this.collector.includeInSlice((Host)exitStmt);
    }

    private void processAssignmentsForTypes(Stmt assignStmt) {
        CastExpr _v;
        Value _rightOp = ((AssignStmt)assignStmt).getRightOp();
        Type _type = null;
        if (_rightOp instanceof CastExpr) {
            _v = (CastExpr)_rightOp;
            _type = _v.getCastType();
        } else if (_rightOp instanceof InstanceOfExpr) {
            _v = (InstanceOfExpr)_rightOp;
            _type = _v.getCheckType();
        }
        if (_type != null) {
            if (_type instanceof ArrayType) {
                _type = ((ArrayType)_type).baseType;
            }
            if (_type instanceof RefType) {
                SootClass _sootClass = ((RefType)_type).getSootClass();
                this.collector.includeInSlice((Host)_sootClass);
            }
        }
    }

    private void processHandlers(SootMethod method, Stmt stmt, BasicBlockGraph bbg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Pruning handlers " + stmt + "@" + method);
        }
        for (Trap _trap : TrapManager.getTrapsAt((Unit)stmt, (Body)method.retrieveActiveBody())) {
            IdentityStmt _handlerUnit = (IdentityStmt)_trap.getHandlerUnit();
            if (bbg.getEnclosingBlock((Stmt)_handlerUnit) == null) continue;
            this.collector.includeInSlice((Host)_handlerUnit);
            this.collector.includeInSlice((Host)_handlerUnit.getLeftOpBox());
            this.collector.includeInSlice((Host)_handlerUnit.getRightOpBox());
            SootClass _exceptionClass = _trap.getException();
            this.collector.includeInSlice(Util.getAncestors((SootClass)_exceptionClass));
            this.collector.includeInSlice((Host)_exceptionClass);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Pruning handlers " + stmt + "@" + method);
        }
    }

    private void processMethod(SootMethod method) {
        HashSet<Type> _temp = new HashSet<Type>();
        for (SootMethod _sm : Util.findMethodInSuperClassesAndInterfaces((SootMethod)method)) {
            this.collector.includeInSlice((Host)_sm.getDeclaringClass());
            this.collector.includeInSlice((Host)_sm);
            _temp.clear();
            _temp.add(_sm.getReturnType());
            _temp.addAll(_sm.getParameterTypes());
            for (Type _type : _temp) {
                Type _baseType;
                if (_type instanceof RefType) {
                    this.collector.includeInSlice((Host)((RefType)_type).getSootClass());
                    continue;
                }
                if (!(_type instanceof ArrayType) || !((_baseType = ((ArrayType)_type).baseType) instanceof RefType)) continue;
                this.collector.includeInSlice((Host)((RefType)_baseType).getSootClass());
            }
            this.methodWorkBag.addWorkNoDuplicates((Object)_sm);
        }
    }

    private void processStmts(SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Picking up identity statements and methods required in" + method);
        }
        BasicBlockGraph _bbg = this.bbgMgr.getBasicBlockGraph(method);
        UnitGraph _unitGraph = _bbg.getStmtGraph();
        for (Stmt _stmt : _unitGraph) {
            if (_stmt instanceof IdentityStmt) {
                IdentityStmt _identityStmt = (IdentityStmt)_stmt;
                Value _rhs = _identityStmt.getRightOp();
                if (!(_rhs instanceof ThisRef) && !(_rhs instanceof ParameterRef)) continue;
                this.collector.includeInSlice((Host)_identityStmt.getLeftOpBox());
                this.collector.includeInSlice((Host)_identityStmt.getRightOpBox());
                this.collector.includeInSlice((Host)_identityStmt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Picked " + _identityStmt + " in " + method);
                }
                this.processHandlers(method, _stmt, _bbg);
                this.stmtCollected = true;
                continue;
            }
            if (!this.collector.hasBeenCollected((Host)_stmt)) continue;
            if (_stmt.containsInvokeExpr() && !(_stmt.getInvokeExpr() instanceof StaticInvokeExpr)) {
                this.processMethod(_stmt.getInvokeExpr().getMethod());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Included method invoked at " + _stmt + " in " + method);
                }
            } else if (_stmt instanceof ThrowStmt) {
                this.processThrowStmt((ThrowStmt)_stmt);
            } else if (_stmt instanceof AssignStmt) {
                this.processAssignmentsForTypes(_stmt);
            }
            this.processHandlers(method, _stmt, _bbg);
            this.stmtCollected = true;
        }
    }

    private void processThrowStmt(ThrowStmt throwStmt) {
        if (!this.collector.hasBeenCollected((Host)throwStmt.getOpBox())) {
            SootClass _exceptionClass = ((RefType)throwStmt.getOp().getType()).getSootClass();
            this.collector.includeInSlice((Host)_exceptionClass);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Included classes of exception thrown at " + throwStmt);
            }
        }
    }
}

