/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.specification;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.slicer.CriteriaSpecHelper;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.tools.JiBX_MungeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SliceCriterionSpec
implements Cloneable,
IUnmarshallable,
IMarshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SliceCriterionSpec.class);
    private static final SliceCriteriaFactory CRITERIA_FACTORY = SliceCriteriaFactory.getFactory();
    private List<String> parameterTypeNames = SliceCriterionSpec.createParameterTypeNamesContainer();
    private String className;
    private String methodName;
    private String returnTypeName;
    private boolean considerEntireStmt;
    private boolean considerExecution;
    private int exprIndex = -1;
    private int stmtIndex = -1;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.tools.slicer.criteria.specification.JiBX_sliceCriteria_JiBXBindingFactory|";

    SliceCriterionSpec() {
    }

    public Collection<ISliceCriterion> getCriteria(Scene scene) {
        Collection<ISliceCriterion> _result;
        this.trim();
        SootClass _sc = scene.getSootClass(this.className);
        if (_sc == null) {
            String _msg = String.valueOf(this.className) + " is not available in the System.";
            LOGGER.error(_msg);
            throw new MissingResourceException("Given class not available in the System.", this.className, null);
        }
        ArrayList<Type> _parameterTypes = new ArrayList<Type>();
        for (String _name : this.parameterTypeNames) {
            _parameterTypes.add(Util.getTypeFor((String)_name, (Scene)scene));
        }
        SootMethod _sm = _sc.getMethod(this.methodName, _parameterTypes, Util.getTypeFor((String)this.returnTypeName, (Scene)scene));
        _sc.setApplicationClass();
        Body _body = _sm.retrieveActiveBody();
        if (_body == null) {
            String _msg = String.valueOf(this.returnTypeName) + " " + this.methodName + "(" + this.parameterTypeNames + ") does not have a body.";
            LOGGER.error(_msg);
            throw new IllegalStateException(_msg);
        }
        List _stmts = Collections.list(Collections.enumeration(_body.getUnits()));
        if (_stmts.size() < this.stmtIndex + 1) {
            String _msg = String.valueOf(this.returnTypeName) + " " + this.methodName + "(" + this.parameterTypeNames + ") has only " + _stmts.size() + " statements. [" + this.stmtIndex + "]";
            LOGGER.error(_msg);
            throw new IllegalStateException(_msg);
        }
        if (this.stmtIndex == -1) {
            _result = CRITERIA_FACTORY.getCriteria(_sm);
        } else {
            Stmt _stmt = (Stmt)_stmts.get(this.stmtIndex);
            _result = this.exprIndex == -1 ? CRITERIA_FACTORY.getCriteria(_sm, _stmt, this.considerEntireStmt, this.considerExecution) : CRITERIA_FACTORY.getCriteria(_sm, _stmt, (ValueBox)_stmt.getUseAndDefBoxes().get(this.exprIndex), this.considerExecution);
        }
        return _result;
    }

    public static List<String> getNamesOfTypes(List<Type> parameterTypes) {
        ArrayList<String> _result = new ArrayList<String>();
        Iterator<Type> _i = parameterTypes.iterator();
        while (_i.hasNext()) {
            _result.add(_i.next().toString().replace(']', ' ').trim());
        }
        return _result;
    }

    public String toString() {
        this.trim();
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("returnTypeName", (Object)this.returnTypeName).append("methodName", (Object)this.methodName).append("parameterTypeNames", this.parameterTypeNames).append("stmtIndex", this.stmtIndex).append("exprIndex", this.exprIndex).append("considerExecution", this.considerExecution).append("considerEntireStmt", this.considerEntireStmt).toString();
    }

    static Collection<SliceCriterionSpec> getCriterionSpec(ISliceCriterion criterion) {
        ArrayList<SliceCriterionSpec> _result;
        SootMethod _method = criterion.getOccurringMethod();
        SootClass _declaringClass = _method.getDeclaringClass();
        String _prefix = _declaringClass.getPackageName();
        String _shortJavaStyleName = _declaringClass.getShortJavaStyleName();
        String _className = _prefix.length() != 0 ? String.valueOf(_prefix) + "." + _shortJavaStyleName : _shortJavaStyleName;
        String _methodName = _method.getName();
        if (!_method.isAbstract() && !_method.isNative()) {
            Body _body = _method.retrieveActiveBody();
            if (_body == null) {
                String _msg = String.valueOf(_method.getSignature()) + " does not have a body.";
                LOGGER.error(_msg);
                throw new IllegalStateException(_msg);
            }
            List _stmts = Collections.list(Collections.enumeration(_body.getUnits()));
            Stmt _occurringStmt = CriteriaSpecHelper.getOccurringStmt(criterion);
            int _stmtIndex = _stmts.indexOf(_occurringStmt);
            boolean _considerExecution = CriteriaSpecHelper.isConsiderExecution(criterion);
            SliceCriterionSpec _spec = new SliceCriterionSpec();
            _spec.className = _className;
            _spec.methodName = _methodName;
            _spec.parameterTypeNames = SliceCriterionSpec.getNamesOfTypes(_method.getParameterTypes());
            _spec.returnTypeName = _method.getReturnType().toString();
            _spec.stmtIndex = _stmtIndex;
            _spec.exprIndex = -1;
            _spec.considerExecution = _considerExecution;
            _spec.considerEntireStmt = false;
            _result = new ArrayList<SliceCriterionSpec>();
            ValueBox _occurringExprBox = CriteriaSpecHelper.getOccurringExpr(criterion);
            if (_occurringExprBox != null) {
                Value _expr = _occurringExprBox.getValue();
                int _size = _expr.getUseBoxes().size();
                if (_size == 0) {
                    _spec.exprIndex = _occurringStmt.getUseAndDefBoxes().indexOf(_occurringExprBox);
                    _result.add(_spec);
                } else {
                    int _i = _size - 1;
                    while (_i >= 0) {
                        try {
                            SliceCriterionSpec _temp = (SliceCriterionSpec)_spec.clone();
                            _temp.exprIndex = _i--;
                            _result.add(_temp);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            LOGGER.error("Low level Error while creating criterion specification.");
                            throw new IllegalStateException("Low level Error while creating criterion specification.");
                        }
                    }
                }
            } else {
                _result.add(_spec);
            }
        } else {
            _result = (ArrayList<SliceCriterionSpec>)((Object)Collections.emptySet());
        }
        return _result;
    }

    public static List<String> createParameterTypeNamesContainer() {
        return new ArrayList<String>();
    }

    private void trim() {
        if (this.className != null) {
            this.className = this.className.trim();
        }
        if (this.methodName != null) {
            this.methodName = this.methodName.trim();
        }
        if (this.returnTypeName != null) {
            this.returnTypeName = this.returnTypeName.trim();
        }
        ListIterator<String> _i = this.parameterTypeNames.listIterator();
        while (_i.hasNext()) {
            String _str = _i.next();
            if (_str == null) continue;
            _i.remove();
            _i.add(_str.trim());
        }
    }

    public static /* synthetic */ SliceCriterionSpec JiBX_sliceCriteria_JiBXBinding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new SliceCriterionSpec();
    }

    public final /* synthetic */ SliceCriterionSpec JiBX_sliceCriteria_JiBXBinding_unmarshalAttr_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        SliceCriterionSpec sliceCriterionSpec = this;
        this.considerExecution = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "considerExecution");
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ SliceCriterionSpec JiBX_sliceCriteria_JiBXBinding_unmarshal_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SliceCriterionSpec sliceCriterionSpec = this;
        this.className = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "className");
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "method");
        this.methodName = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "methodName");
        this.returnTypeName = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "returnTypeName");
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "parameters");
        List list = this.parameterTypeNames;
        if (list == null) {
            list = JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_newinstance_1_1((UnmarshallingContext)arg1);
        }
        this.parameterTypeNames = JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_unmarshal_1_1(list, (UnmarshallingContext)arg1);
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "parameters");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "method");
        if (arg1.isAt("http://indus.projects.cis.ksu.edu/slicer", "stmt")) {
            arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
            this.stmtIndex = arg1.attributeInt("http://indus.projects.cis.ksu.edu/slicer", "index");
            this.considerEntireStmt = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "considerEntireStmt");
            arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
            arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
        } else {
            sliceCriterionSpec = null;
        }
        if (arg1.isAt("http://indus.projects.cis.ksu.edu/slicer", "expr")) {
            arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
            this.exprIndex = arg1.attributeInt("http://indus.projects.cis.ksu.edu/slicer", "index", -1);
            arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
            arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
        } else {
            sliceCriterionSpec = null;
        }
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(3).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_sliceCriteria_JiBXBinding_marshalAttr_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(3, "considerExecution", Utility.serializeBoolean((boolean)this.considerExecution));
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_sliceCriteria_JiBXBinding_marshal_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.element(3, "className", this.className);
        arg1.startTagNamespaces(3, "method", new int[]{3}, new String[]{"slicer"}).closeStartContent();
        MarshallingContext marshallingContext2 = marshallingContext.element(3, "methodName", this.methodName).element(3, "returnTypeName", this.returnTypeName);
        arg1.startTagNamespaces(3, "parameters", new int[]{3}, new String[]{"slicer"}).closeStartContent();
        JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_marshal_1_1(this.parameterTypeNames, (MarshallingContext)arg1);
        arg1.endTag(3, "parameters");
        arg1.endTag(3, "method");
        arg1.startTagNamespaces(3, "stmt", new int[]{3}, new String[]{"slicer"});
        MarshallingContext marshallingContext3 = marshallingContext2.attribute(3, "index", Utility.serializeInt((int)this.stmtIndex)).attribute(3, "considerEntireStmt", Utility.serializeBoolean((boolean)this.considerEntireStmt));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(3, "expr", new int[]{3}, new String[]{"slicer"});
        int n = this.exprIndex;
        if (n != -1) {
            marshallingContext3 = marshallingContext3.attribute(3, "index", Utility.serializeInt((int)n));
        }
        arg1.closeStartEmpty();
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(3, "edu.ksu.cis.indus.tools.slicer.criteria.specification.SliceCriterionSpec").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 3;
    }
}

