/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.specification;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.tools.slicer.criteria.specification.SliceCriteriaSpec;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SliceCriteriaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SliceCriteriaParser.class);
    private static final int INDENT = 4;

    @Empty
    private SliceCriteriaParser() {
    }

    public static Collection<ISliceCriterion> deserialize(String criteriaSpec, Scene scene) throws JiBXException {
        Collection<ISliceCriterion> _result;
        IUnmarshallingContext _unmarshallingContext;
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(SliceCriteriaSpec.class);
            _unmarshallingContext = _bindingFactory.createUnmarshallingContext();
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while setting up JiBX.  Aborting.", (Throwable)_e);
            throw _e;
        }
        try {
            StringReader _reader = new StringReader(criteriaSpec);
            SliceCriteriaSpec _sliceCriteriaSpec = (SliceCriteriaSpec)_unmarshallingContext.unmarshalDocument((Reader)_reader, null);
            _result = _sliceCriteriaSpec.getCriteria(scene);
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while deserializing slice criteria.", (Throwable)_e);
            throw _e;
        }
        return _result;
    }

    public static String serialize(Collection<ISliceCriterion> criteria) throws JiBXException {
        String _result;
        IMarshallingContext _marshallingContext;
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(SliceCriteriaSpec.class);
            _marshallingContext = _bindingFactory.createMarshallingContext();
            _marshallingContext.setIndent(4);
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while setting up JiBX.", (Throwable)_e);
            throw _e;
        }
        try {
            StringWriter _writer = new StringWriter();
            _marshallingContext.marshalDocument((Object)SliceCriteriaSpec.getSliceCriteriaSpec(criteria), "UTF-8", Boolean.TRUE, (Writer)_writer);
            _writer.flush();
            _result = _writer.toString();
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while marshalling Slicer configuration.", (Throwable)_e);
            throw _e;
        }
        return _result;
    }
}

