/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.generators;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.ReflectionBasedSupertypePredicate;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.AbstractStmtBasedSliceCriteriaGenerator;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StmtTypeBasedSliceCriteriaGenerator
extends AbstractStmtBasedSliceCriteriaGenerator<Stmt> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StmtTypeBasedSliceCriteriaGenerator.class);
    private final Collection<Class<? extends Stmt>> stmtTypes = new HashSet<Class<? extends Stmt>>();
    private final ReflectionBasedSupertypePredicate<Stmt> subClassPredicate = new ReflectionBasedSupertypePredicate();

    public <T extends Stmt> void setStmtTypes(@NonNull @NonNullContainer Collection<Class<T>> types) {
        this.stmtTypes.clear();
        this.stmtTypes.addAll(types);
    }

    @Override
    protected boolean shouldConsiderStmt(Stmt stmt) {
        this.subClassPredicate.setsubType(stmt.getClass());
        boolean _result = CollectionUtils.exists(this.stmtTypes, this.subClassPredicate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("shouldConsiderStmt(Stmt stmt = " + stmt + ":" + stmt.getClass() + ") = " + _result);
        }
        return _result;
    }
}

