/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.generators;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.AbstractStmtBasedSliceCriteriaGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import soot.jimple.Stmt;
import soot.tagkit.LineNumberTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumberBasedCriteriaGenerator
extends AbstractStmtBasedSliceCriteriaGenerator<Stmt> {
    private Map<String, Collection<String>> className2lineNos = new HashMap<String, Collection<String>>();

    public LineNumberBasedCriteriaGenerator(Properties props) {
        for (Object _key : props.keySet()) {
            String _className = (String)_key;
            List<String> _lineNos = Arrays.asList(props.getProperty(_className).split(","));
            this.className2lineNos.put(_className, _lineNos);
        }
    }

    @Override
    protected boolean shouldConsiderStmt(Stmt stmt) {
        boolean _result = false;
        LineNumberTag _lnt = (LineNumberTag)stmt.getTag("LineNumberTag");
        if (_lnt != null) {
            String _className = this.getProcessingMethod().getDeclaringClass().getName();
            Collection _lineNos = MapUtils.queryCollection(this.className2lineNos, (Object)_className);
            _result = _lineNos.contains(_lnt.toString());
        }
        return _result;
    }
}

