/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.generators;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.AbstractSliceCriteriaGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.VoidType;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeadlockPreservingCriteriaGenerator
extends AbstractSliceCriteriaGenerator<SootMethod, Triple<EnterMonitorStmt, ExitMonitorStmt, SootMethod>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeadlockPreservingCriteriaGenerator.class);

    @Override
    protected Collection<ISliceCriterion> getCriteriaTemplateMethod() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: creating deadlock criteria.");
        }
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        HashSet<ISliceCriterion> _subResult = new HashSet<ISliceCriterion>();
        Context _context = new Context();
        SlicerTool<?> _slicer = this.getSlicerTool();
        BasicBlockGraphMgr _bbgMgr = _slicer.getBasicBlockGraphManager();
        SliceCriteriaFactory _criteriaFactory = SliceCriteriaFactory.getFactory();
        Collection _monitorTriples = _slicer.getMonitorInfo().getMonitorTriples();
        for (Triple _mTriple : _monitorTriples) {
            SootMethod _method = (SootMethod)_mTriple.getThird();
            if (!this.shouldConsiderSite(_method)) continue;
            _subResult.clear();
            _context.setRootMethod(_method);
            if (this.shouldGenerateCriteriaFrom(_mTriple)) {
                if (_mTriple.getFirst() == null) {
                    _subResult.addAll(this.generateCriteriaForMethodBoundary(_method, _bbgMgr, _criteriaFactory));
                    this.contextualizeCriteriaBasedOnThis(_method, _subResult);
                } else {
                    EnterMonitorStmt _enterStmt = (EnterMonitorStmt)_mTriple.getFirst();
                    _subResult.addAll(_criteriaFactory.getCriteria(_method, (Stmt)_enterStmt, true, true));
                    _subResult.addAll(_criteriaFactory.getCriteria(_method, (Stmt)_mTriple.getSecond(), true, true));
                    _context.setStmt((Stmt)_enterStmt);
                    _context.setProgramPoint(_enterStmt.getOpBox());
                    this.contextualizeCriteriaBasedOnProgramPoint(_context, _subResult);
                }
            }
            _result.addAll(_subResult);
        }
        InstanceOfPredicate _instanceOfPredicate = new InstanceOfPredicate(InvokeStmt.class);
        for (SootMethod _caller : _slicer.getCallGraph().getReachableMethods()) {
            Iterator _sl = _bbgMgr.getStmtList(_caller).iterator();
            _context.setRootMethod(_caller);
            Iterator _j = IteratorUtils.filteredIterator(_sl, (IPredicate)_instanceOfPredicate);
            while (_j.hasNext()) {
                InvokeStmt _stmt = (InvokeStmt)_j.next();
                InvokeExpr _ve = _stmt.getInvokeExpr();
                SootMethod _callee = _ve.getMethod();
                if (!_callee.getName().equals("join") || _callee.getParameterCount() != 0 || _callee.getReturnType() != VoidType.v() || !_callee.getDeclaringClass().getName().equals("java.lang.Thread")) continue;
                _subResult.clear();
                _subResult.addAll(_criteriaFactory.getCriteria(_caller, (Stmt)_stmt, true, true));
                _context.setStmt((Stmt)_stmt);
                _context.setProgramPoint(((VirtualInvokeExpr)_ve).getBaseBox());
                this.contextualizeCriteriaBasedOnProgramPoint(_context, _subResult);
                _result.addAll(_subResult);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: creating deadlock criteria. - " + _result);
        }
        return _result;
    }

    private Collection<ISliceCriterion> generateCriteriaForMethodBoundary(SootMethod method, BasicBlockGraphMgr bbgMgr, SliceCriteriaFactory criteriaFactory) throws IllegalStateException {
        ArrayList<ISliceCriterion> _result = new ArrayList<ISliceCriterion>();
        BasicBlockGraph _bbg = bbgMgr.getBasicBlockGraph(method);
        if (_bbg != null) {
            Collection<ISliceCriterion> _criteria = criteriaFactory.getCriteria(method, (Stmt)bbgMgr.getStmtList(method).get(0), false);
            _result.addAll(_criteria);
            for (BasicBlockGraph.BasicBlock _bb : _bbg.getSinks()) {
                Stmt _stmt = _bb.getTrailerStmt();
                _result.addAll(criteriaFactory.getCriteria(method, _stmt, false));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Could not retrieve the basic block graph for " + method.getSignature() + ".  Moving on.");
        }
        return _result;
    }
}

