/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.generators;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.slicer.SliceType;
import edu.ksu.cis.indus.tools.slicer.SlicerConfiguration;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.AbstractSliceCriteriaGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStmtBasedSliceCriteriaGenerator<T1>
extends AbstractSliceCriteriaGenerator<SootMethod, T1> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStmtBasedSliceCriteriaGenerator.class);
    private SootMethod processingMethodCache;

    @Override
    @NonNull
    protected final Collection<ISliceCriterion> getCriteriaTemplateMethod() {
        SlicerTool<?> _slicer;
        SliceType _sliceType;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: creating field criteria.");
        }
        boolean _considerExecution = !(_sliceType = ((SlicerConfiguration)(_slicer = this.getSlicerTool()).getActiveConfiguration()).getSliceType()).equals((Object)SliceType.FORWARD_SLICE);
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        SliceCriteriaFactory _criteriaFactory = SliceCriteriaFactory.getFactory();
        BasicBlockGraphMgr _bbgMgr = _slicer.getBasicBlockGraphManager();
        ICallGraphInfo _cgi = _slicer.getCallGraph();
        Collection _reachableMethods = _cgi.getReachableMethods();
        Iterator _i = _reachableMethods.iterator();
        int _iEnd = _reachableMethods.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            this.processingMethodCache = (SootMethod)_i.next();
            if (this.shouldConsiderSite(this.processingMethodCache)) {
                BasicBlockGraph _bbg = _bbgMgr.getBasicBlockGraph(this.processingMethodCache);
                List _nodeList = _bbg.getNodes();
                Iterator _j = _nodeList.iterator();
                int _jEnd = _nodeList.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_j.next();
                    List _stmtsOf = _bb.getStmtsOf();
                    Iterator _k = _stmtsOf.iterator();
                    int _kEnd = _stmtsOf.size();
                    int _kIndex = 0;
                    while (_kIndex < _kEnd) {
                        Stmt _stmt = (Stmt)_k.next();
                        if (this.shouldConsiderStmt(_stmt) && this.shouldGenerateCriteriaFrom(this.getEntityForCriteriaFiltering(_stmt))) {
                            if (_sliceType.equals((Object)SliceType.COMPLETE_SLICE)) {
                                _result.addAll(_criteriaFactory.getCriteria(this.processingMethodCache, _stmt, true));
                                _result.addAll(_criteriaFactory.getCriteria(this.processingMethodCache, _stmt, false));
                            } else {
                                _result.addAll(_criteriaFactory.getCriteria(this.processingMethodCache, _stmt, _considerExecution));
                            }
                        }
                        ++_kIndex;
                    }
                    ++_jIndex;
                }
            }
            ++_iIndex;
        }
        return _result;
    }

    @Functional
    protected T1 getEntityForCriteriaFiltering(@NonNull Stmt stmt) {
        return (T1)stmt;
    }

    protected final SootMethod getProcessingMethod() {
        return this.processingMethodCache;
    }

    @Functional
    protected boolean shouldConsiderStmt(Stmt stmt) {
        return true;
    }
}

