/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria.generators;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.contextualizers.ISliceCriteriaContextualizer;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.ISliceCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.predicates.ISliceCriteriaPredicate;
import java.util.Collection;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSliceCriteriaGenerator<T1, T2>
implements ISliceCriteriaGenerator<T1, T2> {
    private ISliceCriteriaContextualizer contextualizer;
    private ISliceCriteriaPredicate<T2> criteriaPredicate;
    private IPredicate<T1> siteSelectionPredicate;
    private SlicerTool<?> slicerTool;

    @Override
    public final Collection<ISliceCriterion> getCriteria(SlicerTool<?> slicer) {
        this.slicerTool = slicer;
        if (this.contextualizer != null) {
            this.contextualizer.setSlicerTool(this.slicerTool);
        }
        if (this.criteriaPredicate != null) {
            this.criteriaPredicate.setSlicerTool(this.slicerTool);
        }
        return this.getCriteriaTemplateMethod();
    }

    @Override
    public final void setCriteriaContextualizer(ISliceCriteriaContextualizer theContextualizer) {
        this.contextualizer = theContextualizer;
    }

    @Override
    public final void setCriteriaFilterPredicate(ISliceCriteriaPredicate<T2> thePredicate) {
        this.criteriaPredicate = thePredicate;
    }

    @Override
    public final void setSiteSelectionPredicate(IPredicate<T1> thePredicate) {
        this.siteSelectionPredicate = thePredicate;
    }

    protected final void contextualizeCriteriaBasedOnProgramPoint(@NonNull Context context, @NonNull @NonNullContainer Collection<ISliceCriterion> baseCriteria) {
        if (this.contextualizer != null) {
            this.contextualizer.processCriteriaBasedOnProgramPoint(context, baseCriteria);
        }
    }

    protected final void contextualizeCriteriaBasedOnThis(@NonNull SootMethod method, @NonNull @NonNullContainer Collection<ISliceCriterion> baseCriteria) {
        if (this.contextualizer != null) {
            this.contextualizer.processCriteriaBasedOnThis(method, baseCriteria);
        }
    }

    protected final boolean shouldConsiderSite(T1 site) {
        boolean _result = this.siteSelectionPredicate != null ? this.siteSelectionPredicate.evaluate(site) : true;
        return _result;
    }

    @NonNull
    @NonNullContainer
    protected abstract Collection<ISliceCriterion> getCriteriaTemplateMethod();

    protected SlicerTool<?> getSlicerTool() {
        return this.slicerTool;
    }

    protected final boolean shouldGenerateCriteriaFrom(@NonNull T2 entity) {
        boolean _result = this.criteriaPredicate != null ? this.criteriaPredicate.evaluate(entity) : true;
        return _result;
    }
}

