/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.contextualizers;

import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.contextualizers.ISliceCriteriaContextualizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSliceCriteriaCallStackContextualizer
implements ISliceCriteriaContextualizer {
    private SlicerTool<?> slicerTool;

    @Override
    public void setSlicerTool(SlicerTool<?> slicer) {
        this.slicerTool = slicer;
    }

    @Override
    public final void processCriteriaBasedOnProgramPoint(Context programPoint, Collection<ISliceCriterion> baseCriteria) {
        Collection<Stack<ICallGraphInfo.CallTriple>> _contexts = this.getCallingContextsForProgramPoint(programPoint);
        this.contextualize(baseCriteria, _contexts);
    }

    @Override
    public final void processCriteriaBasedOnThis(SootMethod method, Collection<ISliceCriterion> baseCriteria) {
        Collection<Stack<ICallGraphInfo.CallTriple>> _contexts = this.getCallingContextsForThis(method);
        this.contextualize(baseCriteria, _contexts);
    }

    protected final SlicerTool<?> getSlicerTool() {
        return this.slicerTool;
    }

    protected abstract Collection<Stack<ICallGraphInfo.CallTriple>> getCallingContextsForProgramPoint(Context var1);

    protected abstract Collection<Stack<ICallGraphInfo.CallTriple>> getCallingContextsForThis(SootMethod var1);

    private void addCriteriaWithGivenCallStackToResult(ISliceCriterion criterion, Stack<ICallGraphInfo.CallTriple> stack, Collection<ISliceCriterion> result) {
        criterion.setCallStack(stack);
        result.add(criterion);
    }

    private void contextualize(Collection<ISliceCriterion> baseCriteria, Collection<Stack<ICallGraphInfo.CallTriple>> contexts) {
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        SliceCriteriaFactory _criteriaFactory = SliceCriteriaFactory.getFactory();
        Iterator<ISliceCriterion> _j = baseCriteria.iterator();
        int _jEnd = baseCriteria.size();
        ICallGraphInfo _cgi = this.getSlicerTool().getCallGraph();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            ISliceCriterion _criterion = _j.next();
            Iterator<Stack<ICallGraphInfo.CallTriple>> _i = contexts.iterator();
            int _iEnd = contexts.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Stack<ICallGraphInfo.CallTriple> _callStack = _i.next();
                ISliceCriterion _temp = _criteriaFactory.clone(_criterion);
                if (_callStack == null) {
                    this.addCriteriaWithGivenCallStackToResult(_temp, null, _result);
                } else if (!_callStack.isEmpty() && _cgi.getCallers(_temp.getOccurringMethod()).contains(_callStack.peek())) {
                    this.addCriteriaWithGivenCallStackToResult(_temp, (Stack<ICallGraphInfo.CallTriple>)_callStack.clone(), _result);
                }
                ++_iIndex;
            }
            _j.remove();
            ++_jIndex;
        }
        baseCriteria.addAll(_result);
    }
}

