/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class TagBasedSliceXMLizer
extends AbstractXMLizer {
    static final Logger LOGGER = LoggerFactory.getLogger(TagBasedSliceXMLizer.class);
    final String tagName;
    private final TagBasedSliceProcessor processor;

    public TagBasedSliceXMLizer(String theTagName, IJimpleIDGenerator generator) {
        this.setGenerator(generator);
        this.processor = new TagBasedSliceProcessor(generator);
        this.tagName = theTagName;
    }

    public String getFileName(String name) {
        String _result = TagBasedSliceXMLizer.xmlizeString((String)name);
        _result = _result.length() == 0 ? "slice.xml" : "slice_" + _result + ".xml";
        return _result;
    }

    public void writeXML(Map info) {
        ProcessingController _ctrl = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory((IStmtGraphFactory)info.get(IStmtGraphFactory.ID));
        _ctrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _ctrl.setEnvironment((IEnvironment)info.get(IEnvironment.ID));
        TagBasedProcessingFilter _filter = new TagBasedProcessingFilter(this.tagName);
        _filter.chain((IProcessingFilter)new XMLizingProcessingFilter());
        _ctrl.setProcessingFilter((IProcessingFilter)_filter);
        try {
            File _f = new File(String.valueOf(this.getXmlOutputDir()) + File.separator + this.getFileName((String)info.get(FILE_NAME_ID)));
            FileWriter _writer = new FileWriter(_f);
            this.processor.writer = new CustomXMLOutputter((Writer)_writer);
            this.processor.hookup(_ctrl);
            _ctrl.process();
            this.processor.unhook(_ctrl);
            _writer.flush();
            _writer.close();
        }
        catch (IOException _e) {
            LOGGER.error("Error while xmlizing slice information ", (Throwable)_e);
        }
    }

    private class TagBasedSliceProcessor
    extends AbstractProcessor {
        protected XMLOutputter writer;
        private final IJimpleIDGenerator idGenerator;
        private boolean processingClass;
        private boolean processingMethod;
        private boolean processingStmt;

        public TagBasedSliceProcessor(IJimpleIDGenerator generator) {
            this.idGenerator = generator;
        }

        public void callback(ValueBox vBox, Context context) {
            SootMethod _method = context.getCurrentMethod();
            Stmt _stmt = context.getStmt();
            try {
                NamedTag _tag = (NamedTag)vBox.getTag(TagBasedSliceXMLizer.this.tagName);
                if (_tag != null) {
                    this.writer.startTag("value");
                    this.writer.attribute("id", this.idGenerator.getIdForValueBox(vBox, _stmt, _method));
                    this.writer.endTag();
                }
            }
            catch (IOException _e) {
                LOGGER.error("Exception while writing information about " + vBox + " occurring in " + _stmt + " and " + _method.getSignature(), (Throwable)_e);
            }
        }

        public void callback(Stmt stmt, Context context) {
            SootMethod _method = context.getCurrentMethod();
            try {
                NamedTag _tag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if ((_tag = (NamedTag)stmt.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("stmt");
                    this.writer.attribute("id", this.idGenerator.getIdForStmt(stmt, _method));
                    this.processingStmt = true;
                }
            }
            catch (IOException _e) {
                LOGGER.error("Exception while writing information about " + stmt + " occurring in " + _method.getSignature(), (Throwable)_e);
            }
        }

        public void callback(SootMethod method) {
            try {
                NamedTag _tag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if (this.processingMethod) {
                    this.writer.endTag();
                    this.processingMethod = false;
                }
                if ((_tag = (NamedTag)method.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("method");
                    this.writer.attribute("id", this.idGenerator.getIdForMethod(method));
                    this.processingMethod = true;
                }
            }
            catch (IOException _e) {
                LOGGER.error("Exception while writing xml information about " + method.getSignature(), (Throwable)_e);
            }
        }

        public void callback(SootClass clazz) {
            try {
                NamedTag _tag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if (this.processingMethod) {
                    this.writer.endTag();
                    this.processingMethod = false;
                }
                if (this.processingClass) {
                    this.writer.endTag();
                    this.processingClass = false;
                }
                if ((_tag = (NamedTag)clazz.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("class");
                    this.writer.attribute("id", this.idGenerator.getIdForClass(clazz));
                    this.processingClass = true;
                }
            }
            catch (IOException _e) {
                LOGGER.error("Exception while writing xml information about " + clazz.getName(), (Throwable)_e);
            }
        }

        public void callback(SootField field) {
            NamedTag _tag = (NamedTag)field.getTag(TagBasedSliceXMLizer.this.tagName);
            if (_tag != null) {
                try {
                    this.writer.startTag("field");
                    this.writer.attribute("id", this.idGenerator.getIdForField(field));
                    this.writer.endTag();
                }
                catch (IOException _e) {
                    LOGGER.error("Exception while writing xml information about " + field.getSignature(), (Throwable)_e);
                }
            }
        }

        public void consolidate() {
            try {
                this.writer.endDocument();
            }
            catch (IOException _e) {
                LOGGER.error("Exception while finishing up writing xml information.", (Throwable)_e);
            }
        }

        public void hookup(ProcessingController ppc) {
            ppc.registerForAllStmts((IProcessor)this);
            ppc.register((IProcessor)this);
            ppc.registerForAllValues((IProcessor)this);
        }

        public void processingBegins() {
            try {
                this.writer.declaration();
                this.writer.startTag("system");
            }
            catch (IOException _e) {
                LOGGER.error("Exception while starting up writing xml information.", (Throwable)_e);
            }
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregisterForAllStmts((IProcessor)this);
            ppc.unregister((IProcessor)this);
            ppc.unregisterForAllValues((IProcessor)this);
        }
    }
}

