/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.slicer.SliceGotoProcessor;
import edu.ksu.cis.indus.slicer.transformations.ExecutableSlicePostProcessorAndModifier;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.processing.ISlicePostProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlicerToolHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlicerToolHelper.class);

    private SlicerToolHelper() {
    }

    public static void applyPostProcessor(SlicerTool<?> tool, ISlicePostProcessor processor) {
        SliceCollector _collector = tool.getSliceCollector();
        Collection<SootMethod> _methods = _collector.getMethodsInSlice();
        SliceGotoProcessor _gotoProcessor = new SliceGotoProcessor(_collector);
        BasicBlockGraphMgr _bbgMgr = tool.getBasicBlockGraphManager();
        processor.process(_methods, _bbgMgr, _collector);
        _gotoProcessor.process(_methods, _bbgMgr);
    }

    public static String loadConfigurationInFile(String configFileName) {
        URL _filename;
        InputStream _inStream = null;
        String _result = null;
        if (configFileName == null) {
            LOGGER.warn("Trying to use default configuration.");
            _filename = ClassLoader.getSystemResource("edu/ksu/cis/indus/tools/slicer/default_slicer_configuration.xml");
        } else {
            try {
                _filename = new File(configFileName).toURI().toURL();
            }
            catch (MalformedURLException _e) {
                LOGGER.warn("The specified path " + configFileName + " does not exist.");
                throw new IllegalArgumentException("The specified path is invalid. - " + configFileName, _e);
            }
        }
        try {
            try {
                _inStream = _filename.openStream();
                _result = IOUtils.toString((InputStream)_inStream);
            }
            catch (IOException _e2) {
                LOGGER.error("Could not retrieve a handle to configuration file or an .IO error while reading configuration file. ", (Throwable)_e2);
                throw new IllegalStateException(_e2);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)_inStream);
        }
        return _result;
    }

    public static Collection<SootClass> optimizeForSpaceAfterResidualization(SlicerTool<?> tool, Collection<String> classesToRetain) {
        HashSet<SootClass> _classesToErase = new HashSet<SootClass>();
        Collection _classes = tool.getSystem().getClasses();
        Iterator _i = _classes.iterator();
        int _iEnd = _classes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = (SootClass)_i.next();
            if (_sc.getMethods().size() == 0 && _sc.getFields().size() == 0 && !classesToRetain.contains(_sc.getName())) {
                _classesToErase.add(_sc);
            }
            ++_iIndex;
        }
        Collection _c = Util.eraseClassesFrom(_classesToErase, (IEnvironment)tool.getSystem());
        _classesToErase.removeAll(_c);
        return _c;
    }

    public static void optimizeForSpaceBeforeResidualization(SlicerTool<?> tool, Collection<String> classesToRetain) {
        IEnvironment _system = tool.getSystem();
        ExecutableSlicePostProcessorAndModifier _processor = new ExecutableSlicePostProcessorAndModifier(_system, classesToRetain);
        SlicerToolHelper.applyPostProcessor(tool, _processor);
    }
}

