/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.ICallingContextRetriever;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IExceptionRaisingInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.INewExpr2InitMapper;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.slicer.SliceType;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.cfg.ExceptionRaisingAnalysis;
import edu.ksu.cis.indus.staticanalyses.cfg.StaticFieldUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.MonitorAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.SafeLockAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.DataAliasBasedCallingContextRetrieverV3;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ThreadEscapeInfoBasedCallingContextRetrieverV2;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.processors.NewExpr2InitMapper;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.tools.AbstractTool;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.CompositeToolConfigurator;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.slicer.SlicerConfiguration;
import edu.ksu.cis.indus.tools.slicer.SlicerConfigurator;
import edu.ksu.cis.indus.tools.slicer.SlicerToolHelper;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.ISliceCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.processing.ExecutableSlicePostProcessor;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Type;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlicerTool<T extends ITokens<T, Value>>
extends AbstractTool {
    public static final Phase DEPENDENCE_MAJOR_PHASE;
    public static final String FLOW_ANALYSIS_TAG_NAME = "indus.tools.slicer.SlicerTool:FA";
    public static final Phase SLICE_MAJOR_PHASE;
    private static final int INDENT = 4;
    private static final Logger LOGGER;
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private AliasedUseDefInfov2 aliasUD;
    private final BasicBlockGraphMgr bbgMgr;
    private final CallGraphInfo callGraph;
    private final ValueAnalyzerBasedProcessingController cgBasedPreProcessCtrl;
    private final ValueAnalyzerBasedProcessingController cgPreProcessCtrl;
    private final Collection<ISliceCriterion> criteria;
    private final Collection<ISliceCriteriaGenerator<?, ?>> criteriaGenerators;
    private AnalysesController daController;
    private EquivalenceClassBasedEscapeAnalysis ecba;
    private final SlicingEngine engine;
    private final Map<Comparable<?>, Object> info;
    private NewExpr2InitMapper initMapper;
    private final MonitorAnalysis monitorInfo;
    private final OFAnalyzer<T> ofa;
    private final Pair.PairManager pairMgr;
    private Phase phase;
    private final Collection<SootMethod> rootMethods;
    private final SafeLockAnalysis safelockAnalysis;
    private SpecificationBasedScopeDefinition sliceScopeDefinition;
    private final StaticFieldUseDefInfo staticFieldUD;
    private final IStmtGraphFactory<?> stmtGraphFactory;
    private IEnvironment system;
    private final ITokenManager<T, Value, Type> theTokenMgr;
    private final ThreadGraph threadGraph;

    static {
        LOGGER = LoggerFactory.getLogger(SlicerTool.class);
        Phase _i = Phase.createPhase();
        _i.nextMajorPhase();
        DEPENDENCE_MAJOR_PHASE = _i.clone();
        _i.nextMajorPhase();
        SLICE_MAJOR_PHASE = _i.clone();
    }

    public SlicerTool(ITokenManager<T, Value, Type> tokenMgr, IStmtGraphFactory<?> stmtGraphFactoryToUse) {
        this.theTokenMgr = tokenMgr;
        this.phase = Phase.createPhase();
        this.rootMethods = new HashSet<SootMethod>();
        this.criteria = new HashSet<ISliceCriterion>();
        this.info = new HashMap();
        this.criteriaGenerators = new HashSet();
        this.stmtGraphFactory = stmtGraphFactoryToUse;
        this.ofa = OFAnalyzer.getFIOSAnalyzer((String)FLOW_ANALYSIS_TAG_NAME, tokenMgr, this.getStmtGraphFactory());
        this.addActivePart(this.ofa.getActivePart());
        this.cgPreProcessCtrl = new ValueAnalyzerBasedProcessingController();
        this.cgPreProcessCtrl.setAnalyzer(this.ofa);
        this.cgPreProcessCtrl.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(FLOW_ANALYSIS_TAG_NAME));
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        this.cgPreProcessCtrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        this.addActivePart(this.cgPreProcessCtrl.getActivePart());
        this.pairMgr = new Pair.PairManager(false, true);
        this.callGraph = new CallGraphInfo(this.pairMgr);
        this.cgBasedPreProcessCtrl = new ValueAnalyzerBasedProcessingController();
        this.cgBasedPreProcessCtrl.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter((ICallGraphInfo)this.callGraph));
        this.cgBasedPreProcessCtrl.setAnalyzer(this.ofa);
        this.cgBasedPreProcessCtrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        this.addActivePart(this.cgBasedPreProcessCtrl.getActivePart());
        this.bbgMgr = new BasicBlockGraphMgr();
        this.bbgMgr.setStmtGraphFactory(this.getStmtGraphFactory());
        _ssr.setBbgFactory(this.bbgMgr);
        this.threadGraph = new ThreadGraph((ICallGraphInfo)this.callGraph, new CFGAnalysis((ICallGraphInfo)this.callGraph, this.bbgMgr), this.pairMgr);
        this.ecba = new EquivalenceClassBasedEscapeAnalysis((ICallGraphInfo)this.callGraph, null, this.bbgMgr);
        this.monitorInfo = new MonitorAnalysis();
        this.safelockAnalysis = new SafeLockAnalysis();
        this.aliasUD = new AliasedUseDefInfov2(this.ofa, (ICallGraphInfo)this.callGraph, (IThreadGraphInfo)this.threadGraph, this.bbgMgr, this.pairMgr);
        this.staticFieldUD = new StaticFieldUseDefInfo();
        this.info.put(ICallGraphInfo.ID, this.callGraph);
        this.info.put(IThreadGraphInfo.ID, this.threadGraph);
        this.info.put(IEnvironment.ID, this.ofa.getEnvironment());
        this.info.put(IUseDefInfo.ALIASED_USE_DEF_ID, this.aliasUD);
        this.info.put(IUseDefInfo.GLOBAL_USE_DEF_ID, this.staticFieldUD);
        this.info.put(Pair.PairManager.ID, this.pairMgr);
        this.info.put(IValueAnalyzer.ID, this.ofa);
        this.info.put(IEscapeInfo.ID, this.ecba.getEscapeInfo());
        this.info.put(IMonitorInfo.ID, this.monitorInfo);
        this.info.put(SafeLockAnalysis.ID, this.safelockAnalysis);
        this.engine = new SlicingEngine();
        this.addActivePart(this.engine.getActivePart());
        this.initMapper = new NewExpr2InitMapper();
        this.addActivePart((IActivePart)this.activePart);
    }

    public void addCriteria(Collection<ISliceCriterion> theCriteria) {
        this.criteria.addAll(theCriteria);
    }

    public boolean addCriteriaGenerator(ISliceCriteriaGenerator<?, ?> theCriteriaGenerator) {
        return this.criteriaGenerators.add(theCriteriaGenerator);
    }

    public void clearCriteria() {
        this.criteria.clear();
    }

    public boolean destringizeConfiguration(String stringizedForm) {
        IUnmarshallingContext _unmarshallingContext;
        boolean _result = false;
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(CompositeToolConfiguration.class);
            _unmarshallingContext = _bindingFactory.createUnmarshallingContext();
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while setting up JiBX.  Aborting.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        this.configurationInfo = null;
        if (stringizedForm != null && stringizedForm.length() != 0) {
            try {
                StringReader _reader = new StringReader(stringizedForm);
                this.configurationInfo = (IToolConfiguration)_unmarshallingContext.unmarshalDocument((Reader)_reader, null);
                _result = true;
            }
            catch (JiBXException _e) {
                LOGGER.error("Error while unmarshalling Slicer configurationCollection. Recovering with new clean configuration.", (Throwable)_e);
                this.configurationInfo = null;
            }
        }
        if (this.configurationInfo == null) {
            this.initialize();
        }
        this.configurator = new CompositeToolConfigurator((CompositeToolConfiguration)this.configurationInfo, (IToolConfigurator)new SlicerConfigurator(), SlicerConfiguration.getFactory());
        return _result;
    }

    public void execute(Phase phaseParam, Phase lastPhase) throws InterruptedException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Execution of the slicer tool");
        }
        Phase _ph = this.phase;
        if (phaseParam != null && phaseParam.isEarlierThan(this.phase)) {
            _ph = this.phase = phaseParam.clone();
        }
        if (_ph.equalsMajor(Phase.STARTING_PHASE)) {
            this.fireToolProgressEvent("Performing low level analyses", _ph);
            this.lowLevelAnalysisPhase();
        }
        if (this.phase.equals((Object)lastPhase)) {
            return;
        }
        this.movingToNextPhase();
        SlicerConfiguration _slicerConfig = (SlicerConfiguration)this.getActiveConfiguration();
        this.setCurrentConfiguration((IToolConfiguration)_slicerConfig);
        _slicerConfig.setupForUse();
        if (_ph.equalsMajor(DEPENDENCE_MAJOR_PHASE)) {
            this.fireToolProgressEvent("Performing dependence analyses", _ph);
            this.dependencyAnalysisPhase(_slicerConfig);
        }
        if (this.phase.equals((Object)lastPhase)) {
            return;
        }
        this.movingToNextPhase();
        if (_ph.equalsMajor(SLICE_MAJOR_PHASE)) {
            this.fireToolProgressEvent("Performing slicing", _ph);
            this.slicingPhase(_slicerConfig);
        }
        this.phase.finished();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Execution of the slicer tool");
        }
    }

    public BasicBlockGraphMgr getBasicBlockGraphManager() {
        return this.bbgMgr;
    }

    public ICallGraphInfo getCallGraph() {
        return this.callGraph;
    }

    public Collection<ISliceCriterion> getCriteria() {
        return this.criteria;
    }

    public Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> getDAs() {
        LinkedHashSet _result = new LinkedHashSet();
        SlicerConfiguration _config = (SlicerConfiguration)this.getActiveConfiguration();
        ArrayList<IDependencyAnalysis.DependenceSort> _daNames = new ArrayList<IDependencyAnalysis.DependenceSort>(_config.getIDsOfDAsToUse());
        Collections.sort(_daNames);
        Iterator _i = _daNames.iterator();
        while (_i.hasNext()) {
            _result.addAll(_config.getDependenceAnalyses((IDependencyAnalysis.DependenceSort)_i.next()));
        }
        return _result;
    }

    public EquivalenceClassBasedEscapeAnalysis getECBA() {
        return this.ecba;
    }

    public IEscapeInfo getEscapeInfo() {
        return this.ecba.getEscapeInfo();
    }

    public MonitorAnalysis getMonitorInfo() {
        return this.monitorInfo;
    }

    public IValueAnalyzer<Value> getOFAnalyzer() {
        return this.ofa;
    }

    public Object getPhase() {
        return this.phase;
    }

    public Collection<SootMethod> getRootMethods() {
        return Collections.unmodifiableCollection(this.rootMethods);
    }

    public IStmtGraphFactory<?> getStmtGraphFactory() {
        return this.stmtGraphFactory;
    }

    public IEnvironment getSystem() {
        return this.system;
    }

    public void initialize() {
        this.configurationInfo = new CompositeToolConfiguration();
        IToolConfiguration _toolConfig = SlicerConfiguration.getFactory().createToolConfiguration();
        _toolConfig.initialize();
        ((CompositeToolConfiguration)this.configurationInfo).addToolConfiguration(_toolConfig);
    }

    public boolean removeCriteriaGenerator(ISliceCriteriaGenerator<?, ?> theCriteriaGenerator) {
        return this.criteriaGenerators.remove(theCriteriaGenerator);
    }

    public void reset() {
        this.aliasUD.reset();
        this.bbgMgr.reset();
        this.callGraph.reset();
        this.cgBasedPreProcessCtrl.reset();
        this.cgPreProcessCtrl.reset();
        this.criteria.clear();
        this.ecba.reset();
        this.engine.reset();
        this.initMapper.reset();
        this.monitorInfo.reset();
        this.ofa.reset();
        this.pairMgr.reset();
        this.phase.reset();
        this.rootMethods.clear();
        this.safelockAnalysis.reset();
        this.stmtGraphFactory.reset();
        this.theTokenMgr.reset();
        this.threadGraph.reset();
        this.activePart.activate();
        if (this.daController != null) {
            this.daController.reset();
        }
    }

    public void setActiveConfiguration(String configID) {
        if (this.configurationInfo instanceof CompositeToolConfiguration) {
            ((CompositeToolConfiguration)this.configurationInfo).setActiveToolConfigurationID(configID);
        }
    }

    public void setRootMethods(Collection<SootMethod> theRootMethods) {
        this.rootMethods.clear();
        this.rootMethods.addAll(theRootMethods);
    }

    public void setSliceScopeDefinition(SpecificationBasedScopeDefinition scope) {
        this.sliceScopeDefinition = scope;
    }

    public void setSystem(IEnvironment theEnvironment) {
        this.system = theEnvironment;
    }

    public void setTagName(String tagName) {
        this.engine.setTagName(tagName);
    }

    public String stringizeConfiguration() {
        StringWriter _result = new StringWriter();
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(CompositeToolConfiguration.class);
            IMarshallingContext _marshallingContext = _bindingFactory.createMarshallingContext();
            _marshallingContext.setIndent(4);
            _marshallingContext.marshalDocument((Object)this.configurationInfo, "UTF-8", null, (Writer)_result);
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while marshalling Slicer configurationCollection.");
            throw new RuntimeException(_e);
        }
        return _result.toString();
    }

    protected void checkConfiguration() {
        IToolConfiguration _slicerConf = this.getActiveConfiguration();
        if (((Boolean)_slicerConf.getProperty(SlicerConfiguration.EXECUTABLE_SLICE)).booleanValue() && _slicerConf.getProperty(SlicerConfiguration.SLICE_TYPE).equals((Object)SliceType.FORWARD_SLICE)) {
            LOGGER.error("Forward Executable slice is unsupported.");
            throw new IllegalStateException("Forward Executable slice is unsupported.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checkConfiguration() - " + _slicerConf.getConfigName());
        }
    }

    SliceCollector getSliceCollector() {
        return this.engine.getCollector();
    }

    private void dependencyAnalysisPhase(SlicerConfiguration slicerConfig) {
        BasicBlockGraphMgr _b;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: dependence analyses phase");
        }
        if (slicerConfig.isExplicitExceptionalExitSensitiveControlDependenceUsed()) {
            ExceptionRaisingAnalysis _e = new ExceptionRaisingAnalysis(this.getStmtGraphFactory(), this.getCallGraph(), this.getSystem());
            if (slicerConfig.areCommonUncheckedExceptionsConsidered()) {
                _e.setupForCommonUncheckedExceptions();
            }
            _e.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
            this.cgBasedPreProcessCtrl.process();
            _e.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
            _b = new BasicBlockGraphMgr((IExceptionRaisingInfo)_e);
            _b.setStmtGraphFactory(this.getStmtGraphFactory());
        } else {
            _b = this.getBasicBlockGraphManager();
        }
        this.daController = new AnalysesController(this.info, (ProcessingController)this.cgBasedPreProcessCtrl, _b);
        this.addActivePart(this.daController.getActivePart());
        Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> _controlDAs = slicerConfig.getDependenceAnalyses(IDependencyAnalysis.DependenceSort.CONTROL_DA);
        Collection _deps = (Collection)MapUtils.getFromMap(this.info, (Object)IDependencyAnalysis.DependenceSort.CONTROL_DA, new ArrayList());
        _deps.addAll(_controlDAs);
        for (IDependencyAnalysis.DependenceSort _id : slicerConfig.getIDsOfDAsToUse()) {
            Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> _c = slicerConfig.getDependenceAnalyses(_id);
            this.daController.addAnalyses((Comparable)_id, _c);
        }
        this.daController.addAnalyses(IMonitorInfo.ID, (Collection)Collections.singleton(this.monitorInfo));
        this.daController.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection)Collections.singleton(this.ecba));
        if (slicerConfig.isSafeLockAnalysisUsedForReady()) {
            this.daController.addAnalyses(SafeLockAnalysis.ID, (Collection)Collections.singleton(this.safelockAnalysis));
        }
        this.daController.initialize();
        this.daController.execute();
        this.removeActivePart(this.daController.getActivePart());
        String _deadlockCriteriaSelectionStrategy = slicerConfig.getDeadlockCriteriaSelectionStrategy();
        if (!slicerConfig.getPropertyAware() && !_deadlockCriteriaSelectionStrategy.equals(SlicerConfiguration.CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS)) {
            this.ecba.flushSiteContexts();
        }
        this.phase.nextMajorPhase();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: dependence analyses phase");
        }
    }

    private void lowLevelAnalysisPhase() throws InterruptedException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: low level static analyses phase");
        }
        this.fireToolProgressEvent("LOW LEVEL ANALYSES: Performing object flow analysis", this.phase);
        this.phase.reset();
        this.ofa.reset();
        this.bbgMgr.reset();
        this.stmtGraphFactory.reset();
        this.ofa.analyze(this.system, this.rootMethods);
        this.phase.nextMinorPhase();
        this.movingToNextPhase();
        this.fireToolProgressEvent("LOW LEVEL ANALYSES: Constructing call graph", this.phase);
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        this.cgPreProcessCtrl.reset();
        _callGraphInfoCollector.hookup((ProcessingController)this.cgPreProcessCtrl);
        this.cgPreProcessCtrl.process();
        _callGraphInfoCollector.unhook((ProcessingController)this.cgPreProcessCtrl);
        this.callGraph.reset();
        this.callGraph.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.phase.nextMinorPhase();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Call Graph:\n" + this.callGraph);
        }
        this.movingToNextPhase();
        this.fireToolProgressEvent("LOW LEVEL ANALYSES: Constructing thread graph and misc.", this.phase);
        this.threadGraph.reset();
        this.cgBasedPreProcessCtrl.reset();
        this.initMapper.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.threadGraph.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.cgBasedPreProcessCtrl.process();
        this.threadGraph.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.initMapper.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.phase.nextMinorPhase();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread Graph:\n" + this.threadGraph);
        }
        this.movingToNextPhase();
        this.fireToolProgressEvent("LOW LEVEL ANALYSES: Calculating inter-procedural use-def information", this.phase);
        this.cgBasedPreProcessCtrl.reset();
        this.aliasUD.reset();
        this.aliasUD.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.staticFieldUD.reset();
        this.staticFieldUD.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.cgBasedPreProcessCtrl.process();
        this.aliasUD.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.staticFieldUD.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.phase.nextMajorPhase();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: low level static analyses phase");
        }
    }

    private void postProcessSlice() {
        SlicerConfiguration _slicerConfig = (SlicerConfiguration)this.getActiveConfiguration();
        if (_slicerConfig.getExecutableSlice()) {
            SlicerToolHelper.applyPostProcessor(this, new ExecutableSlicePostProcessor());
        }
    }

    private void slicingPhase(SlicerConfiguration slicerConfig) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: slicing phase");
        }
        this.engine.reset();
        this.fireToolProgressEvent("SLICING: adding criteria", this.phase);
        for (ISliceCriteriaGenerator<?, ?> _e : this.criteriaGenerators) {
            this.criteria.addAll(_e.getCriteria(this));
        }
        for (ISliceCriteriaGenerator<?, ?> _generator : slicerConfig.getSliceCriteriaGenerators()) {
            this.criteria.addAll(_generator.getCriteria(this));
        }
        if (!this.criteria.isEmpty()) {
            this.fireToolProgressEvent("SLICING: Calculating the slice", this.phase);
            this.engine.setCgi((ICallGraphInfo)this.callGraph);
            this.engine.setSliceType((SliceType)((Object)slicerConfig.getProperty(SlicerConfiguration.SLICE_TYPE)));
            this.engine.setInitMapper((INewExpr2InitMapper)this.initMapper);
            this.engine.setBasicBlockGraphManager(this.bbgMgr);
            this.engine.setAnalysesControllerAndDependenciesToUse(this.daController, slicerConfig.getIDsOfDAsToUse());
            this.engine.setSliceCriteria(this.criteria);
            this.engine.setSliceScopeDefinition(this.sliceScopeDefinition);
            this.engine.setSystem(this.system);
            if (slicerConfig.getPropertyAware()) {
                HashMap<IDependencyAnalysis.DependenceSort, ICallingContextRetriever> _map = new HashMap<IDependencyAnalysis.DependenceSort, ICallingContextRetriever>();
                int _callingContextLimit = slicerConfig.getCallingContextLimit();
                ThreadEscapeInfoBasedCallingContextRetrieverV2 _t1 = new ThreadEscapeInfoBasedCallingContextRetrieverV2(_callingContextLimit, true, false);
                _t1.setEscapeInfo(this.getEscapeInfo());
                _t1.setECBA(this.ecba);
                _t1.setCallGraph(this.getCallGraph());
                _map.put(IDependencyAnalysis.DependenceSort.READY_DA, (ICallingContextRetriever)_t1);
                ThreadEscapeInfoBasedCallingContextRetrieverV2 _t2 = new ThreadEscapeInfoBasedCallingContextRetrieverV2(_callingContextLimit, false, true);
                _t2.setEscapeInfo(this.getEscapeInfo());
                _t2.setECBA(this.ecba);
                _t2.setCallGraph(this.getCallGraph());
                _map.put(IDependencyAnalysis.DependenceSort.INTERFERENCE_DA, (ICallingContextRetriever)_t2);
                DataAliasBasedCallingContextRetrieverV3 _t3 = new DataAliasBasedCallingContextRetrieverV3(_callingContextLimit);
                _t3.setCallGraph(this.getCallGraph());
                _t3.setThreadGraph((IThreadGraphInfo)this.threadGraph);
                _t3.setCfgAnalysis(new CFGAnalysis(this.getCallGraph(), this.getBasicBlockGraphManager()));
                _t3.setECBA(this.ecba);
                _map.put(IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA, (ICallingContextRetriever)_t3);
                this.engine.setDepID2ContextRetrieverMapping(_map);
            }
            this.engine.initialize();
            this.engine.slice();
            this.phase.nextMinorPhase();
            this.fireToolProgressEvent("SLICING: Post processing the slice", this.phase);
            this.postProcessSlice();
            this.phase.nextMajorPhase();
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("No slicing criteria were specified. Hence, no slicing was done.\nIf \"slice for deadlock\" was selected then the system did not have any synchronized methods or synchronized blocks.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: slicing phase");
        }
    }
}

