/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.AbstractXMLBasedTestSetup;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.XMLBasedDependencyAnalysisTest;
import edu.ksu.cis.indus.tools.slicer.SliceXMLizerCLI;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;

public class SlicerTestSetup
extends AbstractXMLBasedTestSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlicerTestSetup.class);
    SliceXMLizerCLI driver = new SliceXMLizerCLI();

    public SlicerTestSetup(TestSuite suite, String[] classNames, String xmlTestDirectory, String xmlControlDirectory, String sootClasspath) {
        super(suite);
        this.driver.setOutputDirectory(xmlTestDirectory);
        if (sootClasspath != null) {
            this.driver.addToSootClassPath(sootClasspath);
        }
        this.driver.setClassNames(Arrays.asList(classNames));
        this.setXMLControlDir(xmlControlDirectory);
        this.setXMLTestDir(xmlTestDirectory);
    }

    protected void setUp() throws Exception {
        this.driver.setIDGenerator(this.idGenerator);
        this.driver.initialize();
        this.driver.slicer.destringizeConfiguration(this.stringizeConfig());
        this.driver.executeForSingleSlice();
        TestSuite _suite = (TestSuite)this.getTest();
        DependencyXMLizer _xmlizer = new DependencyXMLizer();
        ICallGraphInfo _cgiImpl = this.driver.slicer.getCallGraph();
        IEnvironment _environment = this.driver.slicer.getSystem();
        for (IDependencyAnalysis<?, ?, ?, ?, ?, ?> _da : this.driver.slicer.getDAs()) {
            XMLBasedDependencyAnalysisTest _test = new XMLBasedDependencyAnalysisTest(_da, _xmlizer);
            _test.setCallGraph(_cgiImpl);
            _test.setEnvironment(_environment);
            _suite.addTest((Test)_test);
        }
        this.setStmtGraphFactory(this.driver.slicer.getStmtGraphFactory());
        super.setUp();
        TestHelper.appendSuiteNameToTestsIn((TestSuite)_suite, (boolean)true);
    }

    protected void tearDown() throws Exception {
        this.driver.destructivelyUpdateJimple();
        if (this.dumpLocation != null) {
            this.driver.jimpleXMLDumpDir = this.dumpLocation;
            this.driver.dumpJimpleAsXML("");
        }
        G.reset();
        this.driver.slicer.reset();
        Iterator<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> _iter = this.driver.slicer.getDAs().iterator();
        while (_iter.hasNext()) {
            _iter.next().reset();
        }
        this.driver = null;
        super.tearDown();
    }

    private String stringizeConfig() {
        InputStreamReader _reader = null;
        URL _defaultConfigFileName = ClassLoader.getSystemResource("edu/ksu/cis/indus/tools/slicer/default_slicer_configuration.xml");
        try {
            _reader = new InputStreamReader(_defaultConfigFileName.openStream());
        }
        catch (FileNotFoundException _e1) {
            LOGGER.error("Even default configuration file could not be found.  Aborting", (Throwable)_e1);
            throw new RuntimeException(_e1);
        }
        catch (IOException _e2) {
            LOGGER.error("Could not retrieve a handle to default configuration file.  Aborting.", (Throwable)_e2);
            throw new RuntimeException(_e2);
        }
        String _result = null;
        try {
            BufferedReader _br = new BufferedReader(_reader);
            StringBuffer _buffer = new StringBuffer();
            while (_br.ready()) {
                _buffer.append(_br.readLine());
            }
            _result = _buffer.toString();
        }
        catch (IOException _e) {
            LOGGER.error("IO error while reading configuration file.  Aborting", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        return _result;
    }
}

