/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.ErringTestCase;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.tools.slicer.SlicerTestSetup;
import edu.ksu.cis.indus.tools.slicer.XMLBasedSlicerTest;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public final class SlicerRegressionTestSuite
extends TestCase {
    private static final String SLICER_TEST_PROPERTIES_FILE = "indus.slicer.XMLBasedSlicerTest.properties.file";

    public static void main(String[] args) {
        String[] _suiteName = new String[]{SlicerRegressionTestSuite.class.getName()};
        TestRunner.main((String[])_suiteName);
    }

    public static Test suite() {
        TestSuite _suite = new TestSuite("Test for edu.ksu.cis.indus.tools.slicer");
        String _propFileName = System.getProperty(SLICER_TEST_PROPERTIES_FILE);
        if (_propFileName == null) {
            throw new RuntimeException("Please provide a property file like XMLBasedSlicerTest.properties via-Dindus.slicer.XMLBasedSlicerTest.properties.file");
        }
        SlicerRegressionTestSuite.setupTests(_propFileName, _suite);
        return _suite;
    }

    private static void setupTests(String propFileName, TestSuite suite) {
        Properties _props = new Properties();
        try {
            FileInputStream _propFile = new FileInputStream(new File(propFileName));
            _props.load(_propFile);
            _propFile.close();
            String[] _configs = _props.getProperty("configs").split(" ");
            int _i = 0;
            while (_i < _configs.length) {
                Object _test;
                String _config = _configs[_i];
                _props.setProperty("name", _config);
                String[] _temp = _props.getProperty(String.valueOf(_config) + ".classNames").split(" ");
                String _xmlTestDir = _props.getProperty(String.valueOf(_config) + ".xmlTestDir");
                String _xmlControlDir = _props.getProperty(String.valueOf(_config) + ".xmlControlDir");
                String _classpath = _props.getProperty(String.valueOf(_config) + ".classpath");
                String _jimpleXMLDumpDir = _props.getProperty(String.valueOf(_config) + ".jimpleXMLDumpDir");
                String _str = TestHelper.checkXMLBasedTestExecutability((String)_config, (String)_xmlTestDir, (String)_xmlControlDir);
                try {
                    if (_str.length() > 0) {
                        _test = new ErringTestCase(_str);
                    } else {
                        TestSuite _suite = new TestSuite(_config);
                        SlicerTestSetup _sTestSetup = new SlicerTestSetup(_suite, _temp, _xmlTestDir, _xmlControlDir, _classpath);
                        _sTestSetup.setJimpleXMLDumpLocation(_jimpleXMLDumpDir);
                        _sTestSetup.setIdGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
                        XMLBasedSlicerTest _xmlTest = new XMLBasedSlicerTest(_sTestSetup);
                        _suite.addTest((Test)_xmlTest);
                        _test = _sTestSetup;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _test = null;
                }
                if (_test != null) {
                    suite.addTest((Test)_test);
                }
                ++_i;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Specified property file does not exist.");
        }
    }
}

