/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.slicer.SliceType;
import edu.ksu.cis.indus.tools.AbstractToolConfigurator;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.slicer.SlicerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public final class SlicerConfigurator
extends AbstractToolConfigurator {
    Button executableSliceButton;

    SlicerConfigurator() {
    }

    public void widgetDisposed(DisposeEvent evt) {
        super.widgetDisposed(evt);
        this.executableSliceButton = null;
    }

    protected void checkConfiguration(IToolConfiguration toolConfiguration) {
        if (!(toolConfiguration instanceof SlicerConfiguration)) {
            throw new RuntimeException("The toolConfiguration has to be of type edu.ksu.cis.indus.tools.slicer.SlicerConfiguration.");
        }
    }

    protected void setup() {
        TabFolder _tabFolder = new TabFolder(this.parent, 2176);
        TabItem _sliceInfoTab = new TabItem(_tabFolder, 0);
        Composite _sliceInfoTabComposite = new Composite((Composite)_tabFolder, 0);
        this.setupSliceInfoUI(_sliceInfoTabComposite);
        _sliceInfoTabComposite.pack();
        _sliceInfoTab.setControl((Control)_sliceInfoTabComposite);
        _sliceInfoTab.setText("Slice");
        _sliceInfoTab.setToolTipText("Configure slice properties.");
        TabItem _dependenceDATab = new TabItem(_tabFolder, 0);
        Composite _dependenceDAComposite = new Composite((Composite)_tabFolder, 0);
        this.setupDependenceDepUI(_dependenceDAComposite);
        _dependenceDAComposite.pack();
        _dependenceDATab.setControl((Control)_dependenceDAComposite);
        _dependenceDATab.setText("General Dependence");
        _dependenceDATab.setToolTipText("Configure control and synchronization dependences.");
        TabItem _divergenceDATab = new TabItem(_tabFolder, 0);
        Composite _divergenceDAComposite = new Composite((Composite)_tabFolder, 0);
        this.setupDivergenceDepUI(_divergenceDAComposite);
        _divergenceDAComposite.pack();
        _divergenceDATab.setControl((Control)_divergenceDAComposite);
        _divergenceDATab.setText("Divergence");
        _divergenceDATab.setToolTipText("Configure divergence dependences.");
        TabItem _interferenceDATab = new TabItem(_tabFolder, 0);
        Composite _interferenceDATabComposite = new Composite((Composite)_tabFolder, 0);
        this.setupInteferenceDepUI(_interferenceDATabComposite);
        _interferenceDATabComposite.pack();
        _interferenceDATab.setControl((Control)_interferenceDATabComposite);
        _interferenceDATab.setText("Intereference");
        _interferenceDATab.setToolTipText("Configure interference dependences.");
        TabItem _readyDATab = new TabItem(_tabFolder, 0);
        Composite _readyDATabComposite = new Composite((Composite)_tabFolder, 0);
        this.setupReadyDepUI(_readyDATabComposite);
        _readyDATabComposite.pack();
        _readyDATab.setControl((Control)_readyDATabComposite);
        _readyDATab.setText("Ready");
        _readyDATab.setToolTipText("Configure ready dependences.");
        _tabFolder.pack();
        this.parent.pack();
    }

    private void setupAssertionUI(Composite composite, SlicerConfiguration cfg) {
        Group _assertionGroup = new Group(composite, 0);
        GridData _gridData1 = new GridData(1, 1, false, false);
        _gridData1.horizontalSpan = 3;
        _gridData1.grabExcessHorizontalSpace = true;
        _assertionGroup.setLayoutData((Object)_gridData1);
        GridLayout _gl1 = new GridLayout(3, false);
        _assertionGroup.setLayout((Layout)_gl1);
        _assertionGroup.setText("Preservation of assertions in the system");
        Button _assertionPreservingSliceButton = new Button((Composite)_assertionGroup, 32);
        _assertionPreservingSliceButton.setText("Preserve assertions");
        _assertionPreservingSliceButton.setEnabled(true);
        GridData _gd2 = new GridData(1, 1, false, false);
        _gd2.horizontalSpan = 1;
        _assertionPreservingSliceButton.setLayoutData((Object)_gd2);
        final Button _applclasses = new Button((Composite)_assertionGroup, 32);
        _applclasses.setText("Preserve assertions in application classes only");
        _applclasses.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.ASSERTIONS_IN_APPLICATION_CLASSES_ONLY, _applclasses, (IToolConfiguration)cfg));
        _applclasses.setSelection(cfg.areAssertionsOnlyInAppClassesConsidered());
        GridData _gd3 = new GridData(0x1000008, 1, false, false);
        _gd3.horizontalSpan = 2;
        _gd3.grabExcessHorizontalSpace = true;
        _applclasses.setLayoutData((Object)_gd3);
        AbstractToolConfigurator.BooleanPropertySelectionListener _sl1 = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.SLICE_TO_PRESERVE_ASSERTIONS, _assertionPreservingSliceButton, (IToolConfiguration)cfg){

            public void widgetSelected(SelectionEvent evt) {
                boolean _value = this.button.getSelection();
                this.containingConfiguration.setProperty(this.id, (Object)_value);
                _applclasses.setEnabled(_value);
            }
        };
        _assertionPreservingSliceButton.addSelectionListener((SelectionListener)_sl1);
        _assertionPreservingSliceButton.setSelection(cfg.getSliceToPreserveAssertions());
        _assertionPreservingSliceButton.notifyListeners(13, null);
    }

    private void setupDeadlockUI(Composite composite, final SlicerConfiguration cfg) {
        Group _deadlockGroup = new Group(composite, 0);
        GridData _gridData1 = new GridData(1, 1, false, false);
        _gridData1.horizontalSpan = 2;
        _deadlockGroup.setLayoutData((Object)_gridData1);
        RowLayout _rowLayout1 = new RowLayout();
        _rowLayout1.type = 512;
        _rowLayout1.fill = true;
        _deadlockGroup.setLayout((Layout)_rowLayout1);
        _deadlockGroup.setText("Preservation of Deadlocking property");
        Button _button = new Button((Composite)_deadlockGroup, 32);
        _button.setText("Preserve Deadlock");
        final Button _applclasses = new Button((Composite)_deadlockGroup, 32);
        _applclasses.setText("Preserve sync constructs in application classes only");
        _applclasses.setSelection(cfg.areSynchronizationsOnlyInAppClassesConsidered());
        _applclasses.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.SYNCS_IN_APPLICATION_CLASSES_ONLY, _applclasses, (IToolConfiguration)cfg));
        final Group _group1 = new Group((Composite)_deadlockGroup, 16);
        _group1.setText("Deadlock Criteria Selection Strategy");
        RowLayout _rowLayout2 = new RowLayout();
        _rowLayout2.type = 512;
        _group1.setLayout((Layout)_rowLayout2);
        final Button _allSyncStrategy = new Button((Composite)_group1, 16);
        _allSyncStrategy.setText("All Synchronization constructs");
        _allSyncStrategy.setToolTipText("Synchronization constructs are preserved independent of any property");
        final Button _escapingSyncStrategy = new Button((Composite)_group1, 16);
        _escapingSyncStrategy.setText("Escaping Sychronization constructs");
        _escapingSyncStrategy.setToolTipText("Only synchronization constructs involving escaping lock object are preserved.");
        final Button _ctxtsensEscapingSyncStrategy = new Button((Composite)_group1, 16);
        _ctxtsensEscapingSyncStrategy.setText("Escaping Sychronization constructs with their contexts");
        _ctxtsensEscapingSyncStrategy.setToolTipText("Calling contexs of the preserved synchronization constructs are considered");
        SelectionListener _sl4 = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                Comparable<String> _value = null;
                if (evt.widget == _ctxtsensEscapingSyncStrategy) {
                    _value = SlicerConfiguration.CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS;
                } else if (evt.widget == _escapingSyncStrategy) {
                    _value = SlicerConfiguration.ESCAPING_SYNC_CONSTRUCTS;
                } else if (evt.widget == _allSyncStrategy) {
                    _value = SlicerConfiguration.ALL_SYNC_CONSTRUCTS;
                }
                if (_value != null) {
                    cfg.setProperty(SlicerConfiguration.DEADLOCK_CRITERIA_SELECTION_STRATEGY, _value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        _allSyncStrategy.addSelectionListener(_sl4);
        _escapingSyncStrategy.addSelectionListener(_sl4);
        _ctxtsensEscapingSyncStrategy.addSelectionListener(_sl4);
        String _temp = cfg.getDeadlockCriteriaSelectionStrategy();
        if (_temp.equals(SlicerConfiguration.ALL_SYNC_CONSTRUCTS)) {
            _allSyncStrategy.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.ESCAPING_SYNC_CONSTRUCTS)) {
            _escapingSyncStrategy.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS)) {
            _ctxtsensEscapingSyncStrategy.setSelection(true);
        }
        AbstractToolConfigurator.BooleanPropertySelectionListener _sl5 = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.SLICE_FOR_DEADLOCK, _button, (IToolConfiguration)cfg){

            public void widgetSelected(SelectionEvent evt) {
                boolean _value = this.button.getSelection();
                this.containingConfiguration.setProperty(this.id, (Object)_value);
                _group1.setEnabled(_value);
                _applclasses.setEnabled(_value);
                _allSyncStrategy.setEnabled(_value);
                _escapingSyncStrategy.setEnabled(_value);
                _ctxtsensEscapingSyncStrategy.setEnabled(_value);
            }
        };
        _button.addSelectionListener((SelectionListener)_sl5);
        _button.setSelection(cfg.getSliceForDeadlock());
        _button.notifyListeners(13, null);
    }

    private void setupDependenceDepUI(Composite composite) {
        RowLayout _rowLayout = new RowLayout(512);
        composite.setLayout((Layout)_rowLayout);
        SlicerConfiguration _cfg = (SlicerConfiguration)this.configuration;
        Button _useNonTerminationSensitiveCDAButton = new Button(composite, 32);
        _useNonTerminationSensitiveCDAButton.setText("use non-termination sensitive control dependence");
        _useNonTerminationSensitiveCDAButton.setToolTipText("Loop behaviors are not preserved");
        _useNonTerminationSensitiveCDAButton.setSelection(((Boolean)_cfg.getProperty(SlicerConfiguration.NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE)).booleanValue());
        _useNonTerminationSensitiveCDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE, _useNonTerminationSensitiveCDAButton, (IToolConfiguration)_cfg));
        final Button _useExplicitExceptionalExitSensitiveCDAButton = new Button(composite, 32);
        _useExplicitExceptionalExitSensitiveCDAButton.setText("consider explicit exceptional exit points");
        _useExplicitExceptionalExitSensitiveCDAButton.setSelection(((Boolean)_cfg.getProperty(SlicerConfiguration.EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE)).booleanValue());
        _useExplicitExceptionalExitSensitiveCDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE, _useExplicitExceptionalExitSensitiveCDAButton, (IToolConfiguration)_cfg));
        final Button _useCommonUncheckedExceptionsCDAButton = new Button(composite, 32);
        _useCommonUncheckedExceptionsCDAButton.setText("consider common unchecked exception based exit points");
        _useCommonUncheckedExceptionsCDAButton.setSelection(((Boolean)_cfg.getProperty(SlicerConfiguration.COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD)).booleanValue());
        _useCommonUncheckedExceptionsCDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD, _useCommonUncheckedExceptionsCDAButton, (IToolConfiguration)_cfg));
        _useExplicitExceptionalExitSensitiveCDAButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean _t = _useExplicitExceptionalExitSensitiveCDAButton.getSelection();
                _useCommonUncheckedExceptionsCDAButton.setEnabled(_t);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button _useSyncDepButton = new Button(composite, 32);
        _useSyncDepButton.setText("use synchronization dependence");
        _useSyncDepButton.setToolTipText("Use synchronization dependence in calculation of the slice.");
        _useSyncDepButton.setSelection(_cfg.isSynchronizationDepAnalysisUsed());
        _useSyncDepButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_SYNCHRONIZATIONDA, _useSyncDepButton, (IToolConfiguration)_cfg));
        boolean _t = _cfg.isExplicitExceptionalExitSensitiveControlDependenceUsed();
        _useExplicitExceptionalExitSensitiveCDAButton.setSelection(_t);
        _useExplicitExceptionalExitSensitiveCDAButton.notifyListeners(13, null);
    }

    private void setupDivergenceDepUI(Composite composite) {
        RowLayout _rowLayout = new RowLayout(512);
        composite.setLayout((Layout)_rowLayout);
        final SlicerConfiguration _cfg = (SlicerConfiguration)this.configuration;
        final Button _useDDAButton = new Button(composite, 32);
        _useDDAButton.setText("use divergence dependence");
        _useDDAButton.setToolTipText("Use divergence dependence in calculation of the slice.");
        _useDDAButton.setSelection(_cfg.isDivergenceDepAnalysisUsed());
        _useDDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_DIVERGENCEDA, _useDDAButton, (IToolConfiguration)_cfg));
        final Group _natureOfDDAGroup = new Group(composite, 16);
        RowLayout _rowLayout3 = new RowLayout(512);
        _natureOfDDAGroup.setLayout((Layout)_rowLayout3);
        _natureOfDDAGroup.setText("Nature of Divergence dependence");
        final Button _intraProceduralDDA = new Button((Composite)_natureOfDDAGroup, 16);
        _intraProceduralDDA.setText("intra-procedural only");
        _intraProceduralDDA.setToolTipText("This will not capture dependence on call-sites to divergent methods.");
        final Button _interProceduralDDA = new Button((Composite)_natureOfDDAGroup, 16);
        _interProceduralDDA.setText("inter-procedural only");
        _interProceduralDDA.setToolTipText("This will not capture dependence on intra-procedual divergence.");
        final Button _intraAndInterProceduralDDA = new Button((Composite)_natureOfDDAGroup, 16);
        _intraAndInterProceduralDDA.setText("intra- and inter-procedural");
        _intraAndInterProceduralDDA.setToolTipText("This will capture both intra- and inter-procedual divergence.");
        SelectionListener _sl2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                Comparable<String> _value = null;
                if (evt.widget == _intraProceduralDDA) {
                    _value = SlicerConfiguration.INTRA_PROCEDURAL_ONLY;
                } else if (evt.widget == _interProceduralDDA) {
                    _value = SlicerConfiguration.INTER_PROCEDURAL_ONLY;
                } else if (evt.widget == _intraAndInterProceduralDDA) {
                    _value = SlicerConfiguration.INTRA_AND_INTER_PROCEDURAL;
                }
                if (_value != null) {
                    _cfg.setProperty(SlicerConfiguration.NATURE_OF_DIVERGENCE_DA, _value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        _intraAndInterProceduralDDA.addSelectionListener(_sl2);
        _interProceduralDDA.addSelectionListener(_sl2);
        _intraProceduralDDA.addSelectionListener(_sl2);
        Object _temp = _cfg.getProperty(SlicerConfiguration.NATURE_OF_DIVERGENCE_DA);
        if (_temp == null || _temp.equals(SlicerConfiguration.INTER_PROCEDURAL_ONLY)) {
            _interProceduralDDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.INTRA_AND_INTER_PROCEDURAL)) {
            _intraAndInterProceduralDDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.INTRA_PROCEDURAL_ONLY)) {
            _intraProceduralDDA.setSelection(true);
        }
        _useDDAButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                boolean _val = false;
                if (_useDDAButton.getSelection()) {
                    _val = true;
                }
                _natureOfDDAGroup.setEnabled(_val);
                _interProceduralDDA.setEnabled(_val);
                _intraProceduralDDA.setEnabled(_val);
                _intraAndInterProceduralDDA.setEnabled(_val);
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        _useDDAButton.setSelection(_cfg.isDivergenceDepAnalysisUsed());
        _useDDAButton.notifyListeners(13, null);
    }

    private void setupInteferenceDepUI(Composite composite) {
        final SlicerConfiguration _cfg = (SlicerConfiguration)this.configuration;
        GridLayout _gridLayout = new GridLayout();
        _gridLayout.numColumns = 2;
        composite.setLayout((Layout)_gridLayout);
        final Button _useIDAButton = new Button(composite, 32);
        _useIDAButton.setText("use interference dependence");
        _useIDAButton.setToolTipText("Use interference dependence in calculation of the slice.");
        _useIDAButton.setSelection(_cfg.isInterferenceDepAnalysisUsed());
        _useIDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_INTERFERENCEDA, _useIDAButton, (IToolConfiguration)_cfg));
        final Group _natureOfIDAGroup = new Group(composite, 16);
        GridLayout _gridLayout3 = new GridLayout();
        _gridLayout3.numColumns = 2;
        _natureOfIDAGroup.setLayout((Layout)_gridLayout3);
        _natureOfIDAGroup.setText("Precision of Interference dependence");
        _natureOfIDAGroup.setToolTipText("Controls the precision of interference dependence.");
        GridData _gridData1 = new GridData(768);
        _gridData1.horizontalSpan = 2;
        _natureOfIDAGroup.setLayoutData((Object)_gridData1);
        final Group _precisionGroup = new Group((Composite)_natureOfIDAGroup, 16);
        GridLayout _gridLayout4 = new GridLayout();
        _gridLayout4.numColumns = 1;
        _precisionGroup.setLayout((Layout)_gridLayout4);
        _precisionGroup.setText("Sort of analysis to be used.");
        _precisionGroup.setToolTipText("Controls the precision via  properties inherent to interference.");
        final Button _typedIDA = new Button((Composite)_precisionGroup, 16);
        _typedIDA.setText("use type-based analysis");
        _typedIDA.setToolTipText("Only primaries of compatible types will be considered");
        final Button _equivalenceClassBasedEscapeAnalysisBasedIDA = new Button((Composite)_precisionGroup, 16);
        _equivalenceClassBasedEscapeAnalysisBasedIDA.setText("use equivalence class-based escape analysis");
        _equivalenceClassBasedEscapeAnalysisBasedIDA.setToolTipText("Only primaries of belonging to the same equivalence class will be considered.");
        final Button _symbolBasedEscapeAnalysisBasedIDA = new Button((Composite)_precisionGroup, 16);
        _symbolBasedEscapeAnalysisBasedIDA.setText("use symbolic and equivalence class-based escape analysis");
        _symbolBasedEscapeAnalysisBasedIDA.setToolTipText("Only symbolically equivalent primaries that belong to the same equivalence class will be considered.");
        SelectionListener _sl2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                Comparable<String> _value = null;
                if (evt.widget == _equivalenceClassBasedEscapeAnalysisBasedIDA) {
                    _value = SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO;
                } else if (evt.widget == _symbolBasedEscapeAnalysisBasedIDA) {
                    _value = SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO;
                } else if (evt.widget == _typedIDA) {
                    _value = SlicerConfiguration.TYPE_BASED_INFO;
                }
                if (_value != null) {
                    _cfg.setProperty(SlicerConfiguration.NATURE_OF_INTERFERENCE_DA, _value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        _equivalenceClassBasedEscapeAnalysisBasedIDA.addSelectionListener(_sl2);
        _symbolBasedEscapeAnalysisBasedIDA.addSelectionListener(_sl2);
        _typedIDA.addSelectionListener(_sl2);
        Object _temp = _cfg.getProperty(SlicerConfiguration.NATURE_OF_INTERFERENCE_DA);
        if (_temp == null || _temp.equals(SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            _symbolBasedEscapeAnalysisBasedIDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO)) {
            _equivalenceClassBasedEscapeAnalysisBasedIDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.TYPE_BASED_INFO)) {
            _typedIDA.setSelection(true);
        }
        Composite _analysisComposite = new Composite((Composite)_natureOfIDAGroup, 0);
        RowLayout _rowLayout = new RowLayout();
        _rowLayout.type = 512;
        _analysisComposite.setLayout((Layout)_rowLayout);
        GridData _analysisCompositeGridData = new GridData(768);
        _analysisCompositeGridData.verticalAlignment = 128;
        _analysisComposite.setLayoutData((Object)_analysisCompositeGridData);
        final Button _useOFAForInterference = new Button(_analysisComposite, 32);
        _useOFAForInterference.setText("use object flow analysis information");
        _useOFAForInterference.setToolTipText("Only aliasing primaries will be considered");
        _useOFAForInterference.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_OFA_FOR_INTERFERENCE_DA, _useOFAForInterference, (IToolConfiguration)_cfg));
        _useOFAForInterference.setSelection(_cfg.isOFAUsedForInterference());
        _useIDAButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                boolean _val = false;
                if (_useIDAButton.getSelection()) {
                    _val = true;
                }
                _natureOfIDAGroup.setEnabled(_val);
                _equivalenceClassBasedEscapeAnalysisBasedIDA.setEnabled(_val);
                _typedIDA.setEnabled(_val);
                _symbolBasedEscapeAnalysisBasedIDA.setEnabled(_val);
                _useOFAForInterference.setEnabled(_val);
                _precisionGroup.setEnabled(_val);
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        _useOFAForInterference.setSelection(_cfg.isOFAUsedForInterference());
        _useIDAButton.setSelection(_cfg.isInterferenceDepAnalysisUsed());
        _useIDAButton.notifyListeners(13, null);
    }

    private void setupCallingContextUI(final Composite composite, final SlicerConfiguration cfg) {
        final Button _propertyAwareSlicingButton = new Button(composite, 32);
        _propertyAwareSlicingButton.setText("Property Aware Slicing");
        _propertyAwareSlicingButton.setToolTipText("Precise but expensive");
        GridData _gridData4 = new GridData();
        _gridData4.horizontalSpan = 1;
        _propertyAwareSlicingButton.setLayoutData((Object)_gridData4);
        _propertyAwareSlicingButton.setSelection(cfg.getPropertyAware());
        AbstractToolConfigurator.BooleanPropertySelectionListener _sl3 = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.PROPERTY_AWARE, _propertyAwareSlicingButton, (IToolConfiguration)cfg);
        _propertyAwareSlicingButton.addSelectionListener((SelectionListener)_sl3);
        Composite _c = new Composite(composite, 0);
        GridData _gridData5 = new GridData();
        _gridData4.horizontalSpan = 1;
        _c.setLayoutData((Object)_gridData5);
        _c.setLayout((Layout)new FillLayout(256));
        final Label _l = new Label(_c, 16640);
        _l.setText("Limit for calling contexts: ");
        final Text _callingContextLimit = new Text(_c, 16388);
        _callingContextLimit.setToolTipText("This has to be >=0");
        _callingContextLimit.setText(String.valueOf(cfg.getCallingContextLimit()));
        FocusAdapter _sl4 = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    int _i = Integer.parseInt(_callingContextLimit.getText());
                    if (_i < 0) {
                        throw new NumberFormatException();
                    }
                    cfg.setCallingContextLimit(_i);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox _msgBox = new MessageBox(composite.getShell(), 5);
                    _msgBox.setMessage("The limit has to be zero or a positive integer. It was \"" + _callingContextLimit.getText() + "\".");
                    _msgBox.open();
                    _callingContextLimit.setText(SlicerConfiguration.DEFAULT_CALLING_CONTEXT_LIMIT.toString());
                }
            }
        };
        _callingContextLimit.addFocusListener((FocusListener)_sl4);
        SelectionListener _sl5 = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean _b = _propertyAwareSlicingButton.getSelection();
                _callingContextLimit.setEnabled(_b);
                _l.setEnabled(_b);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        _propertyAwareSlicingButton.addSelectionListener(_sl5);
        _c.pack();
    }

    private void setupReadyDepUI(Composite composite) {
        final SlicerConfiguration _cfg = (SlicerConfiguration)this.configuration;
        RowLayout _rowLayout1 = new RowLayout(512);
        composite.setLayout((Layout)_rowLayout1);
        Composite _readyComposite1 = new Composite(composite, 0);
        GridLayout _gridLayout2 = new GridLayout();
        _gridLayout2.numColumns = 2;
        _readyComposite1.setLayout((Layout)_gridLayout2);
        final Button _useRDAButton = new Button(_readyComposite1, 32);
        _useRDAButton.setText("use ready dependence");
        _useRDAButton.setToolTipText("Use ready dependence in calculation of the slice.");
        _useRDAButton.setSelection(_cfg.isReadyDepAnalysisUsed());
        _useRDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_READYDA, _useRDAButton, (IToolConfiguration)_cfg));
        final Group _precisionOfRDAGroup = new Group(composite, 16);
        GridLayout _gridLayout3 = new GridLayout();
        _gridLayout3.numColumns = 2;
        _precisionOfRDAGroup.setLayout((Layout)_gridLayout3);
        _precisionOfRDAGroup.setText("Precision of Ready dependence");
        final Group _precisionGroup = new Group((Composite)_precisionOfRDAGroup, 16);
        GridLayout _gridLayout4 = new GridLayout();
        _gridLayout4.numColumns = 1;
        _precisionGroup.setLayout((Layout)_gridLayout4);
        _precisionGroup.setText("Sort of analysis to be used.");
        _precisionGroup.setToolTipText("Controls the precision via  properties inherent to interference.");
        final Button _typedRDA = new Button((Composite)_precisionGroup, 16);
        _typedRDA.setText("use type-based analysis");
        _typedRDA.setToolTipText("Only primaries of compatible types will be considered");
        final Button _equivalenceClassBasedEscapeAnalysisBasedRDA = new Button((Composite)_precisionGroup, 16);
        _equivalenceClassBasedEscapeAnalysisBasedRDA.setText("use equivalence class-based escape analysis");
        _equivalenceClassBasedEscapeAnalysisBasedRDA.setToolTipText("Only primaries belonging to the same equivalence class  will be considered.");
        final Button _symbolBasedEscapeAnalysisBasedRDA = new Button((Composite)_precisionGroup, 16);
        _symbolBasedEscapeAnalysisBasedRDA.setText("use sybmolic and equivalence class-based escape analysis");
        _symbolBasedEscapeAnalysisBasedRDA.setToolTipText("Only symbolically equivalent primaries that belong to the same equivalence class will be considered.");
        SelectionListener _sl = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                Comparable<String> _value = null;
                if (evt.widget == _equivalenceClassBasedEscapeAnalysisBasedRDA) {
                    _value = SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO;
                } else if (evt.widget == _symbolBasedEscapeAnalysisBasedRDA) {
                    _value = SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO;
                } else if (evt.widget == _typedRDA) {
                    _value = SlicerConfiguration.TYPE_BASED_INFO;
                }
                if (_value != null) {
                    _cfg.setProperty(SlicerConfiguration.NATURE_OF_READY_DA, _value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        _equivalenceClassBasedEscapeAnalysisBasedRDA.addSelectionListener(_sl);
        _symbolBasedEscapeAnalysisBasedRDA.addSelectionListener(_sl);
        _typedRDA.addSelectionListener(_sl);
        Object _temp = _cfg.getProperty(SlicerConfiguration.NATURE_OF_READY_DA);
        if (_temp == null || _temp.equals(SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            _symbolBasedEscapeAnalysisBasedRDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO)) {
            _equivalenceClassBasedEscapeAnalysisBasedRDA.setSelection(true);
        } else if (_temp.equals(SlicerConfiguration.TYPE_BASED_INFO)) {
            _typedRDA.setSelection(true);
        }
        Composite _analysisComposite = new Composite((Composite)_precisionOfRDAGroup, 0);
        RowLayout _rowLayout = new RowLayout();
        _rowLayout.type = 512;
        _analysisComposite.setLayout((Layout)_rowLayout);
        GridData _analysisCompositeGridData = new GridData(768);
        _analysisCompositeGridData.verticalAlignment = 128;
        _analysisComposite.setLayoutData((Object)_analysisCompositeGridData);
        final Button _useOFAForReady = new Button(_analysisComposite, 32);
        _useOFAForReady.setText("use object flow analysis information");
        _useOFAForReady.setToolTipText("Only aliasing primaries will be considered");
        _useOFAForReady.setSelection(_cfg.isOFAUsedForReady());
        _useOFAForReady.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_OFA_FOR_READY_DA, _useOFAForReady, (IToolConfiguration)_cfg));
        final Button _useSLAForReady = new Button(_analysisComposite, 32);
        _useSLAForReady.setText("use safe lock analysis ");
        _useSLAForReady.setToolTipText("Safe locks will not considered");
        _useSLAForReady.setSelection(_cfg.isSafeLockAnalysisUsedForReady());
        _useSLAForReady.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_SLA_FOR_READY_DA, _useSLAForReady, (IToolConfiguration)_cfg));
        final Button _useCallSiteSensitiveReady = new Button(_analysisComposite, 32);
        _useCallSiteSensitiveReady.setText("blocking call-site aware");
        _useCallSiteSensitiveReady.setToolTipText("Calls leading to blocking will be considered as blocking as well.");
        _useCallSiteSensitiveReady.setSelection(_cfg.isCallSiteSensitiveReadyUsed());
        _useCallSiteSensitiveReady.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.CALL_SITE_SENSITIVE_READY_DA, _useCallSiteSensitiveReady, (IToolConfiguration)_cfg));
        Group _natureOfRDAGroup = new Group(composite, 16);
        GridLayout _gridLayout5 = new GridLayout();
        _gridLayout5.numColumns = 2;
        _natureOfRDAGroup.setLayout((Layout)_gridLayout5);
        _natureOfRDAGroup.setText("Nature of Ready dependence");
        final Button _rule1RDAButton = new Button((Composite)_natureOfRDAGroup, 32);
        _rule1RDAButton.setText("use rule 1 of ready dependence");
        _rule1RDAButton.setToolTipText("Intra-thread intra-procedural monitor acquisition based ready dependence");
        _rule1RDAButton.setSelection(_cfg.isReadyRule1Used());
        _rule1RDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE1_IN_READYDA, _rule1RDAButton, (IToolConfiguration)_cfg));
        final Button _rule2RDAButton = new Button((Composite)_natureOfRDAGroup, 32);
        _rule2RDAButton.setText("use rule 2 of ready dependence");
        _rule2RDAButton.setToolTipText("Inter-thread monitor acquisition ready dependence");
        _rule2RDAButton.setSelection(_cfg.isReadyRule2Used());
        _rule2RDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE2_IN_READYDA, _rule2RDAButton, (IToolConfiguration)_cfg));
        final Button _rule3RDAButton = new Button((Composite)_natureOfRDAGroup, 32);
        _rule3RDAButton.setText("use rule 3 of ready dependence");
        _rule3RDAButton.setToolTipText("Intra-thread intra-procedural Object.wait() based ready dependence");
        _rule3RDAButton.setSelection(_cfg.isReadyRule3Used());
        _rule3RDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE3_IN_READYDA, _rule3RDAButton, (IToolConfiguration)_cfg));
        final Button _rule4RDAButton = new Button((Composite)_natureOfRDAGroup, 32);
        _rule4RDAButton.setText("use rule 4 of ready dependence");
        _rule4RDAButton.setToolTipText("Inter-thread Object.wait() based ready dependence");
        _rule4RDAButton.setSelection(_cfg.isReadyRule4Used());
        _rule4RDAButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE4_IN_READYDA, _rule4RDAButton, (IToolConfiguration)_cfg));
        _useRDAButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                boolean _val = false;
                if (_useRDAButton.getSelection()) {
                    _val = true;
                }
                _precisionGroup.setEnabled(_val);
                _precisionOfRDAGroup.setEnabled(_val);
                _equivalenceClassBasedEscapeAnalysisBasedRDA.setEnabled(_val);
                _typedRDA.setEnabled(_val);
                _useOFAForReady.setEnabled(_val);
                _useSLAForReady.setEnabled(_val);
                _useCallSiteSensitiveReady.setEnabled(_val);
                _symbolBasedEscapeAnalysisBasedRDA.setEnabled(_val);
                _rule1RDAButton.setEnabled(_val);
                _rule2RDAButton.setEnabled(_val);
                _rule3RDAButton.setEnabled(_val);
                _rule4RDAButton.setEnabled(_val);
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        _useRDAButton.setSelection(_cfg.isInterferenceDepAnalysisUsed());
        _useRDAButton.notifyListeners(13, null);
    }

    private void setupSliceInfoUI(Composite composite) {
        final SlicerConfiguration _cfg = (SlicerConfiguration)this.configuration;
        GridLayout _gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)_gridLayout);
        this.executableSliceButton = new Button(composite, 32);
        this.executableSliceButton.setText("Executable slice");
        GridData _gridData2 = new GridData();
        _gridData2.horizontalSpan = 1;
        this.executableSliceButton.setLayoutData((Object)_gridData2);
        this.executableSliceButton.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.EXECUTABLE_SLICE, this.executableSliceButton, (IToolConfiguration)_cfg));
        if (_cfg.getSliceType().equals((Object)SliceType.FORWARD_SLICE)) {
            this.executableSliceButton.setEnabled(false);
        }
        this.executableSliceButton.setSelection(_cfg.getExecutableSlice());
        this.setupCallingContextUI(composite, _cfg);
        this.setupAssertionUI(composite, _cfg);
        this.setupDeadlockUI(composite, _cfg);
        Group _group2 = new Group(composite, 16);
        _group2.setText("Slice Type");
        GridData _gridData = new GridData(768);
        _gridData.horizontalSpan = 1;
        _gridData.verticalAlignment = 128;
        _gridData.horizontalAlignment = 131072;
        _group2.setLayoutData((Object)_gridData);
        RowLayout _rowLayout = new RowLayout();
        _rowLayout.type = 512;
        _group2.setLayout((Layout)_rowLayout);
        final Button _backwardSlice = new Button((Composite)_group2, 16);
        _backwardSlice.setText("Backward slice");
        final Button _forwardSlice = new Button((Composite)_group2, 16);
        _forwardSlice.setText("Forward slice");
        final Button _completeSlice = new Button((Composite)_group2, 16);
        _completeSlice.setText("Complete slice");
        SelectionListener _sl6 = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                SliceType _value = null;
                if (evt.widget == _forwardSlice) {
                    _value = SliceType.FORWARD_SLICE;
                    SlicerConfigurator.this.executableSliceButton.setSelection(false);
                    SlicerConfigurator.this.executableSliceButton.notifyListeners(13, null);
                    SlicerConfigurator.this.executableSliceButton.setEnabled(false);
                } else {
                    if (evt.widget == _backwardSlice) {
                        _value = SliceType.BACKWARD_SLICE;
                    } else if (evt.widget == _completeSlice) {
                        _value = SliceType.COMPLETE_SLICE;
                    }
                    SlicerConfigurator.this.executableSliceButton.setEnabled(true);
                }
                if (_value != null) {
                    _cfg.setProperty(SlicerConfiguration.SLICE_TYPE, (Object)_value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        _backwardSlice.addSelectionListener(_sl6);
        _completeSlice.addSelectionListener(_sl6);
        _forwardSlice.addSelectionListener(_sl6);
        SliceType _sliceType = _cfg.getSliceType();
        if (((Object)((Object)_sliceType)).equals((Object)SliceType.BACKWARD_SLICE)) {
            _backwardSlice.setSelection(true);
        } else if (((Object)((Object)_sliceType)).equals((Object)SliceType.COMPLETE_SLICE)) {
            _completeSlice.setSelection(true);
        } else if (((Object)((Object)_sliceType)).equals((Object)SliceType.FORWARD_SLICE)) {
            _forwardSlice.setSelection(true);
        }
    }
}

