/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.soot.ApplicationClassesOnlyPredicate;
import edu.ksu.cis.indus.slicer.SliceType;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ThreadEscapeInfoBasedCallingContextRetriever;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.ThreadEscapeInfoBasedCallingContextRetrieverV2;
import edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.InterProceduralDivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationInsensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.tools.AbstractToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurationFactory;
import edu.ksu.cis.indus.tools.slicer.contextualizers.DeadlockPreservingCriteriaCallStackContextualizer;
import edu.ksu.cis.indus.tools.slicer.contextualizers.ISliceCriteriaContextualizer;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.DeadlockPreservingCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.ISliceCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.StmtTypeBasedSliceCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.predicates.AssertionSliceCriteriaPredicate;
import edu.ksu.cis.indus.tools.slicer.criteria.predicates.EscapingSliceCriteriaPredicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.ThrowStmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlicerConfiguration
extends AbstractToolConfiguration
implements Cloneable,
IToolConfigurationFactory,
IUnmarshallable,
IMarshallable {
    static final Comparable<String> ALL_SYNC_CONSTRUCTS = "ALL_SYNC_CONSTRUCTS";
    static final Comparable<String> ASSERTIONS_IN_APPLICATION_CLASSES_ONLY = "consider assertions in application classes only";
    static final Comparable<String> CALL_SITE_SENSITIVE_READY_DA = "call site sensitive ready dependence";
    static final Comparable<String> CALLING_CONTEXT_LENGTH = "calling context length";
    static final Comparable<String> COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD = "common unchecked exceptional exit sensitive control dependence";
    static final Comparable<String> CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS = "CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS";
    static final Comparable<String> DEADLOCK_CRITERIA_SELECTION_STRATEGY = "deadlock criteria selection strategy";
    static final Integer DEFAULT_CALLING_CONTEXT_LIMIT = new Integer(10);
    static final Comparable<String> EQUIVALENCE_CLASS_BASED_INFO = "EQUIVALENCE_CLASS_BASED_INFO";
    static final Comparable<String> ESCAPING_SYNC_CONSTRUCTS = "ESCAPING_SYNC_CONSTRUCTS";
    static final Comparable<String> EXECUTABLE_SLICE = "executable slice";
    static final Comparable<String> EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE = "explicit exceptional exit sensitive control dependence";
    static final Comparable<String> INTER_PROCEDURAL_ONLY = "INTER_PROCEDURAL_ONLY";
    static final Comparable<String> INTRA_AND_INTER_PROCEDURAL = "INTRA_AND_INTER_PROCEDURAL";
    static final Comparable<String> INTRA_PROCEDURAL_ONLY = "INTRA_PROCEDURAL_ONLY";
    static final Comparable<String> NATURE_OF_DIVERGENCE_DA = "nature of divergence dependence";
    static final Comparable<String> NATURE_OF_INTERFERENCE_DA = "nature of interference dependence";
    static final Comparable<String> NATURE_OF_READY_DA = "nature of ready dependence";
    static final Comparable<String> NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE = "Non termination sensitive control dependence";
    static final Comparable<String> PROPERTY_AWARE = "property aware slicing";
    static final Comparable<String> SLICE_FOR_DEADLOCK = "slice for deadlock";
    static final Comparable<String> SLICE_TO_PRESERVE_ASSERTIONS = "slice to preserve assertions";
    static final Comparable<String> SLICE_TYPE = "slice type";
    static final Comparable<String> SYMBOL_AND_EQUIVCLS_BASED_INFO = "SYMBOL_AND_EQUIVCLS_BASED_INFO";
    static final Comparable<String> SYNCS_IN_APPLICATION_CLASSES_ONLY = "consider synchronization constructs in application classes only";
    static final Comparable<String> TYPE_BASED_INFO = "TYPE_BASED_INFO";
    static final Comparable<String> USE_DIVERGENCEDA = "use divergence dependence";
    static final Comparable<String> USE_INTERFERENCEDA = "use interference dependence";
    static final Comparable<String> USE_OFA_FOR_INTERFERENCE_DA = "use ofa for interference";
    static final Comparable<String> USE_OFA_FOR_READY_DA = "use ofa for ready";
    static final Comparable<String> USE_READYDA = "use ready dependence";
    static final Comparable<String> USE_RULE1_IN_READYDA = "use rule1 in ready dependence";
    static final Comparable<String> USE_RULE2_IN_READYDA = "use rule2 in ready dependence";
    static final Comparable<String> USE_RULE3_IN_READYDA = "use rule3 in ready dependence";
    static final Comparable<String> USE_RULE4_IN_READYDA = "use rule4 in ready dependence";
    static final Comparable<String> USE_SLA_FOR_READY_DA = "use sla for ready";
    static final Comparable<String> USE_SYNCHRONIZATIONDA = "use synchronization dependences";
    private static final Comparable<String> ASSERTION_PRESERVING_CRITERIA_GENERATOR_ID = "assertion preserving criteria generator id";
    private static final Comparable<String> DEADLOCK_PRESERVING_CRITERIA_GENERATOR_ID = "deadlock preserving criteria generator id";
    private static final IToolConfigurationFactory FACTORY_SINGLETON = new SlicerConfiguration();
    private static final Logger LOGGER = LoggerFactory.getLogger(SlicerConfiguration.class);
    private final Collection<IDependencyAnalysis.DependenceSort> dependencesToUse;
    private final Map<Object, ISliceCriteriaGenerator<?, ?>> id2critGenerators = new HashMap();
    private final Map<IDependencyAnalysis.DependenceSort, Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>>> id2dependencyAnalyses = new HashMap();
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.tools.JiBX_slicerConfig_JiBXBindingFactory|";

    protected SlicerConfiguration() {
        this.dependencesToUse = new HashSet<IDependencyAnalysis.DependenceSort>();
        this.propertyIds.add(NATURE_OF_INTERFERENCE_DA);
        this.propertyIds.add(USE_OFA_FOR_INTERFERENCE_DA);
        this.propertyIds.add(USE_INTERFERENCEDA);
        this.propertyIds.add(USE_READYDA);
        this.propertyIds.add(NATURE_OF_READY_DA);
        this.propertyIds.add(USE_OFA_FOR_READY_DA);
        this.propertyIds.add(USE_RULE1_IN_READYDA);
        this.propertyIds.add(USE_RULE2_IN_READYDA);
        this.propertyIds.add(USE_RULE3_IN_READYDA);
        this.propertyIds.add(USE_RULE4_IN_READYDA);
        this.propertyIds.add(USE_SLA_FOR_READY_DA);
        this.propertyIds.add(SLICE_FOR_DEADLOCK);
        this.propertyIds.add(SLICE_TO_PRESERVE_ASSERTIONS);
        this.propertyIds.add(DEADLOCK_CRITERIA_SELECTION_STRATEGY);
        this.propertyIds.add(SLICE_TYPE);
        this.propertyIds.add(EXECUTABLE_SLICE);
        this.propertyIds.add(PROPERTY_AWARE);
        this.propertyIds.add(NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE);
        this.propertyIds.add(EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE);
        this.propertyIds.add(COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD);
        this.propertyIds.add(USE_DIVERGENCEDA);
        this.propertyIds.add(NATURE_OF_DIVERGENCE_DA);
        this.propertyIds.add(INTRA_PROCEDURAL_ONLY);
        this.propertyIds.add(INTRA_AND_INTER_PROCEDURAL);
        this.propertyIds.add(INTER_PROCEDURAL_ONLY);
        this.propertyIds.add(USE_SYNCHRONIZATIONDA);
        this.propertyIds.add(CALL_SITE_SENSITIVE_READY_DA);
        this.propertyIds.add(ASSERTIONS_IN_APPLICATION_CLASSES_ONLY);
        this.propertyIds.add(SYNCS_IN_APPLICATION_CLASSES_ONLY);
        this.propertyIds.add(CALLING_CONTEXT_LENGTH);
    }

    static IToolConfigurationFactory getFactory() {
        return FACTORY_SINGLETON;
    }

    static SlicerConfiguration makeToolConfiguration() {
        SlicerConfiguration _result = new SlicerConfiguration();
        _result.setConfigName("tool_configuration_" + System.currentTimeMillis());
        _result.initialize();
        return _result;
    }

    public boolean areAssertionsOnlyInAppClassesConsidered() {
        return this.getBooleanProperty(ASSERTIONS_IN_APPLICATION_CLASSES_ONLY);
    }

    public boolean areCommonUncheckedExceptionsConsidered() {
        return this.getBooleanProperty(COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD);
    }

    public boolean areSynchronizationsOnlyInAppClassesConsidered() {
        return this.getBooleanProperty(SYNCS_IN_APPLICATION_CLASSES_ONLY);
    }

    public void considerAssertionsInAppClassesOnly(boolean value) {
        this.setProperty(ASSERTIONS_IN_APPLICATION_CLASSES_ONLY, value);
    }

    public void considerCommonUncheckedExceptions(boolean value) {
        this.setProperty(COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD, value);
    }

    public void considerSynchronizationsInAppClassesOnly(boolean value) {
        this.setProperty(SYNCS_IN_APPLICATION_CLASSES_ONLY, value);
    }

    public IToolConfiguration createToolConfiguration() {
        return SlicerConfiguration.makeToolConfiguration();
    }

    public boolean equals(Object object) {
        boolean _result = false;
        if (object instanceof SlicerConfiguration) {
            SlicerConfiguration _config = (SlicerConfiguration)object;
            _result = new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.propertyIds, (Object)_config.propertyIds).append(this.id2dependencyAnalyses, _config.id2dependencyAnalyses).append(this.dependencesToUse, _config.dependencesToUse).append((Object)this.properties, (Object)_config.properties).isEquals();
        }
        return _result;
    }

    public int getCallingContextLimit() {
        return (Integer)this.getProperty(CALLING_CONTEXT_LENGTH);
    }

    public String getDeadlockCriteriaSelectionStrategy() {
        String _result = (String)this.getProperty(DEADLOCK_CRITERIA_SELECTION_STRATEGY);
        if (_result == null) {
            _result = CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS.toString();
        }
        return _result;
    }

    public Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> getDependenceAnalyses(IDependencyAnalysis.DependenceSort id) {
        Collection _result = this.id2dependencyAnalyses.get(id);
        if (_result == null) {
            _result = Collections.emptyList();
        }
        return _result;
    }

    public boolean getExecutableSlice() {
        return this.getBooleanProperty(EXECUTABLE_SLICE);
    }

    public String getNatureOfDivergenceDepAnalysis() {
        String _result = (String)this.getProperty(NATURE_OF_DIVERGENCE_DA);
        if (_result == null) {
            _result = INTRA_PROCEDURAL_ONLY.toString();
        }
        return _result;
    }

    public String getNatureOfInterferenceDepAnalysis() {
        String _result = (String)this.getProperty(NATURE_OF_INTERFERENCE_DA);
        if (_result == null) {
            _result = SYMBOL_AND_EQUIVCLS_BASED_INFO.toString();
        }
        return _result;
    }

    public String getNatureOfReadyDepAnalysis() {
        String _result = (String)this.getProperty(NATURE_OF_READY_DA);
        if (_result == null) {
            _result = SYMBOL_AND_EQUIVCLS_BASED_INFO.toString();
        }
        return _result;
    }

    public boolean getPropertyAware() {
        return this.getBooleanProperty(PROPERTY_AWARE);
    }

    public boolean getSliceForDeadlock() {
        return this.getBooleanProperty(SLICE_FOR_DEADLOCK);
    }

    public boolean getSliceToPreserveAssertions() {
        return this.getBooleanProperty(SLICE_TO_PRESERVE_ASSERTIONS);
    }

    public SliceType getSliceType() {
        return (SliceType)((Object)this.getProperty(SLICE_TYPE));
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.propertyIds).append(this.id2dependencyAnalyses).append(this.dependencesToUse).append((Object)this.properties).toHashCode();
    }

    public void initialize() {
        this.setProperty(USE_DIVERGENCEDA, Boolean.FALSE);
        this.setProperty(USE_READYDA, Boolean.FALSE);
        this.setProperty(USE_INTERFERENCEDA, Boolean.FALSE);
        this.setProperty(USE_SYNCHRONIZATIONDA, Boolean.FALSE);
        this.setProperty(NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE, Boolean.FALSE);
        this.setProperty(EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE, Boolean.FALSE);
        this.setProperty(COMMON_UNCHECKED_EXCEPTIONAL_EXIT_SENSITIVE_CD, Boolean.FALSE);
        this.setProperty(SLICE_TYPE, (Object)SliceType.BACKWARD_SLICE);
        this.setProperty(EXECUTABLE_SLICE, Boolean.FALSE);
        this.setProperty(SLICE_FOR_DEADLOCK, Boolean.FALSE);
        this.setProperty(SLICE_TO_PRESERVE_ASSERTIONS, Boolean.FALSE);
        this.setProperty(USE_OFA_FOR_INTERFERENCE_DA, Boolean.FALSE);
        this.setProperty(USE_OFA_FOR_READY_DA, Boolean.FALSE);
        this.setProperty(USE_RULE1_IN_READYDA, Boolean.FALSE);
        this.setProperty(USE_RULE2_IN_READYDA, Boolean.FALSE);
        this.setProperty(USE_RULE3_IN_READYDA, Boolean.FALSE);
        this.setProperty(USE_RULE4_IN_READYDA, Boolean.FALSE);
        this.setProperty(CALL_SITE_SENSITIVE_READY_DA, Boolean.FALSE);
        this.setProperty(USE_SLA_FOR_READY_DA, Boolean.FALSE);
        this.setProperty(PROPERTY_AWARE, Boolean.FALSE);
        this.setProperty(ASSERTIONS_IN_APPLICATION_CLASSES_ONLY, Boolean.FALSE);
        this.setProperty(SYNCS_IN_APPLICATION_CLASSES_ONLY, Boolean.FALSE);
        this.setProperty(CALLING_CONTEXT_LENGTH, DEFAULT_CALLING_CONTEXT_LIMIT);
        this.dependencesToUse.add(IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA);
        this.dependencesToUse.add(IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA);
        this.dependencesToUse.add(IDependencyAnalysis.DependenceSort.CONTROL_DA);
    }

    public boolean isCallSiteSensitiveReadyUsed() {
        return this.getBooleanProperty(CALL_SITE_SENSITIVE_READY_DA);
    }

    public boolean isDivergenceDepAnalysisUsed() {
        return this.getBooleanProperty(USE_DIVERGENCEDA);
    }

    public boolean isExplicitExceptionalExitSensitiveControlDependenceUsed() {
        return this.getBooleanProperty(EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE);
    }

    public boolean isInterferenceDepAnalysisUsed() {
        return this.getBooleanProperty(USE_INTERFERENCEDA);
    }

    public boolean isNonTerminationSensitiveControlDependenceUsed() {
        return this.getBooleanProperty(NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE);
    }

    public boolean isOFAUsedForInterference() {
        return this.getBooleanProperty(USE_OFA_FOR_INTERFERENCE_DA);
    }

    public boolean isOFAUsedForReady() {
        return this.getBooleanProperty(USE_OFA_FOR_READY_DA);
    }

    public boolean isReadyDepAnalysisUsed() {
        return this.getBooleanProperty(USE_READYDA);
    }

    public boolean isReadyRule1Used() {
        return this.getBooleanProperty(USE_RULE1_IN_READYDA);
    }

    public boolean isReadyRule2Used() {
        return this.getBooleanProperty(USE_RULE2_IN_READYDA);
    }

    public boolean isReadyRule3Used() {
        return this.getBooleanProperty(USE_RULE3_IN_READYDA);
    }

    public boolean isReadyRule4Used() {
        return this.getBooleanProperty(USE_RULE4_IN_READYDA);
    }

    public boolean isSafeLockAnalysisUsedForReady() {
        return this.getBooleanProperty(USE_SLA_FOR_READY_DA);
    }

    public boolean isSynchronizationDepAnalysisUsed() {
        return this.getBooleanProperty(USE_SYNCHRONIZATIONDA);
    }

    public void setCallingContextLimit(int limit) {
        Integer _i = limit < 0 ? DEFAULT_CALLING_CONTEXT_LIMIT : new Integer(limit);
        this.setProperty(CALLING_CONTEXT_LENGTH, _i);
    }

    public void setDeadlockCriteriaSelectionStrategy(String dc) {
        super.setProperty(DEADLOCK_CRITERIA_SELECTION_STRATEGY, (Object)dc);
    }

    public void setExecutableSlice(boolean value) {
        if (!this.getSliceType().equals((Object)SliceType.FORWARD_SLICE)) {
            this.setProperty(EXECUTABLE_SLICE, value);
        } else if (value) {
            throw new IllegalStateException("Forward Executable Slices are not supported.");
        }
    }

    public void setNatureOfDivergenceDepAnalysis(String use) {
        super.setProperty(NATURE_OF_DIVERGENCE_DA, (Object)use);
    }

    public void setNatureOfInterferenceDepAnalysis(String use) {
        super.setProperty(NATURE_OF_INTERFERENCE_DA, (Object)use);
    }

    public void setNatureOfReadyDepAnalysis(String use) {
        super.setProperty(NATURE_OF_READY_DA, (Object)use);
    }

    public void setPropertyAware(boolean value) {
        this.setProperty(PROPERTY_AWARE, value);
    }

    public void setSliceForDeadlock(boolean value) {
        this.setProperty(SLICE_FOR_DEADLOCK, value);
    }

    public void setSliceToPreserveAssertions(boolean value) {
        this.setProperty(SLICE_TO_PRESERVE_ASSERTIONS, value);
    }

    public void setSliceType(SliceType type) {
        this.setProperty(SLICE_TYPE, (Object)type);
    }

    public void useCallSiteSensitiveReady(boolean use) {
        this.setProperty(CALL_SITE_SENSITIVE_READY_DA, use);
    }

    public void useDivergenceDepAnalysis(boolean use) {
        this.setProperty(USE_DIVERGENCEDA, use);
    }

    public void useExplicitExceptionalExitSensitiveControlDependence(boolean value) {
        this.setProperty(EXPLICIT_EXCEPTIONAL_EXIT_SENSITIVE_CONTROL_DEPENDENCE, value);
    }

    public void useInterferenceDepAnalysis(boolean use) {
        this.setProperty(USE_INTERFERENCEDA, use);
    }

    public void useNonTerminationSensitiveControlDependence(boolean value) {
        this.setProperty(NON_TERMINATION_SENSITIVE_CONTROL_DEPENDENCE, value);
    }

    public void useOFAForInterference(boolean use) {
        this.setProperty(USE_OFA_FOR_INTERFERENCE_DA, use);
    }

    public void useOFAForReady(boolean use) {
        this.setProperty(USE_OFA_FOR_READY_DA, use);
    }

    public void useReadyDepAnalysis(boolean use) {
        this.setProperty(USE_READYDA, use);
    }

    public void useReadyRule1(boolean use) {
        this.setProperty(USE_RULE1_IN_READYDA, use);
    }

    public void useReadyRule2(boolean use) {
        this.setProperty(USE_RULE2_IN_READYDA, use);
    }

    public void useReadyRule3(boolean use) {
        this.setProperty(USE_RULE3_IN_READYDA, use);
    }

    public void useReadyRule4(boolean use) {
        this.setProperty(USE_RULE4_IN_READYDA, use);
    }

    public void useSafeLockAnalysisForReady(boolean use) {
        this.setProperty(USE_SLA_FOR_READY_DA, use);
    }

    public void useSynchronizationDepAnalysis(boolean use) {
        this.setProperty(USE_SYNCHRONIZATIONDA, use);
    }

    protected boolean processProperty(Comparable<?> propertyID, Object value) {
        return true;
    }

    Collection<IDependencyAnalysis.DependenceSort> getIDsOfDAsToUse() {
        return Collections.unmodifiableCollection(this.dependencesToUse);
    }

    Collection<ISliceCriteriaGenerator<?, ?>> getSliceCriteriaGenerators() {
        return this.id2critGenerators.values();
    }

    void setupForUse() {
        this.setupDeadlockPreservation();
        this.setupAssertionPreservation();
        this.setupDivergenceDependence();
        this.setupSynchronizationDependence();
        this.setupInterferenceDependence();
        this.setupReadyDependence();
        this.setupSliceTypeRelatedData();
    }

    private boolean getBooleanProperty(Comparable<?> propertyId) {
        Boolean _value = (Boolean)this.getProperty(propertyId);
        boolean _result = false;
        if (_value != null) {
            _result = _value;
        }
        return _result;
    }

    private IDependencyAnalysis.Direction getDivergenceDirection() throws IllegalStateException {
        IDependencyAnalysis.Direction _result;
        if (SliceType.FORWARD_SLICE.equals((Object)this.getSliceType())) {
            _result = IDependencyAnalysis.Direction.FORWARD_DIRECTION;
        } else if (SliceType.BACKWARD_SLICE.equals((Object)this.getSliceType())) {
            _result = IDependencyAnalysis.Direction.BACKWARD_DIRECTION;
        } else if (SliceType.COMPLETE_SLICE.equals((Object)this.getSliceType())) {
            _result = null;
        } else {
            String _msg = "Illegal slice type : : " + (Object)((Object)this.getSliceType());
            LOGGER.error("setupDivergenceDependence() -  : " + _msg);
            throw new IllegalStateException(_msg);
        }
        return _result;
    }

    private Class<? extends ReadyDAv1> getReadyDAClass(Comparable<?> nature) throws IllegalStateException {
        Class<ReadyDAv3> _result;
        if (SYMBOL_AND_EQUIVCLS_BASED_INFO.equals(nature)) {
            _result = ReadyDAv3.class;
        } else if (EQUIVALENCE_CLASS_BASED_INFO.equals(nature)) {
            _result = ReadyDAv2.class;
        } else if (TYPE_BASED_INFO.equals(nature)) {
            _result = ReadyDAv1.class;
        } else {
            LOGGER.error("setupNatureOfReadyDep() -  : Ready dependence could not be configured due to illegal dependence nature.");
            throw new IllegalStateException("Ready dependence could not be configured due to illegal dependence nature.");
        }
        return _result;
    }

    private void setupAssertionPreservation() {
        Boolean _b = (Boolean)this.getProperty(SLICE_TO_PRESERVE_ASSERTIONS);
        if (_b.booleanValue()) {
            StmtTypeBasedSliceCriteriaGenerator _t = new StmtTypeBasedSliceCriteriaGenerator();
            Collection _stmtTypes = Collections.singleton(ThrowStmt.class);
            _t.setStmtTypes(_stmtTypes);
            _t.setCriteriaFilterPredicate(new AssertionSliceCriteriaPredicate());
            if (this.areAssertionsOnlyInAppClassesConsidered()) {
                _t.setSiteSelectionPredicate(new ApplicationClassesOnlyPredicate());
            }
            this.id2critGenerators.put(ASSERTION_PRESERVING_CRITERIA_GENERATOR_ID, _t);
        } else {
            this.id2critGenerators.remove(ASSERTION_PRESERVING_CRITERIA_GENERATOR_ID);
        }
    }

    private void setupDeadlockPreservation() {
        if (this.getSliceForDeadlock()) {
            String _property = (String)this.getProperty(DEADLOCK_CRITERIA_SELECTION_STRATEGY);
            DeadlockPreservingCriteriaGenerator _t = new DeadlockPreservingCriteriaGenerator();
            this.id2critGenerators.put(DEADLOCK_PRESERVING_CRITERIA_GENERATOR_ID, _t);
            if (ALL_SYNC_CONSTRUCTS.equals(_property)) {
                _t.setCriteriaContextualizer(ISliceCriteriaContextualizer.DUMMY_CONTEXTUALIZER);
            } else if (ESCAPING_SYNC_CONSTRUCTS.equals(_property)) {
                _t.setCriteriaFilterPredicate(new EscapingSliceCriteriaPredicate());
                _t.setCriteriaContextualizer(ISliceCriteriaContextualizer.DUMMY_CONTEXTUALIZER);
            } else if (CONTEXT_SENSITIVE_ESCAPING_SYNC_CONSTRUCTS.equals(_property)) {
                _t.setCriteriaFilterPredicate(new EscapingSliceCriteriaPredicate());
                ThreadEscapeInfoBasedCallingContextRetrieverV2 _retriever = new ThreadEscapeInfoBasedCallingContextRetrieverV2(this.getCallingContextLimit(), true, false);
                _t.setCriteriaContextualizer(new DeadlockPreservingCriteriaCallStackContextualizer((ThreadEscapeInfoBasedCallingContextRetriever)_retriever));
            } else {
                LOGGER.error("setupDeadlockPreservation() -  : Deadlock preservation criteria generation could not be configured due to illegal criteria selection strategy.");
                throw new IllegalStateException("Deadlock preservation criteria generation could not be configured due to illegal criteria selection strategy.");
            }
            if (this.areSynchronizationsOnlyInAppClassesConsidered()) {
                _t.setSiteSelectionPredicate(new ApplicationClassesOnlyPredicate());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupDivergenceDependence() {
        ArrayList<Object> _das;
        block10: {
            boolean _interProcedural;
            String _property;
            block9: {
                if (!this.isDivergenceDepAnalysisUsed()) {
                    this.dependencesToUse.remove(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA);
                    this.id2dependencyAnalyses.remove(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA);
                    return;
                }
                _property = this.getNatureOfDivergenceDepAnalysis();
                IDependencyAnalysis.Direction _direction = this.getDivergenceDirection();
                _interProcedural = INTRA_AND_INTER_PROCEDURAL.equals(_property);
                _das = new ArrayList<Object>();
                if (_direction == null) break block9;
                if (INTER_PROCEDURAL_ONLY.equals(_property)) {
                    _das.add(InterProceduralDivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)_direction));
                    break block10;
                } else if (INTRA_PROCEDURAL_ONLY.equals(_property) || _interProcedural) {
                    DivergenceDA _divergenceDA = DivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)_direction);
                    _das.add(_divergenceDA);
                    _divergenceDA.setConsiderCallSites(_interProcedural);
                }
                break block10;
            }
            if (SliceType.COMPLETE_SLICE.equals((Object)this.getSliceType())) {
                if (INTER_PROCEDURAL_ONLY.equals(_property)) {
                    _das.add(InterProceduralDivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)IDependencyAnalysis.Direction.FORWARD_DIRECTION));
                    _das.add(InterProceduralDivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)IDependencyAnalysis.Direction.BACKWARD_DIRECTION));
                } else if (INTRA_PROCEDURAL_ONLY.equals(_property) || _interProcedural) {
                    DivergenceDA _forwardDivergenceDA = DivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)IDependencyAnalysis.Direction.FORWARD_DIRECTION);
                    DivergenceDA _backwardDivergenceDA = DivergenceDA.getDivergenceDA((IDependencyAnalysis.Direction)IDependencyAnalysis.Direction.BACKWARD_DIRECTION);
                    _das.add(_forwardDivergenceDA);
                    _das.add(_backwardDivergenceDA);
                    _forwardDivergenceDA.setConsiderCallSites(_interProcedural);
                    _backwardDivergenceDA.setConsiderCallSites(_interProcedural);
                }
            }
        }
        if (!_das.isEmpty()) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA, _das);
            this.dependencesToUse.add(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA);
            return;
        }
        LOGGER.error("setupDivergenceDependence() -  : Divergence dependence could not be configured due to illegal slice type ordivergence dependence nature.");
        throw new IllegalStateException("Divergence dependence could not be configured due to illegal slice type ordivergence dependence nature.");
    }

    private void setupInterferenceDependence() {
        IDependencyAnalysis.DependenceSort _id = IDependencyAnalysis.DependenceSort.INTERFERENCE_DA;
        if (this.isInterferenceDepAnalysisUsed()) {
            Class<InterferenceDAv3> _clazz;
            this.dependencesToUse.add(_id);
            String _property = this.getNatureOfInterferenceDepAnalysis();
            if (SYMBOL_AND_EQUIVCLS_BASED_INFO.equals(_property)) {
                _clazz = InterferenceDAv3.class;
            } else if (EQUIVALENCE_CLASS_BASED_INFO.equals(_property)) {
                _clazz = InterferenceDAv2.class;
            } else if (TYPE_BASED_INFO.equals(_property)) {
                _clazz = InterferenceDAv1.class;
            } else {
                LOGGER.error("setupInterferenceDependence() -  : Interference dependence could not be configured due to illegal interference dependence nature.");
                throw new IllegalStateException("Interference dependence could not be configured due to illegal interference dependence nature.");
            }
            try {
                Constructor _constructor = _clazz.getConstructor(null);
                InterferenceDAv1 _newInstance = (InterferenceDAv1)_constructor.newInstance(null);
                this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.INTERFERENCE_DA, (Collection)Collections.singleton(_newInstance));
            }
            catch (NoSuchMethodException _e) {
                String string = "Dependence analysis does not provide zero parameter constructor :" + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                RuntimeException _runtimeException = new RuntimeException(string);
                _runtimeException.initCause(_e);
                throw _runtimeException;
            }
            catch (IllegalArgumentException _e) {
                String string = "Dependence analysis does not provide zero-parameter constructor : " + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                throw _e;
            }
            catch (SecurityException _e) {
                String string = "Insufficient permission to access specified dependence analysis class : " + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                RuntimeException _runtimeException = new RuntimeException(string);
                _runtimeException.initCause(_e);
                throw _runtimeException;
            }
            catch (IllegalAccessException _e) {
                String string = "Dependence analysis does not provide publicly accessible constructors : " + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                RuntimeException _runtimeException = new RuntimeException(string);
                _runtimeException.initCause(_e);
                throw _runtimeException;
            }
            catch (InvocationTargetException _e) {
                String string = "constructor threw an exception : " + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                RuntimeException _runtimeException = new RuntimeException(string);
                _runtimeException.initCause(_e);
                throw _runtimeException;
            }
            catch (InstantiationException _e) {
                String string = "Exception while instantiating the analysis : " + _clazz;
                LOGGER.error("setupInterferenceDependence() -  : " + string);
                RuntimeException _runtimeException = new RuntimeException(string);
                _runtimeException.initCause(_e);
                throw _runtimeException;
            }
            for (InterferenceDAv1 interferenceDAv1 : this.id2dependencyAnalyses.get(IDependencyAnalysis.DependenceSort.INTERFERENCE_DA)) {
                interferenceDAv1.setUseOFA(this.isOFAUsedForInterference());
            }
        } else {
            this.dependencesToUse.remove(_id);
            this.id2dependencyAnalyses.remove(_id);
        }
    }

    private void setupNatureOfReadyDep(Comparable<?> nature) {
        Class<? extends ReadyDAv1> _clazz = this.getReadyDAClass(nature);
        try {
            HashSet<IDependencyAnalysis> _temp = new HashSet<IDependencyAnalysis>();
            if (SliceType.FORWARD_SLICE.equals((Object)this.getSliceType())) {
                _temp.add((IDependencyAnalysis)_clazz.getMethod("getForwardReadyDA", null).invoke(null, null));
            } else if (SliceType.BACKWARD_SLICE.equals((Object)this.getSliceType())) {
                _temp.add((IDependencyAnalysis)_clazz.getMethod("getBackwardReadyDA", null).invoke(null, null));
            } else if (SliceType.COMPLETE_SLICE.equals((Object)this.getSliceType())) {
                _temp.add((IDependencyAnalysis)_clazz.getMethod("getBackwardReadyDA", null).invoke(null, null));
                _temp.add((IDependencyAnalysis)_clazz.getMethod("getForwardReadyDA", null).invoke(null, null));
            } else {
                String _msg = "Illegal slice type :" + _clazz.toString() + " : " + (Object)((Object)this.getSliceType());
                LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
                throw new IllegalStateException(_msg);
            }
            this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.READY_DA, _temp);
        }
        catch (NoSuchMethodException _e) {
            String _msg = "Dependence analysis does not provide getForwardReadyDA() and/or getBackwardReadyDA() :" + _clazz;
            LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
            RuntimeException _runtimeException = new RuntimeException(_msg);
            _runtimeException.initCause(_e);
            throw _runtimeException;
        }
        catch (IllegalArgumentException _e) {
            String _msg = "Dependence analysis does not provide static zero-parameter versions of getForwardReadyDA() and/or getBackwardReadyDA() : " + _clazz;
            LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
            throw _e;
        }
        catch (SecurityException _e) {
            String _msg = "Insufficient permission to access specified ready dependence analysis class : " + _clazz;
            LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
            RuntimeException _runtimeException = new RuntimeException(_msg);
            _runtimeException.initCause(_e);
            throw _runtimeException;
        }
        catch (IllegalAccessException _e) {
            String _msg = "Dependence analysis does not provide publicly accessible versions of  getForwardReadyDA() and/or getBackwardReadyDA() : " + _clazz;
            LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
            RuntimeException _runtimeException = new RuntimeException(_msg);
            _runtimeException.initCause(_e);
            throw _runtimeException;
        }
        catch (InvocationTargetException _e) {
            String _msg = "getForwardReadyDA() and/or getBackwardReadyDA() threw an exception : " + _clazz;
            LOGGER.error("setupNatureOfReadyDep() -  : " + _msg);
            RuntimeException _runtimeException = new RuntimeException(_msg);
            _runtimeException.initCause(_e);
            throw _runtimeException;
        }
    }

    private void setupRDARules() {
        int _rule = 0;
        if (this.isReadyRule1Used()) {
            _rule = 1;
        }
        if (this.isReadyRule2Used()) {
            _rule = 2;
        }
        if (this.isReadyRule3Used()) {
            _rule = 4;
        }
        if (this.isReadyRule4Used()) {
            _rule = 8;
        }
        Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> _c = this.id2dependencyAnalyses.get(IDependencyAnalysis.DependenceSort.READY_DA);
        for (ReadyDAv1 readyDAv1 : _c) {
            int _rules = readyDAv1.getRules();
            readyDAv1.setRules(_rules | _rule);
        }
    }

    private void setupReadyDependence() {
        IDependencyAnalysis.DependenceSort _id = IDependencyAnalysis.DependenceSort.READY_DA;
        if (this.isReadyDepAnalysisUsed()) {
            this.dependencesToUse.add(_id);
            this.setupNatureOfReadyDep((Comparable<?>)((Object)this.getNatureOfReadyDepAnalysis()));
            boolean _usedForReady = this.isOFAUsedForReady();
            for (ReadyDAv1 readyDAv1 : this.id2dependencyAnalyses.get(_id)) {
                readyDAv1.setUseOFA(_usedForReady);
            }
            boolean _safeLockAnalysisUsedForReady = this.isSafeLockAnalysisUsedForReady();
            for (ReadyDAv1 readyDAv1 : this.id2dependencyAnalyses.get(_id)) {
                readyDAv1.setUseSafeLockAnalysis(_safeLockAnalysisUsedForReady);
            }
            boolean bl = this.isCallSiteSensitiveReadyUsed();
            for (ReadyDAv1 readyDAv1 : this.id2dependencyAnalyses.get(_id)) {
                readyDAv1.setConsiderCallSites(bl);
            }
            this.setupRDARules();
        } else {
            this.dependencesToUse.remove(_id);
            this.id2dependencyAnalyses.remove(_id);
        }
    }

    private void setupSliceTypeRelatedData() {
        SliceType _sliceType = this.getSliceType();
        this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA, (Collection)Collections.singleton(new IdentifierBasedDataDAv3()));
        this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA, (Collection)Collections.singleton(new ReferenceBasedDataDA()));
        HashSet<Object> _c = new HashSet<Object>();
        if (this.isNonTerminationSensitiveControlDependenceUsed()) {
            _c.add(new NonTerminationSensitiveEntryControlDA());
        } else {
            _c.add(new NonTerminationInsensitiveEntryControlDA());
        }
        if (_sliceType.equals((Object)SliceType.FORWARD_SLICE)) {
            _c.add(new ExitControlDA());
            this.setProperty(EXECUTABLE_SLICE, Boolean.FALSE);
        } else if (_sliceType.equals((Object)SliceType.COMPLETE_SLICE)) {
            _c.add(new ExitControlDA());
        } else if (!_sliceType.equals((Object)SliceType.BACKWARD_SLICE)) {
            throw new IllegalStateException("Slice type was not either of BACKWARD_SLICE, FORWARD_SLICE, or COMPLETE_SLICE.");
        }
        this.id2dependencyAnalyses.put(IDependencyAnalysis.DependenceSort.CONTROL_DA, _c);
    }

    private void setupSynchronizationDependence() {
        IDependencyAnalysis.DependenceSort _id = IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA;
        if (this.isSynchronizationDepAnalysisUsed()) {
            this.dependencesToUse.add(_id);
            this.id2dependencyAnalyses.put(_id, (Collection)Collections.singleton(new SynchronizationDA()));
        } else {
            this.dependencesToUse.remove(_id);
            this.id2dependencyAnalyses.remove(_id);
        }
    }

    public static /* synthetic */ SlicerConfiguration JiBX_slicerConfig_JiBXBinding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return SlicerConfiguration.makeToolConfiguration();
    }

    public final /* synthetic */ SlicerConfiguration JiBX_slicerConfig_JiBXBinding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        SlicerConfiguration slicerConfiguration = this;
        this.setSliceType(SliceType.valueOf(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "slicetype")));
        this.setExecutableSlice(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "executableSlice"));
        this.setConfigName(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "name"));
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ SlicerConfiguration JiBX_slicerConfig_JiBXBinding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SlicerConfiguration slicerConfiguration = this;
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "criteria");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "deadlock");
        this.setSliceForDeadlock(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "sliceForDeadlock", true));
        this.setDeadlockCriteriaSelectionStrategy(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "deadlockCriteriaSelectionStrategy"));
        this.considerSynchronizationsInAppClassesOnly(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "inApplicationClassesOnly"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "deadlock");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "deadlock");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "assertion");
        this.setSliceToPreserveAssertions(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "sliceToPreserveAssertions", false));
        this.considerAssertionsInAppClassesOnly(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "inApplicationClassesOnly"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "assertion");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "assertion");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "criteria");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "control");
        this.useNonTerminationSensitiveControlDependence(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "nonTerminationSensitive"));
        this.useExplicitExceptionalExitSensitiveControlDependence(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "explicitExceptionalExitSensitive"));
        this.considerCommonUncheckedExceptions(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "commonUncheckedExceptions"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "control");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "control");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        this.useInterferenceDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.setNatureOfInterferenceDepAnalysis(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "natureOfInterThreadAnalysis"));
        this.useOFAForInterference(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "useOFA"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        this.useDivergenceDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.setNatureOfDivergenceDepAnalysis(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "natureOfDivergenceAnalysis"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        this.useReadyDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.setNatureOfReadyDepAnalysis(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "natureOfInterThreadAnalysis"));
        this.useReadyRule1(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule1"));
        this.useReadyRule2(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule2"));
        this.useReadyRule3(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule3"));
        this.useReadyRule4(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule4"));
        this.useCallSiteSensitiveReady(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "callSiteSensitive"));
        this.useOFAForReady(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "useOFA"));
        this.useSafeLockAnalysisForReady(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "useSafeLockAnalysis"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "synchronization");
        this.useSynchronizationDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "synchronization");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "synchronization");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "callingcontext");
        this.setPropertyAware(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.setCallingContextLimit(arg1.attributeInt("http://indus.projects.cis.ksu.edu/slicer", "contextLengthLimit", 10));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "callingcontext");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/slicer", "callingcontext");
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(1).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_slicerConfig_JiBXBinding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(4, "slicetype", SliceType.name(this.getSliceType())).attribute(4, "executableSlice", Utility.serializeBoolean((boolean)this.getExecutableSlice())).attribute(3, "name", this.getConfigName());
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_slicerConfig_JiBXBinding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        arg1.startTagNamespaces(4, "criteria", new int[]{3, 4}, new String[]{"indus", "slicer"}).closeStartContent();
        arg1.startTagNamespaces(4, "deadlock", new int[]{3, 4}, new String[]{"indus", "slicer"});
        boolean bl = this.getSliceForDeadlock();
        if (!bl) {
            marshallingContext = marshallingContext.attribute(4, "sliceForDeadlock", Utility.serializeBoolean((boolean)bl));
        }
        MarshallingContext marshallingContext2 = marshallingContext.attribute(4, "deadlockCriteriaSelectionStrategy", this.getDeadlockCriteriaSelectionStrategy()).attribute(4, "inApplicationClassesOnly", Utility.serializeBoolean((boolean)this.areSynchronizationsOnlyInAppClassesConsidered()));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "assertion", new int[]{3, 4}, new String[]{"indus", "slicer"});
        boolean bl2 = this.getSliceToPreserveAssertions();
        if (bl2) {
            marshallingContext2 = marshallingContext2.attribute(4, "sliceToPreserveAssertions", Utility.serializeBoolean((boolean)bl2));
        }
        MarshallingContext marshallingContext3 = marshallingContext2.attribute(4, "inApplicationClassesOnly", Utility.serializeBoolean((boolean)this.areAssertionsOnlyInAppClassesConsidered()));
        arg1.closeStartEmpty();
        arg1.endTag(4, "criteria");
        arg1.startTagNamespaces(4, "control", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext4 = marshallingContext3.attribute(4, "nonTerminationSensitive", Utility.serializeBoolean((boolean)this.isNonTerminationSensitiveControlDependenceUsed())).attribute(4, "explicitExceptionalExitSensitive", Utility.serializeBoolean((boolean)this.isExplicitExceptionalExitSensitiveControlDependenceUsed())).attribute(4, "commonUncheckedExceptions", Utility.serializeBoolean((boolean)this.areCommonUncheckedExceptionsConsidered()));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "interference", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext5 = marshallingContext4.attribute(4, "active", Utility.serializeBoolean((boolean)this.isInterferenceDepAnalysisUsed())).attribute(4, "natureOfInterThreadAnalysis", this.getNatureOfInterferenceDepAnalysis()).attribute(4, "useOFA", Utility.serializeBoolean((boolean)this.isOFAUsedForInterference()));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "divergence", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext6 = marshallingContext5.attribute(4, "active", Utility.serializeBoolean((boolean)this.isDivergenceDepAnalysisUsed())).attribute(4, "natureOfDivergenceAnalysis", this.getNatureOfDivergenceDepAnalysis());
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "ready", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext7 = marshallingContext6.attribute(4, "active", Utility.serializeBoolean((boolean)this.isReadyDepAnalysisUsed())).attribute(4, "natureOfInterThreadAnalysis", this.getNatureOfReadyDepAnalysis()).attribute(4, "rule1", Utility.serializeBoolean((boolean)this.isReadyRule1Used())).attribute(4, "rule2", Utility.serializeBoolean((boolean)this.isReadyRule2Used())).attribute(4, "rule3", Utility.serializeBoolean((boolean)this.isReadyRule3Used())).attribute(4, "rule4", Utility.serializeBoolean((boolean)this.isReadyRule4Used())).attribute(4, "callSiteSensitive", Utility.serializeBoolean((boolean)this.isCallSiteSensitiveReadyUsed())).attribute(4, "useOFA", Utility.serializeBoolean((boolean)this.isOFAUsedForReady())).attribute(4, "useSafeLockAnalysis", Utility.serializeBoolean((boolean)this.isSafeLockAnalysisUsedForReady()));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "synchronization", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext8 = marshallingContext7.attribute(4, "active", Utility.serializeBoolean((boolean)this.isSynchronizationDepAnalysisUsed()));
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(4, "callingcontext", new int[]{3, 4}, new String[]{"indus", "slicer"});
        MarshallingContext marshallingContext9 = marshallingContext8.attribute(4, "active", Utility.serializeBoolean((boolean)this.getPropertyAware()));
        int n = this.getCallingContextLimit();
        if (n != 10) {
            marshallingContext9 = marshallingContext9.attribute(4, "contextLengthLimit", Utility.serializeInt((int)n));
        }
        arg1.closeStartEmpty();
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(1, "edu.ksu.cis.indus.tools.slicer.SlicerConfiguration").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 1;
    }
}

