/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition;
import edu.ksu.cis.indus.common.soot.ApplicationClassesOnlyPredicate;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.MetricsProcessor;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.transformations.TagBasedDestructiveSliceResidualizer;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizerCLI;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.tools.IToolProgressListener;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.SlicerToolHelper;
import edu.ksu.cis.indus.tools.slicer.TagBasedSliceXMLizer;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.LineNumberBasedCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.generators.StmtTypeBasedSliceCriteriaGenerator;
import edu.ksu.cis.indus.tools.slicer.criteria.predicates.AbstractSliceCriteriaPredicate;
import edu.ksu.cis.indus.tools.slicer.criteria.specification.SliceCriteriaParser;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Printer;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.options.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliceXMLizerCLI
extends SootBasedDriver
implements IToolProgressListener {
    static final Logger LOGGER = LoggerFactory.getLogger(SliceXMLizerCLI.class);
    private static String configFileName;
    private static SpecificationBasedScopeDefinition sliceScope;
    protected String outputDirectory;
    SlicerTool<?> slicer = new SlicerTool(TokenUtil.getTokenManager((ITypeManager)new SootValueTypeManager()), this.getStmtGraphFactory());
    String jimpleXMLDumpDir;
    private Collection<String> retentionList;
    private IJimpleIDGenerator idGenerator;
    private String criteriaSpecFileName;
    private LineNumberBasedCriteriaGenerator lineBasedCriteriaGenerator;
    private final String nameOfSliceTag = "indus.tools.slicer.SliceXMLizerCLI:SLICER";
    private boolean postResJimpleDump;
    private boolean postResXMLJimpleDump;
    private boolean preResJimpleDump;
    private boolean preResXMLJimpleDump;
    private boolean residualize;
    private boolean shouldWriteSliceXML;
    private boolean preserveThrowStmtsInAppClassesOnly;
    private boolean generateSeparateSlicesForEachThrowStmt;
    private boolean detailedStats;
    private boolean preserveThrowStatements;

    protected <T extends ITokens<T, Value>> SliceXMLizerCLI() {
        this.cfgProvider = this.slicer.getStmtGraphFactory();
    }

    public static void main(String[] args) {
        SliceXMLizerCLI _xmlizer = new SliceXMLizerCLI();
        SliceXMLizerCLI.parseCommandLine(args, _xmlizer);
        _xmlizer.initialize();
        if (!_xmlizer.generateSeparateSlicesForEachThrowStmt) {
            long _startTime = System.currentTimeMillis();
            _xmlizer.executeForSingleSlice();
            long _stopTime = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("It took " + (_stopTime - _startTime) + "ms to identify the slice.");
            }
            _xmlizer.setIDGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
            _xmlizer.writeSliceXML();
            _xmlizer.outputStats(_xmlizer.nameOfSliceTag);
            _xmlizer.residualize();
            _xmlizer.slicer.reset();
            _xmlizer.reset();
        } else {
            _xmlizer.executeForMultipleSlices();
        }
    }

    public void toolProgess(IToolProgressListener.ToolProgressEvent evt) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.valueOf(evt.getMsg()) + " - " + evt.getInfo());
        }
    }

    protected final void setConfiguration(String configuration) {
        this.slicer.destringizeConfiguration(configuration);
    }

    protected final TagBasedSliceXMLizer getXMLizer() {
        return new TagBasedSliceXMLizer("indus.tools.slicer.SliceXMLizerCLI:SLICER", this.idGenerator);
    }

    protected void setIDGenerator(IJimpleIDGenerator generator) {
        this.idGenerator = generator;
    }

    protected final void setOutputDirectory(String oDir) {
        this.outputDirectory = oDir;
    }

    private void executeForMultipleSlices() {
        StmtTypeBasedSliceCriteriaGenerator _generator = new StmtTypeBasedSliceCriteriaGenerator();
        _generator.setStmtTypes((Collection)Collections.singleton(ThrowStmt.class));
        if (this.preserveThrowStmtsInAppClassesOnly) {
            _generator.setSiteSelectionPredicate(new ApplicationClassesOnlyPredicate());
        }
        CustomCriteriaPredicate _filter = new CustomCriteriaPredicate();
        _generator.setCriteriaFilterPredicate(_filter);
        this.slicer.addCriteriaGenerator(_generator);
        Collection<ISliceCriterion> _criteria = this.processCriteriaSpecFile();
        this.slicer.addCriteria(_criteria);
        this.slicer.setSystem((IEnvironment)new Environment(this.scene));
        this.slicer.setRootMethods(this.rootMethods);
        this.slicer.setSliceScopeDefinition(sliceScope);
        this.slicer.addToolProgressListener(this);
        this.slicer.setTagName("indus.tools.slicer.SliceXMLizerCLI:SLICER");
        this.slicer.run(Phase.STARTING_PHASE, SlicerTool.SLICE_MAJOR_PHASE, true);
        int _count = 0;
        do {
            int _prevSize = _filter.getSliceCount();
            String _tag = "indus.tools.slicer.SliceXMLizerCLI:SLICER:" + _prevSize;
            this.slicer.setTagName(_tag);
            this.slicer.run(SlicerTool.SLICE_MAJOR_PHASE, Phase.FINISHED_PHASE, true);
            this.outputStats(_tag);
            this.dumpJimple("_" + String.valueOf(_count++), true, false, _tag);
            _filter.setCountingStatus();
            if (!LOGGER.isInfoEnabled()) continue;
            try {
                LOGGER.info("Criteria specification after slicing: \n" + SliceCriteriaParser.serialize(this.slicer.getCriteria()));
            }
            catch (JiBXException _e) {
                LOGGER.info("JiBX failed during serialization.", (Throwable)_e);
            }
        } while (_filter.getSliceCount() == _count);
    }

    void executeForSingleSlice() {
        this.slicer.setTagName("indus.tools.slicer.SliceXMLizerCLI:SLICER");
        this.slicer.setSystem((IEnvironment)new Environment(this.scene));
        this.slicer.setRootMethods(this.rootMethods);
        if (this.preserveThrowStatements) {
            StmtTypeBasedSliceCriteriaGenerator _generator = new StmtTypeBasedSliceCriteriaGenerator();
            _generator.setStmtTypes((Collection)Collections.singleton(ThrowStmt.class));
            if (this.preserveThrowStmtsInAppClassesOnly) {
                _generator.setSiteSelectionPredicate(new IPredicate<SootMethod>(){

                    public <T1 extends SootMethod> boolean evaluate(T1 t) {
                        return t.getDeclaringClass().isApplicationClass();
                    }
                });
            }
            this.slicer.addCriteriaGenerator(_generator);
        }
        if (this.lineBasedCriteriaGenerator != null) {
            this.slicer.addCriteriaGenerator(this.lineBasedCriteriaGenerator);
        }
        Collection<ISliceCriterion> _criteria = this.processCriteriaSpecFile();
        this.slicer.setSliceScopeDefinition(sliceScope);
        this.slicer.addCriteria(_criteria);
        this.slicer.addToolProgressListener(this);
        this.slicer.run(Phase.STARTING_PHASE, null, true);
        if (LOGGER.isInfoEnabled()) {
            try {
                LOGGER.info("Criteria specification after slicing: \n" + SliceCriteriaParser.serialize(this.slicer.getCriteria()));
            }
            catch (JiBXException _e) {
                LOGGER.info("JiBX failed during serialization.", (Throwable)_e);
            }
        }
    }

    private void setLineBasedCriteriaSpecFile(String lineBasedCritSpecFileName) {
        try {
            FileInputStream _io = new FileInputStream(new File(lineBasedCritSpecFileName));
            Properties _props = new Properties();
            _props.load(_io);
            this.lineBasedCriteriaGenerator = new LineNumberBasedCriteriaGenerator(_props);
            Options.v().set_keep_line_number(true);
        }
        catch (IOException _e) {
            this.lineBasedCriteriaGenerator = null;
            LOGGER.error("Error while handling line based criteria spec file", (Throwable)_e);
            throw new IllegalArgumentException("Error while handling line based criteria spec file", _e);
        }
    }

    void destructivelyUpdateJimple() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Residualizing");
        }
        TagBasedDestructiveSliceResidualizer _residualizer = new TagBasedDestructiveSliceResidualizer();
        _residualizer.setTagToResidualize("indus.tools.slicer.SliceXMLizerCLI:SLICER");
        _residualizer.setBasicBlockGraphMgr(this.getBbm());
        _residualizer.residualizeSystem(this.getEnvironment());
    }

    void dumpJimpleAsXML(String base) {
        TagBasedSliceXMLizer _xmlizer = this.getXMLizer();
        if (this.jimpleXMLDumpDir != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("BEGIN: Dumping XMLized Jimple");
            }
            ProcessingController _ctrl = new ProcessingController();
            XMLizingProcessingFilter _filter = new XMLizingProcessingFilter();
            OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
            _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
            _ctrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
            _ctrl.setEnvironment(this.getEnvironment());
            _filter.chain((IProcessingFilter)new TagBasedProcessingFilter("indus.tools.slicer.SliceXMLizerCLI:SLICER"));
            _ctrl.setProcessingFilter((IProcessingFilter)_filter);
            ((AbstractXMLizer)_xmlizer).dumpJimple(base, this.jimpleXMLDumpDir, _ctrl);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("END: Dumping XMLized Jimple");
            }
        }
    }

    private static void parseCommandLine(String[] args, SliceXMLizerCLI xmlizer) {
        org.apache.commons.cli.Options _options = new org.apache.commons.cli.Options();
        Option _o = new Option("c", "config-file", true, "The configuration file to use.  If unspecified, uses default configuration file.");
        _o.setArgs(1);
        _o.setArgName("config-file");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("a", "active-config", true, "The alternate configuration to use instead of the one specified in the configuration.");
        _o.setArgs(1);
        _o.setArgName("config");
        _o.setLongOpt("active-config");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("o", "output-dir", true, "The output directory to dump the generated info.  If unspecified, picks a temporary directory.");
        _o.setArgs(1);
        _o.setArgName("path");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("g", "gui-config", false, "Display gui for configuration.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        _o.setArgs(1);
        _o.setArgName("classpath");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("e", "exception-preserving-slice", true, "Generate slice that preserves every throw statement in the application class. Comma-separated combination of optional arguments: inAppOnly - preserve throw statements in application classes only, separateSlices - generated a different slice for each throw statement. **This option should not be combined with -r**");
        _o.setArgs(1);
        _o.setOptionalArg(true);
        _o.setArgName("applClassOnly");
        _options.addOption(_o);
        _o = new Option(" ", "detailedStats", false, "Display detailed stats.");
        _o.setOptionalArg(false);
        _o = new Option("h", "help", false, "Display message.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("i", "output-xml-jimple-before-res", false, "Output xml representation of the jimple BEFORE residualization.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("j", "output-xml-jimple-after-res", false, "Output xml representation of the jimple AFTER residualization. This only works with -r option.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("I", "output-jimple-before-res", false, "Output jimple BEFORE residualization.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("J", "output-jimple-after-res", false, "Output jimple AFTER residualization. This only works with -r option.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("s", "criteria-spec-file", true, "Use the slice criteria specified in this file.");
        _o.setArgs(1);
        _o.setArgName("crit-spec-file");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("S", "slice-scope-spec-file", true, "Use the scope specified in this file.");
        _o.setArgs(1);
        _o.setArgName("slice-scope-spec-file");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("r", "residualize", true, "Residualize after slicing. This will also dump the class files for the residualized classes.  Provide the name of the file as an optional argument to optimize the slice (via transformation) for space.  The file shouldcontain the FQN of classes (1 per line) to be retained during optimization.");
        _o.setOptionalArg(true);
        _options.addOption(_o);
        _o = new Option("x", "output-slice-xml", false, "Output xml representation of the slice.");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("l", true, "Generate criteria based on line number based criteria spec file. The format is <class FQN>=<comma-separated list of line numbers from the class containing  Java file>.");
        _o.setArgs(1);
        _o.setArgName("line-based-criteria-spec-file");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        CommandLine _cl = null;
        ParseException _exception = null;
        try {
            _cl = new BasicParser().parse(_options, args);
        }
        catch (ParseException _e) {
            _exception = _e;
        }
        if (_exception != null || _cl.hasOption("h")) {
            SliceXMLizerCLI.printUsage(_options);
            if (_exception != null) {
                LOGGER.error("Incorrect command line.  Aborting.", (Throwable)_exception);
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        xmlizer.setConfiguration(SliceXMLizerCLI.processCommandLineForConfiguration(_cl));
        SliceXMLizerCLI.setupOutputOptions(_cl, xmlizer);
        if (_cl.hasOption('p')) {
            xmlizer.addToSootClassPath(_cl.getOptionValue('p'));
        }
        if (_cl.hasOption('a')) {
            xmlizer.setConfigName(_cl.getOptionValue('a'));
        }
        if (_cl.hasOption('g')) {
            xmlizer.showGUI();
        }
        if (_cl.hasOption('s')) {
            xmlizer.setSliceCriteriaSpecFile(_cl.getOptionValue('s'));
        }
        if (_cl.hasOption('r')) {
            xmlizer.setResidulization(true);
            String _optionValue = _cl.getOptionValue('r');
            if (_optionValue != null) {
                xmlizer.extractExclusionListForCompaction(_optionValue);
            }
        }
        if (_cl.hasOption('S')) {
            sliceScope = xmlizer.setScopeSpecFile(_cl.getOptionValue('S'));
            xmlizer.setScopeSpecFile(null);
        }
        if (_cl.hasOption('l')) {
            xmlizer.setLineBasedCriteriaSpecFile(_cl.getOptionValue('l'));
        }
        xmlizer.preserveThrowStatements = _cl.hasOption('e');
        if (xmlizer.preserveThrowStatements) {
            xmlizer.parseThrowStmtTreatmentOptions(_cl.getOptionValue('e'));
        }
        if (xmlizer.generateSeparateSlicesForEachThrowStmt && xmlizer.residualize) {
            throw new IllegalArgumentException("Residualization (-r) cannot be combined multiple slice generation mode (-e separateSlices).");
        }
        xmlizer.detailedStats = _cl.hasOption("detailedStats");
        xmlizer.shouldWriteSliceXML = _cl.hasOption('x');
        List _result = _cl.getArgList();
        if (_result.isEmpty()) {
            LOGGER.error("Please specify atleast one class that contains an entry method into the system to be sliced.");
            System.exit(1);
        }
        xmlizer.setClassNames(_result);
    }

    private void parseThrowStmtTreatmentOptions(String optionValue) {
        String[] _values;
        if (optionValue == null) {
            return;
        }
        String[] stringArray = _values = optionValue.split(",");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String _v = stringArray[n];
            if (_v.equals("appClassOnly")) {
                this.preserveThrowStmtsInAppClassesOnly = true;
            } else if (_v.equals("separateSlices")) {
                this.generateSeparateSlicesForEachThrowStmt = true;
            }
            ++n;
        }
    }

    private void extractExclusionListForCompaction(String fileName) {
        this.retentionList = new ArrayList<String>();
        try {
            BufferedReader _br = new BufferedReader(new FileReader(new File(fileName)));
            while (_br.ready()) {
                this.retentionList.add(_br.readLine());
            }
            _br.close();
        }
        catch (FileNotFoundException _e) {
            LOGGER.error("File does not exists - " + fileName + ". Hence the slice will not be optimized for space.", (Throwable)_e);
            this.retentionList = null;
        }
        catch (IOException _e) {
            LOGGER.error("Error reading the file - " + fileName + ". Hence the slice will not be optimized for space.", (Throwable)_e);
            this.retentionList = null;
        }
    }

    private static void printUsage(org.apache.commons.cli.Options options) {
        String _cmdLineSyn = "java " + DependencyXMLizerCLI.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }

    private static String processCommandLineForConfiguration(CommandLine cl) {
        String _config;
        configFileName = _config = cl.getOptionValue('c');
        return SlicerToolHelper.loadConfigurationInFile(_config);
    }

    private static void setupOutputOptions(CommandLine cl, SliceXMLizerCLI xmlizer) {
        String _outputDir;
        if (cl.hasOption('o')) {
            _outputDir = cl.getOptionValue("o");
        } else {
            File _tempDir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + System.currentTimeMillis() + "_slicer");
            _tempDir.mkdirs();
            _outputDir = _tempDir.getAbsolutePath();
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Using " + _outputDir + " as the directory to dump information");
            }
        }
        xmlizer.preResXMLJimpleDump = cl.hasOption('i');
        xmlizer.postResXMLJimpleDump = cl.hasOption('j') && cl.hasOption('r');
        xmlizer.preResJimpleDump = cl.hasOption('I');
        boolean bl = xmlizer.postResJimpleDump = cl.hasOption('J') && cl.hasOption('r');
        if (xmlizer.preResXMLJimpleDump || xmlizer.postResXMLJimpleDump || xmlizer.preResJimpleDump || xmlizer.postResJimpleDump) {
            xmlizer.jimpleXMLDumpDir = _outputDir;
        }
        xmlizer.setOutputDirectory(_outputDir);
    }

    private void setConfigName(String configID) {
        this.slicer.setActiveConfiguration(configID);
    }

    private void setResidulization(boolean flag) {
        this.residualize = flag;
    }

    private void setSliceCriteriaSpecFile(String fileName) {
        this.criteriaSpecFileName = fileName;
    }

    private void dumpJimple(String suffix, boolean jimpleFile, boolean classFile, String tag) {
        Printer _printer = Printer.v();
        for (SootClass _sc : this.scene.getClasses()) {
            if (!_sc.hasTag(tag)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Dumping jimple for " + _sc + " with suffix " + suffix);
            }
            for (SootMethod _sm : _sc.getMethods()) {
                if (!_sm.isConcrete()) continue;
                try {
                    _sm.retrieveActiveBody();
                }
                catch (RuntimeException _e) {
                    LOGGER.error("Failed to retrieve body for method " + _sm, (Throwable)_e);
                }
            }
            PrintWriter _writer = null;
            try {
                try {
                    if (jimpleFile) {
                        File _file = new File(String.valueOf(this.outputDirectory) + File.separator + _sc.getName() + ".jimple" + suffix);
                        _writer = new PrintWriter(new FileWriter(_file));
                        _printer.printTo(_sc, _writer);
                    }
                    if (!classFile) continue;
                    _printer.write(_sc, this.outputDirectory);
                }
                catch (IOException _e) {
                    LOGGER.error("Error while writing " + _sc, (Throwable)_e);
                }
                catch (RuntimeException _e) {
                    LOGGER.error("Error while writing class file of " + _sc, (Throwable)_e);
                }
            }
            finally {
                if (_writer != null) {
                    _writer.flush();
                    _writer.close();
                }
            }
        }
    }

    private void outputStats(String tag) {
        if (LOGGER.isInfoEnabled()) {
            MetricsProcessor _processor = new MetricsProcessor();
            ProcessingController _pc = new ProcessingController();
            OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
            _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
            _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
            _pc.setEnvironment(this.getEnvironment());
            _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("indus.tools.slicer.SlicerTool:FA"));
            _processor.hookup(_pc);
            _pc.process();
            _processor.unhook(_pc);
            LOGGER.info("PRE SLICING STATISTICS:" + MapUtils.verbosePrint((Map)(this.detailedStats ? _processor.getStatistics() : _processor.getSummary())));
            _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(tag));
            _processor.hookup(_pc);
            _pc.setEnvironment((IEnvironment)new Environment(this.scene));
            _pc.process();
            _processor.unhook(_pc);
            LOGGER.info("POST SLICING STATISTICS:" + MapUtils.verbosePrint((Map)(this.detailedStats ? _processor.getStatistics() : _processor.getSummary())));
        }
    }

    private Collection<ISliceCriterion> processCriteriaSpecFile() throws IllegalArgumentException, IllegalStateException {
        HashSet<ISliceCriterion> _criteria;
        block6: {
            _criteria = new HashSet<ISliceCriterion>();
            if (this.criteriaSpecFileName != null) {
                try {
                    FileInputStream _in = new FileInputStream(this.criteriaSpecFileName);
                    String _result = IOUtils.toString((InputStream)_in);
                    IOUtils.closeQuietly((InputStream)_in);
                    String _criteriaSpec = _result;
                    _criteria.addAll(SliceCriteriaParser.deserialize(_criteriaSpec, this.scene));
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Criteria specification before slicing: \n" + _result);
                        LOGGER.info("Criteria before slicing: \n" + _criteria);
                    }
                }
                catch (IOException _e) {
                    if (LOGGER.isWarnEnabled()) {
                        String _msg = "Error retrieved slicing criteria from " + this.criteriaSpecFileName;
                        LOGGER.error(_msg, (Throwable)_e);
                        IllegalArgumentException _i = new IllegalArgumentException(_msg);
                        _i.initCause(_e);
                        throw _i;
                    }
                }
                catch (JiBXException _e) {
                    if (!LOGGER.isWarnEnabled()) break block6;
                    LOGGER.error("JiBX failed during deserialization.", (Throwable)_e);
                    IllegalStateException _i = new IllegalStateException("JiBX failed during deserialization.");
                    _i.initCause(_e);
                    throw _i;
                }
            }
        }
        return _criteria;
    }

    private void residualize() {
        if (this.preResXMLJimpleDump) {
            this.dumpJimpleAsXML("unsliced");
        }
        if (this.preResJimpleDump) {
            this.dumpJimple("_preRes", true, false, "indus.tools.slicer.SliceXMLizerCLI:SLICER");
        }
        if (this.residualize) {
            if (this.retentionList != null) {
                SlicerToolHelper.optimizeForSpaceBeforeResidualization(this.slicer, this.retentionList);
            }
            this.destructivelyUpdateJimple();
            if (this.retentionList != null) {
                Collection<SootClass> _c = SlicerToolHelper.optimizeForSpaceAfterResidualization(this.slicer, this.retentionList);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Retained classes are " + _c);
                }
            }
            this.dumpJimple("", false, true, "indus.tools.slicer.SliceXMLizerCLI:SLICER");
        }
        if (this.postResJimpleDump) {
            this.dumpJimple("_postRes", true, false, "indus.tools.slicer.SliceXMLizerCLI:SLICER");
        }
        if (this.postResXMLJimpleDump) {
            this.dumpJimpleAsXML("sliced");
        }
    }

    private void showGUI() {
        Display _display = new Display();
        final Shell _shell = new Shell(67680);
        _shell.setText("Slicer configuration");
        RowLayout _rowLayout = new RowLayout();
        _rowLayout.type = 512;
        _shell.setLayout((Layout)_rowLayout);
        this.slicer.getConfigurator().initialize(new Composite((Composite)_shell, 0));
        Button _ok = new Button((Composite)_shell, 8);
        _ok.setText("Ok");
        _ok.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                _shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        _shell.layout();
        _shell.pack();
        _shell.open();
        while (!_shell.isDisposed()) {
            if (_display.readAndDispatch()) continue;
            _display.sleep();
        }
        _display.dispose();
        try {
            if (configFileName != null) {
                FileUtils.writeStringToFile((File)new File(configFileName), (String)this.slicer.stringizeConfiguration(), (String)"UTF-8");
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Configuration file name is unspecified.  Printing to console.");
                }
                System.out.println(this.slicer.stringizeConfiguration());
            }
        }
        catch (IOException _e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not write the configuration file.  Printing to console", (Throwable)_e);
            }
            System.out.println(this.slicer.stringizeConfiguration());
        }
    }

    private void writeSliceXML() {
        if (this.shouldWriteSliceXML) {
            TagBasedSliceXMLizer _xmlizer = this.getXMLizer();
            HashMap<Comparable, Object> _info = new HashMap<Comparable, Object>();
            _info.put(IEnvironment.ID, this.getEnvironment());
            _info.put(IStmtGraphFactory.ID, this.getStmtGraphFactory());
            _xmlizer.setXmlOutputDir(this.outputDirectory);
            _xmlizer.writeXML(_info);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomCriteriaPredicate
    extends AbstractSliceCriteriaPredicate<Stmt> {
        private boolean countingStatus = true;
        private final Collection<Stmt> stmts = new HashSet<Stmt>();

        CustomCriteriaPredicate() {
        }

        public boolean evaluate(Stmt t) {
            boolean _flag;
            if (this.countingStatus) {
                _flag = this.stmts.add(t);
                if (_flag) {
                    this.countingStatus = false;
                }
            } else {
                _flag = false;
            }
            return _flag;
        }

        int getSliceCount() {
            return this.stmts.size();
        }

        void setCountingStatus() {
            this.countingStatus = true;
        }
    }
}

