/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer.transformations;

import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.cfg.LocalUseDefAnalysisv2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.tagkit.Tag;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.Chain;
import soot.util.Switch;

public final class TagBasedDestructiveSliceResidualizer
extends AbstractProcessor {
    static final IFactory<Pair<Collection<SootMethod>, Collection<SootField>>> PAIR_VALUE_FACTORY = new IFactory<Pair<Collection<SootMethod>, Collection<SootField>>>(){

        public Pair<Collection<SootMethod>, Collection<SootField>> create() {
            return new Pair(new ArrayList(), new ArrayList());
        }
    };
    static final Logger LOGGER = LoggerFactory.getLogger(TagBasedDestructiveSliceResidualizer.class);
    final Map<SootClass, Pair<Collection<SootMethod>, Collection<SootField>>> class2members;
    final Collection<SootClass> classesToKill;
    SootMethod currMethod;
    IEnvironment environment;
    final Collection<Value> localsToKeep;
    IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>> localUseDef;
    final Collection<SootMethod> methodsToKill;
    final Map<Stmt, Stmt> oldStmt2newStmt;
    final Map<Stmt, List<Stmt>> stmt2predecessors;
    NamedTag tagToResidualize;
    String theNameOfTagToResidualize;
    private BasicBlockGraphMgr bbgMgr;
    private SootClass currClass;
    private final Collection<SootField> fieldsToKill;
    private final StmtResidualizer stmtProcessor;
    private final Collection<Stmt> stmtsToBeNOPed = new ArrayList<Stmt>();

    public TagBasedDestructiveSliceResidualizer() {
        this.stmtProcessor = new StmtResidualizer();
        this.fieldsToKill = new HashSet<SootField>();
        this.stmt2predecessors = new HashMap<Stmt, List<Stmt>>();
        this.oldStmt2newStmt = new HashMap<Stmt, Stmt>();
        this.methodsToKill = new HashSet<SootMethod>();
        this.localsToKeep = new HashSet<Value>();
        this.classesToKill = new HashSet<SootClass>();
        this.class2members = new HashMap<SootClass, Pair<Collection<SootMethod>, Collection<SootField>>>(Constants.getNumOfClassesInApplication());
    }

    public void callback(SootClass clazz) {
        this.consolidateClass();
        if (clazz.hasTag(this.theNameOfTagToResidualize)) {
            this.currClass = clazz;
            this.classesToKill.remove(clazz);
            this.methodsToKill.addAll(clazz.getMethods());
            this.fieldsToKill.addAll((Collection<SootField>)clazz.getFields());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Residualized class " + clazz);
            }
        }
    }

    public void callback(SootField field) {
        if (this.currClass != null) {
            this.fieldsToKill.remove(field);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Residualized field " + field);
            }
        }
    }

    public void callback(SootMethod method) {
        if (this.currClass != null) {
            this.consolidateMethod();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing method " + method);
            }
            this.currMethod = method;
            this.methodsToKill.remove(method);
            this.localsToKeep.clear();
            this.localUseDef = null;
        }
    }

    public void callback(Stmt stmt, Context ctxt) {
        if (this.currMethod != null) {
            this.pruneLocals(stmt);
            boolean _flag = this.stmtProcessor.residualize(stmt);
            if (!_flag) {
                this.stmtsToBeNOPed.add(stmt);
            }
        }
    }

    public void consolidate() {
        this.consolidateClass();
        for (SootClass _class : this.class2members.keySet()) {
            Pair<Collection<SootMethod>, Collection<SootField>> _members = this.class2members.get(_class);
            Collection _methods = (Collection)_members.getFirst();
            Collection _fields = (Collection)_members.getSecond();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("BEGIN: Finishing class " + _class);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Erasing methods: " + _methods);
            }
            Iterator _j = _methods.iterator();
            while (_j.hasNext()) {
                _class.removeMethod((SootMethod)_j.next());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Erasing fields: " + _fields);
            }
            _j = _fields.iterator();
            while (_j.hasNext()) {
                _class.removeField((SootField)_j.next());
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("END: Finishing class " + _class);
        }
        this.class2members.clear();
        this.currClass = null;
        this.currMethod = null;
        this.methodsToKill.clear();
        this.fieldsToKill.clear();
    }

    public void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
        ppc.registerForAllStmts((IProcessor)this);
    }

    public void processingBegins() {
        this.currMethod = null;
        this.currClass = null;
        this.classesToKill.clear();
        this.classesToKill.addAll(this.environment.getClasses());
        this.oldStmt2newStmt.clear();
        this.stmtsToBeNOPed.clear();
        this.methodsToKill.clear();
    }

    public void residualizeSystem(IEnvironment env) {
        this.environment = env;
        ProcessingController _pc = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory((IStmtGraphFactory)new CompleteStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(this.theNameOfTagToResidualize));
        _pc.setEnvironment(env);
        this.hookup(_pc);
        _pc.process();
        this.unhook(_pc);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting classes: " + this.classesToKill);
        }
        Iterator<SootClass> _i = this.classesToKill.iterator();
        while (_i.hasNext()) {
            env.removeClass(_i.next());
        }
    }

    public void setBasicBlockGraphMgr(BasicBlockGraphMgr basicBlockGraphMgr) {
        this.bbgMgr = basicBlockGraphMgr;
    }

    public void setTagToResidualize(String nameOfTagToResidualize) {
        this.theNameOfTagToResidualize = nameOfTagToResidualize;
        this.tagToResidualize = new NamedTag(this.theNameOfTagToResidualize);
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
        ppc.unregisterForAllStmts((IProcessor)this);
    }

    private void consolidateClass() {
        if (this.currClass != null) {
            this.consolidateMethod();
            this.class2members.put(this.currClass, (Pair<Collection<SootMethod>, Collection<SootField>>)new Pair(new ArrayList<SootMethod>(this.methodsToKill), new ArrayList<SootField>(this.fieldsToKill)));
            this.methodsToKill.clear();
            this.fieldsToKill.clear();
            this.currClass = null;
        }
    }

    private void consolidateMethod() {
        if (this.currMethod == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Finishing method " + this.currMethod + "[concrete: " + this.currMethod.isConcrete() + "]");
        }
        if (this.currMethod.isConcrete()) {
            NopStmt _newStmt;
            JimpleBody _body = (JimpleBody)this.currMethod.getActiveBody();
            PatchingChain _ch = _body.getUnits();
            Jimple _jimple = Jimple.v();
            if (LOGGER.isDebugEnabled()) {
                ArrayList _l = new ArrayList(_ch);
                StringBuffer stringBuffer = new StringBuffer();
                for (Stmt _stmt : this.stmtsToBeNOPed) {
                    stringBuffer.append(_l.indexOf(_stmt));
                    stringBuffer.append(", ");
                }
                LOGGER.debug("Stmts being NOP-ed: " + stringBuffer);
            }
            for (Stmt stmt : this.stmtsToBeNOPed) {
                Object _pred = _ch.getPredOf((Object)stmt);
                _ch.remove((Object)stmt);
                _newStmt = _jimple.newNopStmt();
                if (_pred == null) {
                    _ch.addFirst((Object)_newStmt);
                    continue;
                }
                _ch.insertAfter((Object)_newStmt, _pred);
            }
            this.stmtsToBeNOPed.clear();
            for (Map.Entry entry : this.oldStmt2newStmt.entrySet()) {
                Stmt _oldStmt = (Stmt)entry.getKey();
                _newStmt = (Stmt)entry.getValue();
                _ch.insertAfter((Object)_newStmt, (Object)_oldStmt);
                _ch.remove((Object)_oldStmt);
            }
            for (Map.Entry entry : this.stmt2predecessors.entrySet()) {
                Stmt _stmt;
                _stmt = (Stmt)entry.getKey();
                List _preds = (List)entry.getValue();
                _ch.insertBefore(_preds, (Object)_stmt);
            }
            this.stmt2predecessors.clear();
            this.oldStmt2newStmt.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Locals " + _body.getLocals());
                LOGGER.debug("Retaining:" + this.localsToKeep);
            }
            _body.getLocals().retainAll(this.localsToKeep);
            this.removeTrapsNotInSlice((Body)_body);
            this.injectReturnsIntoDanglingNopBlocks((Chain)_ch);
            NopEliminator.v().transform((Body)_body);
            UnreachableCodeEliminator.v().transform((Body)_body);
            ConditionalBranchFolder.v().transform((Body)_body);
            UnconditionalBranchFolder.v().transform((Body)_body);
            UnusedLocalEliminator.v().transform((Body)_body);
            _body.validateLocals();
            _body.validateTraps();
            _body.validateUnitBoxes();
            _body.validateUses();
            if (_body.getUnits().isEmpty()) {
                this.pluginSignatureCorrectBody(_body, _jimple);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Finishing method " + this.currMethod);
        }
        this.currMethod = null;
    }

    private void injectReturnsIntoDanglingNopBlocks(Chain stmtList) {
        Stmt _end;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEFORE - Stmts: " + stmtList);
        }
        if ((_end = (Stmt)stmtList.getLast()) instanceof NopStmt) {
            Type _retType = this.currMethod.getReturnType();
            Object _newStmt = _retType instanceof VoidType ? Jimple.v().newReturnVoidStmt() : Jimple.v().newReturnStmt(Util.getDefaultValueFor((Type)_retType));
            stmtList.insertAfter(_newStmt, (Object)_end);
            stmtList.remove((Object)_end);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AFTER - Stmts: " + stmtList);
        }
    }

    private void pluginSignatureCorrectBody(JimpleBody body, Jimple jimpleFactory) {
        body.getTraps().clear();
        body.getLocals().clear();
        PatchingChain _temp = body.getUnits();
        if (!this.currMethod.isStatic()) {
            RefType _type = RefType.v((SootClass)this.currMethod.getDeclaringClass());
            LocalCreation _lc = new LocalCreation(body.getLocals());
            Local _this = _lc.newLocal("_this", (Type)_type);
            IdentityStmt _astmt = jimpleFactory.newIdentityStmt((Value)_this, (Value)jimpleFactory.newThisRef(_type));
            _astmt.addTag((Tag)this.tagToResidualize);
            _astmt.getLeftOpBox().addTag((Tag)this.tagToResidualize);
            _astmt.getRightOpBox().addTag((Tag)this.tagToResidualize);
            body.getUnits().add((Object)_astmt);
        }
        List _paramType = this.currMethod.getParameterTypes();
        int _end = _paramType.size();
        Iterator _i = _paramType.iterator();
        int _pCount = 0;
        while (_pCount < _end) {
            Type _pType = (Type)_i.next();
            LocalCreation _lc = new LocalCreation(body.getLocals());
            Local _this = _lc.newLocal("_local", _pType);
            IdentityStmt _astmt = jimpleFactory.newIdentityStmt((Value)_this, (Value)jimpleFactory.newParameterRef(_pType, _pCount));
            _astmt.addTag((Tag)this.tagToResidualize);
            _astmt.getLeftOpBox().addTag((Tag)this.tagToResidualize);
            _astmt.getRightOpBox().addTag((Tag)this.tagToResidualize);
            body.getUnits().add((Object)_astmt);
            ++_pCount;
        }
        Type _retType = this.currMethod.getReturnType();
        if (_retType instanceof VoidType) {
            _temp.add((Object)jimpleFactory.newReturnVoidStmt());
        } else {
            _temp.add((Object)jimpleFactory.newReturnStmt(Util.getDefaultValueFor((Type)_retType)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Injected lame body for " + this.currMethod);
        }
    }

    private void pruneLocals(Stmt stmt) {
        if (stmt.hasTag(this.theNameOfTagToResidualize)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Pruning locals in " + stmt);
            }
            List _useAndDefBoxes = stmt.getUseAndDefBoxes();
            for (ValueBox _vBox : Util.getHostsWithTag((Collection)_useAndDefBoxes, (String)this.theNameOfTagToResidualize)) {
                Value _value = _vBox.getValue();
                if (!(_value instanceof Local)) continue;
                this.localsToKeep.add(_value);
            }
        }
    }

    private void removeTrapsNotInSlice(Body body) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Collecting handlers for " + this.currMethod);
        }
        Chain _traps = body.getTraps();
        Iterator _i = _traps.iterator();
        int _iEnd = _traps.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Trap _trap = (Trap)_i.next();
            Stmt _handlerStmt = (Stmt)_trap.getHandlerUnit();
            if (!(_handlerStmt.hasTag(this.theNameOfTagToResidualize) && _handlerStmt instanceof IdentityStmt && ((IdentityStmt)_handlerStmt).getRightOp() instanceof CaughtExceptionRef && _trap.getBeginUnit() != _trap.getEndUnit())) {
                _i.remove();
            }
            ++_iIndex;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("RETAINED TRAPS: " + body.getTraps());
            LOGGER.debug("END: Collecting handlers for " + this.currMethod);
        }
    }

    private final class StmtResidualizer
    extends AbstractStmtSwitch {
        final ValueResidualizer valueProcessor;

        private StmtResidualizer() {
            this.valueProcessor = new ValueResidualizer();
        }

        public void caseAssignStmt(AssignStmt stmt) {
            this.residualizeDefStmt((DefinitionStmt)stmt);
        }

        public void caseIdentityStmt(IdentityStmt stmt) {
            this.residualizeDefStmt((DefinitionStmt)stmt);
        }

        public void caseInvokeStmt(InvokeStmt stmt) {
            if (stmt.getInvokeExprBox().hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                this.valueProcessor.residualize(stmt.getInvokeExprBox());
            } else {
                this.setResult(Jimple.v().newNopStmt());
            }
        }

        public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
            ValueBox _vBox = stmt.getKeyBox();
            if (!_vBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                stmt.setKey(Util.getDefaultValueFor((Type)_vBox.getValue().getType()));
            }
        }

        public void caseReturnStmt(ReturnStmt stmt) {
            ValueBox _vBox = stmt.getOpBox();
            if (!_vBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                stmt.setOp(Util.getDefaultValueFor((Type)_vBox.getValue().getType()));
            }
        }

        public void caseTableSwitchStmt(TableSwitchStmt stmt) {
            ValueBox _vBox = stmt.getKeyBox();
            if (!_vBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                stmt.setKey(Util.getDefaultValueFor((Type)_vBox.getValue().getType()));
            }
        }

        public void caseThrowStmt(ThrowStmt stmt) {
            ValueBox _vBox = stmt.getOpBox();
            if (!_vBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                Value _val = stmt.getOp();
                RefType _type = (RefType)_val.getType();
                Jimple _jimple = Jimple.v();
                if (TagBasedDestructiveSliceResidualizer.this.localUseDef == null) {
                    TagBasedDestructiveSliceResidualizer.this.localUseDef = new LocalUseDefAnalysisv2(TagBasedDestructiveSliceResidualizer.this.bbgMgr.getBasicBlockGraph(TagBasedDestructiveSliceResidualizer.this.currMethod));
                }
                Collection _defs = TagBasedDestructiveSliceResidualizer.this.localUseDef.getDefs((Stmt)stmt, TagBasedDestructiveSliceResidualizer.this.currMethod);
                boolean _injectNewCode = true;
                Iterator _j = _defs.iterator();
                int _jEnd = _defs.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd && _injectNewCode) {
                    DefinitionStmt _def = (DefinitionStmt)_j.next();
                    _injectNewCode = !_def.getLeftOpBox().hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize);
                    ++_jIndex;
                }
                if (_injectNewCode) {
                    LocalCreation _lc = new LocalCreation(TagBasedDestructiveSliceResidualizer.this.currMethod.getActiveBody().getLocals());
                    Local _local = _lc.newLocal((Type)_type);
                    TagBasedDestructiveSliceResidualizer.this.localsToKeep.add((Value)_local);
                    NewExpr _newExpr = _jimple.newNewExpr(_type);
                    AssignStmt _astmt = _jimple.newAssignStmt((Value)_local, (Value)_newExpr);
                    NamedTag _tag = new NamedTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize);
                    _astmt.addTag((Tag)_tag);
                    _astmt.getLeftOpBox().addTag((Tag)_tag);
                    _astmt.getRightOpBox().addTag((Tag)_tag);
                    SootClass _clazz = _type.getSootClass();
                    if (!_clazz.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                        TagBasedDestructiveSliceResidualizer.this.classesToKill.remove(_clazz);
                        _clazz.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    }
                    SootMethod _init = this.prepareInitIn(_clazz);
                    ArrayList<Value> _args = new ArrayList<Value>(_init.getParameterCount());
                    int _i = _init.getParameterCount() - 1;
                    while (_i >= 0) {
                        _args.add(Util.getDefaultValueFor((Type)_init.getParameterType(_i)));
                        --_i;
                    }
                    SpecialInvokeExpr _iexpr = _jimple.newSpecialInvokeExpr(_local, _init, _args);
                    InvokeStmt _istmt = _jimple.newInvokeStmt((Value)_iexpr);
                    _istmt.addTag((Tag)_tag);
                    _istmt.getInvokeExprBox().addTag((Tag)_tag);
                    _iexpr.getBaseBox().addTag((Tag)_tag);
                    ArrayList<Object> _stmts = new ArrayList<Object>();
                    _stmts.add(_astmt);
                    _stmts.add(_istmt);
                    TagBasedDestructiveSliceResidualizer.this.stmt2predecessors.put((Stmt)stmt, _stmts);
                    stmt.setOp((Value)_local);
                }
            }
        }

        boolean residualize(Stmt stmt) {
            boolean _result = false;
            if (stmt.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                this.setResult(null);
                stmt.apply((Switch)this);
                Stmt _newStmt = (Stmt)this.getResult();
                if (_newStmt != null) {
                    TagBasedDestructiveSliceResidualizer.this.oldStmt2newStmt.put(stmt, _newStmt);
                }
                _result = true;
            }
            return _result;
        }

        private SootMethod prepareInitIn(SootClass clazz) {
            SootMethod _superinit = null;
            if (clazz.hasSuperclass()) {
                _superinit = this.prepareInitIn(clazz.getSuperclass());
            }
            SootMethod _init = null;
            boolean _existsButIsNotIncluded = false;
            if (clazz.declaresMethod("<init>", Collections.EMPTY_LIST, (Type)VoidType.v())) {
                _init = clazz.getMethod("<init>", Collections.EMPTY_LIST, (Type)VoidType.v());
                boolean bl = _init != null ? !_init.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize) : (_existsButIsNotIncluded = false);
            }
            if (_init == null || _existsButIsNotIncluded) {
                if (_existsButIsNotIncluded) {
                    clazz.removeMethod(_init);
                    Pair _pair = (Pair)MapUtils.getFromMapUsingFactory(TagBasedDestructiveSliceResidualizer.this.class2members, (Object)clazz, PAIR_VALUE_FACTORY);
                    Collection _clazzMethodsToKill = (Collection)_pair.getFirst();
                    _clazzMethodsToKill.remove(_init);
                }
                _init = new SootMethod("<init>", Collections.EMPTY_LIST, (Type)VoidType.v());
                _init.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                Jimple _jimple = Jimple.v();
                JimpleBody _body = _jimple.newBody(_init);
                if (_superinit != null) {
                    RefType _clazzType = RefType.v((SootClass)clazz);
                    LocalCreation _lc = new LocalCreation(_body.getLocals());
                    Local _this = _lc.newLocal("_this", (Type)_clazzType);
                    IdentityStmt _astmt = _jimple.newIdentityStmt((Value)_this, (Value)_jimple.newThisRef(_clazzType));
                    _astmt.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _astmt.getLeftOpBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _astmt.getRightOpBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _body.getUnits().add((Object)_astmt);
                    SpecialInvokeExpr _iexpr = _jimple.newSpecialInvokeExpr(_this, _superinit);
                    InvokeStmt _istmt = _jimple.newInvokeStmt((Value)_iexpr);
                    _istmt.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _istmt.getInvokeExprBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _iexpr.getBaseBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    _body.getUnits().add((Object)_istmt);
                }
                ReturnVoidStmt _retStmt = _jimple.newReturnVoidStmt();
                _retStmt.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                _body.getUnits().add((Object)_retStmt);
                _init.setActiveBody((Body)_body);
                clazz.addMethod(_init);
                if (!clazz.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                    clazz.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                }
            }
            return _init;
        }

        private void residualizeDefStmt(DefinitionStmt stmt) {
            if (!stmt.getLeftOpBox().hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                ValueBox _rightOpBox = stmt.getRightOpBox();
                if (_rightOpBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize) && !stmt.containsInvokeExpr()) {
                    String _message = "Incorrect slice.  How can a def statement and it's non-invoke rhs be marked with the lhs unmarked? ->" + stmt;
                    LOGGER.error(_message);
                    throw new IllegalStateException(_message);
                }
                if (stmt.containsInvokeExpr()) {
                    Value _expr = stmt.getRightOp();
                    InvokeStmt _stmt = Jimple.v().newInvokeStmt(_expr);
                    this.valueProcessor.residualize(stmt.getRightOpBox());
                    this.setResult(_stmt);
                } else {
                    this.setResult(Jimple.v().newNopStmt());
                }
            } else {
                this.valueProcessor.residualize(stmt.getRightOpBox());
            }
        }
    }

    private final class ValueResidualizer
    extends AbstractJimpleValueSwitch {
        private ValueResidualizer() {
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
            this.residualize(v.getBaseBox());
            this.residualizeInvokeExpr((InvokeExpr)v);
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
            this.residualize(v.getBaseBox());
            this.residualizeInvokeExpr((InvokeExpr)v);
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr v) {
            this.residualizeInvokeExpr((InvokeExpr)v);
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
            this.residualize(v.getBaseBox());
            this.residualizeInvokeExpr((InvokeExpr)v);
        }

        public void defaultCase(Object v) {
            Value _v = (Value)v;
            for (ValueBox _vBox : _v.getUseBoxes()) {
                this.residualize(_vBox);
            }
        }

        public void residualize(ValueBox vBox) {
            Value _value = vBox.getValue();
            if (!vBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                vBox.setValue(Util.getDefaultValueFor((Type)_value.getType()));
            } else {
                _value.apply((Switch)this);
            }
        }

        private void residualizeInvokeExpr(InvokeExpr v) {
            int _i = v.getArgCount() - 1;
            while (_i >= 0) {
                ValueBox _vb = v.getArgBox(_i);
                if (!_vb.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                    v.setArg(_i, Util.getDefaultValueFor((Type)_vb.getValue().getType()));
                }
                --_i;
            }
        }
    }
}

