/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IClosure;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.IMutableNode;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.MutableNode;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.ICallingContextRetriever;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.INewExpr2InitMapper;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.BackwardSlicingPart;
import edu.ksu.cis.indus.slicer.CompleteSlicingPart;
import edu.ksu.cis.indus.slicer.DependenceExtractor;
import edu.ksu.cis.indus.slicer.ExprLevelSliceCriterion;
import edu.ksu.cis.indus.slicer.ForwardSlicingPart;
import edu.ksu.cis.indus.slicer.IDirectionSensitivePartOfSlicingEngine;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.MethodLevelSliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.slicer.SliceType;
import edu.ksu.cis.indus.slicer.StmtLevelSliceCriterion;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlicingEngine {
    static final Logger LOGGER = LoggerFactory.getLogger(SlicingEngine.class);
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private BasicBlockGraphMgr bbgMgr;
    private Stack<ICallGraphInfo.CallTriple> callStackCache;
    private SimpleNodeGraph<Object> callStringGraph;
    private ICallGraphInfo cgi;
    private SliceCollector collector;
    private Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> controlflowBasedDAs = new ArrayList();
    private AnalysesController controller;
    private List<ISliceCriterion> criteria = new ArrayList<ISliceCriterion>();
    private final DependenceExtractor dependenceExtractor = new DependenceExtractor(this);
    private IDirectionSensitivePartOfSlicingEngine directionSensitiveInfo;
    private INewExpr2InitMapper initMapper;
    private IPredicate<SootMethod> nonStartMethodPredicate = new NonStartMethodPredicate();
    private SpecificationBasedScopeDefinition sliceScope;
    private SliceType sliceType = SliceType.BACKWARD_SLICE;
    private IEnvironment system;
    private boolean useInterferenceDACache;
    private final IWorkBag<ISliceCriterion> workbag = new FIFOWorkBag();

    public SlicingEngine() {
        this.collector = new SliceCollector(this);
        this.callStringGraph = new SimpleNodeGraph();
        this.callStringGraph.getNode(null);
    }

    public void enterMethod(ICallGraphInfo.CallTriple callsite) {
        if (callsite != null) {
            if (this.callStackCache == null) {
                this.callStackCache = new Stack();
            }
            this.callStackCache.push((Object)callsite);
        }
    }

    public IActivePart getActivePart() {
        return this.activePart;
    }

    public SliceCollector getCollector() {
        return this.collector;
    }

    public IEnvironment getSystem() {
        return this.system;
    }

    public boolean ifInsideContext() {
        return this.callStackCache != null && !this.callStackCache.isEmpty();
    }

    public void initialize() {
        if (this.collector.getTagName() == null) {
            LOGGER.error("Please set the tag name before executing the engine.");
            throw new IllegalStateException("Please set the tag name before executing the engine.");
        }
        this.useInterferenceDACache = this.controller.getAnalyses((Comparable)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA) != null;
    }

    public void reset() {
        this.cgi = null;
        this.collector.reset();
        this.callStackCache = null;
        this.criteria.clear();
        this.activePart.activate();
        this.callStringGraph = new SimpleNodeGraph();
        this.callStringGraph.getNode(null);
        if (this.directionSensitiveInfo != null) {
            this.directionSensitiveInfo.reset();
        }
        this.workbag.clear();
    }

    public ICallGraphInfo.CallTriple returnFromMethod() {
        ICallGraphInfo.CallTriple _result = null;
        if (this.callStackCache != null && this.ifInsideContext()) {
            _result = (ICallGraphInfo.CallTriple)this.callStackCache.pop();
        }
        return _result;
    }

    public void setAnalysesControllerAndDependenciesToUse(AnalysesController ctrl, Collection<IDependencyAnalysis.DependenceSort> dependenciesToUse) {
        this.controller = ctrl;
        this.controlflowBasedDAs.clear();
        for (IDependencyAnalysis.DependenceSort _id : dependenciesToUse) {
            if (!_id.equals((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA) && !_id.equals((Object)IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA) && !_id.equals((Object)IDependencyAnalysis.DependenceSort.DIVERGENCE_DA) && !_id.equals((Object)IDependencyAnalysis.DependenceSort.READY_DA)) continue;
            this.controlflowBasedDAs.addAll(this.controller.getAnalyses((Comparable)_id));
        }
    }

    public void setBasicBlockGraphManager(BasicBlockGraphMgr basicBlockGraphMgr) {
        this.bbgMgr = basicBlockGraphMgr;
    }

    public void setCgi(ICallGraphInfo callgraph) {
        this.cgi = callgraph;
    }

    public void setDepID2ContextRetrieverMapping(Map<IDependencyAnalysis.DependenceSort, ICallingContextRetriever> map) {
        this.dependenceExtractor.setDepID2ContextRetrieverMapping(map);
    }

    public void setInitMapper(INewExpr2InitMapper mapper) {
        this.initMapper = mapper;
    }

    public void setSliceCriteria(Collection<ISliceCriterion> sliceCriteria) {
        if (sliceCriteria == null || sliceCriteria.size() == 0) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Slice criteria is unspecified.");
            }
            throw new IllegalStateException("Slice criteria is unspecified.");
        }
        if (this.controller == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Class Manager and/or Controller is unspecified.");
            }
            throw new IllegalStateException("Class Manager and/or Controller is unspecified.");
        }
        SliceCriteriaFactory _criteriaFactory = SliceCriteriaFactory.getFactory();
        for (ISliceCriterion _o : sliceCriteria) {
            if (!SliceCriteriaFactory.isSlicingCriterion(_o)) {
                LOGGER.error("The work piece is not a valid slice criterion." + _o);
                throw new IllegalStateException("The work piece is not a valid slice criterion." + _o);
            }
            this.criteria.add(_criteriaFactory.clone(_o));
        }
        if (LOGGER.isDebugEnabled()) {
            Collections.sort(this.criteria, ToStringBasedComparator.getComparator());
            StringBuffer _sb = new StringBuffer();
            Iterator<ISliceCriterion> _i = this.criteria.iterator();
            while (_i.hasNext()) {
                _sb.append("\n\t");
                _sb.append(_i.next());
            }
            LOGGER.debug("Criteria:\n" + _sb.toString());
            LOGGER.debug("END: Populating deadlock criteria.");
        }
    }

    public void setSliceScopeDefinition(SpecificationBasedScopeDefinition scope) {
        this.sliceScope = scope;
    }

    public void setSliceType(SliceType theSliceType) {
        this.sliceType = theSliceType;
        if (theSliceType.equals((Object)SliceType.BACKWARD_SLICE)) {
            this.directionSensitiveInfo = new BackwardSlicingPart(this);
        } else if (theSliceType.equals((Object)SliceType.FORWARD_SLICE)) {
            this.directionSensitiveInfo = new ForwardSlicingPart(this);
        } else if (theSliceType.equals((Object)SliceType.COMPLETE_SLICE)) {
            this.directionSensitiveInfo = new CompleteSlicingPart(this);
        }
        this.dependenceExtractor.setDependenceRetriever(this.directionSensitiveInfo);
    }

    public void setSystem(IEnvironment theSystem) {
        this.system = theSystem;
    }

    public void setTagName(String tagName) {
        this.collector.setTagName(tagName);
    }

    /*
     * Unable to fully structure code
     */
    public void slice() {
        this.workbag.addAllWorkNoDuplicates(this.criteria);
        _flag = true;
        ** GOTO lbl34
        {
            _work = this.workbag.getWork();
            if (SlicingEngine.LOGGER.isDebugEnabled()) {
                SlicingEngine.LOGGER.debug("BEGIN - Processing criterion - " + _work);
            }
            if (_work instanceof ExprLevelSliceCriterion) {
                _sliceExpr = (ExprLevelSliceCriterion)_work;
                _sm = _sliceExpr.getOccurringMethod();
                if (this.sliceScope == null || this.sliceScope.isInScope(_sm, this.system)) {
                    this.callStackCache = _sliceExpr.getCallStack();
                    this.transformAndGenerateNewCriteriaForExpr(_sliceExpr);
                }
            } else if (_work instanceof StmtLevelSliceCriterion) {
                _sliceStmt = (StmtLevelSliceCriterion)_work;
                _sm = _sliceStmt.getOccurringMethod();
                if (this.sliceScope == null || this.sliceScope.isInScope(_sm, this.system)) {
                    _stmt = (Stmt)_sliceStmt.getCriterion();
                    this.callStackCache = _sliceStmt.getCallStack();
                    this.transformAndGenerateNewCriteriaForStmt(_stmt, _sm, _sliceStmt.isConsiderExecution());
                }
            } else if (_work instanceof MethodLevelSliceCriterion) {
                _sliceMethod = (MethodLevelSliceCriterion)_work;
                _sm = _sliceMethod.getOccurringMethod();
                if (this.sliceScope == null || this.sliceScope.isInScope(_sm, this.system)) {
                    this.callStackCache = _sliceMethod.getCallStack();
                    this.transformAndGenerateNewCriteriaForMethod(_sm);
                }
            }
            if (SlicingEngine.LOGGER.isDebugEnabled()) {
                SlicingEngine.LOGGER.debug("END - Processing criterion - " + _work);
            }
            do {
                if (this.workbag.hasWork() && this.activePart.canProceed()) continue block0;
                _flag = this.directionSensitiveInfo.continueProcessing();
lbl34:
                // 2 sources

            } while (_flag && this.activePart.canProceed());
        }
        if (this.activePart.canProceed()) {
            this.collector.completeSlicing();
        }
    }

    void generateCriteriaForTheCallToMethod(SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Generating criteria for call-sites (callee-caller) " + method);
        }
        if (this.isNotIncludedInSlice((Host)method)) {
            this.includeMethodAndDeclaringClassInSlice(method);
        }
        if (!this.haveCollectedAllInvocationSites(method)) {
            if (this.ifInsideContext()) {
                if (this.callStackCache.peek() != null) {
                    ICallGraphInfo.CallTriple _top = (ICallGraphInfo.CallTriple)this.callStackCache.pop();
                    SootMethod _caller = _top.getMethod();
                    Stmt _stmt = _top.getStmt();
                    this.directionSensitiveInfo.generateCriteriaForTheCallToMethod(method, _caller, _stmt);
                    this.callStackCache.push((Object)_top);
                }
            } else {
                this.markAsCollectedAllInvocationSites(method);
                for (ICallGraphInfo.CallTriple _ctrp : this.cgi.getCallers(method)) {
                    SootMethod _caller = _ctrp.getMethod();
                    Stmt _stmt = _ctrp.getStmt();
                    this.directionSensitiveInfo.generateCriteriaForTheCallToMethod(method, _caller, _stmt);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Generating criteria for call-sites (callee-caller)");
        }
    }

    boolean generateExprLevelSliceCriterion(ValueBox valueBox, Stmt stmt, SootMethod method, boolean considerExecution) {
        boolean _result;
        if (this.isNotIncludedInSlice((Host)valueBox)) {
            Collection<ISliceCriterion> _sliceCriteria = SliceCriteriaFactory.getFactory().getCriteria(method, stmt, valueBox, considerExecution);
            this.setContext(_sliceCriteria);
            this.workbag.addAllWorkNoDuplicates(_sliceCriteria);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding expr [" + considerExecution + "] " + valueBox.getValue() + " at " + stmt + " in " + method.getSignature() + " @ " + this.callStackCache + " to workbag.");
            }
            _result = true;
        } else {
            if (valueBox.getValue() instanceof InvokeExpr) {
                this.generateCriteriaForInvokeExprIn(stmt, method);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Already collected expr " + valueBox.getValue() + " occurring at " + stmt + " in " + method.getSignature());
            }
            _result = false;
        }
        return _result;
    }

    boolean generateExprLevelSliceCriterion(ValueBox valueBox, Stmt stmt, SootMethod method, boolean considerExecution, Stack<ICallGraphInfo.CallTriple> callStack) {
        Stack<ICallGraphInfo.CallTriple> _stack = this.callStackCache;
        this.callStackCache = callStack;
        boolean _result = this.generateExprLevelSliceCriterion(valueBox, stmt, method, considerExecution);
        this.callStackCache = _stack;
        return _result;
    }

    boolean generateStmtLevelSliceCriterion(Stmt stmt, SootMethod method, boolean considerExecution) {
        boolean _result = this.isNotIncludedInSlice((Host)stmt);
        if (_result) {
            Collection<ISliceCriterion> _sliceCriteria = SliceCriteriaFactory.getFactory().getCriteria(method, stmt, considerExecution);
            this.setContext(_sliceCriteria);
            this.workbag.addAllWorkNoDuplicates(_sliceCriteria);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding [" + considerExecution + "] " + stmt + " in " + method.getSignature() + " @ " + this.callStackCache + " to workbag.");
            }
        } else {
            if (this.sliceType.equals((Object)SliceType.COMPLETE_SLICE) || considerExecution && this.sliceType.equals((Object)SliceType.BACKWARD_SLICE) || !considerExecution && this.sliceType.equals((Object)SliceType.FORWARD_SLICE)) {
                HashSet<ValueBox> _temp = new HashSet<ValueBox>(stmt.getUseAndDefBoxes());
                if (stmt.containsInvokeExpr()) {
                    InvokeExpr _invokeExpr = stmt.getInvokeExpr();
                    _temp.removeAll(_invokeExpr.getUseBoxes());
                    if (_invokeExpr instanceof InstanceInvokeExpr) {
                        _temp.add(((InstanceInvokeExpr)_invokeExpr).getBaseBox());
                    }
                }
                for (ValueBox _valueBox : _temp) {
                    this.generateExprLevelSliceCriterion(_valueBox, stmt, method, considerExecution);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Already collected stmt " + stmt + " in " + method.getSignature());
            }
        }
        return _result;
    }

    BasicBlockGraphMgr getBasicBlockGraphManager() {
        return this.bbgMgr;
    }

    ICallGraphInfo getCgi() {
        return this.cgi;
    }

    Stack<ICallGraphInfo.CallTriple> getCopyOfCallStackCache() {
        Stack _result = this.callStackCache != null ? this.callStackCache.clone() : null;
        return _result;
    }

    INewExpr2InitMapper getInitMapper() {
        return this.initMapper;
    }

    void includeInSlice(Host host) {
        this.collector.includeInSlice(host);
    }

    void includeMethodAndDeclaringClassInSlice(SootMethod method) {
        this.includeInSlice((Host)method);
        SootClass _sc = method.getDeclaringClass();
        this.includeInSlice((Host)_sc);
        HashSet<Type> _types = new HashSet<Type>(method.getParameterTypes());
        _types.add(method.getReturnType());
        this.includeTypesInSlice(_types);
        List _exceptions = method.getExceptions();
        Iterator _i = _exceptions.iterator();
        int _iEnd = _exceptions.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _exception = (SootClass)_i.next();
            this.includeInSlice((Host)_exception);
            ++_iIndex;
        }
    }

    private void generateCriteriaBasedOnStmtLevelDependences(Stmt stmt, SootMethod method, Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> das) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaBasedOnDependences(Stmt stmt=" + stmt + ", SootMethod method=" + method + ", Collection das) - BEGIN");
        }
        this.dependenceExtractor.setTrigger(stmt, method, this.getCopyOfCallStackCache());
        CollectionUtils.forAllDo(das, (IClosure)this.dependenceExtractor);
        for (Object _o : this.dependenceExtractor.getDependences()) {
            SootMethod _methodToBeIncluded;
            Stmt _stmtToBeIncluded;
            Collection<Stack<ICallGraphInfo.CallTriple>> _contexts = this.dependenceExtractor.getContextsFor(_o);
            if (_o instanceof Pair) {
                Pair _pair = (Pair)_o;
                _stmtToBeIncluded = (Stmt)_pair.getFirst();
                _methodToBeIncluded = (SootMethod)_pair.getSecond();
            } else {
                _stmtToBeIncluded = (Stmt)_o;
                _methodToBeIncluded = method;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("generateCriteriaBasedOnDependences(Stmt, SootMethod, Collection) -  : _contexts=" + _contexts + ", _stmtToBeIncluded=" + _stmtToBeIncluded + ", _methodToBeIncluded=" + _methodToBeIncluded);
            }
            Stack<ICallGraphInfo.CallTriple> _temp = this.getCopyOfCallStackCache();
            Iterator<Stack<ICallGraphInfo.CallTriple>> _i1 = _contexts.iterator();
            int _iEnd = _contexts.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Stack<ICallGraphInfo.CallTriple> _context = _i1.next();
                this.setCallStackCache(_context);
                if (_stmtToBeIncluded != null) {
                    boolean _b = this.generateStmtLevelSliceCriterion(_stmtToBeIncluded, _methodToBeIncluded, !this.sliceType.equals((Object)SliceType.FORWARD_SLICE));
                    if (!_b) {
                        this.generateMethodLevelSliceCriteria(_methodToBeIncluded);
                    }
                } else {
                    this.generateMethodLevelSliceCriteria(_methodToBeIncluded);
                }
                ++_iIndex;
            }
            this.setCallStackCache(_temp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaBasedOnDependences(Stmt, SootMethod, Collection) - END");
        }
    }

    private void generateCriteriaForInvokeExprIn(Stmt stmt, SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Generating criteria for invocation expressions (caller-callee)");
        }
        InvokeExpr _expr = stmt.getInvokeExpr();
        SootMethod _sm = _expr.getMethod();
        HashSet<SootMethod> _callees = new HashSet<SootMethod>();
        if (_sm.isStatic()) {
            _callees.add(_sm);
        } else {
            Context _context = new Context();
            _context.setRootMethod(method);
            _context.setStmt(stmt);
            _callees.addAll(this.cgi.getCallees(_expr, _context));
        }
        CollectionUtils.filter(_callees, this.nonStartMethodPredicate);
        this.directionSensitiveInfo.generateCriteriaToIncludeCallees(stmt, method, _callees);
        this.includeMethodAndDeclaringClassInSlice(_sm);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Generating criteria for invocation expressions (caller-callee)");
        }
    }

    private void generateCriteriaForLocals(Collection<ValueBox> locals, Stmt stmt, SootMethod method) {
        Collection _analyses;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForLocals(Collection locals = " + locals + ", Stmt stmt = " + stmt + ", SootMethod method = " + method + ", stack =" + this.callStackCache + ") - BEGIN");
        }
        if ((_analyses = this.controller.getAnalyses((Comparable)IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA)).size() > 0) {
            Iterator<ValueBox> _k = locals.iterator();
            int _kEnd = locals.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                Local _local = (Local)_k.next().getValue();
                this.dependenceExtractor.setTrigger(this.dependenceExtractor.getEntityForIdentifierBasedDataDA(_local, stmt), method, this.getCopyOfCallStackCache());
                CollectionUtils.forAllDo((Collection)_analyses, (IClosure)this.dependenceExtractor);
                Collection<?> _dependences = this.dependenceExtractor.getDependences();
                Iterator<?> _l = _dependences.iterator();
                int _lEnd = _dependences.size();
                int _lIndex = 0;
                while (_lIndex < _lEnd) {
                    Local _depLocal;
                    Stmt _depStmt;
                    Object _o = _l.next();
                    if (_o instanceof Stmt) {
                        _depStmt = (Stmt)_o;
                        _depLocal = _local;
                    } else if (_o instanceof Pair) {
                        Pair _p = (Pair)_o;
                        _depLocal = (Local)_p.getFirst();
                        _depStmt = (Stmt)_p.getSecond();
                    } else {
                        throw new IllegalStateException("Identifier-based Data DA returned result of type - " + _o.getClass());
                    }
                    this.directionSensitiveInfo.processLocalAt(_depLocal, _depStmt, method);
                    ++_lIndex;
                }
                this.directionSensitiveInfo.processLocalAt(_local, stmt, method);
                ++_kIndex;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForLocals() , stack =" + this.callStackCache + "- END");
        }
    }

    private void generateMethodLevelSliceCriteria(SootMethod method) {
        boolean _generateCriteria = this.shouldMethodLevelCriteriaBeGenerated(method);
        if (_generateCriteria) {
            Collection<ISliceCriterion> _sliceCriteria = SliceCriteriaFactory.getFactory().getCriteria(method);
            this.setContext(_sliceCriteria);
            Collection _c = this.workbag.addAllWorkNoDuplicates(_sliceCriteria);
            if (LOGGER.isDebugEnabled() && !_c.isEmpty()) {
                LOGGER.debug("Adding " + method.getSignature() + " @ " + this.callStackCache + " to workbag.");
            }
        }
    }

    @Functional
    boolean haveCollectedAllInvocationSites(@NonNull SootMethod method) {
        return this.callStringGraph.queryNode((Object)method) != null && this.callStringGraph.queryNode((Object)method).getSuccsOf().isEmpty();
    }

    void includeTypesInSlice(@NonNull @NonNullContainer Collection<Type> types) {
        for (Type _type : types) {
            if (_type instanceof RefType) {
                this.includeInSlice((Host)((RefType)_type).getSootClass());
                continue;
            }
            if (!(_type instanceof ArrayType) || !(((ArrayType)_type).baseType instanceof RefType)) continue;
            this.includeInSlice((Host)((RefType)((ArrayType)_type).baseType).getSootClass());
        }
    }

    private boolean isNotIncludedInSlice(Host host) {
        return !this.collector.hasBeenCollected(host);
    }

    void markAsCollectedAllInvocationSites(@NonNull SootMethod method) {
        SimpleNode _n = this.callStringGraph.getNode((Object)method);
        Iterator _i = new ArrayList(_n.getSuccsOf()).iterator();
        while (_i.hasNext()) {
            _n.removeSuccessor((MutableNode)((SimpleNode)_i.next()));
        }
    }

    boolean recordCallStackForMethod(@NonNull SootMethod method) {
        boolean _result = true;
        SimpleNode _methodNode = this.callStringGraph.getNode((Object)method);
        if (this.callStringGraph.queryNode((Object)method) == null) {
            Object _s;
            if (!this.callStackCache.isEmpty() && (_s = this.callStackCache.peek()) != null) {
                this.callStringGraph.addEdgeFromTo((IMutableNode)_methodNode, (IMutableNode)this.callStringGraph.getNode(_s));
                int _i = this.callStackCache.size() - 2;
                while (_i >= 0) {
                    Object _t = this.callStackCache.get(_i);
                    if (_t != null) {
                        this.callStringGraph.addEdgeFromTo((IMutableNode)this.callStringGraph.queryNode(_s), (IMutableNode)this.callStringGraph.getNode(_t));
                        _s = _t;
                        --_i;
                        continue;
                    }
                    break;
                }
            }
        } else if (!this.callStackCache.isEmpty()) {
            _result = this.recordCallStackForVisitedMethod((SimpleNode<Object>)_methodNode);
        }
        return _result;
    }

    private boolean recordCallStackForVisitedMethod(SimpleNode<Object> methodNode) {
        int _limit = this.callStackCache.size() - 1;
        boolean _considerCallStack = this.callStackCache.peek() != null;
        boolean _createdNewNodes = false;
        int _i = _limit;
        while (_i >= 0 && _considerCallStack) {
            SimpleNode _prev;
            Object _o = this.callStackCache.get(_i);
            SimpleNode _node = this.callStringGraph.queryNode(_o);
            if (_node == null) {
                _node = this.callStringGraph.getNode(_o);
                _createdNewNodes = true;
            } else if (_o != null) {
                if (_node.getSuccsOf().isEmpty()) {
                    _considerCallStack = false;
                } else if (_i == 0) {
                    Collection _reachablesFrom = this.callStringGraph.getReachablesFrom((INode)_node, true);
                    _reachablesFrom.add(_node);
                    Iterator _j = _reachablesFrom.iterator();
                    int _jEnd = _reachablesFrom.size();
                    int _jIndex = 0;
                    while (_jIndex < _jEnd) {
                        SimpleNode _src = (SimpleNode)_j.next();
                        ArrayList _succsOfSrc = new ArrayList(_src.getSuccsOf());
                        Iterator _k = _succsOfSrc.iterator();
                        int _kEnd = _succsOfSrc.size();
                        int _kIndex = 0;
                        while (_kIndex < _kEnd) {
                            SimpleNode _dest = (SimpleNode)_k.next();
                            this.callStringGraph.removeEdgeFromTo((IMutableNode)_src, (IMutableNode)_dest);
                            ++_kIndex;
                        }
                        ++_jIndex;
                    }
                    _considerCallStack = false;
                }
            } else {
                _considerCallStack = false;
            }
            if (_limit - _i > 0 && (_considerCallStack || _createdNewNodes) && (_prev = this.callStringGraph.queryNode(this.callStackCache.get(_i + 1))) != null) {
                this.callStringGraph.addEdgeFromTo((IMutableNode)_prev, (IMutableNode)_node);
            }
            --_i;
        }
        this.callStringGraph.addEdgeFromTo(methodNode, (IMutableNode)this.callStringGraph.getNode(this.callStackCache.peek()));
        return _considerCallStack || _createdNewNodes;
    }

    private void setCallStackCache(Stack<ICallGraphInfo.CallTriple> callStack) {
        this.callStackCache = callStack;
    }

    private void setContext(Collection<ISliceCriterion> theCriteria) {
        if (this.callStackCache != null) {
            Iterator<ISliceCriterion> _i = theCriteria.iterator();
            int _iEnd = theCriteria.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                ISliceCriterion _criterion = _i.next();
                _criterion.setCallStack((Stack<ICallGraphInfo.CallTriple>)this.callStackCache.clone());
                ++_iIndex;
            }
        }
    }

    private boolean shouldMethodLevelCriteriaBeGenerated(SootMethod method) {
        boolean _result = this.isNotIncludedInSlice((Host)method);
        if (!_result) {
            if (this.callStackCache == null) {
                _result = !this.haveCollectedAllInvocationSites(method);
            } else if (!this.haveCollectedAllInvocationSites(method)) {
                _result = this.recordCallStackForMethod(method);
            }
        }
        return _result;
    }

    private void transformAndGenerateNewCriteriaForExpr(ExprLevelSliceCriterion expr) {
        Stmt _stmt = expr.getOccurringStmt();
        SootMethod _method = expr.getOccurringMethod();
        ValueBox _vBox = (ValueBox)expr.getCriterion();
        boolean _considerExecution = expr.isConsiderExecution();
        Value _value = _vBox.getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Transforming expr criteria: " + _value + "[" + _considerExecution + "] at " + _stmt + " in " + _method + "   " + this.callStackCache);
        }
        if (this.sliceType.equals((Object)SliceType.FORWARD_SLICE)) {
            this.transformAndGenerateNewCriteriaForStmt(_stmt, _method, true);
        } else {
            this.transformAndGenerateNewCriteriaForStmt(_stmt, _method, false);
        }
        if (this.sliceType.equals((Object)SliceType.COMPLETE_SLICE) || _considerExecution && this.sliceType.equals((Object)SliceType.BACKWARD_SLICE) || !_considerExecution && this.sliceType.equals((Object)SliceType.FORWARD_SLICE)) {
            Collection<ValueBox> _valueBoxes = this.directionSensitiveInfo.retrieveValueBoxesToTransformExpr(_vBox, _stmt);
            this.transformAndGenerateToConsiderExecution(_stmt, _method, _valueBoxes);
            if (_value instanceof InvokeExpr) {
                this.generateCriteriaForInvokeExprIn(_stmt, _method);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Transforming expr criteria: " + _value + " at " + _stmt + " in " + _method);
        }
    }

    private void transformAndGenerateNewCriteriaForMethod(SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("transformAndGenerateNewCriteriaForMethod(SootMethod method = " + method + ") - BEGIN");
        }
        this.generateCriteriaForTheCallToMethod(method);
        this.generateCriteriaBasedOnStmtLevelDependences(null, method, this.controlflowBasedDAs);
        if (this.callStackCache == null) {
            this.markAsCollectedAllInvocationSites(method);
        } else {
            this.recordCallStackForMethod(method);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("transformAndGenerateNewCriteriaForMethod() - END");
        }
    }

    private void transformAndGenerateNewCriteriaForStmt(Stmt stmt, SootMethod method, boolean considerExecution) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Transforming stmt criteria: " + stmt + "[" + considerExecution + "] in " + method + "   " + this.callStackCache);
        }
        if (this.sliceType.equals((Object)SliceType.COMPLETE_SLICE) || considerExecution && this.sliceType.equals((Object)SliceType.BACKWARD_SLICE) || !considerExecution && this.sliceType.equals((Object)SliceType.FORWARD_SLICE)) {
            this.directionSensitiveInfo.processNewExpr(stmt, method);
            Collection<ValueBox> _valueBoxes = this.directionSensitiveInfo.retrieveValueBoxesToTransformStmt(stmt);
            this.transformAndGenerateToConsiderExecution(stmt, method, _valueBoxes);
            if (stmt.containsInvokeExpr()) {
                this.generateCriteriaForInvokeExprIn(stmt, method);
            }
        }
        if (this.isNotIncludedInSlice((Host)stmt)) {
            this.generateCriteriaBasedOnStmtLevelDependences(stmt, method, this.controlflowBasedDAs);
        }
        this.generateCriteriaForTheCallToMethod(method);
        this.includeInSlice((Host)stmt);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Transforming stmt criteria: " + stmt + "[" + considerExecution + "] in " + method);
        }
    }

    private void transformAndGenerateToConsiderExecution(Stmt stmt, SootMethod method, Collection<ValueBox> vBoxes) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer _sb = new StringBuffer();
            _sb.append("BEGIN: Transforming value boxes [");
            for (ValueBox _vBox : vBoxes) {
                _sb.append(_vBox.getValue());
                _sb.append("[" + _vBox + "]");
                _sb.append(", ");
            }
            _sb.append("]");
            LOGGER.debug(_sb.toString());
        }
        HashSet<Type> _types = new HashSet<Type>();
        ArrayList _das = new ArrayList();
        HashSet<ValueBox> _locals = new HashSet<ValueBox>();
        for (ValueBox _vBox : vBoxes) {
            if (!this.isNotIncludedInSlice((Host)_vBox)) continue;
            this.includeInSlice((Host)_vBox);
            Value _value = _vBox.getValue();
            if (_value instanceof ParameterRef) {
                this.directionSensitiveInfo.processParameterRef((IdentityStmt)stmt, method);
            } else if (_value instanceof FieldRef || _value instanceof ArrayRef) {
                _das.addAll(this.controller.getAnalyses((Comparable)IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA));
                if (this.useInterferenceDACache) {
                    _das.addAll(this.controller.getAnalyses((Comparable)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA));
                }
                if (_value instanceof FieldRef) {
                    SootField _field = ((FieldRef)_vBox.getValue()).getField();
                    this.includeInSlice((Host)_field);
                    this.includeInSlice((Host)_field.getDeclaringClass());
                }
            } else if (_value instanceof Local) {
                _locals.add(_vBox);
            }
            _types.add(_value.getType());
        }
        this.includeTypesInSlice(_types);
        if (!_das.isEmpty()) {
            this.generateCriteriaBasedOnStmtLevelDependences(stmt, method, _das);
        }
        this.generateCriteriaForLocals(_locals, stmt, method);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Transforming value boxes");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonStartMethodPredicate
    implements IPredicate<SootMethod> {
        @Empty
        NonStartMethodPredicate() {
        }

        public <T1 extends SootMethod> boolean evaluate(T1 object) {
            return !Util.isStartMethod(object);
        }
    }
}

