/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.slicer.SliceCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SliceGotoProcessor {
    public static final IPredicate<Stmt> GOTO_STMT_PREDICATE = new InstanceOfPredicate(GotoStmt.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SliceGotoProcessor.class);
    protected final SliceCollector sliceCollector;
    protected SootMethod method;

    public SliceGotoProcessor(SliceCollector collector) {
        this.sliceCollector = collector;
    }

    public void process(Collection<SootMethod> methods, BasicBlockGraphMgr bbgMgr) {
        for (SootMethod _sm : methods) {
            BasicBlockGraph _bbg = bbgMgr.getBasicBlockGraph(_sm);
            if (_bbg == null) continue;
            this.process(_sm, _bbg);
        }
    }

    private void process(SootMethod theMethod, BasicBlockGraph bbg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("process(SootMethod theMethod = " + theMethod + ") - BEGIN");
        }
        this.method = theMethod;
        Collection<BasicBlockGraph.BasicBlock> _bbInSlice = this.processForIntraBasicBlockGotos(bbg);
        if (this.methodBodyContainsNonTrivialSlice(_bbInSlice)) {
            SimpleNodeGraph _dag = bbg.getDAG();
            ArrayList<SimpleNode> _bbInSliceInDAG = new ArrayList<SimpleNode>();
            Iterator<BasicBlockGraph.BasicBlock> _i = _bbInSlice.iterator();
            int _iEnd = _bbInSlice.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                BasicBlockGraph.BasicBlock _bb = _i.next();
                _bbInSliceInDAG.add(_dag.queryNode((Object)_bb));
                ++_iIndex;
            }
            Collection _bbToBeIncludedInSlice = _dag.getNodesOnPathBetween(_bbInSliceInDAG);
            Collection _backedges = bbg.getBackEdges();
            Iterator _k = _backedges.iterator();
            int _kEnd = _backedges.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                Pair _edge = (Pair)_k.next();
                _bbInSliceInDAG.clear();
                _bbInSliceInDAG.add(_dag.queryNode((Object)((BasicBlockGraph.BasicBlock)_edge.getFirst())));
                _bbInSliceInDAG.add(_dag.queryNode((Object)((BasicBlockGraph.BasicBlock)_edge.getSecond())));
                Collection _nodes = _dag.getNodesOnPathBetween(_bbInSliceInDAG);
                if (CollectionUtils.containsAny((Collection)_nodes, _bbInSlice) || CollectionUtils.containsAny((Collection)_nodes, (Collection)_bbToBeIncludedInSlice)) {
                    _bbToBeIncludedInSlice.addAll(_nodes);
                }
                ++_kIndex;
            }
            Collection _t = CollectionUtils.collect((Collection)_bbToBeIncludedInSlice, (ITransformer)_dag.getObjectExtractor());
            Iterator _j = _t.iterator();
            int _jEnd = _t.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_j.next();
                _bbInSlice.add(_bb);
                ArrayList _stmtsOf = new ArrayList(_bb.getStmtsOf());
                CollectionUtils.filter(_stmtsOf, GOTO_STMT_PREDICATE);
                this.sliceCollector.includeInSlice(_stmtsOf);
                ++_jIndex;
            }
            ArrayList _stmtList = new ArrayList(bbg.getStmtGraph().getBody().getUnits());
            for (BasicBlockGraph.BasicBlock _bb : _bbInSlice) {
                Stmt _prev;
                Stmt _leader = _bb.getLeaderStmt();
                int _i1 = _stmtList.indexOf(_leader) - 1;
                if (_i1 < 0 || !((_prev = (Stmt)_stmtList.get(_i1)) instanceof ThrowStmt) && !(_prev instanceof ReturnStmt) && !(_prev instanceof ReturnVoidStmt)) continue;
                this.sliceCollector.includeInSlice((Host)_prev);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("process() - END");
        }
    }

    boolean methodBodyContainsNonTrivialSlice(@NonNull @NonNullContainer Collection<BasicBlockGraph.BasicBlock> bbInSlice) {
        boolean _result = false;
        block0: for (BasicBlockGraph.BasicBlock _block : bbInSlice) {
            for (Stmt _s : _block.getStmtsOf()) {
                if (!this.sliceCollector.hasBeenCollected((Host)_s) || _s instanceof IdentityStmt || _s instanceof ReturnStmt || _s instanceof ReturnVoidStmt || _s instanceof ThrowStmt) continue;
                _result = true;
                continue block0;
            }
        }
        return _result;
    }

    void processForIntraBasicBlockGotos(@NonNull BasicBlockGraph.BasicBlock bb, @NonNull @NonNullContainer Collection<BasicBlockGraph.BasicBlock> bbInSlice) {
        for (Stmt _stmt : bb.getStmtsOf()) {
            if (!this.sliceCollector.hasBeenCollected((Host)_stmt)) continue;
            bbInSlice.add(bb);
            ArrayList _stmtsOf = new ArrayList(bb.getStmtsOf());
            CollectionUtils.filter(_stmtsOf, GOTO_STMT_PREDICATE);
            this.sliceCollector.includeInSlice(_stmtsOf);
            break;
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> processForIntraBasicBlockGotos(BasicBlockGraph bbg) {
        HashSet<BasicBlockGraph.BasicBlock> _result = new HashSet<BasicBlockGraph.BasicBlock>();
        for (BasicBlockGraph.BasicBlock _bb : bbg.getNodes()) {
            this.processForIntraBasicBlockGotos(_bb, _result);
        }
        return _result;
    }
}

