/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.slicer.AbstractSliceCriterion;
import edu.ksu.cis.indus.slicer.ExprLevelSliceCriterion;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.MethodLevelSliceCriterion;
import edu.ksu.cis.indus.slicer.StmtLevelSliceCriterion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import soot.Local;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SliceCriteriaFactory {
    private static final SliceCriteriaFactory SINGLETON = new SliceCriteriaFactory();

    @Empty
    private SliceCriteriaFactory() {
    }

    public static SliceCriteriaFactory getFactory() {
        return SINGLETON;
    }

    public static boolean isSlicingCriterion(Object o) {
        boolean _result = false;
        if (o != null) {
            _result = o instanceof ISliceCriterion;
        }
        return _result;
    }

    public ISliceCriterion clone(ISliceCriterion criterion) {
        AbstractSliceCriterion _result;
        if (criterion instanceof StmtLevelSliceCriterion) {
            StmtLevelSliceCriterion _t = (StmtLevelSliceCriterion)criterion;
            _result = this.getStmtCriteria(_t.getOccurringMethod(), (Stmt)_t.getCriterion(), _t.isConsiderExecution());
            Stack<ICallGraphInfo.CallTriple> _callStack = _t.getCallStack();
            if (_callStack != null) {
                _result.setCallStack((Stack<ICallGraphInfo.CallTriple>)_callStack.clone());
            }
        } else if (criterion instanceof ExprLevelSliceCriterion) {
            ExprLevelSliceCriterion _t = (ExprLevelSliceCriterion)criterion;
            _result = this.getExprCriteria(_t.getOccurringMethod(), _t.getOccurringStmt(), (ValueBox)_t.getCriterion(), _t.isConsiderExecution());
            Stack<ICallGraphInfo.CallTriple> _callStack = _t.getCallStack();
            if (_callStack != null) {
                _result.setCallStack((Stack<ICallGraphInfo.CallTriple>)_callStack.clone());
            }
        } else if (criterion instanceof MethodLevelSliceCriterion) {
            MethodLevelSliceCriterion _m = (MethodLevelSliceCriterion)criterion;
            _result = this.getMethodCriteria(_m.getOccurringMethod(), _m.isConsiderExecution());
            Stack<ICallGraphInfo.CallTriple> _callStack = _m.getCallStack();
            if (_callStack != null) {
                _result.setCallStack((Stack<ICallGraphInfo.CallTriple>)_callStack.clone());
            }
        } else {
            throw new IllegalArgumentException("criterion's type " + criterion.getClass() + " is unknown.");
        }
        return _result;
    }

    public Collection<ISliceCriterion> getCriteria(Local local, Collection<Stmt> stmts, SootMethod method, boolean considerExecution) {
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        for (Stmt _stmt : stmts) {
            for (ValueBox _vBox : _stmt.getUseAndDefBoxes()) {
                if (!_vBox.getValue().equals(local)) continue;
                ExprLevelSliceCriterion _exprCriterion = this.getExprCriteria(method, _stmt, _vBox, considerExecution);
                _result.add(_exprCriterion);
            }
        }
        return _result;
    }

    public Collection<ISliceCriterion> getCriteria(SootMethod method) {
        MethodLevelSliceCriterion _criterion = new MethodLevelSliceCriterion();
        _criterion.initialize(method);
        return Collections.singleton(_criterion);
    }

    public Collection<ISliceCriterion> getCriteria(SootMethod method, Stmt stmt, boolean considerExecution) {
        return this.getCriteria(method, stmt, false, considerExecution);
    }

    public Collection<ISliceCriterion> getCriteria(SootMethod method, Stmt stmt, boolean descend, boolean considerExecution) {
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        StmtLevelSliceCriterion _stmtCriterion = this.getStmtCriteria(method, stmt, considerExecution);
        _result.add(_stmtCriterion);
        if (descend) {
            for (ValueBox _vBox : stmt.getUseAndDefBoxes()) {
                ExprLevelSliceCriterion _temp = this.getExprCriteria(method, stmt, _vBox, considerExecution);
                _result.add(_temp);
            }
        }
        return _result;
    }

    public Collection<ISliceCriterion> getCriteria(SootMethod method, Stmt stmt, ValueBox expression, boolean considerExecution) {
        return this.getCriteria(method, stmt, expression, false, considerExecution);
    }

    public Collection<ISliceCriterion> getCriteria(SootMethod method, Stmt stmt, ValueBox expr, boolean descend, boolean considerExecution) {
        HashSet<ISliceCriterion> _result = new HashSet<ISliceCriterion>();
        ExprLevelSliceCriterion _exprCriterion = this.getExprCriteria(method, stmt, expr, considerExecution);
        _result.add(_exprCriterion);
        if (descend) {
            for (ValueBox _useBox : expr.getValue().getUseBoxes()) {
                ExprLevelSliceCriterion _temp = this.getExprCriteria(method, stmt, _useBox, considerExecution);
                _result.add(_temp);
            }
        }
        return _result;
    }

    private ExprLevelSliceCriterion getExprCriteria(SootMethod method, Stmt stmt, ValueBox valueBox, boolean considerExecution) {
        ExprLevelSliceCriterion _temp = new ExprLevelSliceCriterion();
        _temp.initialize(method, stmt, valueBox);
        _temp.setConsiderExecution(considerExecution);
        return _temp;
    }

    private MethodLevelSliceCriterion getMethodCriteria(SootMethod method, boolean considerExecution) {
        MethodLevelSliceCriterion _temp = new MethodLevelSliceCriterion();
        _temp.initialize(method);
        _temp.setConsiderExecution(considerExecution);
        return _temp;
    }

    private StmtLevelSliceCriterion getStmtCriteria(SootMethod method, Stmt stmt, boolean considerExecution) {
        StmtLevelSliceCriterion _stmtCriterion = new StmtLevelSliceCriterion();
        _stmtCriterion.initialize(method, stmt);
        _stmtCriterion.setConsiderExecution(considerExecution);
        return _stmtCriterion;
    }
}

