/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.slicer.SliceGotoProcessor;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.tagkit.Host;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SliceCollector {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(SliceCollector.class);
    private SlicingEngine engine;
    private NamedTag tag;
    private final Collection<SootClass> taggedClasses = new HashSet<SootClass>();
    private final Collection<SootMethod> taggedMethods = new HashSet<SootMethod>();
    private String tagName;

    SliceCollector(SlicingEngine theEngine) {
        this.engine = theEngine;
    }

    public Collection<SootClass> getClassesInSlice() {
        return Collections.unmodifiableCollection(this.taggedClasses);
    }

    @NonNull
    @NonNullContainer
    public <T extends Host> Collection<T> getCollected(@NonNull @NonNullContainer Collection<T> hosts) {
        ArrayList<Host> _result = new ArrayList<Host>();
        for (Host _host : hosts) {
            if (!this.hasBeenCollected(_host)) continue;
            _result.add(_host);
        }
        return _result;
    }

    @NonNull
    @NonNullContainer
    public Collection<SootMethod> getMethodsInSlice() {
        return Collections.unmodifiableCollection(this.taggedMethods);
    }

    @NonNull
    public String getTagName() {
        return this.tagName;
    }

    @NonNull
    @NonNullContainer
    Collection<ValueBox> getUncollected(@NonNull @NonNullContainer List<ValueBox> valueBoxes) {
        HashSet<ValueBox> _result = new HashSet<ValueBox>();
        Iterator<ValueBox> _i = valueBoxes.iterator();
        int _iEnd = valueBoxes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ValueBox _vb = _i.next();
            if (!_vb.hasTag(this.tagName)) {
                _result.add(_vb);
            }
            ++_iIndex;
        }
        return _result;
    }

    public boolean hasBeenCollected(Host host) {
        NamedTag _temp = (NamedTag)host.getTag(this.tagName);
        return _temp != null;
    }

    public void includeInSlice(Collection<? extends Host> hosts) {
        for (Host host : hosts) {
            this.includeInSlice(host);
        }
    }

    public void includeInSlice(Host host) {
        NamedTag _hostTag = (NamedTag)host.getTag(this.tagName);
        if (_hostTag == null) {
            host.addTag((Tag)this.tag);
            if (host instanceof SootMethod) {
                this.taggedMethods.add((SootMethod)host);
            } else if (host instanceof SootClass) {
                this.taggedClasses.add((SootClass)host);
            }
            if (LOGGER.isDebugEnabled()) {
                Host _o = host;
                if (host instanceof ValueBox) {
                    _o = ((ValueBox)host).getValue();
                }
                LOGGER.debug("Tagged[1]: " + _o);
            }
        } else if (!_hostTag.equals((Object)this.tag)) {
            host.removeTag(this.tagName);
            host.addTag((Tag)this.tag);
            if (LOGGER.isDebugEnabled()) {
                Object _temp = host instanceof ValueBox ? ((ValueBox)host).getValue() : host;
                LOGGER.debug("Tagged[2]: " + _temp);
            }
        } else if (LOGGER.isDebugEnabled()) {
            Object _temp = host instanceof ValueBox ? ((ValueBox)host).getValue() : host;
            LOGGER.debug("Already Tagged: " + _temp);
        }
    }

    public void processGotos() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing Gotos");
        }
        SliceGotoProcessor _gotoProcessor = new SliceGotoProcessor(this);
        BasicBlockGraphMgr _bbgMgr = this.engine.getBasicBlockGraphManager();
        _gotoProcessor.process(this.taggedMethods, _bbgMgr);
    }

    public String toString() {
        StringWriter _sw = new StringWriter();
        PrintWriter _pw = new PrintWriter(_sw);
        for (SootClass _sc : this.taggedClasses) {
            _pw.println("Class: " + _sc);
            _pw.println("  Fields:");
            Iterator _j = this.getCollected((Collection)_sc.getFields()).iterator();
            while (_j.hasNext()) {
                _pw.println("    " + _j.next());
            }
            _pw.println("  Methods:");
            for (SootMethod _method : this.getCollected(_sc.getMethods())) {
                _pw.println("    " + _method);
                if (!_method.hasActiveBody()) continue;
                for (Stmt _stmt : this.getCollected((Collection)_method.getActiveBody().getUnits())) {
                    _pw.println("      " + _stmt);
                    Iterator _l = this.getCollected(_stmt.getUseAndDefBoxes()).iterator();
                    while (_l.hasNext()) {
                        _pw.println("        " + ((ValueBox)_l.next()).getValue());
                    }
                }
            }
        }
        _pw.flush();
        _pw.close();
        return _sw.getBuffer().toString();
    }

    void completeSlicing() {
        this.processGotos();
    }

    void reset() {
        this.taggedMethods.clear();
        this.taggedClasses.clear();
    }

    void setTagName(String theTagName) {
        if (theTagName != null) {
            this.tag = new NamedTag(theTagName);
            this.tagName = theTagName;
        }
    }
}

