/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.IDirectionSensitivePartOfSlicingEngine;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardSlicingPart
implements IDirectionSensitivePartOfSlicingEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardSlicingPart.class);
    private final SlicingEngine engine;

    ForwardSlicingPart(SlicingEngine theEngine) {
        this.engine = theEngine;
    }

    @Override
    @Empty
    public boolean continueProcessing() {
        return false;
    }

    @Override
    public void generateCriteriaForTheCallToMethod(SootMethod callee, SootMethod caller, Stmt callStmt) {
        this.engine.generateStmtLevelSliceCriterion(callStmt, caller, true);
        this.engine.includeInSlice((Host)callStmt.getInvokeExprBox());
        if (!callee.isStatic()) {
            ValueBox _vBox = ((InstanceInvokeExpr)callStmt.getInvokeExpr()).getBaseBox();
            this.engine.generateExprLevelSliceCriterion(_vBox, callStmt, caller, false);
        }
        if (callStmt instanceof AssignStmt) {
            AssignStmt _defStmt = (AssignStmt)callStmt;
            this.engine.generateExprLevelSliceCriterion(_defStmt.getLeftOpBox(), callStmt, caller, true);
        }
    }

    @Override
    public void generateCriteriaToIncludeCallees(Stmt stmt, SootMethod caller, Collection<SootMethod> callees) {
        InvokeExpr _expr = stmt.getInvokeExpr();
        if (_expr instanceof InstanceInvokeExpr) {
            Iterator<SootMethod> _i = callees.iterator();
            int _iEnd = callees.size();
            this.engine.enterMethod(new ICallGraphInfo.CallTriple(caller, stmt, _expr));
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootMethod _callee = _i.next();
                List _units = this.engine.getBasicBlockGraphManager().getStmtList(_callee);
                for (Stmt _stmt : _units) {
                    IdentityStmt _idStmt;
                    Value _rightOp;
                    if (!(_stmt instanceof IdentityStmt) || !((_rightOp = (_idStmt = (IdentityStmt)_stmt).getRightOp()) instanceof ThisRef)) continue;
                    this.engine.generateStmtLevelSliceCriterion((Stmt)_idStmt, _callee, false);
                    break;
                }
                ++_iIndex;
            }
            this.engine.returnFromMethod();
        }
    }

    public Collection<Object> getDependences(IDependencyAnalysis analysis, Object entity, SootMethod method) {
        HashSet<Object> _result = new HashSet<Object>();
        IDependencyAnalysis.Direction _dir = analysis.getDirection();
        if (_dir.equals(IDependencyAnalysis.Direction.FORWARD_DIRECTION)) {
            _result.addAll(analysis.getDependees(entity, (Object)method));
        } else if (_dir.equals(IDependencyAnalysis.Direction.BI_DIRECTIONAL)) {
            _result.addAll(analysis.getDependents(entity, (Object)method));
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Trying to retrieve FORWARD dependence from a dependence analysis that is BACKWARD in direction. -- " + analysis.getClass() + " - " + _dir);
        }
        return _result;
    }

    @Override
    public Object getEntityForIdentifierBasedDataDA(Local local, Stmt stmt) {
        Object _result = stmt instanceof DefinitionStmt ? stmt : null;
        return _result;
    }

    @Override
    public void processLocalAt(Local local, Stmt stmt, SootMethod method) {
        this.engine.generateStmtLevelSliceCriterion(stmt, method, true);
        if (stmt instanceof DefinitionStmt) {
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            ValueBox _leftOpBox = ((DefinitionStmt)stmt).getLeftOpBox();
            _boxes.add(_leftOpBox);
            _boxes.addAll(_leftOpBox.getValue().getUseBoxes());
            for (ValueBox _box : _boxes) {
                this.engine.generateExprLevelSliceCriterion(_box, stmt, method, false);
            }
        }
        if (stmt.containsInvokeExpr()) {
            List _useBoxes = stmt.getInvokeExpr().getUseBoxes();
            Iterator _j = _useBoxes.iterator();
            int _jEnd = _useBoxes.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                ValueBox _vb = (ValueBox)_j.next();
                if (_vb.getValue().equals(local)) {
                    this.engine.generateExprLevelSliceCriterion(_vb, stmt, method, true);
                }
                ++_jIndex;
            }
            InvokeExpr _invokeExpr = stmt.getInvokeExpr();
            List _args = _invokeExpr.getArgs();
            int _argIndex = _args.indexOf(local);
            if (_argIndex > -1) {
                Context _ctxt = new Context();
                _ctxt.setRootMethod(method);
                _ctxt.setStmt(stmt);
                Collection _callees = this.engine.getCgi().getCallees(_invokeExpr, _ctxt);
                this.engine.enterMethod(new ICallGraphInfo.CallTriple(method, stmt, stmt.getInvokeExpr()));
                this.generateCriteriaToIncludeArgumentReadStmts(_argIndex, _callees);
                this.engine.returnFromMethod();
            }
        }
    }

    @Override
    public void processNewExpr(Stmt stmt, SootMethod method) {
        if (stmt instanceof AssignStmt) {
            AssignStmt _as = (AssignStmt)stmt;
            this.engine.generateExprLevelSliceCriterion(_as.getLeftOpBox(), stmt, method, false);
        }
    }

    @Override
    public void processParameterRef(IdentityStmt stmt, SootMethod method) {
        this.engine.generateExprLevelSliceCriterion(stmt.getLeftOpBox(), (Stmt)stmt, method, false);
    }

    @Override
    @Empty
    public void reset() {
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformExpr(ValueBox valueBox, Stmt stmt) {
        HashSet<ValueBox> _valueBoxes = new HashSet<ValueBox>();
        _valueBoxes.add(valueBox);
        Value _value = valueBox.getValue();
        if (_value instanceof InvokeExpr) {
            _valueBoxes.addAll(_value.getUseBoxes());
            if (_value instanceof InstanceInvokeExpr) {
                _valueBoxes.add(((InstanceInvokeExpr)_value).getBaseBox());
            }
        }
        if (stmt instanceof DefinitionStmt && ((DefinitionStmt)stmt).getLeftOp().getUseBoxes().contains(valueBox)) {
            _valueBoxes.addAll(this.engine.getCollector().getUncollected(stmt.getDefBoxes()));
        }
        return _valueBoxes;
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformStmt(Stmt stmt) {
        return new HashSet<ValueBox>(stmt.getUseBoxes());
    }

    private void generateCriteriaToIncludeArgumentReadStmts(int argIndex, Collection<SootMethod> callees) {
        Iterator<SootMethod> _i = callees.iterator();
        int _iEnd = callees.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootMethod _callee = _i.next();
            List _units = this.engine.getBasicBlockGraphManager().getStmtList(_callee);
            for (Stmt _stmt : _units) {
                IdentityStmt _idStmt;
                Value _rightOp;
                if (!(_stmt instanceof IdentityStmt) || !((_rightOp = (_idStmt = (IdentityStmt)_stmt).getRightOp()) instanceof ParameterRef) || ((ParameterRef)_rightOp).getIndex() != argIndex) continue;
                this.engine.generateStmtLevelSliceCriterion((Stmt)_idStmt, _callee, false);
                break;
            }
            ++_iIndex;
        }
    }
}

