/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IClosure;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.ICallingContextRetriever;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependenceExtractor
implements IClosure<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenceExtractor.class);
    private static final IProgramPointRetriever READY_DA_PPR = new IProgramPointRetriever(){

        @Override
        public Collection<ValueBox> getProgramPoints(Stmt stmt) {
            if (stmt instanceof InvokeStmt) {
                return Collections.singleton(((VirtualInvokeExpr)((InvokeStmt)stmt).getInvokeExpr()).getBaseBox());
            }
            if (stmt instanceof MonitorStmt) {
                return Collections.singleton(((MonitorStmt)stmt).getOpBox());
            }
            throw new IllegalArgumentException("stmt has to be of type MonitorStmt or InvokeStmt.");
        }
    };
    private static final IProgramPointRetriever REFERENTIAL_DA_PPR = new IProgramPointRetriever(){

        @Override
        public Collection<ValueBox> getProgramPoints(Stmt stmt) {
            Collection _result;
            if (stmt.containsArrayRef()) {
                _result = Collections.singleton(stmt.getArrayRef().getBaseBox());
            } else if (stmt.containsFieldRef()) {
                FieldRef _fr = stmt.getFieldRef();
                _result = _fr instanceof InstanceFieldRef ? (Collection)Collections.singleton(((InstanceFieldRef)_fr).getBaseBox()) : (Collection)Collections.singleton(stmt.getFieldRefBox());
            } else {
                throw new IllegalArgumentException("stmt has to contain an array/field reference.");
            }
            return _result;
        }
    };
    private static final IProgramPointRetriever SYNCHRONIZATION_DA_PPR = new IProgramPointRetriever(){

        @Override
        public Collection<ValueBox> getProgramPoints(Stmt stmt) {
            if (stmt instanceof MonitorStmt) {
                return Collections.singleton(((MonitorStmt)stmt).getOpBox());
            }
            throw new IllegalArgumentException("stmt has to be of type MonitorStmt.");
        }
    };
    protected Object entity;
    protected SootMethod occurringMethod;
    private final Map<Object, Collection<Stack<ICallGraphInfo.CallTriple>>> criteriabase2contexts;
    private final Collection<Object> dependences = new HashSet<Object>();
    private final Map<IDependencyAnalysis.DependenceSort, ICallingContextRetriever> depID2ctxtRetriever;
    private final SlicingEngine engine;
    private Stack<ICallGraphInfo.CallTriple> occurringCallingContext;
    private IDependenceRetriver retriever;

    protected DependenceExtractor(SlicingEngine slicingEngine) {
        this.engine = slicingEngine;
        this.criteriabase2contexts = new HashMap<Object, Collection<Stack<ICallGraphInfo.CallTriple>>>();
        this.depID2ctxtRetriever = new HashMap<IDependencyAnalysis.DependenceSort, ICallingContextRetriever>();
    }

    public void execute(IDependencyAnalysis<?, ?, ?, ?, ?, ?> analysis) {
        IDependencyAnalysis<?, ?, ?, ?, ?, ?> _da = analysis;
        Collection<Object> _t = this.retriever.getDependences(_da, this.entity, this.occurringMethod);
        if (!_t.isEmpty()) {
            this.dependences.addAll(_t);
            this.populateCriteriaBaseToContextsMap(_da, _t);
        }
    }

    @NonNull
    public <T> Collection<Stack<ICallGraphInfo.CallTriple>> getContextsFor(@NonNull T criteriaBase) {
        Collection _result = MapUtils.queryCollection(this.criteriabase2contexts, criteriaBase);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getContextsFor(criteriaBase = " + criteriaBase + ") -  : _result = " + _result);
        }
        return _result;
    }

    public Object getEntityForIdentifierBasedDataDA(Local local, Stmt stmt) {
        return this.retriever.getEntityForIdentifierBasedDataDA(local, stmt);
    }

    public void setDepID2ContextRetrieverMapping(@NonNull Map<IDependencyAnalysis.DependenceSort, ICallingContextRetriever> map) {
        this.depID2ctxtRetriever.putAll(map);
    }

    @NonNull
    Collection<?> getDependences() {
        return Collections.unmodifiableCollection(this.dependences);
    }

    void setDependenceRetriever(IDependenceRetriver theRetriever) {
        this.retriever = theRetriever;
    }

    void setTrigger(Object theEntity, SootMethod method, Stack<ICallGraphInfo.CallTriple> callStack) {
        this.entity = theEntity;
        this.occurringMethod = method;
        this.occurringCallingContext = callStack;
        this.dependences.clear();
        this.criteriabase2contexts.clear();
    }

    private void populateContextsForInterProceduralDependences(Collection<IDependencyAnalysis.DependenceSort> ids, Collection<?> criteriaBases) {
        IProgramPointRetriever _result;
        if (ids.contains(IDependencyAnalysis.DependenceSort.READY_DA)) {
            _result = READY_DA_PPR;
        } else if (ids.contains(IDependencyAnalysis.DependenceSort.INTERFERENCE_DA) || ids.contains(IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA)) {
            _result = REFERENTIAL_DA_PPR;
        } else if (ids.contains(IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA)) {
            _result = SYNCHRONIZATION_DA_PPR;
        } else {
            throw new IllegalArgumentException("da has to have one of these Ids mentioned in the documentation. - " + ids);
        }
        IProgramPointRetriever _ppr = _result;
        Iterator _i = SetUtils.intersection(ids, (Collection)this.depID2ctxtRetriever.keySet()).iterator();
        while (_i.hasNext()) {
            ICallingContextRetriever _ctxtRetriever = this.depID2ctxtRetriever.get(_i.next());
            _ctxtRetriever.setInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_ENTITY, this.entity);
            _ctxtRetriever.setInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD, (Object)this.occurringMethod);
            _ctxtRetriever.setInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_CALLING_CONTEXT, this.occurringCallingContext);
            Context _context = new Context();
            for (Pair _t : criteriaBases) {
                boolean _containsKey = this.criteriabase2contexts.containsKey(_t);
                if (_containsKey && this.criteriabase2contexts.get(_t).contains(null)) continue;
                Pair _pair = _t;
                Stmt _stmt = (Stmt)_pair.getFirst();
                SootMethod _criteriabaseMethod = (SootMethod)_pair.getSecond();
                _context.setStmt(_stmt);
                _context.setRootMethod(_criteriabaseMethod);
                if (_stmt != null) {
                    Collection<ValueBox> _programPoints = _ppr.getProgramPoints(_stmt);
                    Iterator<ValueBox> _k = _programPoints.iterator();
                    while (_k.hasNext()) {
                        _context.setProgramPoint(_k.next());
                        Collection _ctxts = _ctxtRetriever.getCallingContextsForProgramPoint(_context);
                        MapUtils.putAllIntoCollectionInMap(this.criteriabase2contexts, (Object)_pair, (Collection)_ctxts);
                    }
                    continue;
                }
                Collection _ctxts = _ctxtRetriever.getCallingContextsForThis(_context);
                MapUtils.putAllIntoCollectionInMap(this.criteriabase2contexts, (Object)_pair, (Collection)_ctxts);
            }
        }
    }

    private void populateCriteriaBaseToContextsMap(IDependencyAnalysis<?, ?, ?, ?, ?, ?> da, Collection<?> criteriaBases) {
        Collection _ids;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("populateCriteriaBaseToContextsMap(IDependencyAnalysis da=" + da.getIds() + ", Collection criteriaBases=" + criteriaBases + ") - BEGIN");
        }
        if ((_ids = da.getIds()).contains(IDependencyAnalysis.DependenceSort.CONTROL_DA) || _ids.contains(IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA)) {
            Iterator<?> _i = criteriaBases.iterator();
            while (_i.hasNext()) {
                MapUtils.putIntoCollectionInMap(this.criteriabase2contexts, _i.next(), this.engine.getCopyOfCallStackCache());
            }
        } else if (CollectionUtils.containsAny((Collection)_ids, (Collection)this.depID2ctxtRetriever.keySet())) {
            this.populateContextsForInterProceduralDependences(_ids, criteriaBases);
        } else {
            for (Object _cb : criteriaBases) {
                MapUtils.putIntoCollectionInMap(this.criteriabase2contexts, _cb, null);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            ArrayList _t = new ArrayList(_ids);
            Collections.sort(_t);
            LOGGER.debug("populateDependenceToContextsMap(): criteriabases2contexts - " + this.criteriabase2contexts + " - END");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface IDependenceRetriver {
        @NonNull
        public Collection<Object> getDependences(@NonNull IDependencyAnalysis<?, ?, ?, ?, ?, ?> var1, @NonNull Object var2, @NonNull SootMethod var3);

        public Object getEntityForIdentifierBasedDataDA(Local var1, Stmt var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IProgramPointRetriever {
        public Collection<ValueBox> getProgramPoints(Stmt var1);
    }
}

