/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.slicer.BackwardSlicingPart;
import edu.ksu.cis.indus.slicer.ForwardSlicingPart;
import edu.ksu.cis.indus.slicer.IDirectionSensitivePartOfSlicingEngine;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import java.util.HashSet;
import soot.Local;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteSlicingPart
implements IDirectionSensitivePartOfSlicingEngine {
    private final BackwardSlicingPart backwardPart;
    private final SlicingEngine engine;
    private final ForwardSlicingPart forwardPart;

    public CompleteSlicingPart(SlicingEngine theEngine) {
        this.engine = theEngine;
        this.backwardPart = new BackwardSlicingPart(this.engine);
        this.forwardPart = new ForwardSlicingPart(this.engine);
    }

    @Override
    public boolean continueProcessing() {
        return this.backwardPart.continueProcessing() || this.forwardPart.continueProcessing();
    }

    @Override
    public void generateCriteriaForTheCallToMethod(SootMethod callee, SootMethod caller, Stmt callStmt) {
        this.backwardPart.generateCriteriaForTheCallToMethod(callee, caller, callStmt);
        this.forwardPart.generateCriteriaForTheCallToMethod(callee, caller, callStmt);
    }

    public void generateCriteriaToIncludeCallees(Stmt stmt, SootMethod caller, Collection callees) {
        this.backwardPart.generateCriteriaToIncludeCallees(stmt, caller, callees);
        this.forwardPart.generateCriteriaToIncludeCallees(stmt, caller, callees);
    }

    public Collection<Object> getDependences(IDependencyAnalysis analysis, Object entity, SootMethod method) {
        HashSet<Object> _result = new HashSet<Object>();
        if (entity instanceof Pair) {
            _result.addAll(this.backwardPart.getDependences(analysis, ((Pair)entity).getSecond(), method));
            _result.addAll(this.forwardPart.getDependences(analysis, ((Pair)entity).getSecond(), method));
        } else {
            _result.addAll(this.backwardPart.getDependences(analysis, entity, method));
            _result.addAll(this.forwardPart.getDependences(analysis, entity, method));
        }
        return _result;
    }

    @Override
    public Object getEntityForIdentifierBasedDataDA(Local local, Stmt stmt) {
        return new Pair(this.backwardPart.getEntityForIdentifierBasedDataDA(local, stmt), this.forwardPart.getEntityForIdentifierBasedDataDA(local, stmt));
    }

    @Override
    public void processLocalAt(Local local, Stmt stmt, SootMethod method) {
        this.backwardPart.processLocalAt(local, stmt, method);
        this.forwardPart.processLocalAt(local, stmt, method);
    }

    @Override
    public void processNewExpr(Stmt stmt, SootMethod method) {
        this.backwardPart.processNewExpr(stmt, method);
        this.forwardPart.processNewExpr(stmt, method);
    }

    @Override
    public void processParameterRef(IdentityStmt stmt, SootMethod method) {
        this.backwardPart.processParameterRef(stmt, method);
        this.forwardPart.processParameterRef(stmt, method);
    }

    @Override
    public void reset() {
        this.backwardPart.reset();
        this.forwardPart.reset();
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformExpr(ValueBox valueBox, Stmt stmt) {
        HashSet<ValueBox> _result = new HashSet<ValueBox>();
        _result.addAll(this.backwardPart.retrieveValueBoxesToTransformExpr(valueBox, stmt));
        _result.addAll(this.forwardPart.retrieveValueBoxesToTransformExpr(valueBox, stmt));
        return _result;
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformStmt(Stmt stmt) {
        HashSet<ValueBox> _result = new HashSet<ValueBox>();
        _result.addAll(this.backwardPart.retrieveValueBoxesToTransformStmt(stmt));
        _result.addAll(this.forwardPart.retrieveValueBoxesToTransformStmt(stmt));
        return _result;
    }
}

