/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.common.collections.IClosure;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.IDirectionSensitivePartOfSlicingEngine;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.cfg.LocalUseDefAnalysisv2;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackwardSlicingPart
implements IDirectionSensitivePartOfSlicingEngine {
    private final boolean CONSIDER_EXECUTION = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(BackwardSlicingPart.class);
    final SlicingEngine engine;
    private final Map<SootMethod, Collection<Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>>>> callee2callsites = new HashMap<SootMethod, Collection<Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>>>>();
    private final Map<SootMethod, Collection<Stmt>> exitTransformedMethods2exitpoints = new HashMap<SootMethod, Collection<Stmt>>();
    private final Map<SootMethod, BitSet> method2params = new HashMap<SootMethod, BitSet>();
    private final IClosure<Pair<Stmt, SootMethod>> returnValueInclClosure = new ReturnValueInclusionClosure();
    private final IClosure<Pair<Stmt, SootMethod>> tailStmtInclusionClosure = new TailStmtInclusionClosure();

    BackwardSlicingPart(SlicingEngine theEngine) {
        this.engine = theEngine;
    }

    @Override
    public boolean continueProcessing() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("continueProcessing() - BEGIN");
        }
        boolean _result = false;
        Iterator<Map.Entry<SootMethod, Collection<Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>>>>> _i = this.callee2callsites.entrySet().iterator();
        while (_i.hasNext()) {
            Map.Entry<SootMethod, Collection<Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>>>> _entry = _i.next();
            SootMethod _callee = _entry.getKey();
            BitSet _params = this.method2params.get(_callee);
            if (_params == null) continue;
            Collection<Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>>> _temp = _entry.getValue();
            for (Triple<Stmt, SootMethod, Stack<ICallGraphInfo.CallTriple>> _triple : _temp) {
                Stmt _stmt = (Stmt)_triple.getFirst();
                SootMethod _caller = (SootMethod)_triple.getSecond();
                Stack _stack = (Stack)_triple.getThird();
                InvokeExpr _expr = _stmt.getInvokeExpr();
                int _j = _params.nextSetBit(0);
                while (_j >= 0) {
                    _result |= this.engine.generateExprLevelSliceCriterion(_expr.getArgBox(_j), _stmt, _caller, true, (Stack<ICallGraphInfo.CallTriple>)_stack);
                    _j = _params.nextSetBit(_j + 1);
                }
            }
            if (_params.cardinality() != _callee.getParameterCount()) continue;
            _i.remove();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("continueProcessing() - END");
        }
        return _result;
    }

    @Override
    public void generateCriteriaForTheCallToMethod(SootMethod callee, SootMethod caller, Stmt callStmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForTheCallToMethod(Stmt callStmt = " + callStmt + "SootMethod callee = " + callee + ", SootMethod caller = " + caller + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        this.engine.generateStmtLevelSliceCriterion(callStmt, caller, false);
        this.engine.includeInSlice((Host)callStmt.getInvokeExprBox());
        this.generateCriteriaForReceiverOfAt(callStmt, caller);
        this.recordCallInfoForProcessingArgsTo(callStmt, caller, callee);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForTheCallToMethod() - END");
        }
    }

    @Override
    public void generateCriteriaToIncludeCallees(Stmt stmt, SootMethod caller, Collection<SootMethod> callees) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaToIncludeCallees(Stmt stmt = " + stmt + ", Collection callees = " + callees + ", SootMethod caller = " + caller + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        this.processTailsOf(callees, stmt, caller, this.tailStmtInclusionClosure);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaToIncludeCallees() - END");
        }
    }

    public Collection<Object> getDependences(IDependencyAnalysis analysis, Object entity, SootMethod method) {
        HashSet<Object> _result = new HashSet<Object>();
        IDependencyAnalysis.Direction _direction = analysis.getDirection();
        if (_direction.equals((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION) || _direction.equals((Object)IDependencyAnalysis.Direction.BI_DIRECTIONAL)) {
            if (analysis instanceof IdentifierBasedDataDA && entity instanceof Stmt) {
                _result.addAll(((IdentifierBasedDataDA)analysis).getDependees((Stmt)entity, method));
            } else if (analysis instanceof IdentifierBasedDataDAv2 && entity instanceof Stmt) {
                _result.addAll(((IdentifierBasedDataDAv2)analysis).getDependees((Stmt)entity, method));
            } else {
                _result.addAll(analysis.getDependees(entity, (Object)method));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Trying to retrieve BACKWARD dependence from a dependence analysis that is FORWARD direction. -- " + analysis.getClass() + " - " + _direction);
        }
        return _result;
    }

    @Override
    public Object getEntityForIdentifierBasedDataDA(Local local, Stmt stmt) {
        return new Pair((Object)local, (Object)stmt);
    }

    @Override
    public void processLocalAt(Local local, Stmt stmt, SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processLocalAt(Local local = " + local + ", Stmt stmt = " + stmt + ", SootMethod method = " + method + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        boolean _flag = false;
        if (stmt instanceof DefinitionStmt) {
            Iterator _i = stmt.getDefBoxes().iterator();
            int _iEnd = stmt.getDefBoxes().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd && !_flag) {
                ValueBox _vb = (ValueBox)_i.next();
                Value _v = _vb.getValue();
                _flag = _v.equals(local);
                ++_iIndex;
            }
        }
        this.engine.generateStmtLevelSliceCriterion(stmt, method, _flag);
        if (stmt.containsInvokeExpr() && _flag) {
            Context _ctxt = new Context();
            _ctxt.setRootMethod(method);
            _ctxt.setStmt(stmt);
            this.processTailsOf(this.engine.getCgi().getCallees(stmt.getInvokeExpr(), _ctxt), stmt, method, this.returnValueInclClosure);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processLocalAt() , stack = " + this.engine.getCopyOfCallStackCache() + "- END");
        }
    }

    @Override
    public void processNewExpr(Stmt stmt, SootMethod method) {
        AssignStmt _as;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processNewExpr(Stmt stmt = " + stmt + ", SootMethod method = " + method + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        if (stmt instanceof AssignStmt && (_as = (AssignStmt)stmt).getRightOp() instanceof NewExpr) {
            InvokeStmt _def = this.engine.getInitMapper().getInitCallStmtForNewExprStmt(stmt, method);
            if (_def != null) {
                this.engine.generateStmtLevelSliceCriterion((Stmt)_def, method, true);
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not find the <init> for " + stmt + "@" + method);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processNewExpr() - END");
        }
    }

    @Override
    public void processParameterRef(IdentityStmt stmt, SootMethod callee) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processParameterRef(ValueBox pBox = " + stmt.getRightOpBox() + ", SootMethod callee = " + callee + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        ParameterRef _param = (ParameterRef)stmt.getRightOp();
        int _index = _param.getIndex();
        BitSet _params = this.method2params.get(callee);
        if (_params == null) {
            _params = new BitSet(8);
            this.method2params.put(callee, _params);
        }
        _params.set(_param.getIndex());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parameters required for " + callee + " are " + _params);
        }
        if (this.engine.ifInsideContext()) {
            ICallGraphInfo.CallTriple _temp = this.engine.returnFromMethod();
            if (_temp != null) {
                SootMethod _caller = _temp.getMethod();
                Stmt _stmt = _temp.getStmt();
                ValueBox _argBox = _temp.getExpr().getArgBox(_index);
                this.engine.generateExprLevelSliceCriterion(_argBox, _stmt, _caller, true);
                this.generateCriteriaForReceiverOfAt(_stmt, _caller);
            }
            this.engine.enterMethod(_temp);
        } else {
            for (ICallGraphInfo.CallTriple _ctrp : this.engine.getCgi().getCallers(callee)) {
                SootMethod _caller = _ctrp.getMethod();
                Stmt _stmt = _ctrp.getStmt();
                ValueBox _argBox = _ctrp.getExpr().getArgBox(_index);
                this.engine.generateExprLevelSliceCriterion(_argBox, _stmt, _caller, true);
                this.generateCriteriaForReceiverOfAt(_stmt, _caller);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processParameterRef() - END");
        }
    }

    @Override
    public void reset() {
        this.callee2callsites.clear();
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformExpr(ValueBox valueBox, Stmt stmt) {
        HashSet<ValueBox> _valueBoxes = new HashSet<ValueBox>();
        _valueBoxes.add(valueBox);
        Value _value = valueBox.getValue();
        if (!(_value instanceof InvokeExpr)) {
            _valueBoxes.addAll(_value.getUseBoxes());
        } else if (_value instanceof InstanceInvokeExpr) {
            _valueBoxes.add(((InstanceInvokeExpr)_value).getBaseBox());
        }
        if (stmt instanceof DefinitionStmt && stmt.getDefBoxes().contains(valueBox)) {
            _valueBoxes.addAll(this.engine.getCollector().getUncollected(stmt.getUseBoxes()));
        }
        return _valueBoxes;
    }

    @Override
    public Collection<ValueBox> retrieveValueBoxesToTransformStmt(Stmt stmt) {
        HashSet<ValueBox> _valueBoxes = new HashSet<ValueBox>(stmt.getUseAndDefBoxes());
        if (stmt.containsInvokeExpr()) {
            InvokeExpr _invokeExpr = stmt.getInvokeExpr();
            _valueBoxes.removeAll(_invokeExpr.getUseBoxes());
            if (_invokeExpr instanceof InstanceInvokeExpr) {
                _valueBoxes.add(((InstanceInvokeExpr)_invokeExpr).getBaseBox());
            }
        }
        return _valueBoxes;
    }

    private boolean considerMethodExitForCriteriaGeneration(SootMethod callee, boolean expr) {
        boolean _result = false;
        if (!this.exitTransformedMethods2exitpoints.containsKey(callee)) {
            _result = true;
        } else if (expr) {
            Collection _temp = MapUtils.queryCollection(this.exitTransformedMethods2exitpoints, (Object)callee);
            Iterator _i = _temp.iterator();
            int _iEnd = _temp.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd && !_result) {
                Stmt _tail = (Stmt)_i.next();
                if (_tail instanceof ReturnStmt) {
                    _result |= !this.engine.getCollector().hasBeenCollected((Host)((ReturnStmt)_tail).getOpBox());
                } else if (_tail instanceof ThrowStmt) {
                    _result |= !this.engine.getCollector().hasBeenCollected((Host)((ThrowStmt)_tail).getOpBox());
                }
                ++_iIndex;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Consider Method exit for method " + callee + " is " + _result);
        }
        return _result;
    }

    private void generateCriteriaForReceiverOfAt(Stmt callStmt, SootMethod caller) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForReceiverOfAt(Stmt invocationStmt = " + callStmt + ", SootMethod caller = " + caller + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        if (!callStmt.getInvokeExpr().getMethod().isStatic()) {
            ValueBox _vBox = ((InstanceInvokeExpr)callStmt.getInvokeExpr()).getBaseBox();
            this.engine.generateExprLevelSliceCriterion(_vBox, callStmt, caller, true);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("generateCriteriaForReceiverOfAt(), stack = " + this.engine.getCopyOfCallStackCache() + " - END");
        }
    }

    private void processSuperInitInInit(SootMethod initMethod, BasicBlockGraph bbg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processSuperInitInInit(SootMethod initMethod = " + initMethod + ", BasicBlockGraph bbg = " + bbg + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        if (initMethod.getName().equals("<init>") && initMethod.getDeclaringClass().hasSuperclass()) {
            LocalUseDefAnalysisv2 _udl = new LocalUseDefAnalysisv2(this.engine.getBasicBlockGraphManager().getBasicBlockGraph(initMethod));
            Collection _uses = _udl.getUses((DefinitionStmt)bbg.getHead().getLeaderStmt(), initMethod);
            for (Pair _pair : _uses) {
                SootMethod _called;
                Stmt _stmt = (Stmt)_pair.getSecond();
                if (!(_stmt instanceof InvokeStmt) || !(_called = _stmt.getInvokeExpr().getMethod()).getName().equals("<init>") || !_called.getDeclaringClass().equals(initMethod.getDeclaringClass().getSuperclass())) continue;
                this.engine.generateStmtLevelSliceCriterion(_stmt, initMethod, true);
                break;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processSuperInitInInit() - END");
        }
    }

    private void processTailsOf(Collection<SootMethod> callees, Stmt stmt, SootMethod caller, IClosure<Pair<Stmt, SootMethod>> closure) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processTailsOf(Collection callees = " + callees + ", Stmt stmt = " + stmt + ", SootMethod caller = " + caller + ", IClosure closure = " + closure + ", stack = " + this.engine.getCopyOfCallStackCache() + ") - BEGIN");
        }
        BasicBlockGraphMgr _bbgMgr = this.engine.getBasicBlockGraphManager();
        for (SootMethod _callee : callees) {
            if (this.considerMethodExitForCriteriaGeneration(_callee, closure == this.returnValueInclClosure)) {
                this.engine.includeInSlice((Host)_callee);
                if (_callee.isConcrete()) {
                    BasicBlockGraph _calleeBasicBlockGraph = _bbgMgr.getBasicBlockGraph(_callee);
                    ICallGraphInfo.CallTriple _callTriple = new ICallGraphInfo.CallTriple(caller, stmt, stmt.getInvokeExpr());
                    this.engine.enterMethod(_callTriple);
                    this.processSuperInitInInit(_callee, _calleeBasicBlockGraph);
                    HashSet<Stmt> _temp = new HashSet<Stmt>();
                    for (BasicBlockGraph.BasicBlock _bb : _calleeBasicBlockGraph.getSinks()) {
                        Stmt _trailer = _bb.getTrailerStmt();
                        closure.execute((Object)new Pair((Object)_trailer, (Object)_callee));
                        _temp.add(_trailer);
                    }
                    this.exitTransformedMethods2exitpoints.put(_callee, _temp);
                    this.engine.returnFromMethod();
                } else {
                    InvokeExpr _invokeExpr = stmt.getInvokeExpr();
                    int _j = _callee.getParameterCount() - 1;
                    while (_j >= 0) {
                        this.engine.generateExprLevelSliceCriterion(_invokeExpr.getArgBox(_j), stmt, caller, true);
                        --_j;
                    }
                }
            }
            this.recordCallInfoForProcessingArgsTo(stmt, caller, _callee);
        }
        this.generateCriteriaForReceiverOfAt(stmt, caller);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processTailsOf() , stack = " + this.engine.getCopyOfCallStackCache() + "- END");
        }
    }

    private void recordCallInfoForProcessingArgsTo(Stmt stmt, SootMethod caller, SootMethod callee) {
        Stack<ICallGraphInfo.CallTriple> _stackClone = this.engine.getCopyOfCallStackCache();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recordCallInfoForParameterProcessing(Stmt stmt = " + stmt + ", SootMethod caller = " + caller + ", SootMethod callee = " + callee + ", stack = " + _stackClone + ") - BEGIN");
        }
        Triple _triple = new Triple((Object)stmt, (Object)caller, _stackClone);
        MapUtils.putIntoSetInMap(this.callee2callsites, (Object)callee, (Object)_triple);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recordCallInfoForParameterProcessing() - END");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReturnValueInclusionClosure
    implements IClosure<Pair<Stmt, SootMethod>> {
        private ReturnValueInclusionClosure() {
        }

        public void execute(Pair<Stmt, SootMethod> input) {
            Stmt _trailer = (Stmt)input.getFirst();
            SootMethod _callee = (SootMethod)input.getSecond();
            if (_trailer instanceof ReturnStmt) {
                BackwardSlicingPart.this.engine.generateExprLevelSliceCriterion(((ReturnStmt)_trailer).getOpBox(), _trailer, _callee, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TailStmtInclusionClosure
    implements IClosure<Pair<Stmt, SootMethod>> {
        private TailStmtInclusionClosure() {
        }

        public void execute(Pair<Stmt, SootMethod> input) {
            Stmt _stmt = (Stmt)input.getFirst();
            SootMethod _callee = (SootMethod)input.getSecond();
            BackwardSlicingPart.this.engine.generateStmtLevelSliceCriterion(_stmt, _callee, false);
        }
    }
}

