/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.ExceptAttr;
import jas.GenericAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Method {
    short acc;
    CP name;
    CP sig;
    CodeAttr code;
    ExceptAttr excepts;
    Vector genericAttrs = new Vector();

    public Method(short s, CP cP, CP cP2, CodeAttr codeAttr, ExceptAttr exceptAttr) {
        this.acc = s;
        this.name = cP;
        this.sig = cP2;
        this.code = codeAttr;
        this.excepts = exceptAttr;
    }

    public void addGenericAttr(GenericAttr genericAttr) {
        this.genericAttrs.addElement(genericAttr);
    }

    void resolve(ClassEnv classEnv) {
        classEnv.addCPItem(this.name);
        classEnv.addCPItem(this.sig);
        if (this.code != null) {
            this.code.resolve(classEnv);
        }
        if (this.excepts != null) {
            this.excepts.resolve(classEnv);
        }
    }

    void write(ClassEnv classEnv, DataOutputStream dataOutputStream) throws IOException, jasError {
        int n = 0;
        dataOutputStream.writeShort(this.acc);
        dataOutputStream.writeShort(classEnv.getCPIndex(this.name));
        dataOutputStream.writeShort(classEnv.getCPIndex(this.sig));
        if (this.code != null) {
            n = (short)(n + 1);
        }
        if (this.excepts != null) {
            n = (short)(n + 1);
        }
        n = (short)(n + this.genericAttrs.size());
        dataOutputStream.writeShort(n);
        if (this.code != null) {
            this.code.write(classEnv, dataOutputStream);
        }
        if (this.excepts != null) {
            this.excepts.write(classEnv, dataOutputStream);
        }
        Enumeration enumeration = this.genericAttrs.elements();
        while (enumeration.hasMoreElements()) {
            ((GenericAttr)enumeration.nextElement()).write(classEnv, dataOutputStream);
        }
    }
}

