/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.peq.graph;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.peq.constructors.ConstructorContainer;
import edu.ksu.cis.indus.peq.constructors.GeneralConstructor;
import edu.ksu.cis.indus.peq.graph.Edge;
import edu.ksu.cis.indus.peq.graph.Node;
import edu.ksu.cis.indus.peq.indusinterface.DependeeTranslator;
import edu.ksu.cis.indus.peq.indusinterface.DependentTranslator;
import edu.ksu.cis.indus.peq.indusinterface.IndusInterface;
import edu.ksu.cis.peq.graph.interfaces.IGraphEngine;
import edu.ksu.cis.peq.graph.interfaces.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.Stmt;

public class GraphBuilder
implements IGraphEngine {
    private Collection initNodeStatements = new ArrayList();
    private Map object2NodeMap;

    public GraphBuilder(Collection stmtColl) {
        this.initNodeStatements.addAll(stmtColl);
        this.object2NodeMap = new HashMap();
    }

    public Set getInitialNodes() {
        HashSet<Node> _collNodes = new HashSet<Node>();
        Iterator iter = this.initNodeStatements.iterator();
        while (iter.hasNext()) {
            Pair _pair = (Pair)iter.next();
            Node _node = new Node();
            _node.setInformation(_pair);
            _collNodes.add(_node);
            this.object2NodeMap.put(_pair, _node);
        }
        return _collNodes;
    }

    public Set getOutgoingEdges(INode node) {
        HashSet _retSet = null;
        if (node.getExitingEdges().size() > 0) {
            _retSet = node.getExitingEdges();
        } else {
            _retSet = new HashSet();
            _retSet.addAll(this.setupDependeeEdges(node));
            _retSet.addAll(this.setupDependentEdges(node));
        }
        return _retSet;
    }

    private Set setupDependeeEdges(INode node) {
        IndusInterface _ii = IndusInterface.getInstance();
        HashSet _depeSet = new HashSet();
        DependeeTranslator _dt = _ii.getDependeeTranslator();
        Pair informationStmt = (Pair)((Node)node).getInformation();
        Node _srcNode = (Node)node;
        Collection _depColl = _dt.getControlInfo(informationStmt);
        if (_depColl.contains(informationStmt.getFirst())) {
            _depColl.remove(informationStmt.getFirst());
        }
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getCDepD()));
        _depColl = _dt.getIDataInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getIDef()));
        _depColl = _dt.getDvgInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getDvdd()));
        _depColl = _dt.getIntfInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getIdd()));
        _depColl = _dt.getSyncInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getSdd()));
        _depColl = _dt.getReadyInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getRdd()));
        _depColl = _dt.getRefDataInfo(informationStmt);
        _depeSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getRdef()));
        return _depeSet;
    }

    private Set setupDependentEdges(INode node) {
        IndusInterface _ii = IndusInterface.getInstance();
        DependentTranslator _dt = _ii.getDependentTranslator();
        Pair informationStmt = (Pair)((Node)node).getInformation();
        HashSet _deptSet = new HashSet();
        Node _srcNode = (Node)node;
        Collection _depColl = _dt.getControlInfo(informationStmt);
        if (_depColl.contains(informationStmt.getFirst())) {
            _depColl.remove(informationStmt.getFirst());
        }
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getCDepT()));
        _depColl = _dt.getIDataInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getIUse()));
        _depColl = _dt.getDvgInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getDvdt()));
        _depColl = _dt.getIntfInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getIdt()));
        _depColl = _dt.getSyncInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getSdt()));
        _depColl = _dt.getReadyInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getRdt()));
        _depColl = _dt.getRefDataInfo(informationStmt);
        _deptSet.addAll(this.process(_srcNode, _depColl, ConstructorContainer.getInstance().getRuse()));
        return _deptSet;
    }

    private Set process(Node mainNode, Collection coll, GeneralConstructor constructor) {
        HashSet<Edge> _retSet = new HashSet<Edge>();
        Pair informationStmt = (Pair)mainNode.getInformation();
        SootMethod _masterMethod = (SootMethod)informationStmt.getSecond();
        Iterator _iter = coll.iterator();
        while (_iter.hasNext()) {
            Object _obj = _iter.next();
            Pair _pair = null;
            if (_obj instanceof Stmt) {
                _pair = new Pair(_obj, (Object)_masterMethod);
            }
            if (_obj instanceof Pair && (_pair = (Pair)_obj).getFirst() == null) continue;
            Node _node = null;
            if (this.object2NodeMap.get(_pair) != null) {
                _node = (Node)this.object2NodeMap.get(_pair);
            } else {
                _node = new Node();
                _node.setInformation(_pair);
                this.object2NodeMap.put(_pair, _node);
            }
            Edge _edge = new Edge();
            _edge.setConstructor(constructor);
            _edge.setSrcNode(mainNode);
            _edge.setDstnNode(_node);
            mainNode.addExitingEdge(_edge);
            _node.addEnteringEdge(_edge);
            _retSet.add(_edge);
        }
        return _retSet;
    }
}

