/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.peq.fsm;

import edu.ksu.cis.indus.peq.fsm.BasicFSM;
import edu.ksu.cis.indus.peq.fsm.EpsTransition;
import edu.ksu.cis.indus.peq.fsm.State;
import edu.ksu.cis.indus.peq.fsm.Transition;
import edu.ksu.cis.peq.fsm.interfaces.IFSM;
import edu.ksu.cis.peq.fsm.interfaces.IState;
import edu.ksu.cis.peq.fsm.interfaces.ITransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EpsClosureConvertor {
    private IFSM fsm;
    private State initialState;

    public EpsClosureConvertor(IFSM fsm) {
        this.fsm = fsm;
    }

    public void processShallow() {
        HashMap _sToEcMap = new HashMap();
        IState _initState = this.fsm.getInitialState();
        this.createEpsFreeAutm(_sToEcMap, _initState, new HashSet());
        this.initialState = (State)_sToEcMap.get(((State)_initState).getEclosure());
        this.postCompute(_sToEcMap);
    }

    public void process() {
        this.preCompute();
        HashMap _sToEcMap = new HashMap();
        IState _initState = this.fsm.getInitialState();
        this.createEpsFreeAutm(_sToEcMap, _initState, new HashSet());
        this.initialState = (State)_sToEcMap.get(((State)_initState).getEclosure());
        this.postCompute(_sToEcMap);
    }

    private void createEpsFreeAutm(Map sToEcMap, IState state, Set reachset) {
        if (!reachset.contains(state)) {
            reachset.add(state);
            State _newState = null;
            Set _eSet = ((State)state).getEclosure();
            if (sToEcMap.containsKey(_eSet)) {
                _newState = (State)sToEcMap.get(_eSet);
            } else {
                _newState = new State();
                sToEcMap.put(((State)state).getEclosure(), _newState);
            }
            Iterator _it = _eSet.iterator();
            while (_it.hasNext()) {
                State _eState = (State)_it.next();
                Set _transSet = _eState.getExitingTransitions();
                Iterator iter = _transSet.iterator();
                while (iter.hasNext()) {
                    ITransition _trans = (ITransition)iter.next();
                    if (_trans instanceof EpsTransition) continue;
                    State _theState = null;
                    State _dstnState = (State)_trans.getDstnState();
                    Object _rObj = sToEcMap.get(_dstnState.getEclosure());
                    if (_rObj == null) {
                        _theState = new State();
                        sToEcMap.put(_dstnState.getEclosure(), _theState);
                    } else {
                        _theState = (State)_rObj;
                    }
                    Transition _t = new Transition();
                    _t.setSrcState(_newState);
                    _t.setDstnState(_theState);
                    _t.setLabel(_trans.getLabel());
                    _newState.addExitingTransitions(_t);
                    _theState.addEnteringTransitions(_t);
                    this.createEpsFreeAutm(sToEcMap, _dstnState, reachset);
                }
            }
        }
    }

    private void preCompute() {
        this.computeEpsilonClosure();
    }

    private void postCompute(Map epsMap) {
        this.computeFinalStates(epsMap);
    }

    private void computeFinalStates(Map epsMap) {
        Set _entrySet = epsMap.entrySet();
        Iterator iter = _entrySet.iterator();
        block0: while (iter.hasNext()) {
            Map.Entry _entry = iter.next();
            Set _epsSet = (Set)_entry.getKey();
            State _state = (State)_entry.getValue();
            Iterator iterator = _epsSet.iterator();
            while (iterator.hasNext()) {
                State _oldState = (State)iterator.next();
                if (!_oldState.isFinalState()) continue;
                _state.setFinal(true);
                continue block0;
            }
        }
    }

    private void computeEpsilonClosure() {
        this.calculateEclosure((State)this.fsm.getInitialState(), new HashSet());
    }

    private void calculateEclosure(State state, HashSet reachSet) {
        if (reachSet.contains(state)) {
            return;
        }
        this.calEclosureForState(state);
        reachSet.add(state);
        Set _transSet = state.getExitingTransitions();
        Iterator iter = _transSet.iterator();
        while (iter.hasNext()) {
            ITransition _trans = (ITransition)iter.next();
            this.calculateEclosure((State)_trans.getDstnState(), reachSet);
        }
    }

    private Set calEclosureForState(State state) {
        if (state.getEclosure().size() > 0) {
            return state.getEclosure();
        }
        HashSet<State> _retSet = new HashSet<State>();
        _retSet.add(state);
        Set _transitionSet = state.getExitingTransitions();
        Iterator iter = _transitionSet.iterator();
        while (iter.hasNext()) {
            ITransition _t = (ITransition)iter.next();
            if (!(_t instanceof EpsTransition)) continue;
            State _newState = (State)_t.getDstnState();
            _retSet.addAll(this.calEclosureForState(_newState));
        }
        state.setEclosure(_retSet);
        return _retSet;
    }

    public IFSM getResult() {
        BasicFSM _bfm = new BasicFSM();
        _bfm.setInitialState(this.initialState);
        return _bfm;
    }
}

