/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.peq.fsm;

import edu.ksu.cis.indus.peq.fsm.BasicFSM;
import edu.ksu.cis.indus.peq.fsm.State;
import edu.ksu.cis.indus.peq.fsm.Transition;
import edu.ksu.cis.peq.constructor.interfaces.IConstructor;
import edu.ksu.cis.peq.fsm.interfaces.IFSM;
import edu.ksu.cis.peq.fsm.interfaces.IState;
import edu.ksu.cis.peq.fsm.interfaces.ITransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EFreeNFA2DFATransformer {
    private IFSM srcAutomata;
    private IFSM dfaAutomata;
    final Map stateSet2NewStateMap = new HashMap();
    private State newInitState;

    public EFreeNFA2DFATransformer(IFSM src) {
        this.srcAutomata = src;
    }

    public void process() {
        this.preprocess();
        this.postprocess();
    }

    private void preprocess() {
        HashSet reachSet = new HashSet();
        IState state = this.srcAutomata.getInitialState();
        HashSet<IState> _initSet = new HashSet<IState>();
        _initSet.add(state);
        this.processForDFA(_initSet, reachSet, this.stateSet2NewStateMap);
        this.newInitState = (State)this.stateSet2NewStateMap.get(_initSet);
    }

    private void processForDFA(Set initSet, Set reachSet, Map stateSet2NewStateMap) {
        if (!reachSet.contains(initSet)) {
            reachSet.add(initSet);
            HashMap<IConstructor, HashSet<IState>> label2StateSetMap = new HashMap<IConstructor, HashSet<IState>>();
            Iterator iter = initSet.iterator();
            while (iter.hasNext()) {
                State _state = (State)iter.next();
                Set _transSet = _state.getExitingTransitions();
                Iterator iterator = _transSet.iterator();
                while (iterator.hasNext()) {
                    ITransition _trans = (ITransition)iterator.next();
                    IConstructor _label = _trans.getLabel();
                    HashSet<IState> _l2SSet = (HashSet<IState>)label2StateSetMap.get(_label);
                    if (_l2SSet == null) {
                        _l2SSet = new HashSet<IState>();
                        label2StateSetMap.put(_label, _l2SSet);
                    }
                    _l2SSet.add(_trans.getDstnState());
                }
            }
            Set _entrySet = label2StateSetMap.entrySet();
            State _srcState = (State)stateSet2NewStateMap.get(initSet);
            if (_srcState == null) {
                _srcState = new State();
                stateSet2NewStateMap.put(initSet, _srcState);
            }
            Iterator iter2 = _entrySet.iterator();
            while (iter2.hasNext()) {
                Map.Entry _entry = iter2.next();
                IConstructor _c = (IConstructor)_entry.getKey();
                Set _stateSet = (Set)_entry.getValue();
                State _dstnState = (State)stateSet2NewStateMap.get(_stateSet);
                if (_dstnState == null) {
                    _dstnState = new State();
                    stateSet2NewStateMap.put(_stateSet, _dstnState);
                }
                Transition _t = new Transition();
                _t.setLabel(_c);
                _t.setSrcState(_srcState);
                _t.setDstnState(_dstnState);
                _srcState.addExitingTransitions(_t);
                _dstnState.addEnteringTransitions(_t);
                this.processForDFA(_stateSet, reachSet, stateSet2NewStateMap);
            }
        }
    }

    private void postprocess() {
        this.markFinalStates();
    }

    private void markFinalStates() {
        Set _entrySet = this.stateSet2NewStateMap.entrySet();
        Iterator iter = _entrySet.iterator();
        block0: while (iter.hasNext()) {
            Map.Entry _entry = iter.next();
            Set _stateSet = (Set)_entry.getKey();
            State _theState = (State)_entry.getValue();
            Iterator iterator = _stateSet.iterator();
            while (iterator.hasNext()) {
                IState _state = (IState)iterator.next();
                if (!_state.isFinalState()) continue;
                _theState.setFinal(true);
                continue block0;
            }
        }
    }

    public IFSM getDfaAutomata() {
        BasicFSM _bfm = new BasicFSM();
        _bfm.setInitialState(this.newInitState);
        return _bfm;
    }
}

