/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.processing;

import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.staticanalyses.dependency.EntryControlDA;
import edu.ksu.cis.indus.tools.slicer.processing.ISlicePostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.Body;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.tagkit.Host;

public final class ExecutableSlicePostProcessor
implements ISlicePostProcessor {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor == null ? (class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor = ExecutableSlicePostProcessor.class$("edu.ksu.cis.indus.tools.slicer.processing.ExecutableSlicePostProcessor")) : class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor));
    private BasicBlockGraphMgr bbgMgr;
    private final Collection processedMethodCache = new HashSet();
    private final Collection processedStmtCache = new HashSet();
    private final IWorkBag methodWorkBag = new HistoryAwareFIFOWorkBag(this.processedMethodCache);
    private final IWorkBag stmtWorkBag = new HistoryAwareFIFOWorkBag(this.processedStmtCache);
    private EntryControlDA cd = new EntryControlDA();
    private SliceCollector collector;
    private boolean stmtCollected;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor;

    public void process(Collection collection, BasicBlockGraphMgr basicBlockGraphMgr, SliceCollector sliceCollector) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Post Processing.");
            LOGGER.debug((Object)("BEFORE SLICE: " + (class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor == null ? (class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor = ExecutableSlicePostProcessor.class$("edu.ksu.cis.indus.tools.slicer.processing.ExecutableSlicePostProcessor")) : class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor).getClass() + "\n" + sliceCollector.toString()));
        }
        this.collector = sliceCollector;
        this.bbgMgr = basicBlockGraphMgr;
        this.cd.setBasicBlockGraphManager(basicBlockGraphMgr);
        this.methodWorkBag.addAllWorkNoDuplicates(collection);
        while (this.methodWorkBag.hasWork()) {
            SootMethod sootMethod = (SootMethod)this.methodWorkBag.getWork();
            this.processMethod(sootMethod);
            if (sootMethod.isConcrete()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Post Processing method " + sootMethod));
                }
                this.stmtCollected = false;
                this.processStmts(sootMethod);
                if (!this.stmtCollected) continue;
                this.pickReturnPoints(sootMethod);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn((Object)("Could not process method " + sootMethod.getSignature()));
        }
        this.fixupClassHierarchy();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("AFTER SLICE: " + (class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor == null ? (class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor = ExecutableSlicePostProcessor.class$("edu.ksu.cis.indus.tools.slicer.processing.ExecutableSlicePostProcessor")) : class$edu$ksu$cis$indus$tools$slicer$processing$ExecutableSlicePostProcessor).getClass() + "\n" + sliceCollector.toString()));
            LOGGER.debug((Object)"END: Post Processing.");
        }
    }

    public void reset() {
        this.methodWorkBag.clear();
        this.processedMethodCache.clear();
    }

    private void fixupClassHierarchy() {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        Object object = this.collector.getClassesInSlice().iterator();
        while (object.hasNext()) {
            hashSet.addAll(Util.getAncestors((SootClass)((SootClass)object.next())));
        }
        this.collector.includeInSlice(hashSet);
        object = this.collector.getClassesInSlice();
        List list = Util.getClassesInTopologicallySortedOrder((Collection)object, (boolean)true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Fixing Class Hierarchy");
            LOGGER.debug((Object)("Topological Sort: " + list));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            Collection collection = this.gatherCollectedAbstractMethodsInSuperClasses(hashMap, sootClass);
            List list2 = sootClass.getMethods();
            List list3 = this.collector.getCollected(list2);
            Collection collection2 = CollectionUtils.subtract((Collection)list2, (Collection)list3);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Fixing up " + sootClass));
            }
            Util.removeMethodsWithSameSignature((Collection)collection, (Collection)list3);
            Util.retainMethodsWithSameSignature((Collection)collection2, (Collection)collection);
            Util.removeMethodsWithSameSignature((Collection)collection, (Collection)collection2);
            this.collector.includeInSlice(collection2);
            if (sootClass.isInterface()) {
                collection.addAll(list3);
            } else if (sootClass.isAbstract()) {
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    SootMethod sootMethod = (SootMethod)iterator2.next();
                    if (!sootMethod.isAbstract()) continue;
                    collection.add(sootMethod);
                }
            }
            if (collection.isEmpty()) continue;
            hashMap.put(sootClass, new ArrayList(collection));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Class -> abstract Method mapping:\n" + hashMap));
            LOGGER.debug((Object)"END: Fixing Class Hierarchy");
        }
    }

    private Collection gatherCollectedAbstractMethodsInSuperClasses(Map map, SootClass sootClass) {
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = sootClass.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Collection collection;
            object = (SootClass)iterator.next();
            if (!this.collector.hasBeenCollected((Host)object) || (collection = (Collection)map.get(object)) == null) continue;
            hashSet.addAll(collection);
        }
        if (sootClass.hasSuperclass() && this.collector.hasBeenCollected((Host)(iterator = sootClass.getSuperclass())) && (object = (Collection)map.get(iterator)) != null) {
            hashSet.addAll(object);
        }
        return hashSet;
    }

    private void pickARandomReturnPoint(Collection collection) {
        Stmt stmt = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            Stmt stmt2 = basicBlock.getTrailerStmt();
            if (stmt2 instanceof ReturnStmt || stmt2 instanceof ReturnVoidStmt) {
                stmt = stmt2;
                break;
            }
            if (stmt2 instanceof ThrowStmt && !(stmt instanceof ReturnStmt) && !(stmt2 instanceof ReturnVoidStmt)) {
                stmt = stmt2;
                continue;
            }
            if (stmt == null) continue;
            stmt = stmt2;
        }
        this.processAndIncludeExitStmt(stmt);
    }

    private void pickReturnPoints(SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Picking return points in " + sootMethod));
        }
        String string = this.collector.getTagName();
        BasicBlockGraph basicBlockGraph = this.bbgMgr.getBasicBlockGraph(sootMethod);
        HashSet hashSet = new HashSet();
        hashSet.addAll(basicBlockGraph.getTails());
        hashSet.addAll(basicBlockGraph.getPseudoTails());
        this.cd.analyze(Collections.singleton(sootMethod));
        if (hashSet.size() == 1) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)hashSet.iterator().next();
            this.processAndIncludeExitStmt(basicBlock.getTrailerStmt());
        } else {
            boolean bl = true;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
                Stmt stmt = basicBlock.getTrailerStmt();
                Collection collection = this.cd.getDependees((Object)stmt, (Object)sootMethod);
                boolean bl3 = bl2 = collection.isEmpty() || !Util.getHostsWithTag((Collection)collection, (String)string).isEmpty();
                if (stmt.hasTag(string) || !bl2) continue;
                this.processAndIncludeExitStmt(stmt);
                bl = false;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Picked " + stmt + " in " + sootMethod));
            }
            if (bl) {
                this.pickARandomReturnPoint(hashSet);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Picking return points in " + sootMethod));
        }
    }

    private void processAndIncludeExitStmt(Stmt stmt) {
        if (stmt instanceof ThrowStmt) {
            this.processThrowStmt((ThrowStmt)stmt);
        }
        this.collector.includeInSlice((Host)stmt);
    }

    private void processHandlers(SootMethod sootMethod, Stmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Pruning handlers " + stmt + "@" + sootMethod));
        }
        Body body = sootMethod.retrieveActiveBody();
        ArrayList arrayList = new ArrayList();
        if (this.collector.hasBeenCollected((Host)stmt)) {
            arrayList.addAll(TrapManager.getTrapsAt((Unit)stmt, (Body)body));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Trap trap = (Trap)iterator.next();
            this.collector.includeInSlice(Util.getAncestors((SootClass)trap.getException()));
            IdentityStmt identityStmt = (IdentityStmt)trap.getHandlerUnit();
            this.collector.includeInSlice((Host)identityStmt);
            this.collector.includeInSlice((Host)identityStmt.getLeftOpBox());
            this.collector.includeInSlice((Host)identityStmt.getRightOpBox());
            this.collector.includeInSlice((Host)trap.getException());
            this.stmtWorkBag.addWorkNoDuplicates((Object)identityStmt);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Pruning handlers " + stmt + "@" + sootMethod));
        }
    }

    private void processMethod(SootMethod sootMethod) {
        HashSet<Type> hashSet = new HashSet<Type>();
        Iterator iterator = Util.findMethodInSuperClassesAndInterfaces((SootMethod)sootMethod).iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod2 = (SootMethod)iterator.next();
            this.collector.includeInSlice((Host)sootMethod2.getDeclaringClass());
            this.collector.includeInSlice((Host)sootMethod2);
            hashSet.clear();
            hashSet.add(sootMethod2.getReturnType());
            hashSet.addAll(sootMethod2.getParameterTypes());
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                Type type;
                Type type2 = (Type)iterator2.next();
                if (type2 instanceof RefType) {
                    this.collector.includeInSlice((Host)((RefType)type2).getSootClass());
                    continue;
                }
                if (!(type2 instanceof ArrayType) || !((type = ((ArrayType)type2).baseType) instanceof RefType)) continue;
                this.collector.includeInSlice((Host)((RefType)type).getSootClass());
            }
            this.methodWorkBag.addWorkNoDuplicates((Object)sootMethod2);
        }
    }

    private void processStmts(SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Picking up identity statements and methods required in" + sootMethod));
        }
        this.stmtWorkBag.clear();
        this.stmtWorkBag.addAllWork((Collection)IteratorUtils.toList((Iterator)this.bbgMgr.getBasicBlockGraph(sootMethod).getStmtGraph().iterator()));
        this.processedStmtCache.clear();
        while (this.stmtWorkBag.hasWork()) {
            Stmt stmt = (Stmt)this.stmtWorkBag.getWork();
            if (stmt instanceof IdentityStmt) {
                IdentityStmt identityStmt = (IdentityStmt)stmt;
                Value value = identityStmt.getRightOp();
                if (!(value instanceof ThisRef) && !(value instanceof ParameterRef)) continue;
                this.collector.includeInSlice((Host)identityStmt.getLeftOpBox());
                this.collector.includeInSlice((Host)identityStmt.getRightOpBox());
                this.collector.includeInSlice((Host)identityStmt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Picked " + identityStmt + " in " + sootMethod));
                }
                this.processHandlers(sootMethod, stmt);
                this.stmtCollected = true;
                continue;
            }
            if (!this.collector.hasBeenCollected((Host)stmt)) continue;
            if (stmt.containsInvokeExpr() && !(stmt.getInvokeExpr() instanceof StaticInvokeExpr)) {
                this.processMethod(stmt.getInvokeExpr().getMethod());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Included method invoked at " + stmt + " in " + sootMethod));
                }
            } else if (stmt instanceof ThrowStmt) {
                this.processThrowStmt((ThrowStmt)stmt);
            }
            this.processHandlers(sootMethod, stmt);
            this.stmtCollected = true;
        }
    }

    private void processThrowStmt(ThrowStmt throwStmt) {
        if (!this.collector.hasBeenCollected((Host)throwStmt.getOpBox())) {
            SootClass sootClass = ((RefType)throwStmt.getOp().getType()).getSootClass();
            this.collector.includeInSlice((Host)sootClass);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Included classes of exception thrown at " + throwStmt));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

