/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer.criteria;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.slicer.CriteriaSpecHelper;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.tools.slicer.criteria.JiBX_MungeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;

final class SliceCriterionSpec
implements Cloneable,
IUnmarshallable,
IMarshallable {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$criteria$SliceCriterionSpec == null ? (class$edu$ksu$cis$indus$tools$slicer$criteria$SliceCriterionSpec = SliceCriterionSpec.class$("edu.ksu.cis.indus.tools.slicer.criteria.SliceCriterionSpec")) : class$edu$ksu$cis$indus$tools$slicer$criteria$SliceCriterionSpec));
    private static final SliceCriteriaFactory CRITERIA_FACTORY = SliceCriteriaFactory.getFactory();
    private List parameterTypeNames = SliceCriterionSpec.createParameterTypeNamesContainer();
    private String className;
    private String methodName;
    private String returnTypeName;
    private boolean considerEntireStmt;
    private boolean considerExecution;
    private int exprIndex = -1;
    private int stmtIndex;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$criteria$SliceCriterionSpec;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.tools.slicer.criteria.JiBX_sliceCriteria_JiBXBindingFactory|";

    private SliceCriterionSpec() {
    }

    public Collection getCriteria(Scene scene) {
        String string;
        this.trim();
        SootClass sootClass = scene.getSootClass(this.className);
        if (sootClass == null) {
            String string2 = this.className + " is not available in the System.";
            LOGGER.error((Object)string2);
            throw new MissingResourceException("Given class not available in the System.", this.className, null);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        SootMethod sootMethod = this.parameterTypeNames.iterator();
        while (sootMethod.hasNext()) {
            string = (String)sootMethod.next();
            arrayList.add(Util.getTypeFor((String)string, (Scene)scene));
        }
        sootMethod = sootClass.getMethod(this.methodName, arrayList, Util.getTypeFor((String)this.returnTypeName, (Scene)scene));
        sootClass.setApplicationClass();
        string = sootMethod.retrieveActiveBody();
        if (string == null) {
            String string3 = this.returnTypeName + " " + this.methodName + "(" + this.parameterTypeNames + ") does not have a body.";
            LOGGER.error((Object)string3);
            throw new IllegalStateException(string3);
        }
        ArrayList arrayList2 = Collections.list(Collections.enumeration(string.getUnits()));
        if (arrayList2.size() < this.stmtIndex + 1) {
            String string4 = this.returnTypeName + " " + this.methodName + "(" + this.parameterTypeNames + ") has only " + arrayList2.size() + " statements. [" + this.stmtIndex + "]";
            LOGGER.error((Object)string4);
            throw new IllegalStateException(string4);
        }
        Stmt stmt = (Stmt)arrayList2.get(this.stmtIndex);
        Collection collection = this.exprIndex == -1 ? CRITERIA_FACTORY.getCriterion(sootMethod, stmt, this.considerEntireStmt, this.considerExecution) : CRITERIA_FACTORY.getCriterion(sootMethod, stmt, (ValueBox)stmt.getUseAndDefBoxes().get(this.exprIndex), this.considerExecution);
        return collection;
    }

    public static List getNamesOfTypes(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Type)iterator.next()).toString());
        }
        return arrayList;
    }

    public String toString() {
        this.trim();
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("returnTypeName", (Object)this.returnTypeName).append("methodName", (Object)this.methodName).append("parameterTypeNames", (Object)this.parameterTypeNames).append("stmtIndex", this.stmtIndex).append("exprIndex", this.exprIndex).append("considerExecution", this.considerExecution).append("considerEntireStmt", this.considerEntireStmt).toString();
    }

    static Collection getCriterionSpec(ISliceCriterion iSliceCriterion) {
        SootMethod sootMethod = CriteriaSpecHelper.getOccurringMethod(iSliceCriterion);
        String string = sootMethod.getDeclaringClass().getJavaStyleName();
        String string2 = sootMethod.getName();
        Body body = sootMethod.retrieveActiveBody();
        if (body == null) {
            String string3 = sootMethod.getSignature() + " does not have a body.";
            LOGGER.error((Object)string3);
            throw new IllegalStateException(string3);
        }
        ArrayList arrayList = Collections.list(Collections.enumeration(body.getUnits()));
        Stmt stmt = CriteriaSpecHelper.getOccurringStmt(iSliceCriterion);
        int n = arrayList.indexOf(stmt);
        boolean bl = CriteriaSpecHelper.isConsiderExecution(iSliceCriterion);
        SliceCriterionSpec sliceCriterionSpec = new SliceCriterionSpec();
        sliceCriterionSpec.className = string;
        sliceCriterionSpec.methodName = string2;
        sliceCriterionSpec.parameterTypeNames = SliceCriterionSpec.getNamesOfTypes(sootMethod.getParameterTypes());
        sliceCriterionSpec.returnTypeName = sootMethod.getReturnType().toString();
        sliceCriterionSpec.stmtIndex = n;
        sliceCriterionSpec.exprIndex = -1;
        sliceCriterionSpec.considerExecution = bl;
        sliceCriterionSpec.considerEntireStmt = false;
        ArrayList<SliceCriterionSpec> arrayList2 = new ArrayList<SliceCriterionSpec>();
        ValueBox valueBox = CriteriaSpecHelper.getOccurringExpr(iSliceCriterion);
        if (valueBox != null) {
            Value value = valueBox.getValue();
            int n2 = value.getUseBoxes().size();
            if (n2 == 0) {
                sliceCriterionSpec.exprIndex = stmt.getUseAndDefBoxes().indexOf(valueBox);
                arrayList2.add(sliceCriterionSpec);
            } else {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    try {
                        SliceCriterionSpec sliceCriterionSpec2 = (SliceCriterionSpec)sliceCriterionSpec.clone();
                        sliceCriterionSpec2.exprIndex = n3--;
                        arrayList2.add(sliceCriterionSpec2);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        LOGGER.error((Object)"Low level Error while creating criterion specification.");
                        throw new IllegalStateException("Low level Error while creating criterion specification.");
                    }
                }
            }
        } else {
            arrayList2.add(sliceCriterionSpec);
        }
        return arrayList2;
    }

    public static List createParameterTypeNamesContainer() {
        return new ArrayList();
    }

    private boolean testExpr() {
        return this.exprIndex != -1;
    }

    private void trim() {
        if (this.className != null) {
            this.className = this.className.trim();
        }
        if (this.methodName != null) {
            this.methodName = this.methodName.trim();
        }
        if (this.returnTypeName != null) {
            this.returnTypeName = this.returnTypeName.trim();
        }
        ListIterator<String> listIterator = this.parameterTypeNames.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (string == null) continue;
            listIterator.remove();
            listIterator.add(string.trim());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static SliceCriterionSpec JiBX_sliceCriteria_JiBXBinding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new SliceCriterionSpec();
    }

    public final void JiBX_sliceCriteria_JiBXBinding_unmarshalAttr_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SliceCriterionSpec sliceCriterionSpec = this;
        this.considerExecution = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "considerExecution");
        arg1.popObject();
    }

    public final void JiBX_sliceCriteria_JiBXBinding_unmarshal_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SliceCriterionSpec sliceCriterionSpec = this;
        this.className = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "className");
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "method");
        this.methodName = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "methodName");
        this.returnTypeName = arg1.parseElementText("http://indus.projects.cis.ksu.edu/slicer", "returnTypeName");
        List list = JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_newinstance_1_1(arg1);
        JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_unmarshal_1_1(list, arg1);
        this.parameterTypeNames = list;
        arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "method");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
        this.stmtIndex = arg1.attributeInt("http://indus.projects.cis.ksu.edu/slicer", "index");
        this.considerEntireStmt = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "considerEntireStmt");
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
        arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "stmt");
        if (arg1.isAt("http://indus.projects.cis.ksu.edu/slicer", "expr")) {
            arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
            this.exprIndex = arg1.attributeInt("http://indus.projects.cis.ksu.edu/slicer", "index", -1);
            arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
            arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "expr");
        }
        arg1.popObject();
    }

    public void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(1).unmarshal((Object)this, arg1);
    }

    public final void JiBX_sliceCriteria_JiBXBinding_marshalAttr_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(2, "considerExecution", Utility.serializeBoolean((boolean)this.considerExecution));
        arg1.popObject();
    }

    public final void JiBX_sliceCriteria_JiBXBinding_marshal_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        int[] nArray = new int[]{2};
        String[] stringArray = new String[]{"slicer"};
        MarshallingContext marshallingContext = arg1.element(2, "className", this.className).element(2, "methodName", this.methodName).element(2, "returnTypeName", this.returnTypeName);
        JiBX_MungeAdapter.JiBX_sliceCriteria_JiBXBinding_marshal_1_1(this.parameterTypeNames, arg1);
        marshallingContext.endTag(2, "method");
        MarshallingContext marshallingContext2 = arg1.startTagNamespaces(2, "stmt", new int[]{2}, new String[]{"slicer"});
        arg1.startTagNamespaces(2, "method", nArray, stringArray).closeStartContent().attribute(2, "index", Utility.serializeInt((int)this.stmtIndex)).attribute(2, "considerEntireStmt", Utility.serializeBoolean((boolean)this.considerEntireStmt)).closeStartEmpty();
        if (this.testExpr()) {
            MarshallingContext marshallingContext3 = marshallingContext2;
            marshallingContext2 = arg1.startTagNamespaces(2, "expr", new int[]{2}, new String[]{"slicer"});
            int n = this.exprIndex;
            if (n != -1) {
                marshallingContext3 = marshallingContext3.attribute(2, "index", Utility.serializeInt((int)n));
            }
            marshallingContext3.closeStartEmpty();
        }
        arg1.popObject();
    }

    public void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(1, "edu.ksu.cis.indus.tools.slicer.criteria.SliceCriterionSpec").marshal((Object)this, arg1);
    }

    public int JiBX_getIndex() {
        return 1;
    }
}

