/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class TagBasedSliceXMLizer
extends AbstractXMLizer {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$TagBasedSliceXMLizer == null ? (class$edu$ksu$cis$indus$tools$slicer$TagBasedSliceXMLizer = TagBasedSliceXMLizer.class$("edu.ksu.cis.indus.tools.slicer.TagBasedSliceXMLizer")) : class$edu$ksu$cis$indus$tools$slicer$TagBasedSliceXMLizer));
    final String tagName;
    private final TagBasedSliceProcessor processor;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$TagBasedSliceXMLizer;

    public TagBasedSliceXMLizer(String string, IJimpleIDGenerator iJimpleIDGenerator) {
        this.setGenerator(iJimpleIDGenerator);
        this.processor = new TagBasedSliceProcessor(iJimpleIDGenerator);
        this.tagName = string;
    }

    public String getFileName(String string) {
        String string2 = TagBasedSliceXMLizer.xmlizeString((String)string);
        string2 = string2.length() == 0 ? "slice.xml" : "slice_" + string2 + ".xml";
        return string2;
    }

    public void writeXML(Map map) {
        ProcessingController processingController = new ProcessingController();
        processingController.setStmtGraphFactory((IStmtGraphFactory)map.get(IStmtGraphFactory.ID));
        processingController.setEnvironment((IEnvironment)map.get("The Environment"));
        TagBasedProcessingFilter tagBasedProcessingFilter = new TagBasedProcessingFilter(this.tagName);
        tagBasedProcessingFilter.chain((IProcessingFilter)new XMLizingProcessingFilter());
        processingController.setProcessingFilter((IProcessingFilter)tagBasedProcessingFilter);
        try {
            File file = new File(this.getXmlOutputDir() + File.separator + this.getFileName((String)map.get(FILE_NAME_ID)));
            FileWriter fileWriter = new FileWriter(file);
            this.processor.writer = new CustomXMLOutputter((Writer)fileWriter);
            this.processor.hookup(processingController);
            processingController.process();
            this.processor.unhook(processingController);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Error while xmlizing slice information ", (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TagBasedSliceProcessor
    extends AbstractProcessor {
        protected XMLOutputter writer;
        private final IJimpleIDGenerator idGenerator;
        private boolean processingClass;
        private boolean processingMethod;
        private boolean processingStmt;

        public TagBasedSliceProcessor(IJimpleIDGenerator iJimpleIDGenerator) {
            this.idGenerator = iJimpleIDGenerator;
        }

        public void callback(ValueBox valueBox, Context context) {
            SootMethod sootMethod = context.getCurrentMethod();
            Stmt stmt = context.getStmt();
            try {
                NamedTag namedTag = (NamedTag)valueBox.getTag(TagBasedSliceXMLizer.this.tagName);
                if (namedTag != null) {
                    this.writer.startTag("value");
                    this.writer.attribute("id", this.idGenerator.getIdForValueBox(valueBox, stmt, sootMethod));
                    this.writer.endTag();
                }
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Exception while writing information about " + valueBox + " occurring in " + stmt + " and " + sootMethod.getSignature()), (Throwable)iOException);
            }
        }

        public void callback(Stmt stmt, Context context) {
            SootMethod sootMethod = context.getCurrentMethod();
            try {
                NamedTag namedTag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if ((namedTag = (NamedTag)stmt.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("stmt");
                    this.writer.attribute("id", this.idGenerator.getIdForStmt(stmt, sootMethod));
                    this.processingStmt = true;
                }
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Exception while writing information about " + stmt + " occurring in " + sootMethod.getSignature()), (Throwable)iOException);
            }
        }

        public void callback(SootMethod sootMethod) {
            try {
                NamedTag namedTag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if (this.processingMethod) {
                    this.writer.endTag();
                    this.processingMethod = false;
                }
                if ((namedTag = (NamedTag)sootMethod.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("method");
                    this.writer.attribute("id", this.idGenerator.getIdForMethod(sootMethod));
                    this.processingMethod = true;
                }
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Exception while writing xml information about " + sootMethod.getSignature()), (Throwable)iOException);
            }
        }

        public void callback(SootClass sootClass) {
            try {
                NamedTag namedTag;
                if (this.processingStmt) {
                    this.writer.endTag();
                    this.processingStmt = false;
                }
                if (this.processingMethod) {
                    this.writer.endTag();
                    this.processingMethod = false;
                }
                if (this.processingClass) {
                    this.writer.endTag();
                    this.processingClass = false;
                }
                if ((namedTag = (NamedTag)sootClass.getTag(TagBasedSliceXMLizer.this.tagName)) != null) {
                    this.writer.startTag("class");
                    this.writer.attribute("id", this.idGenerator.getIdForClass(sootClass));
                    this.processingClass = true;
                }
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Exception while writing xml information about " + sootClass.getName()), (Throwable)iOException);
            }
        }

        public void callback(SootField sootField) {
            NamedTag namedTag = (NamedTag)sootField.getTag(TagBasedSliceXMLizer.this.tagName);
            if (namedTag != null) {
                try {
                    this.writer.startTag("field");
                    this.writer.attribute("id", this.idGenerator.getIdForField(sootField));
                    this.writer.endTag();
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)("Exception while writing xml information about " + sootField.getSignature()), (Throwable)iOException);
                }
            }
        }

        public void consolidate() {
            try {
                this.writer.endDocument();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Exception while finishing up writing xml information.", (Throwable)iOException);
            }
        }

        public void hookup(ProcessingController processingController) {
            processingController.registerForAllStmts((IProcessor)this);
            processingController.register((IProcessor)this);
            processingController.registerForAllValues((IProcessor)this);
        }

        public void processingBegins() {
            try {
                this.writer.declaration();
                this.writer.startTag("system");
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Exception while starting up writing xml information.", (Throwable)iOException);
            }
        }

        public void unhook(ProcessingController processingController) {
            processingController.unregisterForAllStmts((IProcessor)this);
            processingController.unregister((IProcessor)this);
            processingController.unregisterForAllValues((IProcessor)this);
        }
    }
}

