/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.INewExpr2InitMapper;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.slicer.AbstractSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.BackwardSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.CompleteSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.ForwardSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.AliasedUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.NewExpr2InitMapper;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.tools.AbstractTool;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.CompositeToolConfigurator;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.slicer.SlicerConfiguration;
import edu.ksu.cis.indus.tools.slicer.SlicerConfigurator;
import edu.ksu.cis.indus.tools.slicer.processing.ExecutableSlicePostProcessor;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.Stmt;

public final class SlicerTool
extends AbstractTool {
    public static final Object DEPENDENCE_MAJOR_PHASE;
    public static final Object SLICE_MAJOR_PHASE;
    public static final String FLOW_ANALYSIS_TAG_NAME = "indus.tools.slicer.SlicerTool:FA";
    private static final Log LOGGER;
    private static final int INDENT = 4;
    private final AnalysesController daController;
    private final BasicBlockGraphMgr bbgMgr;
    private final CallGraph callGraph;
    private final Collection criteria;
    private final Collection rootMethods;
    private final IStmtGraphFactory stmtGraphFactory;
    private final OFAnalyzer ofa;
    private Phase phase = Phase.createPhase();
    private final SlicingEngine engine;
    private final ThreadGraph threadGraph;
    private final ValueAnalyzerBasedProcessingController cgBasedPreProcessCtrl;
    private final ValueAnalyzerBasedProcessingController cgPreProcessCtrl;
    private Scene system;
    private final SliceCriteriaFactory criteriaFactory;
    private AliasedUseDefInfo aliasUD;
    private EquivalenceClassBasedEscapeAnalysis ecba;
    private NewExpr2InitMapper initMapper;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$SlicerTool;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$CompositeToolConfiguration;

    public SlicerTool(ITokenManager iTokenManager, IStmtGraphFactory iStmtGraphFactory) {
        this.rootMethods = new HashSet();
        this.criteria = new HashSet();
        this.ofa = OFAnalyzer.getFSOSAnalyzer((String)FLOW_ANALYSIS_TAG_NAME, (ITokenManager)iTokenManager);
        this.stmtGraphFactory = iStmtGraphFactory;
        this.cgPreProcessCtrl = new ValueAnalyzerBasedProcessingController();
        this.cgPreProcessCtrl.setAnalyzer((IValueAnalyzer)this.ofa);
        this.cgPreProcessCtrl.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(FLOW_ANALYSIS_TAG_NAME));
        this.cgPreProcessCtrl.setStmtGraphFactory(this.getStmtGraphFactory());
        this.callGraph = new CallGraph();
        this.cgBasedPreProcessCtrl = new ValueAnalyzerBasedProcessingController();
        this.cgBasedPreProcessCtrl.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter((ICallGraphInfo)this.callGraph));
        this.cgBasedPreProcessCtrl.setAnalyzer((IValueAnalyzer)this.ofa);
        this.cgBasedPreProcessCtrl.setStmtGraphFactory(this.getStmtGraphFactory());
        this.bbgMgr = new BasicBlockGraphMgr();
        this.bbgMgr.setUnitGraphFactory(this.getStmtGraphFactory());
        this.threadGraph = new ThreadGraph((ICallGraphInfo)this.callGraph, new CFGAnalysis((ICallGraphInfo)this.callGraph, this.bbgMgr));
        this.ecba = new EquivalenceClassBasedEscapeAnalysis((ICallGraphInfo)this.callGraph, (IThreadGraphInfo)this.threadGraph, this.bbgMgr);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.aliasUD = new AliasedUseDefInfov2((IValueAnalyzer)this.ofa, (ICallGraphInfo)this.callGraph, this.bbgMgr);
        hashMap.put("Callgraph Information", this.callGraph);
        hashMap.put("Threadgraph Information", this.threadGraph);
        hashMap.put("The Environment", this.ofa.getEnvironment());
        hashMap.put("Aliased Use-Def Information", this.aliasUD);
        hashMap.put("Pair management service", new Pair.PairManager());
        hashMap.put(IValueAnalyzer.ID, this.ofa);
        hashMap.put("Shared Access Information", this.ecba);
        this.daController = new AnalysesController(hashMap, (ProcessingController)this.cgBasedPreProcessCtrl, this.bbgMgr);
        this.engine = new SlicingEngine();
        this.initMapper = new NewExpr2InitMapper();
        this.criteriaFactory = SliceCriteriaFactory.getFactory();
    }

    public void setActiveConfiguration(String string) {
        if (this.configurationInfo instanceof CompositeToolConfiguration) {
            ((CompositeToolConfiguration)this.configurationInfo).setActiveToolConfigurationID(string);
        }
    }

    public ICallGraphInfo getCallGraph() {
        return this.callGraph;
    }

    public void setCriteria(Collection collection) {
        this.criteria.clear();
        this.criteria.addAll(collection);
    }

    public Collection getCriteria() {
        return this.criteria;
    }

    public Collection getDAs() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.getActiveConfiguration();
        ArrayList arrayList = new ArrayList(slicerConfiguration.getIDsOfDAsToUse());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            linkedHashSet.addAll(slicerConfiguration.getDependenceAnalysis(iterator.next()));
        }
        return linkedHashSet;
    }

    public Object getPhase() {
        return this.phase;
    }

    public void setRootMethods(Collection collection) {
        this.rootMethods.clear();
        this.rootMethods.addAll(collection);
    }

    public Collection getRootMethods() {
        return Collections.unmodifiableCollection(this.rootMethods);
    }

    public IStmtGraphFactory getStmtGraphFactory() {
        return this.stmtGraphFactory;
    }

    public void setSystem(Scene scene) {
        this.system = scene;
    }

    public Scene getSystem() {
        return this.system;
    }

    public void setTagName(String string) {
        this.engine.setTagName(string);
    }

    public boolean destringizeConfiguration(String string) {
        IUnmarshallingContext iUnmarshallingContext;
        boolean bl = false;
        try {
            IBindingFactory iBindingFactory = BindingDirectory.getFactory((Class)(class$edu$ksu$cis$indus$tools$CompositeToolConfiguration == null ? (class$edu$ksu$cis$indus$tools$CompositeToolConfiguration = SlicerTool.class$("edu.ksu.cis.indus.tools.CompositeToolConfiguration")) : class$edu$ksu$cis$indus$tools$CompositeToolConfiguration));
            iUnmarshallingContext = iBindingFactory.createUnmarshallingContext();
        }
        catch (JiBXException jiBXException) {
            LOGGER.fatal((Object)"Error while setting up JiBX.  Aborting.", (Throwable)jiBXException);
            throw new RuntimeException(jiBXException);
        }
        this.configurationInfo = null;
        if (string != null && string.length() != 0) {
            try {
                StringReader stringReader = new StringReader(string);
                this.configurationInfo = (IToolConfiguration)iUnmarshallingContext.unmarshalDocument((Reader)stringReader, null);
                bl = true;
            }
            catch (JiBXException jiBXException) {
                LOGGER.error((Object)"Error while unmarshalling Slicer configurationCollection. Recovering with new clean configuration.", (Throwable)jiBXException);
                this.configurationInfo = null;
            }
        }
        if (this.configurationInfo == null) {
            this.initialize();
        }
        this.configurator = new CompositeToolConfigurator((CompositeToolConfiguration)this.configurationInfo, (IToolConfigurator)new SlicerConfigurator(), SlicerConfiguration.getFactory());
        return bl;
    }

    public void execute(Object object) throws InterruptedException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Execution of the slicer tool");
        }
        Phase phase = this.phase;
        if (object != null && ((Phase)object).isEarlierThan(this.phase)) {
            phase = this.phase = (Phase)((Phase)object).clone();
        }
        if (phase.equalsMajor(Phase.STARTING_PHASE)) {
            this.lowLevelAnalysisPhase();
        }
        this.movingToNextPhase();
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.getActiveConfiguration();
        if (phase.equalsMajor((Phase)DEPENDENCE_MAJOR_PHASE)) {
            this.dependencyAnalysisPhase(slicerConfiguration);
        }
        this.movingToNextPhase();
        if (phase.equalsMajor((Phase)SLICE_MAJOR_PHASE)) {
            this.slicingPhase(slicerConfiguration);
        }
        this.phase.finished();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Execution of the slicer tool");
        }
    }

    public void initialize() {
        this.configurationInfo = new CompositeToolConfiguration();
        IToolConfiguration iToolConfiguration = SlicerConfiguration.getFactory().createToolConfiguration();
        iToolConfiguration.initialize();
        ((CompositeToolConfiguration)this.configurationInfo).addToolConfiguration(iToolConfiguration);
    }

    public void reset() {
        this.phase.reset();
        this.daController.reset();
        this.aliasUD.reset();
        this.bbgMgr.reset();
        this.callGraph.reset();
        this.cgBasedPreProcessCtrl.reset();
        this.cgPreProcessCtrl.reset();
        this.initMapper.reset();
        this.ecba.reset();
        this.ofa.reset();
        this.engine.reset();
        this.stmtGraphFactory.reset();
        this.threadGraph.reset();
        this.criteria.clear();
        this.rootMethods.clear();
    }

    public String stringizeConfiguration() {
        StringWriter stringWriter = new StringWriter();
        try {
            IBindingFactory iBindingFactory = BindingDirectory.getFactory((Class)(class$edu$ksu$cis$indus$tools$CompositeToolConfiguration == null ? (class$edu$ksu$cis$indus$tools$CompositeToolConfiguration = SlicerTool.class$("edu.ksu.cis.indus.tools.CompositeToolConfiguration")) : class$edu$ksu$cis$indus$tools$CompositeToolConfiguration));
            IMarshallingContext iMarshallingContext = iBindingFactory.createMarshallingContext();
            iMarshallingContext.setIndent(4);
            iMarshallingContext.marshalDocument((Object)this.configurationInfo, "UTF-8", null, (Writer)stringWriter);
        }
        catch (JiBXException jiBXException) {
            LOGGER.error((Object)"Error while marshalling Slicer configurationCollection.");
            throw new RuntimeException(jiBXException);
        }
        return stringWriter.toString();
    }

    protected void checkConfiguration() {
        IToolConfiguration iToolConfiguration = this.getActiveConfiguration();
        if (((Boolean)iToolConfiguration.getProperty(SlicerConfiguration.EXECUTABLE_SLICE)).booleanValue() && iToolConfiguration.getProperty(SlicerConfiguration.SLICE_TYPE).equals(SlicingEngine.FORWARD_SLICE)) {
            LOGGER.error((Object)"Forward Executable slice is unsupported.");
            throw new IllegalStateException("Forward Executable slice is unsupported.");
        }
    }

    private void dependencyAnalysisPhase(SlicerConfiguration slicerConfiguration) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: dependence analyses phase");
        }
        this.daController.reset();
        Iterator iterator = slicerConfiguration.getIDsOfDAsToUse().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Collection collection = slicerConfiguration.getDependenceAnalysis(e);
            this.daController.addAnalyses(e, collection);
        }
        this.daController.initialize();
        this.daController.execute();
        this.phase.nextMajorPhase();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: dependence analyses phase");
        }
    }

    private void generateDeadlockCriteria(IMonitorInfo iMonitorInfo) {
        HashSet hashSet = new HashSet();
        Iterator iterator = iMonitorInfo.getMonitorTriples().iterator();
        while (iterator.hasNext()) {
            Object object;
            Triple triple = (Triple)iterator.next();
            SootMethod sootMethod = (SootMethod)triple.getThird();
            if (!sootMethod.getDeclaringClass().isApplicationClass()) continue;
            hashSet.clear();
            if (triple.getFirst() == null) {
                object = this.bbgMgr.getBasicBlockGraph(sootMethod);
                if (object == null) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn((Object)("Could not retrieve the basic block graph for " + sootMethod.getSignature() + ".  Moving on."));
                    continue;
                }
                BasicBlockGraph.BasicBlock basicBlock = object.getHead();
                if (basicBlock != null) {
                    hashSet.addAll(this.criteriaFactory.getCriterion(sootMethod, basicBlock.getLeaderStmt(), false));
                    Iterator iterator2 = object.getTails().iterator();
                    while (iterator2.hasNext()) {
                        BasicBlockGraph.BasicBlock basicBlock2 = (BasicBlockGraph.BasicBlock)iterator2.next();
                        Stmt stmt = basicBlock2.getTrailerStmt();
                        hashSet.addAll(this.criteriaFactory.getCriterion(sootMethod, stmt, false));
                    }
                } else {
                    LOGGER.error((Object)("Skipping slicing criteria generation for " + sootMethod + " as it has 0 or more than 1 head."));
                }
            } else {
                object = this.criteriaFactory.getCriterion(sootMethod, (Stmt)triple.getFirst(), true, true);
                hashSet.addAll(object);
                object = this.criteriaFactory.getCriterion(sootMethod, (Stmt)triple.getSecond(), true, true);
                hashSet.addAll(object);
            }
            this.criteria.addAll(hashSet);
        }
    }

    private void lowLevelAnalysisPhase() throws InterruptedException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: low level static analyses phase");
        }
        this.phase.reset();
        this.ofa.reset();
        this.bbgMgr.reset();
        this.stmtGraphFactory.reset();
        this.ofa.analyze(this.system, this.rootMethods);
        this.phase.nextMinorPhase();
        this.movingToNextPhase();
        this.callGraph.reset();
        this.cgPreProcessCtrl.reset();
        this.callGraph.hookup((ProcessingController)this.cgPreProcessCtrl);
        this.cgPreProcessCtrl.process();
        this.callGraph.unhook((ProcessingController)this.cgPreProcessCtrl);
        this.phase.nextMinorPhase();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Call Graph:\n" + this.callGraph.dumpGraph()));
        }
        this.movingToNextPhase();
        this.threadGraph.reset();
        this.cgBasedPreProcessCtrl.reset();
        this.initMapper.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.threadGraph.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.cgBasedPreProcessCtrl.process();
        this.threadGraph.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.initMapper.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.phase.nextMinorPhase();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Thread Graph:\n" + this.threadGraph.dumpGraph()));
        }
        this.movingToNextPhase();
        this.cgBasedPreProcessCtrl.reset();
        this.ecba.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.aliasUD.reset();
        this.aliasUD.hookup((ProcessingController)this.cgBasedPreProcessCtrl);
        this.cgBasedPreProcessCtrl.process();
        this.aliasUD.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.ecba.unhook((ProcessingController)this.cgBasedPreProcessCtrl);
        this.ecba.analyze();
        this.phase.nextMajorPhase();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: low level static analyses phase");
        }
    }

    private void populateDeadlockCriteria() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Populating deadlock criteria.");
        }
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.getActiveConfiguration();
        Collection collection = slicerConfiguration.getDependenceAnalysis(IDependencyAnalysis.SYNCHRONIZATION_DA);
        IMonitorInfo iMonitorInfo = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IMonitorInfo)) continue;
            iMonitorInfo = (IMonitorInfo)e;
            break;
        }
        if (iMonitorInfo == null) {
            throw new IllegalStateException("This implementation requires atleast one Synchronization dependence analysis to implement IMonitorInfo interface.");
        }
        this.generateDeadlockCriteria(iMonitorInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Populating deadlock criteria. - " + this.criteria));
        }
    }

    private void postProcessSlice() {
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.getActiveConfiguration();
        if (((Boolean)slicerConfiguration.getProperty(SlicerConfiguration.EXECUTABLE_SLICE)).booleanValue()) {
            ExecutableSlicePostProcessor executableSlicePostProcessor = new ExecutableSlicePostProcessor();
            String string = slicerConfiguration.getSliceType();
            SliceCollector sliceCollector = this.engine.getCollector();
            Collection collection = sliceCollector.getMethodsInSlice();
            AbstractSliceGotoProcessor abstractSliceGotoProcessor = null;
            if (string.equals(SlicingEngine.FORWARD_SLICE)) {
                abstractSliceGotoProcessor = new ForwardSliceGotoProcessor(sliceCollector);
            } else if (string.equals(SlicingEngine.BACKWARD_SLICE)) {
                abstractSliceGotoProcessor = new BackwardSliceGotoProcessor(sliceCollector);
            } else if (string.equals(SlicingEngine.COMPLETE_SLICE)) {
                abstractSliceGotoProcessor = new CompleteSliceGotoProcessor(sliceCollector);
            }
            executableSlicePostProcessor.process(collection, this.bbgMgr, sliceCollector);
            abstractSliceGotoProcessor.process(collection, this.bbgMgr);
        }
    }

    private void slicingPhase(SlicerConfiguration slicerConfiguration) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: slicing phase");
        }
        this.engine.reset();
        if (slicerConfiguration.sliceForDeadlock) {
            this.populateDeadlockCriteria();
        }
        if (!this.criteria.isEmpty()) {
            this.engine.setCgi((ICallGraphInfo)this.callGraph);
            this.engine.setSliceType(slicerConfiguration.getProperty(SlicerConfiguration.SLICE_TYPE));
            this.engine.setInitMapper((INewExpr2InitMapper)this.initMapper);
            this.engine.setBasicBlockGraphManager(this.bbgMgr);
            this.engine.setAnalysesControllerAndDependenciesToUse(this.daController, slicerConfiguration.getIDsOfDAsToUse());
            this.engine.setSliceCriteria(this.criteria);
            this.engine.initialize();
            this.engine.slice();
            this.postProcessSlice();
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)"No slicing criteria were specified. Hence, no slicing was done.\nIf \"slice for deadlock\" was selected then the system did not have any synchronized methods are blocks.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: slicing phase");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Phase phase = Phase.createPhase();
        phase.nextMajorPhase();
        DEPENDENCE_MAJOR_PHASE = (Phase)phase.clone();
        phase.nextMajorPhase();
        SLICE_MAJOR_PHASE = (Phase)phase.clone();
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$SlicerTool == null ? (class$edu$ksu$cis$indus$tools$slicer$SlicerTool = SlicerTool.class$("edu.ksu.cis.indus.tools.slicer.SlicerTool")) : class$edu$ksu$cis$indus$tools$slicer$SlicerTool));
    }
}

