/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.AbstractXMLBasedTestSetup;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.XMLBasedDependencyAnalysisTest;
import edu.ksu.cis.indus.tools.slicer.SliceXMLizerCLI;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.G;

public class SlicerTestSetup
extends AbstractXMLBasedTestSetup {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$SlicerTestSetup == null ? (class$edu$ksu$cis$indus$tools$slicer$SlicerTestSetup = SlicerTestSetup.class$("edu.ksu.cis.indus.tools.slicer.SlicerTestSetup")) : class$edu$ksu$cis$indus$tools$slicer$SlicerTestSetup));
    SliceXMLizerCLI driver = new SliceXMLizerCLI();
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$SlicerTestSetup;

    public SlicerTestSetup(TestSuite testSuite, String[] stringArray, String string, String string2, String string3) {
        super(testSuite);
        this.driver.setOutputDirectory(string);
        if (string3 != null) {
            this.driver.addToSootClassPath(string3);
        }
        this.driver.setClassNames(Arrays.asList(stringArray));
        this.setXMLControlDir(string2);
        this.setXMLTestDir(string);
    }

    protected void setUp() throws Exception {
        this.driver.setIDGenerator(this.idGenerator);
        this.driver.initialize();
        this.driver.slicer.destringizeConfiguration(this.stringizeConfig());
        this.driver.execute();
        TestSuite testSuite = (TestSuite)this.getTest();
        DependencyXMLizer dependencyXMLizer = new DependencyXMLizer();
        ICallGraphInfo iCallGraphInfo = this.driver.slicer.getCallGraph();
        Environment environment = new Environment(this.driver.slicer.getSystem());
        Iterator iterator = this.driver.slicer.getDAs().iterator();
        while (iterator.hasNext()) {
            IDependencyAnalysis iDependencyAnalysis = (IDependencyAnalysis)iterator.next();
            XMLBasedDependencyAnalysisTest xMLBasedDependencyAnalysisTest = new XMLBasedDependencyAnalysisTest(iDependencyAnalysis, dependencyXMLizer);
            xMLBasedDependencyAnalysisTest.setCallGraph(iCallGraphInfo);
            xMLBasedDependencyAnalysisTest.setEnvironment((IEnvironment)environment);
            testSuite.addTest((Test)xMLBasedDependencyAnalysisTest);
        }
        this.setStmtGraphFactory(this.driver.slicer.getStmtGraphFactory());
        super.setUp();
        TestHelper.appendSuiteNameToTestsIn((TestSuite)testSuite, (boolean)true);
    }

    protected void tearDown() throws Exception {
        this.driver.destructivelyUpdateJimple();
        if (this.dumpLocation != null) {
            this.driver.jimpleXMLDumpDir = this.dumpLocation;
            this.driver.dumpJimpleAsXML("");
        }
        G.reset();
        this.driver.slicer.reset();
        Iterator iterator = this.driver.slicer.getDAs().iterator();
        while (iterator.hasNext()) {
            ((IDependencyAnalysis)iterator.next()).reset();
        }
        this.driver = null;
        super.tearDown();
    }

    private String stringizeConfig() {
        InputStreamReader inputStreamReader = null;
        URL uRL = ClassLoader.getSystemResource("edu/ksu/cis/indus/tools/slicer/default_slicer_configuration.xml");
        try {
            inputStreamReader = new InputStreamReader(uRL.openStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.fatal((Object)"Even default configuration file could not be found.  Aborting", (Throwable)fileNotFoundException);
            throw new RuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.fatal((Object)"Could not retrieve a handle to default configuration file.  Aborting.", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine());
            }
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            LOGGER.fatal((Object)"IO error while reading configuration file.  Aborting", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

