/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.tools.AbstractToolConfigurator;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.slicer.SlicerConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public final class SlicerConfigurator
extends AbstractToolConfigurator {
    SlicerConfigurator() {
    }

    protected void checkConfiguration(IToolConfiguration iToolConfiguration) {
        if (!(iToolConfiguration instanceof SlicerConfiguration)) {
            throw new RuntimeException("The toolConfiguration has to be of type edu.ksu.cis.indus.tools.slicer.SlicerConfiguration.");
        }
    }

    protected void setup() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.parent.setLayout((Layout)gridLayout);
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.configuration;
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        Button button = new Button(this.parent, 32);
        button.setText("Slice for Deadlock");
        button.setLayoutData((Object)gridData);
        button.setSelection(slicerConfiguration.sliceForDeadlock);
        AbstractToolConfigurator.BooleanPropertySelectionListener booleanPropertySelectionListener = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.SLICE_FOR_DEADLOCK, button, (IToolConfiguration)slicerConfiguration);
        button.addSelectionListener((SelectionListener)booleanPropertySelectionListener);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        button = new Button(this.parent, 32);
        button.setText("Executable slice");
        button.setLayoutData((Object)gridData);
        button.setSelection(slicerConfiguration.sliceForDeadlock);
        booleanPropertySelectionListener = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.EXECUTABLE_SLICE, button, (IToolConfiguration)slicerConfiguration);
        button.addSelectionListener((SelectionListener)booleanPropertySelectionListener);
        this.setupRow2();
        this.setupRow3();
        this.setupRow4();
        this.parent.pack();
    }

    private void setupRow2() {
        final SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.configuration;
        Group group = new Group(this.parent, 16);
        group.setText("Slice Type");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        group.setLayout((Layout)rowLayout);
        final Button button = new Button((Composite)group, 16);
        button.setText("Backward slice");
        final Button button2 = new Button((Composite)group, 16);
        button2.setText("Forward slice");
        final Button button3 = new Button((Composite)group, 16);
        button3.setText("Complete slice");
        Object object = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = null;
                if (selectionEvent.widget == button) {
                    object = SlicingEngine.BACKWARD_SLICE;
                } else if (selectionEvent.widget == button3) {
                    object = SlicingEngine.COMPLETE_SLICE;
                } else if (selectionEvent.widget == button2) {
                    object = SlicingEngine.FORWARD_SLICE;
                }
                if (object != null) {
                    slicerConfiguration.setProperty(SlicerConfiguration.SLICE_TYPE, object);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        };
        button.addSelectionListener(object);
        button3.addSelectionListener(object);
        button2.addSelectionListener(object);
        Object object2 = slicerConfiguration.getSliceType();
        if (object2.equals(SlicingEngine.BACKWARD_SLICE)) {
            button.setSelection(true);
        } else if (object2.equals(SlicingEngine.COMPLETE_SLICE)) {
            button3.setSelection(true);
        } else if (object2.equals(SlicingEngine.FORWARD_SLICE)) {
            button2.setSelection(true);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        group = new Group(this.parent, 16);
        group.setText("Precision of Interference dependence");
        group.setLayoutData((Object)gridData);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        group.setLayout((Layout)rowLayout);
        final Button button4 = new Button((Composite)group, 16);
        button4.setText("use type-based analysis");
        final Button button5 = new Button((Composite)group, 16);
        button5.setText("use equivalence class-based analysis");
        final Button button6 = new Button((Composite)group, 16);
        button6.setText("use sybmol and equivalence class-based analysis");
        Button button7 = new Button((Composite)group, 32);
        button7.setText("use object flow analysis information");
        object = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_OFA_FOR_INTERFERENCE_DA, button7, (IToolConfiguration)slicerConfiguration);
        button7.addSelectionListener(object);
        object = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = null;
                if (selectionEvent.widget == button5) {
                    object = SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO;
                } else if (selectionEvent.widget == button6) {
                    object = SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO;
                } else if (selectionEvent.widget == button4) {
                    object = SlicerConfiguration.TYPE_BASED_INFO;
                }
                if (object != null) {
                    slicerConfiguration.setProperty(SlicerConfiguration.NATURE_OF_INTERFERENCE_DA, object);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        };
        button5.addSelectionListener(object);
        button6.addSelectionListener(object);
        button4.addSelectionListener(object);
        object2 = slicerConfiguration.getProperty(SlicerConfiguration.NATURE_OF_INTERFERENCE_DA);
        if (object2 == null || object2.equals(SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            button6.setSelection(true);
        } else if (object2.equals(SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO)) {
            button5.setSelection(true);
        } else if (object2.equals(SlicerConfiguration.TYPE_BASED_INFO)) {
            button4.setSelection(true);
        }
        Boolean bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_RULE4_IN_READYDA);
        button7.setSelection(bl.booleanValue());
    }

    private void setupRow3() {
        SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.configuration;
        GridData gridData = new GridData(1056);
        gridData.horizontalSpan = 2;
        Group group = new Group(this.parent, 16);
        group.setText("Divergence dependence");
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        final Button button = new Button((Composite)group, 32);
        button.setText("use divergence dependence");
        button.setSelection(((Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_DIVERGENCEDA)).booleanValue());
        button.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_DIVERGENCEDA, button, (IToolConfiguration)slicerConfiguration));
        final Button button2 = new Button((Composite)group, 32);
        button2.setText("use interprocedural variant");
        if (button.getSelection()) {
            button2.setSelection(((Boolean)slicerConfiguration.getProperty(SlicerConfiguration.INTERPROCEDURAL_DIVERGENCEDA)).booleanValue());
        } else {
            button2.setEnabled(false);
        }
        button2.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.INTERPROCEDURAL_DIVERGENCEDA, button2, (IToolConfiguration)slicerConfiguration));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button.getSelection()) {
                    button2.setEnabled(true);
                } else {
                    button2.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void setupRow4() {
        final SlicerConfiguration slicerConfiguration = (SlicerConfiguration)this.configuration;
        Group group = new Group(this.parent, 16);
        group.setText("Ready dependence");
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        final Group group2 = new Group((Composite)group, 16);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group2.setLayout((Layout)gridLayout);
        group2.setText("Precision of Ready dependence");
        group2.setLayoutData((Object)gridData2);
        final Button button = new Button((Composite)group2, 16);
        button.setText("use type-based analysis");
        final Button button2 = new Button((Composite)group2, 16);
        button2.setText("use equivalence class-based analysis");
        final Button button3 = new Button((Composite)group2, 16);
        button3.setText("use sybmol and equivalence class-based analysis");
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = null;
                if (selectionEvent.widget == button2) {
                    object = SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO;
                } else if (selectionEvent.widget == button3) {
                    object = SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO;
                } else if (selectionEvent.widget == button) {
                    object = SlicerConfiguration.TYPE_BASED_INFO;
                }
                if (object != null) {
                    slicerConfiguration.setProperty(SlicerConfiguration.NATURE_OF_READY_DA, object);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        };
        button2.addSelectionListener(selectionListener);
        button3.addSelectionListener(selectionListener);
        button.addSelectionListener(selectionListener);
        Object object = slicerConfiguration.getProperty(SlicerConfiguration.NATURE_OF_READY_DA);
        if (object == null || object.equals(SlicerConfiguration.SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            button3.setSelection(true);
        } else if (object.equals(SlicerConfiguration.EQUIVALENCE_CLASS_BASED_INFO)) {
            button2.setSelection(true);
        } else if (object.equals(SlicerConfiguration.TYPE_BASED_INFO)) {
            button.setSelection(true);
        }
        Button button4 = new Button((Composite)group2, 32);
        button4.setText("use object flow analysis information");
        selectionListener = new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_OFA_FOR_READY_DA, button4, (IToolConfiguration)slicerConfiguration);
        button4.addSelectionListener(selectionListener);
        Composite composite = new Composite((Composite)group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        gridData2 = new GridData(256);
        gridData2.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData2);
        final Button button5 = new Button(composite, 32);
        button5.setText("use ready dependence");
        button5.setSelection(((Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_READYDA)).booleanValue());
        button5.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_READYDA, button5, (IToolConfiguration)slicerConfiguration));
        final Button button6 = new Button(composite, 32);
        button6.setText("use rule 1 of ready dependence");
        button6.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE1_IN_READYDA, button6, (IToolConfiguration)slicerConfiguration));
        final Button button7 = new Button(composite, 32);
        button7.setText("use rule 2 of ready dependence");
        button7.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE1_IN_READYDA, button7, (IToolConfiguration)slicerConfiguration));
        final Button button8 = new Button(composite, 32);
        button8.setText("use rule 3 of ready dependence");
        button8.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE1_IN_READYDA, button8, (IToolConfiguration)slicerConfiguration));
        final Button button9 = new Button(composite, 32);
        button9.setText("use rule 4 of ready dependence");
        button9.addSelectionListener((SelectionListener)new AbstractToolConfigurator.BooleanPropertySelectionListener(SlicerConfiguration.USE_RULE1_IN_READYDA, button9, (IToolConfiguration)slicerConfiguration));
        button5.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = false;
                if (button5.getSelection()) {
                    bl = true;
                }
                group2.setEnabled(bl);
                button2.setEnabled(bl);
                button.setEnabled(bl);
                button3.setEnabled(bl);
                button6.setEnabled(bl);
                button7.setEnabled(bl);
                button8.setEnabled(bl);
                button9.setEnabled(bl);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        if (button5.getSelection()) {
            group2.setEnabled(true);
            button.setEnabled(true);
            button2.setEnabled(true);
            button3.setEnabled(true);
            Boolean bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_RULE1_IN_READYDA);
            button6.setSelection(bl.booleanValue());
            bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_RULE2_IN_READYDA);
            button7.setSelection(bl.booleanValue());
            bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_RULE3_IN_READYDA);
            button8.setSelection(bl.booleanValue());
            bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_RULE4_IN_READYDA);
            button9.setSelection(bl.booleanValue());
            bl = (Boolean)slicerConfiguration.getProperty(SlicerConfiguration.USE_OFA_FOR_READY_DA);
            button4.setSelection(bl.booleanValue());
        } else {
            group2.setEnabled(false);
            button.setEnabled(false);
            button2.setEnabled(false);
            button3.setEnabled(false);
            button6.setEnabled(false);
            button7.setEnabled(false);
            button8.setEnabled(false);
            button9.setEnabled(false);
            button4.setEnabled(false);
        }
    }
}

