/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.EntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.tools.AbstractToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurationFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public final class SlicerConfiguration
extends AbstractToolConfiguration
implements IToolConfigurationFactory,
IUnmarshallable,
IMarshallable {
    static final Object EQUIVALENCE_CLASS_BASED_INFO = "EQUIVALENCE_CLASS_BASED_INFO";
    static final Object SYMBOL_AND_EQUIVCLS_BASED_INFO = "SYMBOL_AND_EQUIVCLS_BASED_INFO";
    static final Object TYPE_BASED_INFO = "TYPE_BASED_INFO";
    static final Object NATURE_OF_INTERFERENCE_DA = "nature of interference dependence";
    static final Object NATURE_OF_READY_DA = "nature of ready dependence";
    static final Object INTERPROCEDURAL_DIVERGENCEDA = "interprocedural divergence dependence";
    static final Object USE_READYDA = "use ready dependence";
    static final Object USE_RULE1_IN_READYDA = "use rule1 in ready dependence";
    static final Object USE_RULE2_IN_READYDA = "use rule2 in ready dependence";
    static final Object USE_RULE3_IN_READYDA = "use rule3 in ready dependence";
    static final Object USE_RULE4_IN_READYDA = "use rule4 in ready dependence";
    static final Object USE_DIVERGENCEDA = "use divergence dependence";
    static final Object SLICE_FOR_DEADLOCK = "slice for deadlock";
    static final Object EXECUTABLE_SLICE = "executable slice";
    static final Object SLICE_TYPE = "slice type";
    static final Object USE_OFA_FOR_INTERFERENCE_DA = "use ofa for interference";
    static final Object USE_OFA_FOR_READY_DA = "use ofa for ready";
    private static IToolConfigurationFactory factorySingleton = new SlicerConfiguration();
    boolean sliceForDeadlock;
    private final Collection dependencesToUse = new HashSet();
    private final Map id2dependencyAnalyses = new HashMap();
    private boolean executableSlice = true;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.tools.JiBX_slicerConfig_JiBXBindingFactory|";

    protected SlicerConfiguration() {
        this.propertyIds.add(USE_DIVERGENCEDA);
        this.propertyIds.add(INTERPROCEDURAL_DIVERGENCEDA);
        this.propertyIds.add(NATURE_OF_INTERFERENCE_DA);
        this.propertyIds.add(USE_OFA_FOR_INTERFERENCE_DA);
        this.propertyIds.add(USE_READYDA);
        this.propertyIds.add(NATURE_OF_READY_DA);
        this.propertyIds.add(USE_OFA_FOR_READY_DA);
        this.propertyIds.add(USE_RULE1_IN_READYDA);
        this.propertyIds.add(USE_RULE2_IN_READYDA);
        this.propertyIds.add(USE_RULE3_IN_READYDA);
        this.propertyIds.add(USE_RULE4_IN_READYDA);
        this.propertyIds.add(SLICE_FOR_DEADLOCK);
        this.propertyIds.add(SLICE_TYPE);
        this.propertyIds.add(EXECUTABLE_SLICE);
    }

    public Collection getDependenceAnalysis(Object object) {
        Collection collection = (Collection)this.id2dependencyAnalyses.get(object);
        if (collection == null) {
            collection = Collections.EMPTY_LIST;
        }
        return collection;
    }

    public boolean isDivergenceDepAnalysisUsed() {
        return (Boolean)this.properties.get(USE_DIVERGENCEDA);
    }

    public Collection getIDsOfDAsToUse() {
        return Collections.unmodifiableCollection(this.dependencesToUse);
    }

    public boolean isInterproceduralDivergenceDepAnalysisUsed() {
        return this.getBooleanProperty(INTERPROCEDURAL_DIVERGENCEDA);
    }

    public void setNatureOfInterferenceDepAnalysis(String string) {
        super.setProperty(NATURE_OF_INTERFERENCE_DA, (Object)string);
    }

    public String getNatureOfInterferenceDepAnalysis() {
        return (String)this.properties.get(NATURE_OF_INTERFERENCE_DA);
    }

    public void setNatureOfReadyDepAnalysis(String string) {
        super.setProperty(NATURE_OF_READY_DA, (Object)string);
    }

    public String getNatureOfReadyDepAnalysis() {
        String string = (String)this.properties.get(NATURE_OF_READY_DA);
        if (string == null) {
            string = SYMBOL_AND_EQUIVCLS_BASED_INFO.toString();
        }
        return string;
    }

    public boolean isOFAUsedForInterference() {
        return (Boolean)this.properties.get(USE_OFA_FOR_INTERFERENCE_DA);
    }

    public boolean isOFAUsedForReady() {
        return (Boolean)this.properties.get(USE_OFA_FOR_READY_DA);
    }

    public boolean isReadyDepAnalysisUsed() {
        return (Boolean)this.properties.get(USE_READYDA);
    }

    public boolean isReadyRule1Used() {
        return this.getBooleanProperty(USE_RULE1_IN_READYDA);
    }

    public boolean isReadyRule2Used() {
        return this.getBooleanProperty(USE_RULE2_IN_READYDA);
    }

    public boolean isReadyRule3Used() {
        return this.getBooleanProperty(USE_RULE3_IN_READYDA);
    }

    public boolean isReadyRule4Used() {
        return this.getBooleanProperty(USE_RULE4_IN_READYDA);
    }

    public void setSliceType(String string) {
        if (SlicingEngine.SLICE_TYPES.contains(string)) {
            this.properties.put(SLICE_TYPE, string);
            if (string.equals(SlicingEngine.BACKWARD_SLICE)) {
                HashSet<EntryControlDA> hashSet = (HashSet<EntryControlDA>)this.id2dependencyAnalyses.get(IDependencyAnalysis.CONTROL_DA);
                if (hashSet == null) {
                    hashSet = new HashSet<EntryControlDA>();
                    this.id2dependencyAnalyses.put(IDependencyAnalysis.CONTROL_DA, hashSet);
                } else {
                    hashSet.clear();
                }
                hashSet.add(new EntryControlDA());
            } else if (string.equals(SlicingEngine.FORWARD_SLICE)) {
                HashSet<ExitControlDA> hashSet = (HashSet<ExitControlDA>)this.id2dependencyAnalyses.get(IDependencyAnalysis.CONTROL_DA);
                if (hashSet == null) {
                    hashSet = new HashSet<ExitControlDA>();
                    this.id2dependencyAnalyses.put(IDependencyAnalysis.CONTROL_DA, hashSet);
                } else {
                    hashSet.clear();
                }
                hashSet.add(new ExitControlDA());
            } else if (string.equals(SlicingEngine.COMPLETE_SLICE)) {
                HashSet<EntryControlDA> hashSet = (HashSet<EntryControlDA>)this.id2dependencyAnalyses.get(IDependencyAnalysis.CONTROL_DA);
                if (hashSet == null) {
                    hashSet = new HashSet<EntryControlDA>();
                    this.id2dependencyAnalyses.put(IDependencyAnalysis.CONTROL_DA, hashSet);
                } else {
                    hashSet.clear();
                }
                hashSet.add(new EntryControlDA());
                hashSet.add((EntryControlDA)new ExitControlDA());
            }
        }
    }

    public String getSliceType() {
        return this.properties.get(SLICE_TYPE).toString();
    }

    public void setUseOFAForInterference(boolean bl) {
        this.processPropertyHelper(USE_OFA_FOR_INTERFERENCE_DA, bl);
    }

    public void setUseOFAForReady(boolean bl) {
        this.processPropertyHelper(USE_OFA_FOR_READY_DA, bl);
    }

    public IToolConfiguration createToolConfiguration() {
        return SlicerConfiguration.makeToolConfiguration();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SlicerConfiguration) {
            SlicerConfiguration slicerConfiguration = (SlicerConfiguration)((Object)object);
            bl = new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.propertyIds, (Object)slicerConfiguration.propertyIds).append(this.sliceForDeadlock, slicerConfiguration.sliceForDeadlock).append((Object)this.id2dependencyAnalyses, (Object)slicerConfiguration.id2dependencyAnalyses).append(this.executableSlice, slicerConfiguration.executableSlice).append((Object)this.dependencesToUse, (Object)slicerConfiguration.dependencesToUse).append((Object)this.properties, (Object)slicerConfiguration.properties).isEquals();
        }
        return bl;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.propertyIds).append(this.sliceForDeadlock).append((Object)this.id2dependencyAnalyses).append(this.executableSlice).append((Object)this.dependencesToUse).append((Object)this.properties).toHashCode();
    }

    public void initialize() {
        this.dependencesToUse.add(IDependencyAnalysis.IDENTIFIER_BASED_DATA_DA);
        this.id2dependencyAnalyses.put(IDependencyAnalysis.IDENTIFIER_BASED_DATA_DA, Collections.singleton(new IdentifierBasedDataDAv2()));
        this.dependencesToUse.add(IDependencyAnalysis.REFERENCE_BASED_DATA_DA);
        this.id2dependencyAnalyses.put(IDependencyAnalysis.REFERENCE_BASED_DATA_DA, Collections.singleton(new ReferenceBasedDataDA()));
        this.dependencesToUse.add(IDependencyAnalysis.SYNCHRONIZATION_DA);
        this.id2dependencyAnalyses.put(IDependencyAnalysis.SYNCHRONIZATION_DA, Collections.singleton(new SynchronizationDA()));
        this.dependencesToUse.add(IDependencyAnalysis.INTERFERENCE_DA);
        this.dependencesToUse.add(IDependencyAnalysis.READY_DA);
        this.dependencesToUse.add(IDependencyAnalysis.CONTROL_DA);
        this.setProperty(NATURE_OF_INTERFERENCE_DA, SYMBOL_AND_EQUIVCLS_BASED_INFO);
        this.setProperty(USE_OFA_FOR_INTERFERENCE_DA, Boolean.TRUE);
        this.setProperty(USE_READYDA, Boolean.TRUE);
        this.setProperty(NATURE_OF_READY_DA, SYMBOL_AND_EQUIVCLS_BASED_INFO);
        this.setProperty(USE_OFA_FOR_READY_DA, Boolean.TRUE);
        this.setProperty(USE_RULE1_IN_READYDA, Boolean.TRUE);
        this.setProperty(USE_RULE2_IN_READYDA, Boolean.TRUE);
        this.setProperty(USE_RULE3_IN_READYDA, Boolean.TRUE);
        this.setProperty(USE_RULE4_IN_READYDA, Boolean.TRUE);
        this.setProperty(USE_DIVERGENCEDA, Boolean.FALSE);
        this.setProperty(SLICE_TYPE, SlicingEngine.BACKWARD_SLICE);
        this.setProperty(EXECUTABLE_SLICE, Boolean.TRUE);
        this.setProperty(SLICE_FOR_DEADLOCK, Boolean.TRUE);
    }

    public void useDivergenceDepAnalysis(boolean bl) {
        this.processPropertyHelper(USE_DIVERGENCEDA, bl);
    }

    public void useInterproceduralDivergenceDepAnalysis(boolean bl) {
        this.processPropertyHelper(INTERPROCEDURAL_DIVERGENCEDA, bl);
    }

    public void useReadyDepAnalysis(boolean bl) {
        this.processPropertyHelper(USE_READYDA, bl);
    }

    public void useReadyRule1(boolean bl) {
        this.processPropertyHelper(USE_RULE1_IN_READYDA, bl);
    }

    public void useReadyRule2(boolean bl) {
        this.processPropertyHelper(USE_RULE2_IN_READYDA, bl);
    }

    public void useReadyRule3(boolean bl) {
        this.processPropertyHelper(USE_RULE3_IN_READYDA, bl);
    }

    public void useReadyRule4(boolean bl) {
        this.processPropertyHelper(USE_RULE4_IN_READYDA, bl);
    }

    protected boolean processProperty(Object object, Object object2) {
        boolean bl = true;
        if (object2 instanceof Boolean) {
            this.processBooleanProperty(object, (Boolean)object2);
        } else if (object.equals(SLICE_TYPE)) {
            if (!SlicingEngine.SLICE_TYPES.contains(object2)) {
                bl = false;
            }
            this.setSliceType(object2.toString());
        } else if (object.equals(NATURE_OF_INTERFERENCE_DA)) {
            bl = this.processIDANatureProperty(object2);
        } else if (object.equals(NATURE_OF_READY_DA)) {
            bl = this.processRDANatureProperty(object2);
        }
        return bl;
    }

    static IToolConfigurationFactory getFactory() {
        return factorySingleton;
    }

    static SlicerConfiguration makeToolConfiguration() {
        SlicerConfiguration slicerConfiguration = new SlicerConfiguration();
        slicerConfiguration.setConfigName("tool_configuration_" + System.currentTimeMillis());
        slicerConfiguration.initialize();
        return slicerConfiguration;
    }

    private boolean getBooleanProperty(Object object) {
        Boolean bl = (Boolean)this.properties.get(object);
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        return bl2;
    }

    private void processBooleanProperty(Object object, Boolean bl) {
        if (object.equals(USE_READYDA)) {
            this.processUseProperty(bl, IDependencyAnalysis.READY_DA, Collections.singleton(new ReadyDAv3()));
        } else if (object.equals(USE_DIVERGENCEDA)) {
            this.processUseProperty(bl, IDependencyAnalysis.DIVERGENCE_DA, Collections.singleton(new DivergenceDA()));
        } else if (object.equals(INTERPROCEDURAL_DIVERGENCEDA)) {
            this.processInterProceduralDivergenceDAProperty();
        } else if (object.equals(SLICE_FOR_DEADLOCK)) {
            this.sliceForDeadlock = bl;
        } else if (object.equals(EXECUTABLE_SLICE)) {
            this.executableSlice = bl;
        } else if (object.equals(USE_OFA_FOR_INTERFERENCE_DA)) {
            Iterator iterator = ((Collection)this.id2dependencyAnalyses.get(IDependencyAnalysis.INTERFERENCE_DA)).iterator();
            while (iterator.hasNext()) {
                InterferenceDAv1 interferenceDAv1 = (InterferenceDAv1)iterator.next();
                interferenceDAv1.setUseOFA(bl.booleanValue());
            }
        } else if (object.equals(USE_OFA_FOR_READY_DA)) {
            Iterator iterator = ((Collection)this.id2dependencyAnalyses.get(IDependencyAnalysis.READY_DA)).iterator();
            while (iterator.hasNext()) {
                ReadyDAv1 readyDAv1 = (ReadyDAv1)iterator.next();
                readyDAv1.setUseOFA(bl.booleanValue());
            }
        } else {
            this.processRDARuleProperties(object);
        }
    }

    private boolean processIDANatureProperty(Object object) {
        boolean bl = true;
        if (object.equals(SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.INTERFERENCE_DA, Collections.singleton(new InterferenceDAv3()));
        } else if (object.equals(EQUIVALENCE_CLASS_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.INTERFERENCE_DA, Collections.singleton(new InterferenceDAv2()));
        } else if (object.equals(TYPE_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.INTERFERENCE_DA, Collections.singleton(new InterferenceDAv1()));
        } else {
            bl = false;
        }
        return bl;
    }

    private void processInterProceduralDivergenceDAProperty() {
        Boolean bl = (Boolean)this.properties.get(USE_DIVERGENCEDA);
        if (bl != null && bl.booleanValue()) {
            Collection collection = (Collection)this.id2dependencyAnalyses.get(IDependencyAnalysis.DIVERGENCE_DA);
            boolean bl2 = bl;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DivergenceDA divergenceDA = (DivergenceDA)iterator.next();
                divergenceDA.setConsiderCallSites(bl2);
            }
        }
    }

    private void processPropertyHelper(Object object, boolean bl) {
        super.setProperty(object, (Object)bl);
    }

    private boolean processRDANatureProperty(Object object) {
        boolean bl = true;
        if (object.equals(SYMBOL_AND_EQUIVCLS_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.READY_DA, Collections.singleton(new ReadyDAv3()));
        } else if (object.equals(EQUIVALENCE_CLASS_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.READY_DA, Collections.singleton(new ReadyDAv2()));
        } else if (object.equals(TYPE_BASED_INFO)) {
            this.id2dependencyAnalyses.put(IDependencyAnalysis.READY_DA, Collections.singleton(new ReadyDAv1()));
        } else {
            bl = false;
        }
        return bl;
    }

    private void processRDARuleProperties(Object object) {
        Boolean bl = (Boolean)this.properties.get(USE_READYDA);
        if (bl != null && bl.booleanValue()) {
            int n = 0;
            if (object.equals(USE_RULE1_IN_READYDA)) {
                n = 1;
            } else if (object.equals(USE_RULE2_IN_READYDA)) {
                n = 2;
            } else if (object.equals(USE_RULE3_IN_READYDA)) {
                n = 4;
            } else if (object.equals(USE_RULE4_IN_READYDA)) {
                n = 8;
            }
            Collection collection = (Collection)this.id2dependencyAnalyses.get(IDependencyAnalysis.READY_DA);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ReadyDAv1 readyDAv1 = (ReadyDAv1)iterator.next();
                int n2 = readyDAv1.getRules();
                readyDAv1.setRules(n2 | n);
            }
        }
    }

    private void processUseProperty(Boolean bl, Object object, Collection collection) {
        if (bl.booleanValue()) {
            this.dependencesToUse.add(object);
            this.id2dependencyAnalyses.put(object, collection);
        } else {
            this.dependencesToUse.remove(object);
            this.id2dependencyAnalyses.remove(object);
        }
    }

    public static SlicerConfiguration JiBX_slicerConfig_JiBXBinding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return SlicerConfiguration.makeToolConfiguration();
    }

    public final void JiBX_slicerConfig_JiBXBinding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SlicerConfiguration slicerConfiguration = this;
        this.setSliceType(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "slicetype"));
        this.sliceForDeadlock = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "sliceForDeadlock");
        this.executableSlice = arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "executableSlice");
        this.setConfigName(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "name"));
        arg1.popObject();
    }

    public final void JiBX_slicerConfig_JiBXBinding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SlicerConfiguration slicerConfiguration = this;
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        this.setNatureOfInterferenceDepAnalysis(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "natureOfInterThreadAnalysis"));
        this.setUseOFAForInterference(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "useOFA"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "interference");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        this.useDivergenceDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.useInterproceduralDivergenceDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "interprocedural"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "divergence");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        this.useReadyDepAnalysis(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "active"));
        this.setNatureOfReadyDepAnalysis(arg1.attributeText("http://indus.projects.cis.ksu.edu/slicer", "natureOfInterThreadAnalysis"));
        this.useReadyRule1(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule1"));
        this.useReadyRule2(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule2"));
        this.useReadyRule3(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule3"));
        this.useReadyRule4(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "rule4"));
        this.setUseOFAForReady(arg1.attributeBoolean("http://indus.projects.cis.ksu.edu/slicer", "useOFA"));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        arg1.parsePastEndTag("http://indus.projects.cis.ksu.edu/slicer", "ready");
        arg1.popObject();
    }

    public void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(3).unmarshal((Object)this, arg1);
    }

    public final void JiBX_slicerConfig_JiBXBinding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(3, "slicetype", this.getSliceType()).attribute(3, "sliceForDeadlock", Utility.serializeBoolean((boolean)this.sliceForDeadlock)).attribute(3, "executableSlice", Utility.serializeBoolean((boolean)this.executableSlice)).attribute(2, "name", this.getConfigName());
        arg1.popObject();
    }

    public final void JiBX_slicerConfig_JiBXBinding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        int[] nArray = new int[]{2, 3};
        String[] stringArray = new String[]{"indus", "slicer"};
        arg1.attribute(3, "natureOfInterThreadAnalysis", this.getNatureOfInterferenceDepAnalysis()).attribute(3, "useOFA", Utility.serializeBoolean((boolean)this.isOFAUsedForInterference())).closeStartEmpty();
        int[] nArray2 = new int[]{2, 3};
        String[] stringArray2 = new String[]{"indus", "slicer"};
        arg1.startTagNamespaces(3, "interference", nArray, stringArray).attribute(3, "active", Utility.serializeBoolean((boolean)this.isDivergenceDepAnalysisUsed())).attribute(3, "interprocedural", Utility.serializeBoolean((boolean)this.isInterproceduralDivergenceDepAnalysisUsed())).closeStartEmpty();
        MarshallingContext marshallingContext = arg1.startTagNamespaces(3, "ready", new int[]{2, 3}, new String[]{"indus", "slicer"});
        arg1.startTagNamespaces(3, "divergence", nArray2, stringArray2).attribute(3, "active", Utility.serializeBoolean((boolean)this.isReadyDepAnalysisUsed())).attribute(3, "natureOfInterThreadAnalysis", this.getNatureOfReadyDepAnalysis()).attribute(3, "rule1", Utility.serializeBoolean((boolean)this.isReadyRule1Used())).attribute(3, "rule2", Utility.serializeBoolean((boolean)this.isReadyRule2Used())).attribute(3, "rule3", Utility.serializeBoolean((boolean)this.isReadyRule3Used())).attribute(3, "rule4", Utility.serializeBoolean((boolean)this.isReadyRule4Used())).attribute(3, "useOFA", Utility.serializeBoolean((boolean)this.isOFAUsedForReady())).closeStartEmpty();
        arg1.popObject();
    }

    public void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(3, "edu.ksu.cis.indus.tools.slicer.SlicerConfiguration").marshal((Object)this, arg1);
    }

    public int JiBX_getIndex() {
        return 3;
    }
}

