/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools.slicer;

import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.slicer.ISliceCriterion;
import edu.ksu.cis.indus.slicer.transformations.TagBasedDestructiveSliceResidualizer;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.slicer.SlicerTool;
import edu.ksu.cis.indus.tools.slicer.TagBasedSliceXMLizer;
import edu.ksu.cis.indus.tools.slicer.criteria.SliceCriteriaParser;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jibx.runtime.JiBXException;
import soot.Printer;
import soot.SootClass;
import soot.SootMethod;

public class SliceXMLizerCLI
extends SootBasedDriver {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI == null ? (class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI = SliceXMLizerCLI.class$("edu.ksu.cis.indus.tools.slicer.SliceXMLizerCLI")) : class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI));
    private static String configFileName;
    protected String outputDirectory;
    SlicerTool slicer = new SlicerTool(TokenUtil.getTokenManager(), (IStmtGraphFactory)new ExceptionFlowSensitiveStmtGraphFactory());
    String jimpleXMLDumpDir;
    private IJimpleIDGenerator idGenerator;
    private final String nameOfSliceTag = "indus.tools.slicer.SliceXMLizerCLI:SLICER";
    private String criteriaSpecFileName;
    private boolean postResJimpleDump;
    private boolean postResXMLJimpleDump;
    private boolean preResJimpleDump;
    private boolean preResXMLJimpleDump;
    private boolean residualize;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI;

    protected SliceXMLizerCLI() {
        this.cfgProvider = this.slicer.getStmtGraphFactory();
    }

    public static void main(String[] stringArray) {
        SliceXMLizerCLI sliceXMLizerCLI = new SliceXMLizerCLI();
        sliceXMLizerCLI.setIDGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
        SliceXMLizerCLI.parseCommandLine(stringArray, sliceXMLizerCLI);
        sliceXMLizerCLI.initialize();
        long l = System.currentTimeMillis();
        sliceXMLizerCLI.execute();
        long l2 = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("It took " + (l2 - l) + "ms to identify the slice."));
        }
        sliceXMLizerCLI.writeXML();
        sliceXMLizerCLI.residualize();
    }

    protected final void setConfiguration(String string) {
        this.slicer.destringizeConfiguration(string);
    }

    protected void setIDGenerator(IJimpleIDGenerator iJimpleIDGenerator) {
        this.idGenerator = iJimpleIDGenerator;
    }

    protected final void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    protected final TagBasedSliceXMLizer getXMLizer() {
        return new TagBasedSliceXMLizer("indus.tools.slicer.SliceXMLizerCLI:SLICER", this.idGenerator);
    }

    protected void execute() {
        Object object;
        Object object2;
        block12: {
            HashSet hashSet;
            block11: {
                this.slicer.setTagName("indus.tools.slicer.SliceXMLizerCLI:SLICER");
                this.slicer.setSystem(this.scene);
                this.slicer.setRootMethods(this.rootMethods);
                hashSet = new HashSet();
                if (this.criteriaSpecFileName != null) {
                    try {
                        object2 = new FileInputStream(this.criteriaSpecFileName);
                        object = IOUtils.toString((InputStream)object2);
                        IOUtils.closeQuietly((InputStream)object2);
                        String string = object;
                        hashSet.addAll(SliceCriteriaParser.deserialize(string, this.scene));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Criteria specification before slicing: \n" + (String)object));
                            LOGGER.debug((Object)("Criteria before slicing: \n" + hashSet));
                        }
                    }
                    catch (IOException iOException) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn((Object)("Error retrieved slicing criteria from " + this.criteriaSpecFileName), (Throwable)iOException);
                        }
                    }
                    catch (JiBXException jiBXException) {
                        if (!LOGGER.isWarnEnabled()) break block11;
                        LOGGER.warn((Object)"JiBX failed during deserialization.", (Throwable)jiBXException);
                    }
                }
            }
            this.slicer.setCriteria(hashSet);
            this.slicer.run(Phase.STARTING_PHASE, true);
            if (LOGGER.isDebugEnabled()) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Criteria specification after slicing: \n" + SliceCriteriaParser.serialize(this.slicer.getCriteria())));
                    }
                }
                catch (JiBXException jiBXException) {
                    if (!LOGGER.isDebugEnabled()) break block12;
                    LOGGER.debug((Object)"JiBX faild during serialization.", (Throwable)jiBXException);
                }
            }
        }
        object2 = this.slicer.getCriteria().iterator();
        while (object2.hasNext()) {
            object = (ISliceCriterion)object2.next();
            object.returnToPool();
        }
    }

    void destructivelyUpdateJimple() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Residualizing");
        }
        TagBasedDestructiveSliceResidualizer tagBasedDestructiveSliceResidualizer = new TagBasedDestructiveSliceResidualizer();
        tagBasedDestructiveSliceResidualizer.setTagToResidualize("indus.tools.slicer.SliceXMLizerCLI:SLICER");
        tagBasedDestructiveSliceResidualizer.residualizeSystem(this.scene);
    }

    void dumpJimpleAsXML(String string) {
        TagBasedSliceXMLizer tagBasedSliceXMLizer = this.getXMLizer();
        if (this.jimpleXMLDumpDir != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: Dumping XMLized Jimple");
            }
            ProcessingController processingController = new ProcessingController();
            XMLizingProcessingFilter xMLizingProcessingFilter = new XMLizingProcessingFilter();
            xMLizingProcessingFilter.chain((IProcessingFilter)new TagBasedProcessingFilter("indus.tools.slicer.SliceXMLizerCLI:SLICER"));
            processingController.setStmtGraphFactory(this.getStmtGraphFactory());
            processingController.setEnvironment((IEnvironment)new Environment(this.scene));
            processingController.setProcessingFilter((IProcessingFilter)xMLizingProcessingFilter);
            ((AbstractXMLizer)tagBasedSliceXMLizer).dumpJimple(string, this.jimpleXMLDumpDir, processingController);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: Dumping XMLized Jimple");
            }
        }
    }

    private static void parseCommandLine(String[] stringArray, SliceXMLizerCLI sliceXMLizerCLI) {
        Object object;
        Options options = new Options();
        Option option = new Option("c", "config-file", true, "The configuration file to use.  If unspecified, uses default configuration file.");
        option.setArgs(1);
        option.setArgName("path");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("a", "active-config", true, "The alternate configuration to use instead of the one specified in the configuration.");
        option.setArgs(1);
        option.setArgName("config");
        option.setLongOpt("active-config");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("o", "output-dir", true, "The output directory to dump the generated info.  If unspecified, picks a temporary directory.");
        option.setArgs(1);
        option.setArgName("path");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("g", "gui-config", false, "Display gui for configuration.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        option.setArgs(1);
        option.setArgName("classpath");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("h", "help", false, "Display message.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("i", "output-xml-jimple-before-res", false, "Output xml representation of the jimple BEFORE residualization.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("j", "output-xml-jimple-after-res", false, "Output xml representation of the jimple AFTER residualization. This only works with -r option.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("I", "output-jimple-before-res", false, "Output jimple BEFORE residualization.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("J", "output-jimple-after-res", false, "Output jimple AFTER residualization. This only works with -r option.");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("s", "criteria-spec-file", true, "Use the slice criteria specified in this file.");
        option.setArgs(1);
        option.setArgName("crit-spec-file");
        option.setOptionalArg(false);
        option = new Option("r", "residualize", false, "Residualize after slicing. This will also dump the class files for the residualized classes.");
        option.setOptionalArg(false);
        options.addOption(option);
        CommandLine commandLine = null;
        ParseException parseException = null;
        try {
            commandLine = new BasicParser().parse(options, stringArray);
        }
        catch (ParseException parseException2) {
            parseException = parseException2;
        }
        if (parseException != null || commandLine.hasOption("h")) {
            object = "java " + (class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI == null ? (class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI = SliceXMLizerCLI.class$("edu.ksu.cis.indus.tools.slicer.SliceXMLizerCLI")) : class$edu$ksu$cis$indus$tools$slicer$SliceXMLizerCLI).getName() + "<options> <class names>";
            new HelpFormatter().printHelp(((String)object).length(), (String)object, "", options, "", true);
            if (parseException != null) {
                LOGGER.fatal((Object)"Incorrect command line.  Aborting.", (Throwable)parseException);
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        sliceXMLizerCLI.setConfiguration(SliceXMLizerCLI.processCommandLineForConfiguration(commandLine));
        SliceXMLizerCLI.setupOutputOptions(commandLine, sliceXMLizerCLI);
        if (commandLine.hasOption('p')) {
            sliceXMLizerCLI.addToSootClassPath(commandLine.getOptionValue('p'));
        }
        if ((object = commandLine.getArgList()).isEmpty()) {
            LOGGER.fatal((Object)"Please specify atleast one class that contains an entry method into the system to be sliced.");
            System.exit(1);
        }
        if (commandLine.hasOption('a')) {
            sliceXMLizerCLI.setConfigName(commandLine.getOptionValue('a'));
        }
        if (commandLine.hasOption('g')) {
            sliceXMLizerCLI.showGUI();
        }
        if (commandLine.hasOption('s')) {
            sliceXMLizerCLI.setSliceCriteriaSpecFile(commandLine.getOptionValue('s'));
        }
        if (commandLine.hasOption('r')) {
            sliceXMLizerCLI.setResidulization(true);
        }
        sliceXMLizerCLI.setClassNames(commandLine.getArgList());
    }

    private void setResidulization(boolean bl) {
        this.residualize = bl;
    }

    private void setSliceCriteriaSpecFile(String string) {
        this.criteriaSpecFileName = string;
    }

    private static String processCommandLineForConfiguration(CommandLine commandLine) {
        String string = commandLine.getOptionValue("c");
        InputStream inputStream = null;
        String string2 = null;
        if (string != null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.warn((Object)"Non-existent configuration file specified.", (Throwable)fileNotFoundException);
                string = null;
            }
        } else {
            LOGGER.info((Object)"No configuration file specified.");
        }
        configFileName = string;
        if (string == null) {
            LOGGER.info((Object)"Trying to use default configuration.");
            URL uRL = ClassLoader.getSystemResource("edu/ksu/cis/indus/tools/slicer/default_slicer_configuration.xml");
            try {
                inputStream = uRL.openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.fatal((Object)"Even default configuration file could not be found.  Aborting", (Throwable)fileNotFoundException);
                System.exit(1);
            }
            catch (IOException iOException) {
                LOGGER.fatal((Object)"Could not retrieve a handle to default configuration file.  Aborting.", (Throwable)iOException);
                System.exit(1);
            }
        }
        try {
            string2 = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException iOException) {
            LOGGER.fatal((Object)"IO error while reading configuration file.  Aborting", (Throwable)iOException);
            IOUtils.closeQuietly((InputStream)inputStream);
            System.exit(1);
        }
        return string2;
    }

    private static void setupOutputOptions(CommandLine commandLine, SliceXMLizerCLI sliceXMLizerCLI) {
        String string;
        if (commandLine.hasOption('o')) {
            string = commandLine.getOptionValue("o");
        } else {
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + System.currentTimeMillis() + "_slicer");
            file.mkdirs();
            string = file.getAbsolutePath();
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)("Using " + string + " as the directory to dump information"));
            }
        }
        sliceXMLizerCLI.preResXMLJimpleDump = commandLine.hasOption('i');
        sliceXMLizerCLI.postResXMLJimpleDump = commandLine.hasOption('j') && commandLine.hasOption('r');
        sliceXMLizerCLI.preResJimpleDump = commandLine.hasOption('I');
        boolean bl = sliceXMLizerCLI.postResJimpleDump = commandLine.hasOption('J') && commandLine.hasOption('r');
        if (sliceXMLizerCLI.preResXMLJimpleDump || sliceXMLizerCLI.postResXMLJimpleDump || sliceXMLizerCLI.preResJimpleDump || sliceXMLizerCLI.postResJimpleDump) {
            sliceXMLizerCLI.jimpleXMLDumpDir = string;
        }
        sliceXMLizerCLI.setOutputDirectory(string);
    }

    private void setConfigName(String string) {
        this.slicer.setActiveConfiguration(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpJimple(String string, boolean bl, boolean bl2) {
        Printer printer = Printer.v();
        Iterator iterator = this.scene.getClasses().iterator();
        while (iterator.hasNext()) {
            Object var10_10;
            Object object;
            SootClass sootClass = (SootClass)iterator.next();
            if (!sootClass.hasTag("indus.tools.slicer.SliceXMLizerCLI:SLICER")) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Dumping jimple for " + sootClass));
            }
            Object object2 = sootClass.getMethods().iterator();
            while (object2.hasNext()) {
                object = (SootMethod)object2.next();
                if (!object.isConcrete()) continue;
                object.retrieveActiveBody();
            }
            object2 = null;
            try {
                block9: {
                    try {
                        if (bl) {
                            object = new File(this.outputDirectory + File.separator + sootClass.getName() + ".jimple" + string);
                            object2 = new PrintWriter(new FileWriter((File)object));
                            printer.printTo(sootClass, (PrintWriter)object2);
                        }
                        if (!bl2) break block9;
                        printer.write(sootClass, this.outputDirectory);
                    }
                    catch (IOException iOException) {
                        LOGGER.error((Object)("Error while writing " + sootClass), (Throwable)iOException);
                        var10_10 = null;
                        if (object2 == null) continue;
                        ((PrintWriter)object2).flush();
                        ((PrintWriter)object2).close();
                        continue;
                    }
                }
                var10_10 = null;
                if (object2 == null) continue;
                ((PrintWriter)object2).flush();
                ((PrintWriter)object2).close();
            }
            catch (Throwable throwable) {
                var10_10 = null;
                if (object2 != null) {
                    ((PrintWriter)object2).flush();
                    ((PrintWriter)object2).close();
                }
                throw throwable;
            }
        }
    }

    private void residualize() {
        if (this.preResXMLJimpleDump) {
            this.dumpJimpleAsXML("unsliced");
        }
        if (this.preResJimpleDump) {
            this.dumpJimple("_preRes", true, false);
        }
        if (this.residualize) {
            this.destructivelyUpdateJimple();
            this.dumpJimple("", false, true);
        }
        if (this.postResJimpleDump) {
            this.dumpJimple("_postRes", true, false);
        }
        if (this.postResXMLJimpleDump) {
            this.dumpJimpleAsXML("sliced");
        }
    }

    private void showGUI() {
        Display display = new Display();
        final Shell shell = new Shell(67680);
        shell.setText("Slicer configuration");
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        shell.setLayout((Layout)rowLayout);
        this.slicer.getConfigurator().initialize(new Composite((Composite)shell, 0));
        Button button = new Button((Composite)shell, 8);
        button.setText("Ok");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        shell.layout();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            if (configFileName != null) {
                FileUtils.writeStringToFile((File)new File(configFileName), (String)this.slicer.stringizeConfiguration(), (String)"UTF-8");
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)"Configuration file name is unspecified.  Printing to console.");
                }
                System.out.println(this.slicer.stringizeConfiguration());
            }
        }
        catch (IOException iOException) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"Could not write the configuration file.  Printing to console", (Throwable)iOException);
            }
            System.out.println(this.slicer.stringizeConfiguration());
        }
    }

    private void writeXML() {
        TagBasedSliceXMLizer tagBasedSliceXMLizer = this.getXMLizer();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("The Environment", new Environment(this.slicer.getSystem()));
        hashMap.put(IStmtGraphFactory.ID, this.slicer.getStmtGraphFactory());
        tagBasedSliceXMLizer.setXmlOutputDir(this.outputDirectory);
        tagBasedSliceXMLizer.writeXML(hashMap);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

