/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.Tool;
import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.bandera.util.BaseObservable;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.slicer.transformations.TagBasedDestructiveSliceResidualizer;
import edu.ksu.cis.indus.staticanalyses.tokens.BitSetTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import edu.ksu.cis.indus.staticanalyses.tokens.SootValueTypeManager;
import edu.ksu.cis.indus.toolkits.bandera.SlicerConfigurationView;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.slicer.criteria.SliceCriteriaParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.JiBXException;
import soot.Scene;

public final class SlicerTool
extends BaseObservable
implements Tool {
    public static final Object SCENE = "scene";
    public static final Object ROOT_METHODS = "entryPoints";
    public static final Object CRITERIA = "slicingCriteria";
    public static final Object CRITERIA_SPECIFICATION = "slicingCriteriaSpecification";
    private static final List IN_ARGUMENTS_IDS = new ArrayList();
    private static final List OUT_ARGUMENTS_IDS;
    private static final Log LOGGER;
    private static final String TAG_NAME = "Slicer:Bandera";
    private final edu.ksu.cis.indus.tools.slicer.SlicerTool tool = new edu.ksu.cis.indus.tools.slicer.SlicerTool((ITokenManager)new BitSetTokenManager((ITypeManager)new SootValueTypeManager()), (IStmtGraphFactory)new ExceptionFlowSensitiveStmtGraphFactory());
    private SlicerConfigurationView configurationView;
    static /* synthetic */ Class class$edu$ksu$cis$indus$toolkits$bandera$SlicerTool;

    public SlicerTool() {
        this.tool.setTagName(TAG_NAME);
        this.configurationView = new SlicerConfigurationView(this.tool.getConfigurator());
    }

    public void setConfiguration(String string) throws Exception {
        this.tool.destringizeConfiguration(string);
    }

    public String getConfiguration() {
        return this.tool.stringizeConfiguration();
    }

    public void setInputMap(Map map) {
        Object object;
        Object object2;
        Scene scene = (Scene)map.get(SCENE);
        if (scene == null) {
            LOGGER.error((Object)"A scene must be provided for slicing.");
            throw new IllegalArgumentException("A scene must be provided for slicing.");
        }
        this.tool.setSystem(scene);
        Collection collection = (Collection)map.get(CRITERIA);
        if (collection == null || collection.isEmpty()) {
            LOGGER.warn((Object)"Deadlock criteria will be used.");
        } else {
            this.tool.setCriteria(collection);
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (SliceCriteriaFactory.isSlicingCriterion(object)) continue;
                LOGGER.error((Object)(object + " is an invalid slicing criterion.  " + "All slicing criterion should be created via SliceCriteriaFactory."));
                throw new IllegalArgumentException("Slicing criteion " + object + " was not created via SliceCriteriaFactory.");
            }
        }
        object2 = (String)map.get(CRITERIA_SPECIFICATION);
        if (object2 == null) {
            LOGGER.info((Object)"No criteria specification provided.");
        } else {
            try {
                this.tool.setCriteria(SliceCriteriaParser.deserialize((String)object2, scene));
            }
            catch (JiBXException jiBXException) {
                LOGGER.error((Object)"Error occurred while deserializing the provided criteria specification.");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error occurred while deserializing the provided criteria specification.");
                illegalArgumentException.initCause(jiBXException);
                throw illegalArgumentException;
            }
        }
        object = (Collection)map.get(ROOT_METHODS);
        if (object == null || object.isEmpty()) {
            LOGGER.error((Object)"Atleast one method should be specified as the entry-point into the system.");
            throw new IllegalArgumentException("Atleast one method should be specified as the entry-point into the system.");
        }
        this.tool.setRootMethods((Collection)object);
    }

    public List getInputParameterList() {
        return Collections.unmodifiableList(IN_ARGUMENTS_IDS);
    }

    public Map getOutputMap() {
        HashMap<Object, Scene> hashMap = new HashMap<Object, Scene>();
        hashMap.put(SCENE, this.tool.getSystem());
        return hashMap;
    }

    public List getOutputParameterList() {
        return Collections.unmodifiableList(OUT_ARGUMENTS_IDS);
    }

    public ToolConfigurationView getToolConfigurationView() {
        return this.configurationView;
    }

    public ToolIconView getToolIconView() {
        return this.configurationView;
    }

    public void quit() throws Exception {
    }

    public void run() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: bandera slicer tool");
        }
        this.tool.run(Phase.STARTING_PHASE, true);
        TagBasedDestructiveSliceResidualizer tagBasedDestructiveSliceResidualizer = new TagBasedDestructiveSliceResidualizer();
        tagBasedDestructiveSliceResidualizer.setTagToResidualize(TAG_NAME);
        tagBasedDestructiveSliceResidualizer.residualizeSystem(this.tool.getSystem());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: bandera slicer tool");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IN_ARGUMENTS_IDS.add(SCENE);
        IN_ARGUMENTS_IDS.add(ROOT_METHODS);
        IN_ARGUMENTS_IDS.add(CRITERIA);
        IN_ARGUMENTS_IDS.add(CRITERIA_SPECIFICATION);
        OUT_ARGUMENTS_IDS = new ArrayList();
        OUT_ARGUMENTS_IDS.add(SCENE);
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$toolkits$bandera$SlicerTool == null ? (class$edu$ksu$cis$indus$toolkits$bandera$SlicerTool = SlicerTool.class$("edu.ksu.cis.indus.toolkits.bandera.SlicerTool")) : class$edu$ksu$cis$indus$toolkits$bandera$SlicerTool));
    }
}

