/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer.transformations;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.tagkit.Tag;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.Switch;

public final class TagBasedDestructiveSliceResidualizer
extends AbstractProcessor {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$slicer$transformations$TagBasedDestructiveSliceResidualizer == null ? (class$edu$ksu$cis$indus$slicer$transformations$TagBasedDestructiveSliceResidualizer = TagBasedDestructiveSliceResidualizer.class$("edu.ksu.cis.indus.slicer.transformations.TagBasedDestructiveSliceResidualizer")) : class$edu$ksu$cis$indus$slicer$transformations$TagBasedDestructiveSliceResidualizer));
    final Collection classesToKill = new HashSet();
    final Collection localsToKeep = new HashSet();
    final Collection methodsToKill = new HashSet();
    final Collection trapsToRetain = new HashSet();
    final Map class2members = new HashMap();
    final Map oldStmt2newStmt = new HashMap();
    final Map stmt2predecessors = new HashMap();
    NamedTag tagToResidualize;
    Scene theScene;
    SootMethod currMethod;
    String theNameOfTagToResidualize;
    private final Collection fieldsToKill = new HashSet();
    private final StmtResidualizer stmtProcessor = new StmtResidualizer();
    private List stmtsToBeNOPed = new ArrayList();
    private SootClass currClass;
    static /* synthetic */ Class class$edu$ksu$cis$indus$slicer$transformations$TagBasedDestructiveSliceResidualizer;

    public void setTagToResidualize(String string) {
        this.theNameOfTagToResidualize = string;
        this.tagToResidualize = new NamedTag(this.theNameOfTagToResidualize);
    }

    public void callback(Stmt stmt, Context context) {
        if (this.currMethod != null) {
            this.pruneLocals(stmt);
            boolean bl = this.stmtProcessor.residualize(stmt);
            if (!bl) {
                this.stmtsToBeNOPed.add(stmt);
            } else {
                this.processHandlers(stmt);
            }
        }
    }

    public void callback(SootMethod sootMethod) {
        if (this.currClass != null) {
            this.consolidateMethod();
            this.currMethod = sootMethod;
            this.methodsToKill.remove(sootMethod);
            this.localsToKeep.clear();
            this.trapsToRetain.clear();
        }
    }

    public void callback(SootClass sootClass) {
        this.consolidateClass();
        if (sootClass.hasTag(this.theNameOfTagToResidualize)) {
            this.currClass = sootClass;
            this.classesToKill.remove(sootClass);
            this.methodsToKill.addAll(sootClass.getMethods());
            this.fieldsToKill.addAll(sootClass.getFields());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Residualized class " + sootClass));
            }
        }
    }

    public void callback(SootField sootField) {
        if (this.currClass != null) {
            this.fieldsToKill.remove(sootField);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Residualized field " + sootField));
            }
        }
    }

    public void consolidate() {
        this.consolidateClass();
        Iterator iterator = this.class2members.keySet().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            Pair pair = (Pair)this.class2members.get(sootClass);
            Collection collection = (Collection)pair.getFirst();
            Collection collection2 = (Collection)pair.getSecond();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("BEGIN: Finishing class " + sootClass));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Erasing methods: " + collection));
            }
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                sootClass.removeMethod((SootMethod)iterator2.next());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Erasing fields: " + collection2));
            }
            iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                sootClass.removeField((SootField)iterator2.next());
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("END: Finishing class " + sootClass));
        }
        this.class2members.clear();
        this.currClass = null;
        this.currMethod = null;
        this.methodsToKill.clear();
        this.fieldsToKill.clear();
    }

    public void hookup(ProcessingController processingController) {
        processingController.register((IProcessor)this);
        processingController.registerForAllStmts((IProcessor)this);
    }

    public void processingBegins() {
        this.currMethod = null;
        this.currClass = null;
        this.classesToKill.clear();
        this.classesToKill.addAll(this.theScene.getClasses());
        this.oldStmt2newStmt.clear();
        this.stmtsToBeNOPed.clear();
        this.methodsToKill.clear();
    }

    public void residualizeSystem(Scene scene) {
        this.theScene = scene;
        ProcessingController processingController = new ProcessingController();
        processingController.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(this.theNameOfTagToResidualize));
        processingController.setEnvironment((IEnvironment)new Environment(scene));
        this.hookup(processingController);
        processingController.process();
        this.unhook(processingController);
        processingController.reset();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting classes: " + this.classesToKill));
        }
        Iterator iterator = this.classesToKill.iterator();
        while (iterator.hasNext()) {
            scene.removeClass((SootClass)iterator.next());
        }
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregister((IProcessor)this);
        processingController.unregisterForAllStmts((IProcessor)this);
    }

    private void consolidateClass() {
        if (this.currClass != null) {
            this.consolidateMethod();
            this.class2members.put(this.currClass, new Pair(new ArrayList(this.methodsToKill), new ArrayList(this.fieldsToKill)));
            this.methodsToKill.clear();
            this.fieldsToKill.clear();
            this.currClass = null;
        }
    }

    private void consolidateMethod() {
        if (this.currMethod == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Finishing method " + this.currMethod + "[concrete: " + this.currMethod.isConcrete() + "]"));
        }
        if (this.currMethod.isConcrete()) {
            Object object;
            Object object2;
            Object object3;
            JimpleBody jimpleBody = (JimpleBody)this.currMethod.getActiveBody();
            PatchingChain patchingChain = jimpleBody.getUnits();
            Jimple jimple = Jimple.v();
            Iterator<Object> iterator = this.stmtsToBeNOPed.iterator();
            while (iterator.hasNext()) {
                object3 = (Stmt)iterator.next();
                object2 = patchingChain.getPredOf(object3);
                patchingChain.remove(object3);
                object = jimple.newNopStmt();
                if (object2 == null) {
                    patchingChain.addFirst(object);
                    continue;
                }
                patchingChain.insertAfter(object, object2);
            }
            this.stmtsToBeNOPed.clear();
            iterator = this.oldStmt2newStmt.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = (Map.Entry)iterator.next();
                object2 = object3.getKey();
                object = object3.getValue();
                patchingChain.insertAfter(object, object2);
                patchingChain.remove(object2);
            }
            iterator = this.stmt2predecessors.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = (Map.Entry)iterator.next();
                object2 = object3.getKey();
                object = (List)object3.getValue();
                patchingChain.insertBefore((List)object, object2);
            }
            this.stmt2predecessors.clear();
            this.oldStmt2newStmt.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Locals " + jimpleBody.getLocals()));
                LOGGER.debug((Object)("Retaining:" + this.localsToKeep));
            }
            jimpleBody.getLocals().retainAll(this.localsToKeep);
            jimpleBody.getTraps().retainAll(this.trapsToRetain);
            NopEliminator.v().transform((Body)jimpleBody);
            UnreachableCodeEliminator.v().transform((Body)jimpleBody);
            ConditionalBranchFolder.v().transform((Body)jimpleBody);
            UnconditionalBranchFolder.v().transform((Body)jimpleBody);
            UnusedLocalEliminator.v().transform((Body)jimpleBody);
            jimpleBody.validateLocals();
            jimpleBody.validateTraps();
            jimpleBody.validateUnitBoxes();
            jimpleBody.validateUses();
            if (jimpleBody.getUnits().isEmpty()) {
                this.pluginSignatureCorrectBody(jimpleBody, jimple);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Finishing method " + this.currMethod));
        }
        this.currMethod = null;
    }

    private void pluginSignatureCorrectBody(JimpleBody jimpleBody, Jimple jimple) {
        Local local;
        List list;
        jimpleBody.getTraps().clear();
        jimpleBody.getLocals().clear();
        PatchingChain patchingChain = jimpleBody.getUnits();
        if (!this.currMethod.isStatic()) {
            list = RefType.v((SootClass)this.currMethod.getDeclaringClass());
            LocalCreation localCreation = new LocalCreation(jimpleBody.getLocals());
            local = localCreation.newLocal("_this", (Type)list);
            IdentityStmt identityStmt = jimple.newIdentityStmt((Value)local, (Value)jimple.newThisRef((RefType)list));
            identityStmt.addTag((Tag)this.tagToResidualize);
            identityStmt.getLeftOpBox().addTag((Tag)this.tagToResidualize);
            identityStmt.getRightOpBox().addTag((Tag)this.tagToResidualize);
            jimpleBody.getUnits().add((Object)identityStmt);
        }
        list = this.currMethod.getParameterTypes();
        int n = list.size();
        local = list.iterator();
        for (int i = 0; i < n; ++i) {
            Type type = (Type)local.next();
            LocalCreation localCreation = new LocalCreation(jimpleBody.getLocals());
            Local local2 = localCreation.newLocal("_local", type);
            IdentityStmt identityStmt = jimple.newIdentityStmt((Value)local2, (Value)jimple.newParameterRef(type, i));
            identityStmt.addTag((Tag)this.tagToResidualize);
            identityStmt.getLeftOpBox().addTag((Tag)this.tagToResidualize);
            identityStmt.getRightOpBox().addTag((Tag)this.tagToResidualize);
            jimpleBody.getUnits().add((Object)identityStmt);
        }
        Type type = this.currMethod.getReturnType();
        if (type instanceof VoidType) {
            patchingChain.add((Object)jimple.newReturnVoidStmt());
        } else {
            patchingChain.add((Object)jimple.newReturnStmt(Util.getDefaultValueFor((Type)type)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Injected lame body for " + this.currMethod));
        }
    }

    private void processHandlers(Stmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Collecting handlers " + stmt + "@" + this.currMethod));
        }
        Body body = this.currMethod.retrieveActiveBody();
        if (stmt.hasTag(this.theNameOfTagToResidualize)) {
            this.trapsToRetain.addAll(TrapManager.getTrapsAt((Unit)stmt, (Body)body));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Collecting handlers " + stmt + "@" + this.currMethod));
        }
    }

    private void pruneLocals(Stmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Pruning locals in " + stmt));
        }
        if (stmt.hasTag(this.theNameOfTagToResidualize)) {
            Iterator iterator = Util.getHostsWithTag((Collection)stmt.getUseAndDefBoxes(), (String)this.theNameOfTagToResidualize).iterator();
            while (iterator.hasNext()) {
                ValueBox valueBox = (ValueBox)iterator.next();
                Value value = valueBox.getValue();
                if (!(value instanceof Local)) continue;
                this.localsToKeep.add(value);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ValueResidualizer
    extends AbstractJimpleValueSwitch {
        private ValueResidualizer() {
        }

        public void defaultCase(Object object) {
            Value value = (Value)object;
            Iterator iterator = value.getUseBoxes().iterator();
            while (iterator.hasNext()) {
                ValueBox valueBox = (ValueBox)iterator.next();
                this.residualize(valueBox);
            }
        }

        public void residualize(ValueBox valueBox) {
            Value value = valueBox.getValue();
            if (!valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                valueBox.setValue(Util.getDefaultValueFor((Type)value.getType()));
            } else {
                value.apply((Switch)this);
            }
        }
    }

    private final class StmtResidualizer
    extends AbstractStmtSwitch {
        final ValueResidualizer valueProcessor;
        private final Factory VALUE_FACTORY;

        private StmtResidualizer() {
            this.valueProcessor = new ValueResidualizer();
            this.VALUE_FACTORY = new Factory(){

                public Object create() {
                    return new Pair(new ArrayList(), new ArrayList());
                }
            };
        }

        public void caseAssignStmt(AssignStmt assignStmt) {
            this.residualizeDefStmt((DefinitionStmt)assignStmt);
        }

        public void caseIdentityStmt(IdentityStmt identityStmt) {
            this.residualizeDefStmt((DefinitionStmt)identityStmt);
        }

        public void caseInvokeStmt(InvokeStmt invokeStmt) {
            this.valueProcessor.residualize(invokeStmt.getInvokeExprBox());
        }

        public void caseLookupSwitchStmt(LookupSwitchStmt lookupSwitchStmt) {
            ValueBox valueBox = lookupSwitchStmt.getKeyBox();
            if (!valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                lookupSwitchStmt.setKey(Util.getDefaultValueFor((Type)valueBox.getValue().getType()));
            }
        }

        public void caseReturnStmt(ReturnStmt returnStmt) {
            ValueBox valueBox = returnStmt.getOpBox();
            if (!valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                returnStmt.setOp(Util.getDefaultValueFor((Type)valueBox.getValue().getType()));
            }
        }

        public void caseTableSwitchStmt(TableSwitchStmt tableSwitchStmt) {
            ValueBox valueBox = tableSwitchStmt.getKeyBox();
            if (!valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                tableSwitchStmt.setKey(Util.getDefaultValueFor((Type)valueBox.getValue().getType()));
            }
        }

        public void caseThrowStmt(ThrowStmt throwStmt) {
            ValueBox valueBox = throwStmt.getOpBox();
            if (!valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                Value value = throwStmt.getOp();
                RefType refType = (RefType)value.getType();
                Jimple jimple = Jimple.v();
                LocalCreation localCreation = new LocalCreation(TagBasedDestructiveSliceResidualizer.this.currMethod.getActiveBody().getLocals());
                Local local = localCreation.newLocal((Type)refType);
                TagBasedDestructiveSliceResidualizer.this.localsToKeep.add(local);
                NewExpr newExpr = jimple.newNewExpr(refType);
                AssignStmt assignStmt = jimple.newAssignStmt((Value)local, (Value)newExpr);
                NamedTag namedTag = new NamedTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize);
                assignStmt.addTag((Tag)namedTag);
                assignStmt.getLeftOpBox().addTag((Tag)namedTag);
                assignStmt.getRightOpBox().addTag((Tag)namedTag);
                SootClass sootClass = refType.getSootClass();
                if (!sootClass.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                    TagBasedDestructiveSliceResidualizer.this.classesToKill.remove(sootClass);
                    sootClass.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                }
                SootMethod sootMethod = this.prepareInitIn(sootClass);
                ArrayList<Value> arrayList = new ArrayList<Value>(sootMethod.getParameterCount());
                for (int i = sootMethod.getParameterCount() - 1; i >= 0; --i) {
                    arrayList.add(Util.getDefaultValueFor((Type)sootMethod.getParameterType(i)));
                }
                SpecialInvokeExpr specialInvokeExpr = jimple.newSpecialInvokeExpr(local, sootMethod, arrayList);
                InvokeStmt invokeStmt = jimple.newInvokeStmt((Value)specialInvokeExpr);
                invokeStmt.addTag((Tag)namedTag);
                invokeStmt.getInvokeExprBox().addTag((Tag)namedTag);
                specialInvokeExpr.getBaseBox().addTag((Tag)namedTag);
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(assignStmt);
                arrayList2.add(invokeStmt);
                TagBasedDestructiveSliceResidualizer.this.stmt2predecessors.put(throwStmt, arrayList2);
                throwStmt.setOp((Value)local);
            }
        }

        boolean residualize(Stmt stmt) {
            boolean bl = false;
            if (stmt.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                this.setResult(null);
                stmt.apply((Switch)this);
                Stmt stmt2 = (Stmt)this.getResult();
                if (stmt2 != null) {
                    TagBasedDestructiveSliceResidualizer.this.oldStmt2newStmt.put(stmt, stmt2);
                }
                bl = true;
            }
            return bl;
        }

        private SootMethod prepareInitIn(SootClass sootClass) {
            boolean bl;
            SootMethod sootMethod;
            SootMethod sootMethod2 = null;
            if (sootClass.hasSuperclass()) {
                sootMethod2 = this.prepareInitIn(sootClass.getSuperclass());
            }
            boolean bl2 = (sootMethod = sootClass.getMethod("<init>", Collections.EMPTY_LIST, (Type)VoidType.v())) != null ? !sootMethod.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize) : (bl = false);
            if (sootMethod == null || bl) {
                RefType refType;
                Collection collection;
                Pair pair;
                if (bl) {
                    sootClass.removeMethod(sootMethod);
                    pair = (Pair)CollectionsUtilities.getFromMap((Map)TagBasedDestructiveSliceResidualizer.this.class2members, (Object)sootClass, (Factory)this.VALUE_FACTORY);
                    collection = (Collection)pair.getFirst();
                    collection.remove(sootMethod);
                }
                sootMethod = new SootMethod("<init>", Collections.EMPTY_LIST, (Type)VoidType.v());
                sootMethod.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                pair = Jimple.v();
                collection = pair.newBody(sootMethod);
                if (sootMethod2 != null) {
                    refType = RefType.v((SootClass)sootClass);
                    LocalCreation localCreation = new LocalCreation(collection.getLocals());
                    Local local = localCreation.newLocal("_this", (Type)refType);
                    IdentityStmt identityStmt = pair.newIdentityStmt((Value)local, (Value)pair.newThisRef(refType));
                    identityStmt.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    identityStmt.getLeftOpBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    identityStmt.getRightOpBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    collection.getUnits().add((Object)identityStmt);
                    SpecialInvokeExpr specialInvokeExpr = pair.newSpecialInvokeExpr(local, sootMethod2);
                    InvokeStmt invokeStmt = pair.newInvokeStmt((Value)specialInvokeExpr);
                    invokeStmt.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    invokeStmt.getInvokeExprBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    specialInvokeExpr.getBaseBox().addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                    collection.getUnits().add((Object)invokeStmt);
                }
                refType = pair.newReturnVoidStmt();
                refType.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                collection.getUnits().add((Object)refType);
                sootMethod.setActiveBody((Body)collection);
                sootClass.addMethod(sootMethod);
                if (!sootClass.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                    sootClass.addTag((Tag)TagBasedDestructiveSliceResidualizer.this.tagToResidualize);
                }
            }
            return sootMethod;
        }

        private void residualizeDefStmt(DefinitionStmt definitionStmt) {
            if (!definitionStmt.getLeftOpBox().hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize)) {
                ValueBox valueBox = definitionStmt.getRightOpBox();
                if (valueBox.hasTag(TagBasedDestructiveSliceResidualizer.this.theNameOfTagToResidualize) && !definitionStmt.containsInvokeExpr()) {
                    String string = "Incorrect slice.  How can a def statement and it's non-invoke rhs be marked with the lhs unmarked? ->" + definitionStmt;
                    LOGGER.error((Object)string);
                    throw new IllegalStateException(string);
                }
                Jimple jimple = Jimple.v();
                if (definitionStmt.containsInvokeExpr()) {
                    Value value = definitionStmt.getRightOp();
                    InvokeStmt invokeStmt = jimple.newInvokeStmt(value);
                    this.valueProcessor.residualize(definitionStmt.getRightOpBox());
                    this.setResult(invokeStmt);
                } else {
                    this.setResult(jimple.newNopStmt());
                }
            } else {
                this.valueProcessor.residualize(definitionStmt.getRightOpBox());
            }
        }
    }
}

