/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer.transformations;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import edu.ksu.cis.indus.transformations.common.AbstractTransformer;
import edu.ksu.cis.indus.transformations.common.Cloner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.util.Chain;

class CloningBasedSliceResidualizer
extends AbstractTransformer {
    protected Scene transformedSystem;
    protected Scene untransformedSystem;
    private Cloner cloner;
    private Map slicedMethod2stmtMap = new HashMap();
    private Map unslicedMethod2stmtMap = new HashMap();
    private Object sliceType;

    CloningBasedSliceResidualizer() {
    }

    public void setCloner(Cloner cloner) {
        this.cloner = cloner;
    }

    public void setTagName(String string) {
    }

    public SootClass getTransformed(SootClass sootClass) {
        return this.cloner.getCloneOf(sootClass);
    }

    public SootField getTransformed(SootField sootField) {
        return this.cloner.getCloneOf(sootField);
    }

    public SootMethod getTransformed(SootMethod sootMethod) {
        return this.cloner.getCloneOf(sootMethod);
    }

    public Stmt getTransformed(Stmt stmt, SootMethod sootMethod) {
        Stmt stmt2 = null;
        Map map = (Map)this.unslicedMethod2stmtMap.get(sootMethod);
        if (map != null) {
            stmt2 = (Stmt)map.get(stmt);
        }
        return stmt2;
    }

    public ValueBox getTransformed(ValueBox valueBox, Stmt stmt, SootMethod sootMethod) {
        Stmt stmt2 = this.getTransformed(stmt, sootMethod);
        int n = stmt.getUseAndDefBoxes().indexOf(valueBox);
        return (ValueBox)stmt2.getUseAndDefBoxes().get(n);
    }

    public Collection getTransformedClasses() {
        return this.transformedSystem.getClasses();
    }

    public SootClass getTransformedSootClass(String string) {
        return this.transformedSystem.getSootClass(string);
    }

    public SootClass getUntransformed(SootClass sootClass) {
        return this.untransformedSystem.getSootClass(sootClass.getName());
    }

    public Stmt getUntransformed(Stmt stmt, SootMethod sootMethod) {
        Stmt stmt2 = null;
        Map map = (Map)this.slicedMethod2stmtMap.get(sootMethod);
        if (map != null) {
            stmt2 = (Stmt)map.get(stmt);
        }
        return stmt2;
    }

    public void setUntransformedSystem(Scene scene) {
        this.transformedSystem = scene;
    }

    public void completeTransformation() {
        this.fixupMethods();
        Iterator iterator = this.unslicedMethod2stmtMap.keySet().iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            SootMethod sootMethod2 = this.cloner.getCloneOf(sootMethod);
            if (sootMethod2 == null) {
                this.slicedMethod2stmtMap.put(sootMethod2, null);
                continue;
            }
            Map map = (Map)this.unslicedMethod2stmtMap.get(sootMethod);
            Map map2 = (Map)this.slicedMethod2stmtMap.get(sootMethod2);
            PatchingChain patchingChain = ((JimpleBody)sootMethod.getActiveBody()).getUnits();
            PatchingChain patchingChain2 = ((JimpleBody)sootMethod2.getActiveBody()).getUnits();
            Iterator iterator2 = patchingChain.iterator();
            while (iterator2.hasNext()) {
                Stmt stmt = (Stmt)iterator2.next();
                if (patchingChain2.contains(map.get(stmt))) continue;
                map2.remove(map.get(stmt));
                map.remove(stmt);
            }
        }
    }

    public void fixupMethods() {
        NopEliminator nopEliminator = NopEliminator.v();
        Jimple jimple = Jimple.v();
        Iterator iterator = this.getTransformedClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            SootClass sootClass2 = this.getUntransformed(sootClass);
            Iterator iterator2 = sootClass.getMethods().iterator();
            while (iterator2.hasNext()) {
                Unit unit;
                Stmt stmt;
                Unit unit2;
                Trap trap;
                SootMethod sootMethod = (SootMethod)iterator2.next();
                SootMethod sootMethod2 = sootClass2.getMethod(sootMethod.getName(), sootMethod.getParameterTypes(), sootMethod.getReturnType());
                Body body = sootMethod2.getActiveBody();
                Body body2 = sootMethod.getActiveBody();
                Chain chain = body2.getTraps();
                Iterator iterator3 = body.getTraps().iterator();
                while (iterator3.hasNext()) {
                    trap = (Trap)iterator3.next();
                    unit2 = trap.getBeginUnit();
                    stmt = this.getTransformed((Stmt)unit2, sootMethod2);
                    unit = trap.getEndUnit();
                    Stmt stmt2 = this.getTransformed((Stmt)unit, sootMethod2);
                    Unit unit3 = trap.getHandlerUnit();
                    Stmt stmt3 = this.getTransformed((Stmt)unit3, sootMethod2);
                    chain.add((Object)jimple.newTrap(this.getTransformed(trap.getException()), (Unit)stmt, (Unit)stmt2, (Unit)stmt3));
                }
                iterator3 = body.getUnits().iterator();
                while (iterator3.hasNext()) {
                    trap = (Stmt)iterator3.next();
                    if (!trap.branches()) continue;
                    if (trap instanceof GotoStmt) {
                        unit2 = (GotoStmt)this.getTransformed((Stmt)trap, sootMethod2);
                        unit2.setTarget((Unit)this.getSlicedStmt((Stmt)unit2.getTarget(), sootMethod2));
                        continue;
                    }
                    if (trap instanceof IfStmt) {
                        unit2 = (IfStmt)this.getTransformed((Stmt)trap, sootMethod2);
                        unit2.setTarget((Unit)this.getSlicedStmt(unit2.getTarget(), sootMethod2));
                        continue;
                    }
                    if (trap instanceof LookupSwitchStmt) {
                        unit2 = (LookupSwitchStmt)this.getTransformed((Stmt)trap, sootMethod2);
                        for (int i = 0; i < unit2.getTargetCount(); ++i) {
                            unit = (Stmt)unit2.getTarget(i);
                            unit2.setTarget(i, (Unit)this.getSlicedStmt((Stmt)unit, sootMethod2));
                        }
                        stmt = (Stmt)unit2.getDefaultTarget();
                        unit2.setDefaultTarget((Unit)this.getSlicedStmt(stmt, sootMethod2));
                        continue;
                    }
                    if (!(trap instanceof TableSwitchStmt)) continue;
                    unit2 = (TableSwitchStmt)this.getTransformed((Stmt)trap, sootMethod2);
                    for (int i = 0; i < unit2.getHighIndex() - unit2.getLowIndex(); ++i) {
                        unit = (Stmt)unit2.getTarget(i);
                        unit2.setTarget(i, (Unit)this.getSlicedStmt((Stmt)unit, sootMethod2));
                    }
                    stmt = (Stmt)unit2.getDefaultTarget();
                    unit2.setDefaultTarget((Unit)this.getSlicedStmt(stmt, sootMethod2));
                }
                this.pruneExceptionsAtMethodInterface(sootMethod, (Chain)body2.getUnits());
                nopEliminator.transform(body2);
            }
        }
    }

    public boolean handleSliceType(Object object, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (object.equals(SlicingEngine.BACKWARD_SLICE) || object.equals(SlicingEngine.COMPLETE_SLICE)) && bl;
        if (bl2) {
            this.sliceType = object;
        }
        return bl2;
    }

    public boolean handlesPartialInclusions() {
        return false;
    }

    public void initialize(Scene scene) {
        this.untransformedSystem = scene;
    }

    public void makeExecutable() {
    }

    public void processSeedCriteria(Collection collection) {
    }

    public void reset() {
        this.unslicedMethod2stmtMap.clear();
        this.slicedMethod2stmtMap.clear();
        this.cloner = null;
        this.transformedSystem = null;
        this.untransformedSystem = null;
    }

    public void transform(Stmt stmt, SootMethod sootMethod) {
        Stmt stmt2 = this.cloner.cloneASTFragment(stmt, sootMethod);
        PatchingChain patchingChain = sootMethod.getActiveBody().getUnits();
        PatchingChain patchingChain2 = this.getSliceStmtListFor(sootMethod);
        this.writeIntoAt(stmt2, patchingChain2, stmt, patchingChain);
        this.addMapping(stmt2, stmt, sootMethod);
    }

    public void transform(ValueBox valueBox, Stmt stmt, SootMethod sootMethod) {
    }

    protected void transformSeed(Stmt stmt, SootMethod sootMethod) {
    }

    protected void transformSeed(ValueBox valueBox, Stmt stmt, SootMethod sootMethod) {
    }

    private Stmt getSlicedStmt(Stmt stmt, SootMethod sootMethod) {
        Stmt stmt2 = null;
        SootMethod sootMethod2 = this.getTransformed(sootMethod);
        Iterator iterator = sootMethod2.getActiveBody().getUnits().iterator();
        Iterator iterator2 = sootMethod.getActiveBody().getUnits().iterator();
        while (iterator2.hasNext()) {
            Stmt stmt3 = (Stmt)iterator2.next();
            stmt2 = (Stmt)iterator.next();
            if (!stmt3.equals(stmt)) continue;
            break;
        }
        return stmt2;
    }

    private void addMapping(Stmt stmt, Stmt stmt2, SootMethod sootMethod) {
        Map map = (Map)this.unslicedMethod2stmtMap.get(sootMethod);
        if (map != null) {
            map.put(stmt2, stmt);
        }
        if ((map = (Map)this.slicedMethod2stmtMap.get(this.cloner.getCloneOf(sootMethod))) != null) {
            map.put(stmt, stmt2);
        }
    }

    private void pruneExceptionsAtMethodInterface(SootMethod sootMethod, Chain chain) {
        Stmt stmt;
        HashSet<SootClass> hashSet = new HashSet<SootClass>();
        List list = sootMethod.getExceptions();
        Iterator iterator = chain.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass;
            stmt = (Stmt)iterator.next();
            if (stmt instanceof ThrowStmt) {
                hashSet.add(this.getTransformedSootClass(((RefType)((ThrowStmt)stmt).getOp().getType()).getClassName()));
                continue;
            }
            if (stmt instanceof InvokeStmt) {
                hashSet.addAll(stmt.getInvokeExpr().getMethod().getExceptions());
                continue;
            }
            if (!(stmt instanceof ThrowStmt) || Util.isDescendentOf((SootClass)(sootClass = ((RefType)((ThrowStmt)stmt).getOp().getType()).getSootClass()), (String)"java.lang.RuntimException")) continue;
            hashSet.add(sootClass);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            stmt = (SootClass)iterator.next();
            if (hashSet.contains(stmt)) continue;
            sootMethod.removeException((SootClass)stmt);
        }
    }

    private void writeIntoAt(Stmt stmt, PatchingChain patchingChain, Object object, PatchingChain patchingChain2) {
        Object var5_5 = null;
        Iterator iterator = patchingChain.iterator();
        Iterator iterator2 = patchingChain2.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            var5_5 = iterator.next();
            if (!e.equals(object)) continue;
        }
        patchingChain.insertAfter(var5_5, (Object)stmt);
        patchingChain.remove(var5_5);
    }
}

