/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.PoolAwareWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.INewExpr2InitMapper;
import edu.ksu.cis.indus.interfaces.IPoolable;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.slicer.AbstractSliceCriterion;
import edu.ksu.cis.indus.slicer.SliceCollector;
import edu.ksu.cis.indus.slicer.SliceCriteriaFactory;
import edu.ksu.cis.indus.slicer.SliceExpr;
import edu.ksu.cis.indus.slicer.SliceStmt;
import edu.ksu.cis.indus.staticanalyses.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.tagkit.Host;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public final class SlicingEngine {
    public static final Object BACKWARD_SLICE = "BACKWARD_SLICE";
    public static final Object COMPLETE_SLICE = "COMPLETE_SLICE";
    public static final Object FORWARD_SLICE = "FORWARD_SLICE";
    public static final Collection SLICE_TYPES;
    static final Log LOGGER;
    BasicBlockGraphMgr bbgMgr;
    Object sliceType = BACKWARD_SLICE;
    private AnalysesController controller;
    private final Collection exitTransformedMethods = new HashSet();
    private final IWorkBag workbag = new PoolAwareWorkBag((IWorkBag)new FIFOWorkBag());
    private Collection controlflowBasedDAs = new ArrayList();
    private ICallGraphInfo cgi;
    private List criteria = new ArrayList();
    private final Map method2params = new HashMap();
    private DependenceClosure criteriaClosure;
    private INewExpr2InitMapper initMapper;
    private SliceCollector collector = new SliceCollector(this);
    static /* synthetic */ Class class$edu$ksu$cis$indus$slicer$SlicingEngine;

    public void setAnalysesControllerAndDependenciesToUse(AnalysesController analysesController, Collection collection) {
        this.controller = analysesController;
        this.controlflowBasedDAs.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!e.equals(IDependencyAnalysis.CONTROL_DA) && !e.equals(IDependencyAnalysis.SYNCHRONIZATION_DA) && !e.equals(IDependencyAnalysis.DIVERGENCE_DA)) continue;
            this.controlflowBasedDAs.addAll(this.controller.getAnalyses(e));
        }
        if (collection.contains(IDependencyAnalysis.READY_DA)) {
            this.controlflowBasedDAs.addAll(this.controller.getAnalyses(IDependencyAnalysis.READY_DA));
        }
    }

    public void setBasicBlockGraphManager(BasicBlockGraphMgr basicBlockGraphMgr) {
        this.bbgMgr = basicBlockGraphMgr;
    }

    public void setCgi(ICallGraphInfo iCallGraphInfo) {
        this.cgi = iCallGraphInfo;
    }

    public SliceCollector getCollector() {
        return this.collector;
    }

    public void setInitMapper(INewExpr2InitMapper iNewExpr2InitMapper) {
        this.initMapper = iNewExpr2InitMapper;
    }

    public void setSliceCriteria(Collection collection) {
        Object object;
        if (collection == null || collection.size() == 0) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"Slice criteria is unspecified.");
            }
            throw new IllegalStateException("Slice criteria is unspecified.");
        }
        if (this.controller == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"Class Manager and/or Controller is unspecified.");
            }
            throw new IllegalStateException("Class Manager and/or Controller is unspecified.");
        }
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!SliceCriteriaFactory.isSlicingCriterion(object)) {
                LOGGER.error((Object)("The work piece is not a subtype of AbstractSliceCriterion" + object));
                throw new IllegalStateException("The work piece is not a subtype of AbstractSliceCriterion" + object);
            }
            try {
                this.criteria.add(((AbstractSliceCriterion)object).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error((Object)("The work piece could not be cloned - " + object), (Throwable)cloneNotSupportedException);
                throw new IllegalStateException("The work piece could not be cloned - " + object);
            }
        }
        Collections.sort(this.criteria, ToStringBasedComparator.SINGLETON);
        if (LOGGER.isDebugEnabled()) {
            object2 = new StringBuffer();
            object = this.criteria.iterator();
            while (object.hasNext()) {
                ((StringBuffer)object2).append("\n\t");
                ((StringBuffer)object2).append(object.next());
            }
            LOGGER.debug((Object)("Criteria:\n" + ((StringBuffer)object2).toString()));
            LOGGER.debug((Object)"END: Populating deadlock criteria.");
        }
    }

    public void setSliceType(Object object) {
        if (!SLICE_TYPES.contains(this.sliceType)) {
            throw new IllegalArgumentException("The given slice type is not one of XXX_SLICE values defined in this class.");
        }
        this.sliceType = object;
        if (this.sliceType.equals(BACKWARD_SLICE)) {
            this.criteriaClosure = new DependenceClosure(new BackwardSliceDependenceClosure());
        } else if (this.sliceType.equals(FORWARD_SLICE)) {
            this.criteriaClosure = new DependenceClosure(new ForwardSliceDependenceClosure());
        } else if (this.sliceType.equals(COMPLETE_SLICE)) {
            this.criteriaClosure = new DependenceClosure(new CompleteSliceDependenceClosure());
        }
    }

    public void setTagName(String string) {
        this.collector.setTagName(string);
    }

    public void initialize() {
        if (this.collector.getTagName() == null) {
            LOGGER.fatal((Object)"Please set the tag name before executing the engine.");
            throw new IllegalStateException("Please set the tag name before executing the engine.");
        }
    }

    public void reset() {
        this.cgi = null;
        this.collector.reset();
        this.criteria.clear();
        this.method2params.clear();
        this.exitTransformedMethods.clear();
        while (this.workbag.hasWork()) {
            Object object = this.workbag.getWork();
            ((IPoolable)object).returnToPool();
        }
    }

    public void slice() {
        Object object;
        Object object2 = this.criteria.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            this.workbag.addWorkNoDuplicates(object);
        }
        while (this.workbag.hasWork()) {
            object2 = this.workbag.getWork();
            if (object2 instanceof SliceExpr) {
                this.transformAndGenerateNewCriteriaForExpr((SliceExpr)object2);
            } else if (object2 instanceof SliceStmt) {
                object = (SliceStmt)object2;
                SootMethod sootMethod = ((AbstractSliceCriterion)object).getOccurringMethod();
                this.transformAndGenerateNewCriteriaForStmt((Stmt)((SliceStmt)object).getCriterion(), sootMethod, ((AbstractSliceCriterion)object).isConsiderExecution());
            }
            ((IPoolable)object2).returnToPool();
        }
        this.collector.completeSlicing();
    }

    BasicBlockGraphMgr getBasicBlockGraphManager() {
        return this.bbgMgr;
    }

    private boolean considerMethodExitForCriteriaGeneration(SootMethod sootMethod) {
        boolean bl = false;
        if (!this.exitTransformedMethods.contains(sootMethod)) {
            this.exitTransformedMethods.add(sootMethod);
            bl = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Consider Method exit for method " + sootMethod + " is " + bl));
        }
        return bl;
    }

    private void generateNewCriteria(Stmt stmt, SootMethod sootMethod, Collection collection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Generating Criteria based on dependences");
        }
        this.criteriaClosure.setTrigger(stmt, sootMethod);
        CollectionUtils.forAllDo((Collection)collection, (Closure)this.criteriaClosure);
        Iterator iterator = this.criteriaClosure.getCriteriaMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            boolean bl = (Boolean)entry.getKey();
            Iterator iterator2 = ((Collection)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod2;
                Stmt stmt2;
                Object e = iterator2.next();
                if (e instanceof Pair) {
                    Pair pair = (Pair)e;
                    stmt2 = (Stmt)pair.getFirst();
                    sootMethod2 = (SootMethod)pair.getSecond();
                } else {
                    stmt2 = (Stmt)e;
                    sootMethod2 = sootMethod;
                }
                this.generateSliceStmtCriterion(stmt2, sootMethod2, bl);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Generating Criteria based on dependences");
        }
    }

    private void generateNewCriteriaBasedOnMethodExit(Stmt stmt, SootMethod sootMethod, boolean bl, SootMethod sootMethod2, BasicBlockGraph basicBlockGraph) {
        block6: {
            block5: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Generating criteria for method called at " + stmt + " in " + sootMethod));
                }
                if (!this.considerMethodExitForCriteriaGeneration(sootMethod2)) break block5;
                if (sootMethod2.isConcrete()) {
                    this.processSuperInitInInit(sootMethod2, basicBlockGraph);
                    Iterator iterator = basicBlockGraph.getTails().iterator();
                    while (iterator.hasNext()) {
                        BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
                        Stmt stmt2 = basicBlock.getTrailerStmt();
                        this.generateSliceStmtCriterion(stmt2, sootMethod2, bl);
                    }
                } else {
                    this.includeMethodAndDeclaringClassInSlice(sootMethod2);
                }
                break block6;
            }
            BitSet bitSet = (BitSet)this.method2params.get(sootMethod2);
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            if (bitSet == null || sootMethod2.getParameterCount() <= 0) break block6;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.generateSliceExprCriterion(invokeExpr.getArgBox(n), stmt, sootMethod, true);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    private void generateNewCriteriaForInvokeExprIn(Stmt stmt, SootMethod sootMethod, boolean bl) {
        InvokeExpr invokeExpr;
        SootMethod sootMethod2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Generating criteria for invocation expressions (caller-callee)");
        }
        if ((sootMethod2 = (invokeExpr = stmt.getInvokeExpr()).getMethod()).isStatic()) {
            this.generateNewCriteriaForReturnPointOfMethods(Collections.singleton(sootMethod2), stmt, sootMethod, bl);
        } else {
            Context context = new Context();
            context.setRootMethod(sootMethod);
            context.setStmt(stmt);
            Collection collection = this.cgi.getCallees(invokeExpr, context);
            this.generateNewCriteriaForReturnPointOfMethods(collection, stmt, sootMethod, bl);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Generating criteria for invocation expressions (caller-callee)");
        }
    }

    private void generateNewCriteriaForParam(ValueBox valueBox, SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Generating criteria for parameters");
        }
        ParameterRef parameterRef = (ParameterRef)valueBox.getValue();
        int n = parameterRef.getIndex();
        BitSet bitSet = (BitSet)this.method2params.get(sootMethod);
        if (bitSet == null) {
            bitSet = new BitSet(8);
            this.method2params.put(sootMethod, bitSet);
        }
        bitSet.set(parameterRef.getIndex());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Parameters required for " + sootMethod + " are " + bitSet));
        }
        Iterator iterator = this.cgi.getCallers(sootMethod).iterator();
        while (iterator.hasNext()) {
            ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
            SootMethod sootMethod2 = callTriple.getMethod();
            Stmt stmt = callTriple.getStmt();
            ValueBox valueBox2 = callTriple.getExpr().getArgBox(n);
            this.generateSliceExprCriterion(valueBox2, stmt, sootMethod2, true);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Generating criteria for parameters");
        }
    }

    private void generateNewCriteriaForReturnPointOfMethods(Collection collection, Stmt stmt, SootMethod sootMethod, boolean bl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Generating criteria for return points " + bl));
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod2 = (SootMethod)iterator.next();
            BasicBlockGraph basicBlockGraph = this.bbgMgr.getBasicBlockGraph(sootMethod2);
            if (sootMethod2.getName().equals("start") && sootMethod2.getDeclaringClass().getName().equals("java.lang.Thread") && sootMethod2.getReturnType().equals(VoidType.v()) && sootMethod2.getParameterCount() == 0) continue;
            if (basicBlockGraph == null) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("No basic block graph available for " + sootMethod2.getSignature() + ". Moving on."));
                continue;
            }
            this.generateNewCriteriaBasedOnMethodExit(stmt, sootMethod, bl, sootMethod2, basicBlockGraph);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Generating criteria for return points");
        }
    }

    private void generateNewCriteriaForTheCallToMethod(SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Generating criteria for call-sites (callee-caller) " + sootMethod));
        }
        if (!this.collector.hasBeenCollected((Host)sootMethod)) {
            this.includeMethodAndDeclaringClassInSlice(sootMethod);
            boolean bl = !sootMethod.isStatic();
            Iterator iterator = this.cgi.getCallers(sootMethod).iterator();
            while (iterator.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                SootMethod sootMethod2 = callTriple.getMethod();
                Stmt stmt = callTriple.getStmt();
                this.generateSliceStmtCriterion(stmt, sootMethod2, false);
                this.generateSliceExprCriterion(stmt.getInvokeExprBox(), stmt, sootMethod2, false);
                if (!bl) continue;
                ValueBox valueBox = ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBaseBox();
                this.generateSliceExprCriterion(valueBox, stmt, sootMethod2, true);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Generating criteria for call-sites (callee-caller)");
        }
    }

    private void generateSliceExprCriterion(ValueBox valueBox, Stmt stmt, SootMethod sootMethod, boolean bl) {
        if (!this.collector.hasBeenCollected((Host)valueBox)) {
            Collection collection = SliceCriteriaFactory.getFactory().getCriterion(sootMethod, stmt, valueBox, bl);
            this.workbag.addAllWorkNoDuplicates(collection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Adding expr [" + bl + "] " + valueBox.getValue() + " at " + stmt + " in " + sootMethod.getSignature() + " to workbag."));
            }
        } else {
            if (valueBox.getValue() instanceof InvokeExpr) {
                this.generateNewCriteriaForInvokeExprIn(stmt, sootMethod, bl);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Already collected expr " + valueBox.getValue() + " occurring at " + stmt + " in " + sootMethod.getSignature()));
            }
        }
    }

    private void generateSliceStmtCriterion(Stmt stmt, SootMethod sootMethod, boolean bl) {
        if (!this.collector.hasBeenCollected((Host)stmt)) {
            Collection collection = SliceCriteriaFactory.getFactory().getCriterion(sootMethod, stmt, bl);
            this.workbag.addAllWorkNoDuplicates(collection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Adding [" + bl + "] " + stmt + " in " + sootMethod.getSignature() + " to workbag."));
            }
        } else {
            if (bl) {
                Iterator iterator = stmt.getUseAndDefBoxes().iterator();
                while (iterator.hasNext()) {
                    ValueBox valueBox = (ValueBox)iterator.next();
                    this.generateSliceExprCriterion(valueBox, stmt, sootMethod, bl);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Already collected stmt " + stmt + " in " + sootMethod.getSignature()));
            }
        }
    }

    private void includeClassInSlice(SootClass sootClass) {
        this.collector.includeInSlice((Host)sootClass);
    }

    private void includeMethodAndDeclaringClassInSlice(SootMethod sootMethod) {
        this.collector.includeInSlice((Host)sootMethod);
        SootClass sootClass = sootMethod.getDeclaringClass();
        this.includeClassInSlice(sootClass);
        HashSet<Type> hashSet = new HashSet<Type>(sootMethod.getParameterTypes());
        hashSet.add(sootMethod.getReturnType());
        this.includeTypesInSlice(hashSet);
    }

    private void includeTypesInSlice(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (type instanceof RefType) {
                this.includeClassInSlice(((RefType)type).getSootClass());
                continue;
            }
            if (!(type instanceof ArrayType) || !(((ArrayType)type).baseType instanceof RefType)) continue;
            this.includeClassInSlice(((RefType)((ArrayType)type).baseType).getSootClass());
        }
    }

    private void processForNewExpr(Stmt stmt, SootMethod sootMethod) {
        AssignStmt assignStmt;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: Processing for new expr");
        }
        if (stmt instanceof AssignStmt && (assignStmt = (AssignStmt)stmt).getRightOp() instanceof NewExpr) {
            Stmt stmt2 = this.initMapper.getInitCallStmtForNewExprStmt(stmt, sootMethod);
            this.transformAndGenerateNewCriteriaForStmt(stmt2, sootMethod, true);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Processing for new expr");
        }
    }

    private void processSuperInitInInit(SootMethod sootMethod, BasicBlockGraph basicBlockGraph) {
        if (sootMethod.getName().equals("<init>") && sootMethod.getDeclaringClass().hasSuperclass()) {
            CompleteUnitGraph completeUnitGraph = new CompleteUnitGraph(sootMethod.getActiveBody());
            SimpleLocalUses simpleLocalUses = new SimpleLocalUses((UnitGraph)completeUnitGraph, (LocalDefs)new SimpleLocalDefs((UnitGraph)completeUnitGraph));
            List list = simpleLocalUses.getUsesOf((Unit)basicBlockGraph.getHead().getLeaderStmt());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SootMethod sootMethod2;
                UnitValueBoxPair unitValueBoxPair = (UnitValueBoxPair)iterator.next();
                Stmt stmt = (Stmt)unitValueBoxPair.getUnit();
                if (!(stmt instanceof InvokeStmt) || !(sootMethod2 = stmt.getInvokeExpr().getMethod()).getName().equals("<init>") || !sootMethod2.getDeclaringClass().equals(sootMethod.getDeclaringClass().getSuperclass())) continue;
                this.generateSliceStmtCriterion(stmt, sootMethod, true);
            }
        }
    }

    private void transformAndGenerateCriteriaForVBoxes(Collection collection, Stmt stmt, SootMethod sootMethod) {
        Object object;
        Object object2;
        Serializable serializable;
        if (LOGGER.isDebugEnabled()) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("BEGIN: Transforming value boxes [");
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (ValueBox)object2.next();
                ((StringBuffer)serializable).append(object.getValue());
                ((StringBuffer)serializable).append("[" + object + "]");
                ((StringBuffer)serializable).append(", ");
            }
            ((StringBuffer)serializable).append("]");
            LOGGER.debug((Object)((StringBuffer)serializable).toString());
        }
        serializable = new HashSet();
        object2 = new ArrayList();
        object2.addAll(this.controller.getAnalyses(IDependencyAnalysis.IDENTIFIER_BASED_DATA_DA));
        object = collection.iterator();
        while (object.hasNext()) {
            ValueBox valueBox = (ValueBox)object.next();
            if (this.collector.hasBeenCollected((Host)valueBox)) continue;
            this.collector.includeInSlice((Host)valueBox);
            Value value = valueBox.getValue();
            if (value instanceof ParameterRef) {
                this.generateNewCriteriaForParam(valueBox, sootMethod);
                this.generateNewCriteriaForTheCallToMethod(sootMethod);
            } else if (value instanceof FieldRef || value instanceof ArrayRef) {
                object2.addAll(this.controller.getAnalyses(IDependencyAnalysis.REFERENCE_BASED_DATA_DA));
                object2.addAll(this.controller.getAnalyses(IDependencyAnalysis.INTERFERENCE_DA));
                if (value instanceof FieldRef) {
                    SootField sootField = ((FieldRef)valueBox.getValue()).getField();
                    this.collector.includeInSlice((Host)sootField);
                    this.includeClassInSlice(sootField.getDeclaringClass());
                }
            }
            serializable.add(value.getType());
        }
        this.includeTypesInSlice((Collection)((Object)serializable));
        this.generateNewCriteria(stmt, sootMethod, (Collection)object2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: Transforming value boxes");
        }
    }

    private void transformAndGenerateNewCriteriaForExpr(SliceExpr sliceExpr) {
        Stmt stmt = sliceExpr.getOccurringStmt();
        SootMethod sootMethod = sliceExpr.getOccurringMethod();
        ValueBox valueBox = (ValueBox)sliceExpr.getCriterion();
        Value value = valueBox.getValue();
        boolean bl = sliceExpr.isConsiderExecution();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Transforming expr criteria: " + valueBox.getValue() + "[" + bl + "] at " + stmt + " in " + sootMethod));
        }
        this.transformAndGenerateNewCriteriaForStmt(stmt, sootMethod, false);
        if (bl) {
            HashSet<ValueBox> hashSet = new HashSet<ValueBox>(value.getUseBoxes());
            hashSet.add(valueBox);
            this.transformAndGenerateToConsiderExecution(stmt, sootMethod, hashSet);
        } else {
            this.collector.includeInSlice((Host)valueBox);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Transforming expr criteria: " + valueBox.getValue() + " at " + stmt + " in " + sootMethod));
        }
    }

    private void transformAndGenerateNewCriteriaForStmt(Stmt stmt, SootMethod sootMethod, boolean bl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Transforming stmt criteria: " + stmt + "[" + bl + "] in " + sootMethod));
        }
        if (bl) {
            this.processForNewExpr(stmt, sootMethod);
            this.transformAndGenerateToConsiderExecution(stmt, sootMethod, stmt.getUseAndDefBoxes());
        }
        this.generateNewCriteriaForTheCallToMethod(sootMethod);
        this.generateNewCriteria(stmt, sootMethod, this.controlflowBasedDAs);
        this.includeMethodAndDeclaringClassInSlice(sootMethod);
        this.collector.includeInSlice((Host)stmt);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Transforming stmt criteria: " + stmt + "[" + bl + "] in " + sootMethod));
        }
    }

    private void transformAndGenerateToConsiderExecution(Stmt stmt, SootMethod sootMethod, Collection collection) {
        this.transformAndGenerateCriteriaForVBoxes(collection, stmt, sootMethod);
        if (stmt.containsInvokeExpr()) {
            this.generateNewCriteriaForInvokeExprIn(stmt, sootMethod, true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$slicer$SlicingEngine == null ? (class$edu$ksu$cis$indus$slicer$SlicingEngine = SlicingEngine.class$("edu.ksu.cis.indus.slicer.SlicingEngine")) : class$edu$ksu$cis$indus$slicer$SlicingEngine));
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(BACKWARD_SLICE);
        hashSet.add(FORWARD_SLICE);
        hashSet.add(COMPLETE_SLICE);
        SLICE_TYPES = Collections.unmodifiableCollection(hashSet);
    }

    private class ForwardSliceDependenceClosure
    implements DependenceClosure.IDependenceRetriver {
        private ForwardSliceDependenceClosure() {
        }

        public Collection getDependences(IDependencyAnalysis iDependencyAnalysis, Stmt stmt, SootMethod sootMethod) {
            return new HashSet(iDependencyAnalysis.getDependents((Object)stmt, (Object)sootMethod));
        }
    }

    private class CompleteSliceDependenceClosure
    implements DependenceClosure.IDependenceRetriver {
        private CompleteSliceDependenceClosure() {
        }

        public Collection getDependences(IDependencyAnalysis iDependencyAnalysis, Stmt stmt, SootMethod sootMethod) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(iDependencyAnalysis.getDependees((Object)stmt, (Object)sootMethod));
            hashSet.addAll(iDependencyAnalysis.getDependents((Object)stmt, (Object)sootMethod));
            return hashSet;
        }
    }

    private class BackwardSliceDependenceClosure
    implements DependenceClosure.IDependenceRetriver {
        private BackwardSliceDependenceClosure() {
        }

        public Collection getDependences(IDependencyAnalysis iDependencyAnalysis, Stmt stmt, SootMethod sootMethod) {
            return new HashSet(iDependencyAnalysis.getDependees((Object)stmt, (Object)sootMethod));
        }
    }

    private static class DependenceClosure
    implements Closure {
        protected SootMethod method;
        protected Stmt stmt;
        private final Collection falseCriteria;
        private final Collection trueCriteria;
        private final IDependenceRetriver retriever;
        private final Map newCriteria = new HashMap();

        protected DependenceClosure(IDependenceRetriver iDependenceRetriver) {
            this.trueCriteria = new HashSet();
            this.falseCriteria = new HashSet();
            this.retriever = iDependenceRetriver;
            this.newCriteria.put(Boolean.TRUE, this.trueCriteria);
            this.newCriteria.put(Boolean.FALSE, this.falseCriteria);
        }

        public final void execute(Object object) {
            Object object2;
            IDependencyAnalysis iDependencyAnalysis = (IDependencyAnalysis)object;
            Collection collection = this.retriever.getDependences(iDependencyAnalysis, this.stmt, this.method);
            if (iDependencyAnalysis.getId().equals(IDependencyAnalysis.READY_DA)) {
                object2 = ((ReadyDAv1)iDependencyAnalysis).getSynchronizedMethodEntryExitPoints(collection);
                this.falseCriteria.addAll(object2);
                collection.removeAll((Collection<?>)object2);
            }
            this.trueCriteria.addAll(collection);
            if (LOGGER.isDebugEnabled()) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("Criteria bases for " + this.stmt + "@" + this.method + " from " + iDependencyAnalysis.getClass() + " are :\n[");
                Iterator iterator = this.retriever.getDependences(iDependencyAnalysis, this.stmt, this.method).iterator();
                while (iterator.hasNext()) {
                    ((StringBuffer)object2).append("\n\t->" + iterator.next());
                }
                ((StringBuffer)object2).append("\n]");
                LOGGER.debug((Object)((StringBuffer)object2).toString());
            }
        }

        final Map getCriteriaMap() {
            return Collections.unmodifiableMap(this.newCriteria);
        }

        final void setTrigger(Stmt stmt, SootMethod sootMethod) {
            this.stmt = stmt;
            this.method = sootMethod;
            this.trueCriteria.clear();
            this.falseCriteria.clear();
        }

        static interface IDependenceRetriver {
            public Collection getDependences(IDependencyAnalysis var1, Stmt var2, SootMethod var3);
        }
    }
}

