/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.slicer.AbstractSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.BackwardSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.CompleteSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.ForwardSliceGotoProcessor;
import edu.ksu.cis.indus.slicer.SlicingEngine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.tagkit.Host;
import soot.tagkit.Tag;

public final class SliceCollector {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$slicer$SliceCollector == null ? (class$edu$ksu$cis$indus$slicer$SliceCollector = SliceCollector.class$("edu.ksu.cis.indus.slicer.SliceCollector")) : class$edu$ksu$cis$indus$slicer$SliceCollector));
    private final Collection taggedClasses = new HashSet();
    private final Collection taggedMethods = new HashSet();
    private NamedTag tag;
    private SlicingEngine engine;
    private String tagName;
    static /* synthetic */ Class class$edu$ksu$cis$indus$slicer$SliceCollector;

    SliceCollector(SlicingEngine slicingEngine) {
        this.engine = slicingEngine;
    }

    public Collection getClassesInSlice() {
        return Collections.unmodifiableCollection(this.taggedClasses);
    }

    public List getCollected(Collection collection) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            if (!this.hasBeenCollected(host)) continue;
            arrayList.add(host);
        }
        return arrayList;
    }

    public Collection getMethodsInSlice() {
        return Collections.unmodifiableCollection(this.taggedMethods);
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean hasBeenCollected(Host host) {
        NamedTag namedTag = (NamedTag)host.getTag(this.tagName);
        return namedTag != null;
    }

    public void includeInSlice(Host host) {
        NamedTag namedTag = (NamedTag)host.getTag(this.tagName);
        if (namedTag == null) {
            host.addTag((Tag)this.tag);
            if (host instanceof SootMethod) {
                this.taggedMethods.add(host);
            } else if (host instanceof SootClass) {
                this.taggedClasses.add(host);
            }
            if (LOGGER.isDebugEnabled()) {
                Host host2 = host;
                if (host instanceof ValueBox) {
                    host2 = ((ValueBox)host).getValue();
                }
                LOGGER.debug((Object)("Tagged[1]: " + host2));
            }
        } else if (namedTag != this.tag) {
            host.removeTag(this.tagName);
            host.addTag((Tag)this.tag);
            if (LOGGER.isDebugEnabled()) {
                Object object = host instanceof ValueBox ? ((ValueBox)host).getValue() : host;
                LOGGER.debug((Object)("Tagged[2]: " + object));
            }
        } else if (LOGGER.isDebugEnabled()) {
            Object object = host instanceof ValueBox ? ((ValueBox)host).getValue() : host;
            LOGGER.debug((Object)("Already Tagged: " + object));
        }
    }

    public void includeInSlice(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            this.includeInSlice(host);
        }
    }

    public void processGotos() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Processing Gotos");
        }
        AbstractSliceGotoProcessor abstractSliceGotoProcessor = null;
        if (this.engine.sliceType.equals(SlicingEngine.BACKWARD_SLICE)) {
            abstractSliceGotoProcessor = new BackwardSliceGotoProcessor(this);
        } else if (this.engine.sliceType.equals(SlicingEngine.FORWARD_SLICE)) {
            abstractSliceGotoProcessor = new ForwardSliceGotoProcessor(this);
        } else if (this.engine.sliceType.equals(SlicingEngine.COMPLETE_SLICE)) {
            abstractSliceGotoProcessor = new CompleteSliceGotoProcessor(this);
        }
        BasicBlockGraphMgr basicBlockGraphMgr = this.engine.getBasicBlockGraphManager();
        abstractSliceGotoProcessor.process(this.taggedMethods, basicBlockGraphMgr);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Iterator iterator = this.taggedClasses.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            printWriter.println("Class: " + sootClass);
            printWriter.println("  Fields:");
            Iterator iterator2 = this.getCollected((Collection)sootClass.getFields()).iterator();
            while (iterator2.hasNext()) {
                printWriter.println("    " + iterator2.next());
            }
            printWriter.println("  Methods:");
            iterator2 = this.getCollected(sootClass.getMethods()).iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                printWriter.println("    " + sootMethod);
                if (!sootMethod.hasActiveBody()) continue;
                Iterator iterator3 = this.getCollected((Collection)sootMethod.getActiveBody().getUnits()).iterator();
                while (iterator3.hasNext()) {
                    Stmt stmt = (Stmt)iterator3.next();
                    printWriter.println("      " + stmt);
                    Iterator iterator4 = this.getCollected(stmt.getUseAndDefBoxes()).iterator();
                    while (iterator4.hasNext()) {
                        printWriter.println("        " + ((ValueBox)iterator4.next()).getValue());
                    }
                }
            }
        }
        printWriter.flush();
        printWriter.close();
        return stringWriter.getBuffer().toString();
    }

    void setTagName(String string) {
        if (string != null) {
            this.tag = new NamedTag(string);
            this.tagName = string;
        }
    }

    void completeSlicing() {
        this.processGotos();
    }

    void reset() {
        this.taggedMethods.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

