/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.slicer;

import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.slicer.ISliceGotoProcessor;
import edu.ksu.cis.indus.slicer.SliceCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.Stmt;
import soot.tagkit.Host;
import soot.toolkits.graph.UnitGraph;

public abstract class AbstractSliceGotoProcessor
implements ISliceGotoProcessor {
    protected final IWorkBag workBag = new LIFOWorkBag();
    protected final SliceCollector sliceCollector;
    protected SootMethod method;

    protected AbstractSliceGotoProcessor(SliceCollector sliceCollector) {
        this.sliceCollector = sliceCollector;
    }

    public final void process(Collection collection, BasicBlockGraphMgr basicBlockGraphMgr) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            BasicBlockGraph basicBlockGraph = basicBlockGraphMgr.getBasicBlockGraph(sootMethod);
            if (basicBlockGraph == null) continue;
            this.process(sootMethod, basicBlockGraph);
        }
    }

    protected abstract void processForIntraBasicBlockGotos(BasicBlockGraph.BasicBlock var1);

    private void process(SootMethod sootMethod, BasicBlockGraph basicBlockGraph) {
        Trap trap;
        this.method = sootMethod;
        this.workBag.clear();
        this.processForIntraBasicBlockGotos(basicBlockGraph);
        UnitGraph unitGraph = basicBlockGraph.getStmtGraph();
        List list = IteratorUtils.toList((Iterator)unitGraph.iterator());
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        Object object = unitGraph.getBody().getTraps().iterator();
        while (object.hasNext()) {
            trap = (Trap)object.next();
            arrayList.add(trap.getHandlerUnit());
        }
        object = new HashSet();
        while (this.workBag.hasWork()) {
            Stmt stmt;
            List list2;
            trap = (BasicBlockGraph.BasicBlock)this.workBag.getWork();
            Stmt stmt2 = trap.getLeaderStmt();
            int n = list.indexOf(stmt2);
            object.add(trap);
            if (n <= 0 || (list2 = unitGraph.getSuccsOf((Object)(stmt = (Stmt)list.get(n - 1)))).contains(stmt2) && !arrayList.contains(stmt2) && (!list2.contains(stmt2) || !(stmt instanceof GotoStmt))) continue;
            this.sliceCollector.includeInSlice((Host)stmt);
            BasicBlockGraph.BasicBlock basicBlock = basicBlockGraph.getEnclosingBlock(stmt);
            if (object.contains(basicBlock)) continue;
            this.processForIntraBasicBlockGotos(basicBlock);
            this.workBag.addWorkNoDuplicates((Object)basicBlock);
        }
    }

    private void processForIntraBasicBlockGotos(BasicBlockGraph basicBlockGraph) {
        Iterator iterator = basicBlockGraph.getNodes().iterator();
        while (iterator.hasNext()) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            this.processForIntraBasicBlockGotos(basicBlock);
        }
    }
}

