/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Main;
import soot.Modifier;
import soot.NormalUnitPrinter;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.util.Chain;
import soot.util.StringTools;
import soot.xml.XMLNode;
import soot.xml.XMLRoot;

public class XMLPrinter {
    public static final String xmlHeader = "<?xml version=\"1.0\" ?>\n";
    public static final String dtdHeader = "<!DOCTYPE jil SYSTEM \"http://www.sable.mcgill.ca/~flynn/jil/jil10.dtd\">\n";
    public XMLRoot root;
    private XMLNode xmlNode = null;

    public String toString() {
        if (this.root != null) {
            return this.root.toString();
        }
        throw new RuntimeException("Error generating XML!");
    }

    public XMLNode addElement(String name) {
        return this.addElement(name, "", "", "");
    }

    public XMLNode addElement(String name, String value) {
        return this.addElement(name, value, "", "");
    }

    public XMLNode addElement(String name, String value, String[] attributes) {
        return this.addElement(name, value, attributes, null);
    }

    public XMLNode addElement(String name, String value, String attribute, String attributeValue) {
        return this.addElement(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    public XMLNode addElement(String name, String value, String[] attributes, String[] values) {
        return this.root.addElement(name, value, attributes, values);
    }

    public XMLPrinter(Singletons.Global g) {
    }

    public static XMLPrinter v() {
        return G.v().XMLPrinter();
    }

    public XMLNode setXMLNode(XMLNode node) {
        this.xmlNode = node;
        return this.xmlNode;
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        NormalUnitPrinter up = new NormalUnitPrinter(body);
        Map stmtToName = up.labels();
        PatchingChain units = body.getUnits();
        CompleteUnitGraph completeUnitGraph = new CompleteUnitGraph(body);
        SimpleLiveLocals sll = new SimpleLiveLocals(completeUnitGraph);
        String cleanMethodName = this.cleanMethod(body.getMethod().getName());
        Iterator unitIt = units.iterator();
        Unit currentStmt = null;
        String indent = "        ";
        String currentLabel = "default";
        long statementCount = 0L;
        long labelCount = 0L;
        long labelID = 0L;
        boolean index = false;
        Vector<String> useList = new Vector<String>();
        Vector<Vector<Long>> useDataList = new Vector<Vector<Long>>();
        Vector<String> defList = new Vector<String>();
        Vector<Vector<Long>> defDataList = new Vector<Vector<Long>>();
        Vector<Vector> paramData = new Vector<Vector>();
        Vector<XMLLabel> xmlLabelsList = new Vector<XMLLabel>();
        long maxStmtCount = 0L;
        XMLNode methodNode = this.xmlNode.addChild("method", new String[]{"name", "returntype", "class"}, new String[]{cleanMethodName, body.getMethod().getReturnType().toString(), body.getMethod().getDeclaringClass().getName().toString()});
        String declarationStr = body.getMethod().getDeclaration().toString().trim();
        methodNode.addChild("declaration", this.toCDATA(declarationStr), new String[]{"length"}, new String[]{declarationStr.length() + ""});
        XMLNode parametersNode = methodNode.addChild("parameters", new String[]{"method"}, new String[]{cleanMethodName});
        XMLNode localsNode = methodNode.addChild("locals");
        XMLNode labelsNode = methodNode.addChild("labels");
        XMLNode stmtsNode = methodNode.addChild("statements");
        XMLLabel xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
        labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{labelCount++ + "", currentLabel, cleanMethodName});
        while (unitIt.hasNext()) {
            int i;
            Vector<Long> tempVector;
            String local;
            Unit previousStmt = currentStmt;
            currentStmt = (Unit)unitIt.next();
            Stmt stmtCurrentStmt = (Stmt)currentStmt;
            if (stmtToName.containsKey(currentStmt)) {
                currentLabel = stmtToName.get(currentStmt).toString();
                xmlLabel.stmtCount = labelID;
                xmlLabel.stmtPercentage = new Float((double)(new Float(labelID).floatValue() / (float)new Float(units.size()).intValue()) * 100.0).longValue();
                if (xmlLabel.stmtPercentage > maxStmtCount) {
                    maxStmtCount = xmlLabel.stmtPercentage;
                }
                xmlLabelsList.addElement(xmlLabel);
                xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
                labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{labelCount + "", currentLabel, cleanMethodName});
                ++labelCount;
                labelID = 0L;
            }
            XMLNode stmtNode = stmtsNode.addChild("statement", new String[]{"id", "label", "method", "labelid"}, new String[]{statementCount + "", currentLabel, cleanMethodName, labelID + ""});
            XMLNode sootstmtNode = stmtNode.addChild("soot_statement", new String[]{"branches", "fallsthrough"}, new String[]{this.boolToString(currentStmt.branches()), this.boolToString(currentStmt.fallsThrough())});
            int j = 0;
            for (ValueBox box : currentStmt.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = this.cleanLocal(((Local)box.getValue()).toString());
                sootstmtNode.addChild("uses", new String[]{"id", "local", "method"}, new String[]{j + "", local, cleanMethodName});
                ++j;
                tempVector = null;
                int useIndex = useList.indexOf(local);
                if (useIndex == -1) {
                    useDataList.addElement(tempVector);
                    useList.addElement(local);
                    useIndex = useList.indexOf(local);
                }
                if (useDataList.size() <= useIndex) continue;
                tempVector = (Vector<Long>)useDataList.elementAt(useIndex);
                if (tempVector == null) {
                    tempVector = new Vector<Long>();
                }
                tempVector.addElement(new Long(statementCount));
                useDataList.setElementAt(tempVector, useIndex);
            }
            j = 0;
            for (ValueBox box : currentStmt.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = this.cleanLocal(((Local)box.getValue()).toString());
                sootstmtNode.addChild("defines", new String[]{"id", "local", "method"}, new String[]{j + "", local, cleanMethodName});
                ++j;
                tempVector = null;
                int defIndex = defList.indexOf(local);
                if (defIndex == -1) {
                    defDataList.addElement(tempVector);
                    defList.addElement(local);
                    defIndex = defList.indexOf(local);
                }
                if (defDataList.size() <= defIndex) continue;
                tempVector = (Vector<Long>)defDataList.elementAt(defIndex);
                if (tempVector == null) {
                    tempVector = new Vector<Long>();
                }
                tempVector.addElement(new Long(statementCount));
                defDataList.setElementAt(tempVector, defIndex);
            }
            List liveLocalsIn = sll.getLiveLocalsBefore(currentStmt);
            List liveLocalsOut = sll.getLiveLocalsAfter(currentStmt);
            XMLNode livevarsNode = sootstmtNode.addChild("livevariables", new String[]{"incount", "outcount"}, new String[]{liveLocalsIn.size() + "", liveLocalsOut.size() + ""});
            for (i = 0; i < liveLocalsIn.size(); ++i) {
                livevarsNode.addChild("in", new String[]{"id", "local", "method"}, new String[]{i + "", this.cleanLocal(liveLocalsIn.get(i).toString()), cleanMethodName});
            }
            for (i = 0; i < liveLocalsOut.size(); ++i) {
                livevarsNode.addChild("out", new String[]{"id", "local", "method"}, new String[]{i + "", this.cleanLocal(liveLocalsOut.get(i).toString()), cleanMethodName});
            }
            for (i = 0; i < body.getMethod().getParameterTypes().size(); ++i) {
                Vector tempVec = new Vector();
                paramData.addElement(tempVec);
            }
            currentStmt.toString(up);
            String jimpleStr = up.toString().trim();
            if (currentStmt instanceof IdentityStmt && jimpleStr.indexOf("@parameter") != -1) {
                int paramIndex;
                Vector tempVec;
                String tempStr = jimpleStr.substring(jimpleStr.indexOf("@parameter") + 10);
                if (tempStr.indexOf(":") != -1) {
                    tempStr = tempStr.substring(0, tempStr.indexOf(":")).trim();
                }
                if (tempStr.indexOf(" ") != -1) {
                    tempStr = tempStr.substring(0, tempStr.indexOf(" ")).trim();
                }
                if ((tempVec = (Vector)paramData.elementAt(paramIndex = new Integer(tempStr).intValue())) != null) {
                    tempVec.addElement(Long.toString(statementCount));
                }
                paramData.setElementAt(tempVec, paramIndex);
            }
            sootstmtNode.addChild("jimple", this.toCDATA(jimpleStr), new String[]{"length"}, new String[]{jimpleStr.length() + 1 + ""});
            ++labelID;
            ++statementCount;
        }
        stmtsNode.addAttribute("count", statementCount + "");
        parametersNode.addAttribute("count", body.getMethod().getParameterCount() + "");
        for (int i = 0; i < body.getMethod().getParameterTypes().size(); ++i) {
            XMLNode paramNode = parametersNode.addChild("parameter", new String[]{"id", "type", "method", "name"}, new String[]{i + "", body.getMethod().getParameterTypes().get(i).toString(), cleanMethodName, "_parameter" + i});
            XMLNode sootparamNode = paramNode.addChild("soot_parameter");
            Vector tempVec = (Vector)paramData.elementAt(i);
            for (int k = 0; k < tempVec.size(); ++k) {
                sootparamNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{k + "", String.valueOf(tempVec.elementAt(k)) + "", cleanMethodName});
            }
            sootparamNode.addAttribute("uses", tempVec.size() + "");
        }
        xmlLabel.stmtCount = labelID;
        xmlLabel.stmtPercentage = new Float((double)(new Float(labelID).floatValue() / new Float(units.size()).floatValue()) * 100.0).longValue();
        if (xmlLabel.stmtPercentage > maxStmtCount) {
            maxStmtCount = xmlLabel.stmtPercentage;
        }
        xmlLabelsList.addElement(xmlLabel);
        Chain locals = body.getLocals();
        Iterator localsIterator = locals.iterator();
        Vector<String> localTypes = new Vector<String>();
        Vector<Vector> typedLocals = new Vector<Vector>();
        Vector<Integer> typeCounts = new Vector<Integer>();
        String xmlLongLocals = "";
        int j = 0;
        int currentType = 0;
        while (localsIterator.hasNext()) {
            int i;
            Vector tempVector;
            String query;
            int k;
            int useCount = 0;
            int defineCount = 0;
            Local localData = (Local)localsIterator.next();
            String local = this.cleanLocal(localData.toString());
            String localType = localData.getType().toString();
            if (!localTypes.contains(localType)) {
                localTypes.addElement(localType);
                typedLocals.addElement(new Vector());
                typeCounts.addElement(new Integer(0));
            }
            XMLNode localNode = new XMLNode("local", "", new String[]{"id", "method", "name", "type"}, new String[]{j + "", cleanMethodName, local, localType});
            XMLNode sootlocalNode = localNode.addChild("soot_local");
            currentType = 0;
            for (k = 0; k < localTypes.size(); ++k) {
                if (!localType.equalsIgnoreCase((String)localTypes.elementAt(k))) continue;
                currentType = k;
                Integer tempInt = new Integer((Integer)typeCounts.elementAt(k) + 1);
                typeCounts.setElementAt(tempInt, k);
                break;
            }
            for (k = 0; k < useList.size(); ++k) {
                query = (String)useList.elementAt(k);
                if (!query.equalsIgnoreCase(local)) continue;
                tempVector = (Vector)useDataList.elementAt(useList.indexOf(local));
                for (i = 0; i < tempVector.size(); ++i) {
                    sootlocalNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{i + "", ((Long)tempVector.elementAt(i)).toString(), cleanMethodName});
                }
                useCount = tempVector.size();
                break;
            }
            for (k = 0; k < defList.size(); ++k) {
                query = (String)defList.elementAt(k);
                if (!query.equalsIgnoreCase(local)) continue;
                tempVector = (Vector)defDataList.elementAt(defList.indexOf(local));
                for (i = 0; i < tempVector.size(); ++i) {
                    sootlocalNode.addChild("definition", new String[]{"id", "line", "method"}, new String[]{i + "", ((Long)tempVector.elementAt(i)).toString(), cleanMethodName});
                }
                defineCount = tempVector.size();
                break;
            }
            sootlocalNode.addAttribute("uses", useCount + "");
            sootlocalNode.addAttribute("defines", defineCount + "");
            Vector list = (Vector)typedLocals.elementAt(currentType);
            list.addElement(localNode);
            typedLocals.setElementAt(list, currentType);
            localsNode.addChild((XMLNode)localNode.clone());
            ++j;
        }
        localsNode.addAttribute("count", locals.size() + "");
        XMLNode typesNode = localsNode.addChild("types", new String[]{"count"}, new String[]{localTypes.size() + ""});
        for (int i = 0; i < localTypes.size(); ++i) {
            String type = (String)localTypes.elementAt(i);
            XMLNode typeNode = typesNode.addChild("type", new String[]{"id", "type", "count"}, new String[]{i + "", type, (Integer)typeCounts.elementAt(i) + ""});
            Vector list = (Vector)typedLocals.elementAt(i);
            for (j = 0; j < list.size(); ++j) {
                typeNode.addChild((XMLNode)list.elementAt(j));
            }
        }
        labelsNode.addAttribute("count", labelCount + "");
        XMLNode current = labelsNode.child;
        for (int i = 0; i < xmlLabelsList.size(); ++i) {
            XMLLabel tempLabel = (XMLLabel)xmlLabelsList.elementAt(i);
            tempLabel.stmtPercentage = new Float((double)(new Float(tempLabel.stmtPercentage).floatValue() / new Float(maxStmtCount).floatValue()) * 100.0).longValue();
            if (current == null) continue;
            current.addAttribute("stmtcount", tempLabel.stmtCount + "");
            current.addAttribute("stmtpercentage", tempLabel.stmtPercentage + "");
            current = current.next;
        }
        statementCount = 0L;
        XMLNode exceptionsNode = methodNode.addChild("exceptions");
        Iterator trapIt = body.getTraps().iterator();
        if (trapIt.hasNext()) {
            while (trapIt.hasNext()) {
                Trap trap = (Trap)trapIt.next();
                XMLNode catchNode = exceptionsNode.addChild("exception", new String[]{"id", "method", "type"}, new String[]{statementCount++ + "", cleanMethodName, Scene.v().quotedNameOf(trap.getException().getName())});
                catchNode.addChild("begin", new String[]{"label"}, new String[]{stmtToName.get(trap.getBeginUnit()).toString()});
                catchNode.addChild("end", new String[]{"label"}, new String[]{stmtToName.get(trap.getEndUnit()).toString()});
                catchNode.addChild("handler", new String[]{"label"}, new String[]{stmtToName.get(trap.getHandlerUnit()).toString()});
            }
        }
        exceptionsNode.addAttribute("count", exceptionsNode.getNumberOfChildren() + "");
    }

    private String cleanMethod(String str) {
        return str.trim().replace('<', '_').replace('>', '_');
    }

    private String cleanLocal(String str) {
        return str.trim();
    }

    private String toCDATA(String str) {
        str = StringTools.replaceAll(str, "]]>", "]]&gt;");
        return "<![CDATA[" + str + "]]>";
    }

    private String boolToString(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }

    private void printXMLTo(SootClass cl, PrintWriter out) {
        this.root = new XMLRoot();
        XMLNode xmlRootNode = null;
        XMLNode xmlHistoryNode = null;
        XMLNode xmlClassNode = null;
        XMLNode xmlTempNode = null;
        xmlRootNode = this.root.addElement("jil");
        String cmdlineStr = "";
        for (int i = 0; i < Main.v().cmdLineArgs.length; ++i) {
            cmdlineStr = cmdlineStr + Main.v().cmdLineArgs[i] + " ";
        }
        String dateStr = new Date().toString();
        xmlHistoryNode = xmlRootNode.addChild("history");
        xmlHistoryNode.addAttribute("created", dateStr);
        xmlHistoryNode.addChild("soot", new String[]{"version", "command", "timestamp"}, new String[]{Main.v().versionString, cmdlineStr.trim(), dateStr});
        xmlClassNode = xmlRootNode.addChild("class", new String[]{"name"}, new String[]{Scene.v().quotedNameOf(cl.getName()).toString()});
        if (cl.getPackageName().length() > 0) {
            xmlClassNode.addAttribute("package", cl.getPackageName());
        }
        if (cl.hasSuperclass()) {
            xmlClassNode.addAttribute("extends", Scene.v().quotedNameOf(cl.getSuperclass().getName()).toString());
        }
        xmlTempNode = xmlClassNode.addChild("modifiers");
        StringTokenizer st = new StringTokenizer(Modifier.toString(cl.getModifiers()));
        while (st.hasMoreTokens()) {
            xmlTempNode.addChild("modifier", new String[]{"name"}, new String[]{st.nextToken() + ""});
        }
        xmlTempNode.addAttribute("count", xmlTempNode.getNumberOfChildren() + "");
        xmlTempNode = xmlClassNode.addChild("interfaces", "", new String[]{"count"}, new String[]{cl.getInterfaceCount() + ""});
        Iterator interfaceIt = cl.getInterfaces().iterator();
        if (interfaceIt.hasNext()) {
            while (interfaceIt.hasNext()) {
                xmlTempNode.addChild("implements", "", new String[]{"class"}, new String[]{Scene.v().quotedNameOf(((SootClass)interfaceIt.next()).getName()).toString()});
            }
        }
        xmlTempNode = xmlClassNode.addChild("fields", "", new String[]{"count"}, new String[]{cl.getFieldCount() + ""});
        Iterator fieldIt = cl.getFields().iterator();
        if (fieldIt.hasNext()) {
            int i = 0;
            while (fieldIt.hasNext()) {
                SootField f = (SootField)fieldIt.next();
                if (f.isPhantom()) continue;
                String type = f.getType().toString();
                String name = f.getName().toString();
                XMLNode xmlFieldNode = xmlTempNode.addChild("field", "", new String[]{"id", "name", "type"}, new String[]{i++ + "", name, type});
                XMLNode xmlModifiersNode = xmlFieldNode.addChild("modifiers");
                StringTokenizer st2 = new StringTokenizer(Modifier.toString(f.getModifiers()));
                while (st2.hasMoreTokens()) {
                    xmlModifiersNode.addChild("modifier", new String[]{"name"}, new String[]{st2.nextToken() + ""});
                }
                xmlModifiersNode.addAttribute("count", xmlModifiersNode.getNumberOfChildren() + "");
            }
        }
        Iterator methodIt = cl.methodIterator();
        this.setXMLNode(xmlClassNode.addChild("methods", new String[]{"count"}, new String[]{cl.getMethodCount() + ""}));
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (method.isPhantom() || Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers())) continue;
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method " + method.getName() + " has no active body!");
            }
            this.printTo(method.getActiveBody(), out);
        }
        out.println(this.toString());
    }

    public void printJimpleStyleTo(SootClass cl, PrintWriter out) {
        this.printXMLTo(cl, out);
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        this.printStatementsInBody(b, out);
    }

    class XMLLabel {
        public long id;
        public String methodName;
        public String label;
        public long stmtCount;
        public long stmtPercentage;

        public XMLLabel(long in_id, String in_methodName, String in_label) {
            this.id = in_id;
            this.methodName = in_methodName;
            this.label = in_label;
        }
    }
}

