/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.Body;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.ValueBox;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.KeyTag;
import soot.tagkit.Tag;
import soot.xml.Attribute;
import soot.xml.Key;

public class TagCollector {
    private ArrayList attributes = new ArrayList();
    private ArrayList keys = new ArrayList();

    public void collectTags(SootClass sc) {
        for (SootField sf : sc.getFields()) {
            this.collectFieldTags(sf);
        }
        for (SootMethod sm : sc.getMethods()) {
            this.collectMethodTags(sm);
            if (!sm.hasActiveBody()) continue;
            Body b = sm.getActiveBody();
            this.collectBodyTags(b);
        }
    }

    public void collectKeyTags(SootClass sc) {
        for (Object next : sc.getTags()) {
            if (!(next instanceof KeyTag)) continue;
            KeyTag kt = (KeyTag)next;
            Key k = new Key(kt.red(), kt.green(), kt.blue(), kt.key());
            this.keys.add(k);
        }
    }

    public void printKeys(PrintWriter writerOut) {
        for (Key k : this.keys) {
            k.print(writerOut);
        }
    }

    public void collectFieldTags(SootField sf) {
        Iterator fTags = sf.getTags().iterator();
        Attribute fa = new Attribute();
        while (fTags.hasNext()) {
            Tag t = (Tag)fTags.next();
            fa.addTag(t);
        }
        this.attributes.add(fa);
    }

    public void collectMethodTags(SootMethod sm) {
        if (!sm.hasActiveBody()) {
            return;
        }
        if (!sm.getTags().isEmpty()) {
            Iterator mTags = sm.getTags().iterator();
            Attribute ma = new Attribute();
            while (mTags.hasNext()) {
                Tag t = (Tag)mTags.next();
                ma.addTag(t);
            }
            this.attributes.add(ma);
        }
    }

    public void collectBodyTags(Body b) {
        for (Unit u : b.getUnits()) {
            Iterator itTags = u.getTags().iterator();
            Attribute ua = new Attribute();
            JimpleLineNumberTag jlnt = null;
            while (itTags.hasNext()) {
                Tag t = (Tag)itTags.next();
                ua.addTag(t);
                if (!(t instanceof JimpleLineNumberTag)) continue;
                jlnt = (JimpleLineNumberTag)t;
            }
            this.attributes.add(ua);
            for (ValueBox vb : u.getUseAndDefBoxes()) {
                if (vb.getTags().isEmpty()) continue;
                Iterator tagsIt = vb.getTags().iterator();
                Attribute va = new Attribute();
                while (tagsIt.hasNext()) {
                    Tag t = (Tag)tagsIt.next();
                    va.addTag(t);
                    if (jlnt == null) continue;
                    va.addTag(jlnt);
                }
                this.attributes.add(va);
            }
        }
    }

    public void printTags(PrintWriter writerOut) {
        for (Attribute a : this.attributes) {
            a.print(writerOut);
        }
    }
}

