/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.jimple.spark.fieldrw.FieldRWTag;
import soot.jimple.toolkits.annotation.tags.ArrayCheckTag;
import soot.jimple.toolkits.annotation.tags.ArrayNullCheckTag;
import soot.jimple.toolkits.annotation.tags.NullCheckTag;
import soot.jimple.toolkits.pointer.CastCheckTag;
import soot.tagkit.ColorTag;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.LinkTag;
import soot.tagkit.PositionTag;
import soot.tagkit.SourceLineNumberTag;
import soot.tagkit.SourcePositionTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.util.StringTools;
import soot.xml.PosColorAttribute;

public class JavaAttribute {
    private int startLn;
    private ArrayList tags;
    private ArrayList vbAttrs;
    public PrintWriter writerOut;

    public int startLn() {
        return this.startLn;
    }

    public void startLn(int x) {
        this.startLn = x;
    }

    public ArrayList tags() {
        return this.tags;
    }

    public ArrayList vbAttrs() {
        return this.vbAttrs;
    }

    public void addTag(Tag t) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        this.tags.add(t);
    }

    public void addVbAttr(PosColorAttribute vbAttr) {
        if (this.vbAttrs == null) {
            this.vbAttrs = new ArrayList();
        }
        this.vbAttrs.add(vbAttr);
    }

    public boolean hasInfoTag() {
        if (this.tags != null) {
            for (Tag t : this.tags) {
                if (t instanceof StringTag) {
                    return true;
                }
                if (t instanceof LinkTag) {
                    return true;
                }
                if (t instanceof ArrayCheckTag) {
                    return true;
                }
                if (t instanceof ArrayNullCheckTag) {
                    return true;
                }
                if (t instanceof NullCheckTag) {
                    return true;
                }
                if (t instanceof CastCheckTag) {
                    return true;
                }
                if (!(t instanceof FieldRWTag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasColorTag() {
        if (this.tags != null) {
            for (Object t : this.tags) {
                if (!(t instanceof ColorTag)) continue;
                return true;
            }
        }
        if (this.vbAttrs != null) {
            for (Object t : this.vbAttrs) {
                if (!((PosColorAttribute)t).hasColor()) continue;
                return true;
            }
        }
        return false;
    }

    private void printAttributeTag(Tag t) {
        if (t instanceof LineNumberTag) {
            int lnNum = new Integer(((LineNumberTag)t).toString());
            this.printJavaLnAttr(lnNum, lnNum);
        } else if (t instanceof JimpleLineNumberTag) {
            JimpleLineNumberTag jlnTag = (JimpleLineNumberTag)t;
            this.printJimpleLnAttr(jlnTag.getStartLineNumber(), jlnTag.getEndLineNumber());
        } else if (t instanceof SourceLineNumberTag) {
            SourceLineNumberTag jlnTag = (SourceLineNumberTag)t;
            this.printJavaLnAttr(jlnTag.getStartLineNumber(), jlnTag.getEndLineNumber());
        } else if (t instanceof LinkTag) {
            LinkTag lt = (LinkTag)t;
            Host h = lt.getLink();
            this.printLinkAttr(this.formatForXML(lt.toString()), this.getJimpleLnOfHost(h), this.getJavaLnOfHost(h), lt.getClassName());
        } else if (t instanceof StringTag) {
            this.printTextAttr(this.formatForXML(((StringTag)t).toString()));
        } else if (t instanceof SourcePositionTag) {
            SourcePositionTag pt = (SourcePositionTag)t;
            this.printSourcePositionAttr(pt.getStartOffset(), pt.getEndOffset());
        } else if (t instanceof PositionTag) {
            PositionTag pt = (PositionTag)t;
            this.printJimplePositionAttr(pt.getStartOffset(), pt.getEndOffset());
        } else if (t instanceof ColorTag) {
            ColorTag ct = (ColorTag)t;
            this.printColorAttr(ct.getRed(), ct.getGreen(), ct.getBlue(), ct.isForeground());
        } else {
            this.printTextAttr(t.toString());
        }
    }

    private void printJavaLnAttr(int start_ln, int end_ln) {
        this.writerOut.println("<javaStartLn>" + start_ln + "</javaStartLn>");
        this.writerOut.println("<javaEndLn>" + end_ln + "</javaEndLn>");
    }

    private void printJimpleLnAttr(int start_ln, int end_ln) {
        this.writerOut.println("<jimpleStartLn>" + start_ln + "</jimpleStartLn>");
        this.writerOut.println("<jimpleEndLn>" + end_ln + "</jimpleEndLn>");
    }

    private void printTextAttr(String text) {
        this.writerOut.println("<text>" + text + "</text>");
    }

    private void printLinkAttr(String label, int jimpleLink, int javaLink, String className) {
        this.writerOut.println("<link_attribute>");
        this.writerOut.println("<link_label>" + label + "</link_label>");
        this.writerOut.println("<jimple_link>" + jimpleLink + "</jimple_link>");
        this.writerOut.println("<java_link>" + javaLink + "</java_link>");
        this.writerOut.println("<className>" + className + "</className>");
        this.writerOut.println("</link_attribute>");
    }

    private void startPrintValBoxAttr() {
        this.writerOut.println("<value_box_attribute>");
    }

    private void printSourcePositionAttr(int start, int end) {
        this.writerOut.println("<javaStartPos>" + start + "</javaStartPos>");
        this.writerOut.println("<javaEndPos>" + end + "</javaEndPos>");
    }

    private void printJimplePositionAttr(int start, int end) {
        this.writerOut.println("<jimpleStartPos>" + start + "</jimpleStartPos>");
        this.writerOut.println("<jimpleEndPos>" + end + "</jimpleEndPos>");
    }

    private void printColorAttr(int r, int g, int b, boolean fg) {
        this.writerOut.println("<red>" + r + "</red>");
        this.writerOut.println("<green>" + g + "</green>");
        this.writerOut.println("<blue>" + b + "</blue>");
        if (fg) {
            this.writerOut.println("<fg>1</fg>");
        } else {
            this.writerOut.println("<fg>0</fg>");
        }
    }

    private void endPrintValBoxAttr() {
        this.writerOut.println("</value_box_attribute>");
    }

    public void printAllTags(PrintWriter writer) {
        this.writerOut = writer;
        if (this.tags != null) {
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                this.printAttributeTag((Tag)it.next());
            }
        }
        if (this.vbAttrs != null) {
            for (PosColorAttribute attr : this.vbAttrs) {
                if (!attr.hasColor()) continue;
                this.startPrintValBoxAttr();
                this.printSourcePositionAttr(attr.javaStartPos(), attr.javaEndPos());
                this.printJimplePositionAttr(attr.jimpleStartPos(), attr.jimpleEndPos());
                this.endPrintValBoxAttr();
            }
        }
    }

    public void printInfoTags(PrintWriter writer) {
        this.writerOut = writer;
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            this.printAttributeTag((Tag)it.next());
        }
    }

    private String formatForXML(String in) {
        in = StringTools.replaceAll(in, "<", "&lt;");
        in = StringTools.replaceAll(in, ">", "&gt;");
        in = StringTools.replaceAll(in, "&", "&amp;");
        return in;
    }

    private int getJavaLnOfHost(Host h) {
        for (Tag t : h.getTags()) {
            if (t instanceof SourceLineNumberTag) {
                return ((SourceLineNumberTag)t).getStartLineNumber();
            }
            if (!(t instanceof LineNumberTag)) continue;
            return new Integer(((LineNumberTag)t).toString());
        }
        return 0;
    }

    private int getJimpleLnOfHost(Host h) {
        for (Tag t : h.getTags()) {
            if (!(t instanceof JimpleLineNumberTag)) continue;
            return ((JimpleLineNumberTag)t).getStartLineNumber();
        }
        return 0;
    }
}

