/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.CompilationDeathException;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.options.Options;
import soot.util.ClassInputRep;
import soot.util.JavaInputRep;
import soot.util.JimpleInputRep;
import soot.util.SingletonList;
import soot.util.SootInputRepresentation;

public class SourceLocator {
    private char pathSeparator = System.getProperty("path.separator").charAt(0);
    private char fileSeparator = System.getProperty("file.separator").charAt(0);
    private List zipFileList = Collections.synchronizedList(new LinkedList());
    private HashMap sourceToClassMap;
    private Map nameToZipFile = new HashMap();
    private List previousLocations = null;
    private String previousCP = "<impossible-class-path>";
    private boolean isRunningUnderBraindeadOS = System.getProperty("os.name").startsWith("Windows");
    private int count = 0;
    private List locationsFound;
    private String fullPathFound;

    public SourceLocator(Singletons.Global g) {
    }

    public static SourceLocator v() {
        return G.v().SourceLocator();
    }

    public HashMap getSourceToClassMap() {
        return this.sourceToClassMap;
    }

    public void setSourceToClassMap(HashMap map) {
        this.sourceToClassMap = map;
    }

    public void addToSourceToClassMap(String key, String val) {
        this.sourceToClassMap.put(key, val);
    }

    public InputStream getInputStreamOf(String className) throws ClassNotFoundException {
        return this.getInputStreamOf(Scene.v().getSootClassPath(), className);
    }

    public InputStream getInputStreamOf(String classPath, String className) throws ClassNotFoundException {
        ArrayList<String> locations = null;
        if (classPath == this.previousCP || this.previousCP.equals(classPath)) {
            locations = this.previousLocations;
        } else {
            this.previousCP = classPath;
            locations = new ArrayList<String>();
            if (classPath == null) {
                classPath = System.getProperty("java.class.path") + this.pathSeparator + System.getProperty("java.home") + this.fileSeparator + "lib" + this.fileSeparator + "rt.jar";
            }
            String userDir = System.getProperty("user.dir");
            boolean done = false;
            while (!done) {
                boolean absolutePath = classPath.indexOf(this.fileSeparator) == 0 || this.isRunningUnderBraindeadOS && classPath.length() >= 2 && classPath.charAt(1) == ':';
                int sepIndex = classPath.indexOf(this.pathSeparator);
                String candidate = null;
                if (sepIndex == -1) {
                    candidate = classPath;
                    done = true;
                } else {
                    candidate = classPath.substring(0, sepIndex);
                }
                if (candidate.startsWith("~")) {
                    if (candidate.startsWith("~" + System.getProperty("user.name") + this.fileSeparator)) {
                        candidate = "~" + this.fileSeparator + candidate.substring(candidate.indexOf(this.fileSeparator));
                    }
                    if (!candidate.startsWith("~" + this.fileSeparator)) {
                        throw new RuntimeException("can't handle tilde expansion of a username; please provide fully-qualified path.");
                    }
                    candidate = System.getProperty("user.home") + this.fileSeparator + candidate.substring(2);
                } else if (!absolutePath) {
                    candidate = userDir + this.fileSeparator + candidate;
                }
                if (this.isArchive(candidate)) {
                    this.addArchive(candidate);
                } else {
                    locations.add(candidate);
                }
                classPath = classPath.substring(sepIndex + 1);
            }
            this.previousLocations = locations;
        }
        this.setLocationsFound(locations);
        InputStream res = null;
        SingletonList jimple = new SingletonList(JimpleInputRep.v());
        SingletonList java = new SingletonList(JavaInputRep.v());
        SingletonList clss = new SingletonList(ClassInputRep.v());
        String javaClassName = className;
        if (className.indexOf("$") != -1) {
            javaClassName = className.substring(0, className.indexOf("$"));
        } else if (this.sourceToClassMap != null && this.sourceToClassMap.get(javaClassName) != null) {
            javaClassName = (String)this.sourceToClassMap.get(javaClassName);
        }
        switch (Options.v().src_prec()) {
            case 1: {
                res = this.getFileInputStream(locations, clss, className);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, jimple, className);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, java, javaClassName);
                if (res == null) break;
                return res;
            }
            case 3: {
                res = this.getFileInputStream(locations, java, javaClassName);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, clss, className);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, jimple, className);
                if (res == null) break;
                return res;
            }
            case 2: {
                res = this.getFileInputStream(locations, jimple, className);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, clss, className);
                if (res != null) {
                    return res;
                }
                res = this.getFileInputStream(locations, java, javaClassName);
                if (res == null) break;
                return res;
            }
            default: {
                throw new RuntimeException("Other source precedences are not currently supported.");
            }
        }
        throw new ClassNotFoundException();
    }

    private void setLocationsFound(List locs) {
        this.locationsFound = locs;
    }

    public List getLocationsFound() {
        return this.locationsFound;
    }

    private void setFullPathFound(String fp) {
        this.fullPathFound = fp;
    }

    public String getFullPathFound() {
        return this.fullPathFound;
    }

    private InputStream getFileInputStream(List locations, List reps, String className) {
        Iterator it = locations.iterator();
        if (className.indexOf("/") >= 0) {
            throw new RuntimeException("Class names may not contain slashes! " + className);
        }
        String classNameSlashed = className.replace('.', '/');
        while (it.hasNext()) {
            StringBuffer locationBuf = new StringBuffer();
            String locationPath = (String)it.next();
            locationBuf.append(locationPath);
            if (!locationPath.endsWith(new Character(this.fileSeparator).toString())) {
                locationBuf.append(this.fileSeparator);
            }
            String path = locationBuf.toString();
            for (SootInputRepresentation inputRep : reps) {
                String adjustedClassName = path + className;
                if (inputRep instanceof ClassInputRep) {
                    adjustedClassName = path + classNameSlashed;
                }
                if (inputRep instanceof JavaInputRep) {
                    adjustedClassName = path + classNameSlashed;
                }
                String fullPath = adjustedClassName + inputRep.getFileExtension();
                File f = new File(fullPath);
                this.setFullPathFound(fullPath);
                if (!f.canRead()) continue;
                try {
                    return inputRep.createInputStream(new FileInputStream(f));
                }
                catch (IOException e) {
                    G.v().out.println(e);
                    throw new RuntimeException("!");
                }
            }
        }
        for (ZipFile zip : this.zipFileList) {
            for (SootInputRepresentation inputRep : reps) {
                ZipEntry entry = zip.getEntry(classNameSlashed + inputRep.getFileExtension());
                if (entry == null) continue;
                try {
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                    InputStream bugFreeInputStream = this.doJDKBugWorkaround(is, entry.getSize());
                    return inputRep.createInputStream(bugFreeInputStream);
                }
                catch (IOException e) {
                    G.v().out.println("error reading file:" + zip.getName() + e.toString());
                    throw new CompilationDeathException(0);
                }
            }
        }
        return null;
    }

    private boolean isArchive(String path) {
        File f = new File(path);
        if (f.isFile() && f.canRead()) {
            if (path.endsWith("zip") || path.endsWith("jar")) {
                return true;
            }
            G.v().out.println("Warning: the following soot-classpath entry is not a supported archive file (must be .zip or .jar): " + path);
        }
        return false;
    }

    private void addArchive(String fileName) {
        try {
            ZipFile zipFile = new ZipFile(fileName);
            this.zipFileList.add(zipFile);
        }
        catch (IOException e) {
            G.v().out.println("error loading file:" + fileName + e.toString());
        }
    }

    private InputStream doJDKBugWorkaround(InputStream is, long size) throws IOException {
        int sz;
        byte[] buf = new byte[sz];
        int N = 1024;
        int ln = 0;
        int count = 0;
        for (sz = (int)size; sz > 0 && (ln = is.read(buf, count, Math.min(1024, sz))) != -1; sz -= ln) {
            count += ln;
        }
        return new ByteArrayInputStream(buf);
    }

    public List getClassesUnder(String aPath) {
        File file = new File(aPath);
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] files = file.listFiles();
        if (files == null) {
            files = new File[]{file};
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                List l = this.getClassesUnder(aPath + this.fileSeparator + files[i].getName());
                for (String s : l) {
                    fileNames.add(files[i].getName() + "." + s);
                }
                continue;
            }
            String fileName = files[i].getName();
            if (fileName.endsWith(".class")) {
                int index = fileName.lastIndexOf(".class");
                fileNames.add(fileName.substring(0, index));
            }
            if (fileName.endsWith(".jimple")) {
                int index = fileName.lastIndexOf(".jimple");
                fileNames.add(fileName.substring(0, index));
            }
            if (!fileName.endsWith(".java")) continue;
            int index = fileName.lastIndexOf(".java");
            fileNames.add(fileName.substring(0, index));
        }
        return fileNames;
    }

    public String getFileNameFor(SootClass c, int rep) {
        String path;
        File dir;
        if (rep == 10) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        b.append(this.getOutputDir());
        if (b.length() > 0 && b.charAt(b.length() - 1) != this.fileSeparator) {
            b.append(this.fileSeparator);
        }
        if (rep != 13) {
            b.append(c.getName());
            b.append(this.getExtensionFor(rep));
            return b.toString();
        }
        b.append("dava");
        b.append(this.fileSeparator);
        String classPath = b.toString() + "classes";
        File dir2 = new File(classPath);
        if (!dir2.exists()) {
            try {
                dir2.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + classPath);
                throw new CompilationDeathException(0);
            }
        }
        b.append("src");
        b.append(this.fileSeparator);
        String fixedPackageName = c.getJavaPackageName();
        if (!fixedPackageName.equals("")) {
            b.append(fixedPackageName.replace('.', this.fileSeparator));
            b.append(this.fileSeparator);
        }
        if (!(dir = new File(path = b.toString())).exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + path);
                throw new CompilationDeathException(0);
            }
        }
        b.append(c.getShortJavaStyleName());
        b.append(".java");
        return b.toString();
    }

    public Set classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(Scene.v().getSootClassPath(), String.valueOf(this.pathSeparator));
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            List l = this.getClassesUnder(path);
            for (String filename : l) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            path = path + this.pathSeparator;
            StringTokenizer tokenizer = new StringTokenizer(str, ".");
            while (tokenizer.hasMoreTokens()) {
                path = path + tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                path = path + this.pathSeparator;
            }
            l = this.getClassesUnder(path);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                set.add(str + "." + (String)it.next());
            }
        }
        return set;
    }

    public String getExtensionFor(int rep) {
        switch (rep) {
            case 5: {
                return ".baf";
            }
            case 6: {
                return ".b";
            }
            case 1: {
                return ".jimple";
            }
            case 2: {
                return ".jimp";
            }
            case 3: {
                return ".shimple";
            }
            case 4: {
                return ".shimp";
            }
            case 8: {
                return ".grimp";
            }
            case 7: {
                return ".grimple";
            }
            case 12: {
                return ".class";
            }
            case 13: {
                return ".java";
            }
            case 11: {
                return ".jasmin";
            }
            case 9: {
                return ".xml";
            }
        }
        throw new RuntimeException();
    }

    public String getOutputDir() {
        File dir;
        String ret = Options.v().output_dir();
        if (ret.length() == 0) {
            ret = "sootOutput";
        }
        if (!(dir = new File(ret)).exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + ret);
                throw new CompilationDeathException(0);
            }
        }
        return ret;
    }
}

